/*
    YAGF - cuneiform OCR graphical front-end
    Copyright (C) 2009 Andrei Borovsky <anb@symmetrica.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef IMAGEPROCESSOR_H
#define IMAGEPROCESSOR_H

#include "qipgrayscaleimage.h"
#include "qipblackandwhiteimage.h"
#include <QObject>
#include <QImage>



class ImageProcessor : public QObject
{
    Q_OBJECT
public:
    explicit ImageProcessor(QObject *parent = 0);
    ~ImageProcessor();
    QRect crop();
    void loadImage(const QImage &image);
    QImage gsImage() const;
    void binarize();
    void saveYGF(const QImage &image, const QString &fileName);
    QImage loadYGF(const QString &fileName);
    static void polishImage(QImage &image);
    static void polishImage2(QImage &image);
    static bool isTextHorizontal(QImage &image);
    static void cropAngles(QImage &image);
signals:
    
public slots:

private:
    QIPGrayscaleImage img;
private:
    
};

#endif // IMAGEPROCESSOR_H
