/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PlinkoBoard
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    double COUNT;
    double TOTAL;
    double TOTAL_SQUARES;
    long[] HIST;
    float MAX;
    double[][][] PINS;
    double DIST;
    double BALL_RAD;
    int PIN_RAD;
    int BINS;
    int R;
    int W;
    int H;
    int BALL_COUNT;
    int BOTTOM_MARGIN = 5;
    double SIDE_MARGIN;
    PlinkoBall FIRST_BALL;
    int RIGHT;
    double PERCENT;
    int CURRENT_BIN = 0;
    static double[][] DYS;
    static Color[] COLORS;
    Image[] IMAGES;
    Thread thread;
    boolean active;
    Image background;
    Image image;
    Graphics2D graphics;
    PlinkoNegativeBinomial plinko;
    int maximum_balls;
    int start_number = 0;
    int showstats = 0;

    public PlinkoBoard(PlinkoNegativeBinomial plinkoNegativeBinomial) {
        this.plinko = plinkoNegativeBinomial;
        this.setup();
        this.newHist();
        this.FIRST_BALL = null;
        this.BALL_COUNT = 0;
        this.active = false;
        DYS = new double[12][];
        for (double d = 0.0; d < 12.0; d += 1.0) {
            PlinkoBoard.DYS[(int)d] = new double[(int)d];
            for (double d2 = 0.0; d2 < d; d2 += 1.0) {
                PlinkoBoard.DYS[(int)d][(int)d2] = PlinkoBall.A * d2 * d2 / (d * d) + PlinkoBall.B * d2 / d;
            }
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.maximum_balls = this.plinko.total_balls - 1;
        if (!this.plinko.wims_exercise) {
            this.showstats = 1;
        } else {
            this.start_number = 1;
        }
    }

    public void setup() {
        int n;
        this.W = this.getWidth();
        this.H = this.getHeight();
        PlinkoNegativeBinomial plinkoNegativeBinomial = this.plinko;
        this.BINS = (Integer)PlinkoNegativeBinomial.bins.getValue();
        PlinkoNegativeBinomial plinkoNegativeBinomial2 = this.plinko;
        this.R = (Integer)PlinkoNegativeBinomial.strk.getValue();
        this.CURRENT_BIN = Math.min(this.CURRENT_BIN, this.BINS - 1);
        this.RIGHT = 0;
        this.PERCENT = 0.0;
        this.DIST = Math.min((double)(this.H - 100 - this.BOTTOM_MARGIN) / (double)(this.BINS + this.R), (double)(this.W - 10) / (double)this.BINS);
        this.SIDE_MARGIN = ((double)this.W - (double)this.BINS * this.DIST) / 2.0;
        this.PIN_RAD = (int)this.DIST / 9 + 1;
        this.BALL_RAD = Math.max(2.0 * this.DIST / 7.0, 2.0) + 1.0;
        this.IMAGES = new Image[COLORS.length];
        for (n = 0; n < COLORS.length; ++n) {
            this.IMAGES[n] = PlinkoBoard.getBall(this.BALL_RAD, COLORS[n]);
        }
        this.PINS = new double[this.R + 1][][];
        for (n = 0; n < this.R; ++n) {
            this.PINS[n] = new double[200][2];
            for (int i = 0; i < 150; ++i) {
                this.PINS[n][i][0] = this.DIST * (double)(i - n + this.R) + this.SIDE_MARGIN;
                this.PINS[n][i][1] = this.DIST * (double)(i + n + 1);
            }
        }
        this.PINS[this.R] = new double[200][2];
        for (n = 0; n < 200; ++n) {
            this.PINS[this.R][n][0] = this.DIST * ((double)n + 0.5) + this.SIDE_MARGIN;
            this.PINS[this.R][n][1] = (double)(this.H - 30) - this.BALL_RAD;
        }
    }

    public static Image getBall(double d, Color color) {
        BufferedImage bufferedImage = new BufferedImage((int)(2.0 * d + 2.0), (int)(2.0 * d + 2.0), 2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[]{-5.0, 5.0, 10.0};
        double d2 = Math.sqrt(150.0);
        for (int i = 0; i < (int)(2.0 * d + 2.0); ++i) {
            for (int j = 0; j < (int)(2.0 * d + 2.0); ++j) {
                if ((d - (double)i) * (d - (double)i) + (d - (double)j) * (d - (double)j) <= (d - 1.0) * (d - 1.0)) {
                    dArray[0] = ((double)i - d) / d;
                    dArray[1] = (d - (double)j) / d;
                    dArray[2] = Math.sqrt(1.0 - dArray[0] * dArray[0] - dArray[1] * dArray[1]);
                    double d3 = (dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2]) / Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
                    d3 = (1.0 + d3) / 2.0;
                    double d4 = Math.pow(d3, 20.0);
                    int n = (int)((double)color.getRed() * (d3 - d4) + d4 * 255.0);
                    int n2 = (int)((double)color.getGreen() * (d3 - d4) + d4 * 255.0);
                    int n3 = (int)((double)color.getBlue() * (d3 - d4) + d4 * 255.0);
                    bufferedImage.setRGB(i, j, -16777216 + (n << 16) + (n2 << 8) + n3);
                    continue;
                }
                if ((d - (double)i) * (d - (double)i) + (d - (double)j) * (d - (double)j) > (d + 1.0) * (d + 1.0)) continue;
                int n = 0;
                int n4 = 0;
                int n5 = 0;
                for (double d5 = -0.33; d5 < 0.5; d5 += 0.33) {
                    for (double d6 = -0.33; d6 < 0.5; d6 += 0.33) {
                        double d7;
                        double d8;
                        if ((d - ((double)i + d5)) * (d - ((double)i + d5)) + (d - ((double)j + d6)) * (d - ((double)j + d6)) <= d * d) {
                            dArray[0] = ((double)i + d6 - d) / d;
                            dArray[1] = (d - ((double)j + d6)) / d;
                            dArray[2] = Math.sqrt(1.0 - dArray[0] * dArray[0] - dArray[1] * dArray[1]);
                            d8 = (dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2]) / d2;
                            d8 = (1.0 + d8) / 2.0;
                            d7 = Math.pow(d8, 20.0);
                        } else {
                            d8 = 1.0;
                            d7 = 1.0;
                        }
                        n += (int)((double)color.getRed() * (d8 - d7) + d7 * 255.0);
                        n4 += (int)((double)color.getGreen() * (d8 - d7) + d7 * 255.0);
                        n5 += (int)((double)color.getBlue() * (d8 - d7) + d7 * 255.0);
                    }
                }
                bufferedImage.setRGB(i, j, (255 - ((n /= 9) + (n4 /= 9) + (n5 /= 9)) / 3 << 24) + (n << 16) + (n4 << 8) + n5);
            }
        }
        return bufferedImage;
    }

    public void newHist() {
        this.COUNT = 0.0;
        this.TOTAL = 0.0;
        this.TOTAL_SQUARES = 0.0;
        this.MAX = 0.0f;
        this.PERCENT = 0.0;
        this.HIST = new long[101];
    }

    public String ReadData() {
        int n;
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.HIST.length; ++n) {
            d += (double)this.HIST[n];
            if (n >= this.plinko.bins_num) continue;
            string = n != 0 ? string + "," + this.HIST[n] : "" + this.HIST[0];
            d2 += (double)this.HIST[n];
        }
        n = (int)(d - d2);
        string = string + "," + n;
        return string;
    }

    public void run() {
        while (this.BALL_COUNT > 0) {
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaint();
        this.active = false;
        this.plinko.active = false;
        PlinkoNegativeBinomial plinkoNegativeBinomial = this.plinko;
        PlinkoNegativeBinomial.strk.setEnabled(true);
    }

    public void kill() {
        this.FIRST_BALL = null;
        if (this.plinko.start.getText().equals("Start")) {
            this.active = false;
            this.plinko.active = false;
            PlinkoNegativeBinomial plinkoNegativeBinomial = this.plinko;
            PlinkoNegativeBinomial.strk.setEnabled(true);
        }
    }

    public void LimitReached() {
        this.plinko.active = true;
        this.FIRST_BALL = null;
        this.plinko.toggleStart();
    }

    public void dropBall(boolean bl) {
        ++this.BALL_COUNT;
        if (this.COUNT >= (double)this.maximum_balls) {
            this.LimitReached();
        }
        if (this.FIRST_BALL == null) {
            this.FIRST_BALL = new PlinkoBall();
            this.FIRST_BALL.sound = bl;
        } else {
            this.FIRST_BALL.previousBall = new PlinkoBall();
            this.FIRST_BALL.previousBall.sound = bl;
            this.FIRST_BALL.previousBall.nextBall = this.FIRST_BALL;
            this.FIRST_BALL = this.FIRST_BALL.previousBall;
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.active) {
            this.active = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void paintComponent(Graphics graphics) {
        this.W = this.getWidth();
        this.H = this.getHeight();
        if (this.background == null || this.background.getWidth(this) != this.W || this.background.getHeight(this) != this.H || this.image == null || this.image.getWidth(this) != this.W || this.image.getHeight(this) != this.H) {
            this.setup();
            this.background = this.createImage(this.W, this.H);
            this.drawBackground(this.W, this.H);
            this.image = this.createImage(this.W, this.H);
            this.graphics = (Graphics2D)this.image.getGraphics();
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.graphics.drawImage(this.background, 0, 0, this);
        PlinkoBall plinkoBall = this.FIRST_BALL;
        while (plinkoBall != null) {
            this.graphics.drawImage(this.IMAGES[plinkoBall.spaz], (int)(plinkoBall.X - this.BALL_RAD), (int)(plinkoBall.Y - 2.0 * this.BALL_RAD - (double)this.PIN_RAD + 1.0), this);
            this.increment(plinkoBall);
            plinkoBall = plinkoBall.nextBall;
        }
        this.drawHist(this.graphics);
        this.drawStats(this.graphics);
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void increment(PlinkoBall plinkoBall) {
        if (plinkoBall.t == plinkoBall.C && plinkoBall.ROW < this.R) {
            plinkoBall.t = 0;
            plinkoBall.DIR = 0;
            PlinkoNegativeBinomial plinkoNegativeBinomial = this.plinko;
            if (!this.plinko.wims_exercise) {
                if (Math.random() < (Double)PlinkoNegativeBinomial.prob.getValue()) {
                    plinkoBall.DIR = 1;
                }
            } else if (Math.random() < this.plinko.chance) {
                plinkoBall.DIR = 1;
            }
            plinkoBall.ROW += 1 - plinkoBall.DIR;
            plinkoBall.COL += plinkoBall.DIR;
            PlinkoNegativeBinomial plinkoNegativeBinomial2 = this.plinko;
            plinkoBall.C = 11 - (Integer)PlinkoNegativeBinomial.rate.getValue();
            if (plinkoBall.sound) {
                PlinkoNegativeBinomial.ping.play();
            }
        }
        double d = this.DIST * (double)plinkoBall.t * (double)(2 * plinkoBall.DIR - 1) / (double)plinkoBall.C;
        if (plinkoBall.ROW == 0 && plinkoBall.COL == 0) {
            plinkoBall.X = this.PINS[0][0][0];
            plinkoBall.Y = this.PINS[0][0][1] - this.DIST + this.DIST * (double)plinkoBall.t * (double)plinkoBall.t / (double)(plinkoBall.C * plinkoBall.C);
        } else if (plinkoBall.ROW < this.R) {
            plinkoBall.X = this.DIST * (double)(plinkoBall.COL - plinkoBall.ROW - 2 * plinkoBall.DIR + 1 + this.R) + d + this.SIDE_MARGIN;
            plinkoBall.Y = this.DIST * ((double)(plinkoBall.COL + plinkoBall.ROW) - DYS[plinkoBall.C][plinkoBall.t]);
        } else {
            plinkoBall.X = this.PINS[this.R - 1][plinkoBall.COL][0] + d;
            plinkoBall.X = Math.max(plinkoBall.X, this.PINS[this.R][plinkoBall.COL][0] - this.DIST / 2.0 + this.BALL_RAD + 1.0);
            d = Math.abs(d);
            PlinkoBall plinkoBall2 = plinkoBall;
            PlinkoBall plinkoBall3 = plinkoBall;
            plinkoBall.Y = this.PINS[plinkoBall.ROW - 1][plinkoBall.COL][1] - d * (PlinkoBall.A * d / this.DIST + PlinkoBall.B);
            if (plinkoBall.Y > (double)(this.H - this.BOTTOM_MARGIN - this.PIN_RAD)) {
                if (plinkoBall.previousBall != null && plinkoBall.nextBall != null) {
                    plinkoBall.previousBall.nextBall = plinkoBall.nextBall;
                    plinkoBall.nextBall.previousBall = plinkoBall.previousBall;
                } else if (plinkoBall.previousBall != null && plinkoBall.nextBall == null) {
                    plinkoBall.previousBall.nextBall = null;
                } else if (plinkoBall.previousBall == null && plinkoBall.nextBall != null) {
                    plinkoBall.nextBall.previousBall = null;
                    this.FIRST_BALL = plinkoBall.nextBall;
                } else {
                    this.FIRST_BALL = null;
                    PlinkoNegativeBinomial plinkoNegativeBinomial = this.plinko;
                    PlinkoNegativeBinomial.strk.setEnabled(true);
                }
                --this.BALL_COUNT;
                this.updateHist(plinkoBall.COL);
                if (plinkoBall.sound) {
                    PlinkoNegativeBinomial.click.play();
                }
            }
        }
        ++plinkoBall.t;
    }

    public void updateHist(int n) {
        int n2 = Math.min(n, 100);
        this.HIST[n2] = this.HIST[n2] + 1L;
        this.COUNT += 1.0;
        this.TOTAL += (double)n;
        this.TOTAL_SQUARES += (double)(n * n);
        if ((float)this.HIST[Math.min(n, 100)] > this.MAX) {
            this.MAX = this.HIST[Math.min(n, 100)];
        }
        if (n <= this.RIGHT) {
            this.PERCENT += 1.0;
        }
    }

    public void drawStats(Graphics graphics) {
        if (this.showstats == 1) {
            this.plinko.count.setText(this.plinko.label_count + (int)this.COUNT);
            this.plinko.current_bin.setText(this.plinko.label_bin + this.CURRENT_BIN);
            this.plinko.current_bin_count.setText(this.plinko.label_bin_count + this.HIST[this.CURRENT_BIN]);
            if (this.COUNT > 0.0) {
                double d = this.TOTAL / this.COUNT;
                this.plinko.mean.setText(this.plinko.label_mean + (float)d);
                this.plinko.variance.setText(this.plinko.label_variance + (float)(this.TOTAL_SQUARES / this.COUNT - d * d));
                this.plinko.current_bin_prob.setText(this.plinko.label_bin_probability + (float)((double)((int)((double)(100000L * this.HIST[this.CURRENT_BIN]) / this.COUNT)) / 1000.0) + "%");
                if (this.RIGHT == 0) {
                    this.plinko.confidence.setText(this.plinko.label_confidence + (float)((double)((int)(100000.0 * this.PERCENT / this.COUNT)) / 1000.0) + "% of the balls landed in bin " + this.RIGHT + ".");
                } else {
                    this.plinko.confidence.setText(this.plinko.label_confidence + (float)((double)((int)(100000.0 * this.PERCENT / this.COUNT)) / 1000.0) + "% of the balls landed in bins 0 through " + this.RIGHT + ".");
                }
            } else {
                this.plinko.mean.setText(this.plinko.label_mean);
                this.plinko.variance.setText(this.plinko.label_variance);
                this.plinko.current_bin_prob.setText(this.plinko.label_bin_probability);
                this.plinko.confidence.setText(this.plinko.label_confidence);
            }
        } else {
            this.plinko.count.setText(this.plinko.label_count + (int)this.COUNT);
            this.plinko.current_bin.setText(this.plinko.label_bin + (this.CURRENT_BIN + 1));
            this.plinko.current_bin_count.setText(this.plinko.label_bin_count + this.HIST[this.CURRENT_BIN]);
        }
    }

    public void drawHist(Graphics2D graphics2D) {
        this.W = this.getWidth();
        this.H = this.getHeight();
        for (int i = 0; i < this.BINS; ++i) {
            double d;
            double d2;
            if (i == this.BINS - 1) {
                d2 = this.PINS[this.R][i][0] - this.DIST / 2.0;
                d = this.PINS[this.R][i][0] + this.DIST / 2.0;
            } else {
                d2 = this.PINS[this.R][i][0] - this.DIST / 2.0;
                d = this.PINS[this.R][i + 1][0] - this.DIST / 2.0;
            }
            long l = this.HIST[i];
            if (this.MAX > 100.0f) {
                l = (int)(100.0 * (double)l / (double)this.MAX);
            }
            graphics2D.setColor(new Color(255, 0, 0, 175));
            if (i <= this.RIGHT) {
                graphics2D.setColor(new Color(0, 255, 0, 175));
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, (long)this.H - l - (long)this.BOTTOM_MARGIN, d - d2, l);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(double_);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(new Line2D.Double(this.PINS[this.R][this.CURRENT_BIN][0] - this.DIST / 2.0, this.H - this.BOTTOM_MARGIN + 3, this.PINS[this.R][this.CURRENT_BIN][0] + this.DIST / 2.0, this.H - this.BOTTOM_MARGIN + 3));
    }

    public void drawBackground() {
        this.drawBackground(this.getWidth(), this.getHeight());
    }

    public void drawBackground(int n, int n2) {
        int n3;
        Object object;
        Graphics2D graphics2D = (Graphics2D)this.background.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        Image image = PlinkoBoard.getBall(this.PIN_RAD, Color.black);
        for (int i = 0; i < this.R; ++i) {
            object = this.PINS[i][0];
            for (n3 = 0; n3 < 1000 && object[1] + (double)n3 * this.DIST - (double)this.PIN_RAD < (double)n2; ++n3) {
                graphics2D.drawImage(image, (int)(object[0] - (double)this.PIN_RAD + (double)n3 * this.DIST), (int)(object[1] - (double)this.PIN_RAD + (double)n3 * this.DIST), this);
            }
        }
        graphics2D.setFont(new Font("Helvetica", 1, Math.min((int)(2.0 * this.DIST) / 3, 50)));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.draw(new Line2D.Double(0.0, n2 - this.BOTTOM_MARGIN, n, n2 - this.BOTTOM_MARGIN));
        object = "";
        for (n3 = 0; n3 < this.BINS; ++n3) {
            double[] dArray = this.PINS[this.R][n3];
            object = "" + (n3 + this.start_number);
            graphics2D.setColor(Color.darkGray);
            graphics2D.drawString((String)object, (int)(dArray[0] - (double)(fontMetrics.stringWidth((String)object) / 2)), n2 - 100 - this.BOTTOM_MARGIN + Math.min((int)(2.0 * this.DIST) / 3, 50));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Line2D.Double(dArray[0] - this.DIST / 2.0, n2 - 100 - this.BOTTOM_MARGIN, dArray[0] - this.DIST / 2.0, n2 - this.BOTTOM_MARGIN));
        }
        double[] dArray = this.PINS[this.R][this.BINS - 1];
        graphics2D.draw(new Line2D.Double(dArray[0] + this.DIST / 2.0, n2 - 100 - this.BOTTOM_MARGIN, dArray[0] + this.DIST / 2.0, n2 - this.BOTTOM_MARGIN));
        this.repaint();
    }

    public void updatePercent() {
        this.RIGHT = this.CURRENT_BIN;
        this.PERCENT = 0.0;
        for (int i = 0; i <= this.RIGHT; ++i) {
            this.PERCENT += (double)this.HIST[i];
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (c >= '0' && c <= '4') {
            int n2;
            int n3 = c - 48;
            int n4 = 1;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 *= 10;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                this.dropBall(n4 == 1);
            }
        } else if (n == 37) {
            --this.CURRENT_BIN;
            if (this.CURRENT_BIN < 0) {
                this.CURRENT_BIN = this.BINS - 1;
            }
            this.updatePercent();
            this.repaint();
        } else if (n == 39) {
            ++this.CURRENT_BIN;
            if (this.CURRENT_BIN > this.BINS - 1) {
                this.CURRENT_BIN = 0;
            }
            this.updatePercent();
            this.repaint();
        } else if (n != 10) {
            if (c == ' ') {
                this.plinko.toggleStart();
            } else if (c == '\u0014' || c == '\u0003' || c != '\u0018') {
                // empty if block
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
        Point point = mouseEvent.getPoint();
        if ((double)point.x > this.PINS[this.R][0][0] - this.DIST / 2.0 && (double)point.x < this.PINS[this.R][this.BINS - 1][0] + this.DIST / 2.0 && point.y > this.H - 100 - this.BOTTOM_MARGIN && point.y < this.H - this.BOTTOM_MARGIN) {
            this.CURRENT_BIN = (int)(((double)point.x - this.PINS[this.R][0][0]) / this.DIST + 0.5);
            this.updatePercent();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static {
        COLORS = new Color[]{Color.red, Color.magenta, Color.orange, Color.yellow, Color.green, Color.blue, Color.cyan};
    }
}

