/*
 * NurbsPlaneDialog.h
 *
 * Copyright (C) 2000 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NURBS_PLANE_DIALOG_H
#define _NURBS_PLANE_DIALOG_H

#ifndef _DIALOG_H
#include "Dialog.h"
#endif

#include "swttypedef.h"

class NurbsPlaneDialog : public Dialog {
public:
                        NurbsPlaneDialog(SWND parent, int width, int depth,
                                         int uDegree, int vDegree);
    virtual            ~NurbsPlaneDialog();

    void                LoadData();
    virtual void        SaveData();
    virtual bool        Validate();
    int                 GetWidth() const { return _width; }
    int                 GetDepth() const { return _depth; }
    int                 GetUDegree() const { return _uDegree; }
    int                 GetVDegree() const { return _vDegree; }
private:
    int                 _width;
    int                 _depth;
    int                 _uDegree;
    int                 _vDegree;
};

#endif
