/*
 *            Copyright 2009-2020 The VOTCA Development Team
 *                       (http://www.votca.org)
 *
 *      Licensed under the Apache License, Version 2.0 (the "License")
 *
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *              http://www.apache.org/licenses/LICENSe-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "gauss_hermite_quadrature.h"

// Gauss-Hermite quadrature points and adapted weights as exported from
// https://keisan.casio.com/exec/system/1329114617
// with 50 digits

namespace votca {
namespace xtp {

void Gauss_Hermite_Quadrature::FillPoints() {
  Eigen::VectorXd points_8(8);
  points_8 << -2.9306374202572440192235027052435991461994485855216,
      -1.9816567566958429258546306397693095686949116340382,
      -1.1571937124467801947207657790631002434520047595976,
      -0.38118699020732211685471888558369141763186003151966,
      0.38118699020732211685471888558369141763186003151966,
      1.1571937124467801947207657790631002434520047595976,
      1.9816567566958429258546306397693095686949116340382,
      2.9306374202572440192235027052435991461994485855216;
  map_points_[8] = points_8;
  Eigen::VectorXd points_10(10);
  points_10 << -3.4361591188377376033267254943191213848406783093902,
      -2.5327316742327897964089607977547934803078465081567,
      -1.7566836492998817734514012201061567632954744937389,
      -1.0366108297895136541774919167592090162982561106572,
      -0.34290132722370460878916502555725803120830265867773,
      0.34290132722370460878916502555725803120830265867773,
      1.0366108297895136541774919167592090162982561106572,
      1.7566836492998817734514012201061567632954744937389,
      2.5327316742327897964089607977547934803078465081567,
      3.4361591188377376033267254943191213848406783093902;
  map_points_[10] = points_10;
  Eigen::VectorXd points_12(12);
  points_12 << -3.8897248978697819192716427472441917601481810141665,
      -3.0206370251208897717106793751767636460038065983103,
      -2.279507080501059900187728569424341135039156593214,
      -1.5976826351526047967096627709045767082402869887687,
      -0.94778839124016374370457813106013651367915379591455,
      -0.31424037625435911127661163409533712897211083832271,
      0.3142403762543591112766116340953371289721108383227,
      0.94778839124016374370457813106013651367915379591455,
      1.5976826351526047967096627709045767082402869887687,
      2.279507080501059900187728569424341135039156593214,
      3.0206370251208897717106793751767636460038065983103,
      3.8897248978697819192716427472441917601481810141665;
  map_points_[12] = points_12;
  Eigen::VectorXd points_14(14);
  points_14 << -4.3044485704736318126212981003689427253218103879463,
      -3.4626569336022705502089173611504324421390765376615,
      -2.7484707249854025686249985241464309299737954499322,
      -2.0951832585077168157349727263032374554797833544483,
      -1.4766827311411408705835065442050785826659377346378,
      -0.87871378732939941611467931186079607260338557501491,
      -0.29174551067256207844611307579938114089108844043221,
      0.29174551067256207844611307579938114089108844043221,
      0.87871378732939941611467931186079607260338557501491,
      1.4766827311411408705835065442050785826659377346378,
      2.0951832585077168157349727263032374554797833544483,
      2.7484707249854025686249985241464309299737954499322,
      3.4626569336022705502089173611504324421390765376615,
      4.3044485704736318126212981003689427253218103879463;
  map_points_[14] = points_14;
  Eigen::VectorXd points_16(16);
  points_16 << -4.6887389393058183646884986487456108906323917275435,
      -3.8694479048601226987194240980148123970065994702497,
      -3.176999161979956026813994559263696476791667372742,
      -2.5462021578474813621593287054458941245194651994058,
      -1.9517879909162539774346554149598874927683260586599,
      -1.3802585391988807963720896696945820384406817699701,
      -0.82295144914465589258245449673394264076350817254127,
      -0.2734810461381524521582804019650150339298178803279,
      0.2734810461381524521582804019650150339298178803279,
      0.82295144914465589258245449673394264076350817254127,
      1.3802585391988807963720896696945820384406817699701,
      1.9517879909162539774346554149598874927683260586599,
      2.5462021578474813621593287054458941245194651994058,
      3.1769991619799560268139945592636964767916673727419,
      3.8694479048601226987194240980148123970065994702497,
      4.6887389393058183646884986487456108906323917275435;
  map_points_[16] = points_16;
  Eigen::VectorXd points_18(18);
  points_18 << -5.0483640088744667683720375788536521210964511478335,
      -4.2481178735681264630234201609020812454613481259571,
      -3.5737690684862660795006759937718894579393109766802,
      -2.9613775055316068447786325490618382146613988430531,
      -2.3862990891666860002645930142399451367070333328477,
      -1.8355316042616288922538394440906011492669936367257,
      -1.3009208583896173656662655543926105802181346396612,
      -0.7766829192674116613166594622838522947287132144905,
      -0.25826775051909675925811609871057963300171513532774,
      0.2582677505190967592581160987105796330017151353277,
      0.7766829192674116613166594622838522947287132144905,
      1.3009208583896173656662655543926105802181346396612,
      1.8355316042616288922538394440906011492669936367257,
      2.3862990891666860002645930142399451367070333328477,
      2.9613775055316068447786325490618382146613988430531,
      3.5737690684862660795006759937718894579393109766802,
      4.248117873568126463023420160902081245461348125957,
      5.0483640088744667683720375788536521210964511478335;
  map_points_[18] = points_18;
  Eigen::VectorXd points_20(20);
  points_20 << -5.3874808900112328620169004106811207539962864490659,
      -4.6036824495507442730776752489783475851133984877619,
      -3.944764040115625210375628800524411807149768127888,
      -3.3478545673832163269149245229964636985104785902937,
      -2.788806058428130480525033756403185410670698887902,
      -2.2549740020892755230823333447345651280822653160264,
      -1.7385377121165862067808656621364064429514094196004,
      -1.2340762153953230078858183469594102295854459300694,
      -0.7374737285453943587056051442521042290772162039768,
      -0.24534070830090124990383653063361662396613385130349,
      0.24534070830090124990383653063361662396613385130349,
      0.73747372854539435870560514425210422907721620397679,
      1.2340762153953230078858183469594102295854459300694,
      1.7385377121165862067808656621364064429514094196004,
      2.2549740020892755230823333447345651280822653160264,
      2.788806058428130480525033756403185410670698887902,
      3.3478545673832163269149245229964636985104785902937,
      3.9447640401156252103756288005244118071497681278883,
      4.603682449550744273077675248978347585113398487762,
      5.3874808900112328620169004106811207539962864490659;
  map_points_[20] = points_20;

  Eigen::VectorXd points_40(40);
  points_40 << -8.098761139250850052012636369630536203159878558411,
      -7.4115825314854688094393004346606137838517548859766,
      -6.8402373052493554178458239138344048541844776615676,
      -6.3282553512200819556569910907660684038833769829979,
      -5.8540950560304001080427055883267519292216187560587,
      -5.406654247970127608400173980753063275682274386632,
      -4.9792609785452558716265182296182638236429580903587,
      -4.567502072844394855169482293577938174854843489872,
      -4.1682570668325002015364923207359804227827976573906,
      -3.779206753435223493119356115842927618490199421049,
      -3.3985582658596283462937862596982787619977026521078,
      -3.024879883901284437677049325341784266908327117963,
      -2.6569959984428957949808471006826969983518444487154,
      -2.2939171418750834218850495645276828751185935391695,
      -1.9347914722822957932979370652209982676235065775805,
      -1.5788698949316138862584512814687415071154993234949,
      -1.2254801090462890309490863830460385618165976626906,
      -0.87400661235708807743789879817524989268743615719011,
      -0.52387471383227719261491711165465674591655953342785,
      -0.1745372145975823834894506883588453187290397479542,
      0.1745372145975823834894506883588453187290397479542,
      0.52387471383227719261491711165465674591655953342785,
      0.87400661235708807743789879817524989268743615719011,
      1.2254801090462890309490863830460385618165976626906,
      1.5788698949316138862584512814687415071154993234949,
      1.9347914722822957932979370652209982676235065775805,
      2.2939171418750834218850495645276828751185935391695,
      2.6569959984428957949808471006826969983518444487154,
      3.024879883901284437677049325341784266908327117963,
      3.3985582658596283462937862596982787619977026521078,
      3.779206753435223493119356115842927618490199421049,
      4.168257066832500201536492320735980422782797657391,
      4.567502072844394855169482293577938174854843489872,
      4.9792609785452558716265182296182638236429580903587,
      5.406654247970127608400173980753063275682274386632,
      5.8540950560304001080427055883267519292216187560587,
      6.3282553512200819556569910907660684038833769829979,
      6.8402373052493554178458239138344048541844776615676,
      7.4115825314854688094393004346606137838517548859766,
      8.0987611392508500520126363696305362031598785584111;
  map_points_[40] = points_40;

  Eigen::VectorXd points_100(100);
  points_100 << -13.406487338144910138498015358651607145889756981295,
      -12.82379974948780890633912881377721549748456726861,
      -12.342964222859674295102740266870727507684215885999,
      -11.915061943114165801984797918762777070787192719624,
      -11.521415400787030241694215193615806787762300833732,
      -11.15240438558512526489903525035673867121886647691,
      -10.80226075368471459482166754925048490352246777013,
      -10.46718542134281214178313316357805048536805919779,
      -10.144509941292845469888588301440455941004734121264,
      -9.8322698077779690943551615313409315780947453926671,
      -9.5289658233901148046970657443074887808291687384498,
      -9.2334208902191615504779366283532133797467520910863,
      -8.944689217325474478798596807541288507747329552581,
      -8.6619961681345177143760754560127444328156251045127,
      -8.3846969404162650750860155396074513179782321306247,
      -8.112247311162791917211692013817029356168170316702,
      -7.84418238446082116879207953051081085258829182278,
      -7.5801008078574888842858087147798508005952446740541,
      -7.3196528223045353163320619830886983154201857246218,
      -7.0625310602488654374655227313402111369558533713012,
      -6.808463352858796414478980904321988789367313784202,
      -6.5572070319215393159801431092748363242153412136856,
      -6.308544361112135121638817415387415841889996789733,
      -6.06227883261430263866518460107768521940501572821,
      -5.818232135203517047362269817047869590598875519347,
      -5.5762416493299241033034851100970939533372038220982,
      -5.3361583601383604972771152654631793693757767432758,
      -5.09784510508913624700009193939928820181483169172,
      -4.861175091791210210046066849049651598903759210722,
      -4.6260306357871557730740379959854765524883917545046,
      -4.3923020786826840167447755690930260111118164084445,
      -4.1598868551310305400680411225876429394973862403352,
      -3.9286886834276709720095023242871466851524016002606,
      -3.6986168593184919397969539485760535948752486554752,
      -3.4695856364185891697681598371294103733559227855906,
      -3.2415136796310129503587732945183130796639221482042,
      -3.0143235803311555167151651485231965602581338238536,
      -2.7879414239819893131903676217409219127677228740981,
      -2.5622964023726080250560245984515873668232679322664,
      -2.3373204639068785050126227798659529280851747489535,
      -2.1129479963711879520297712999877086865700732258921,
      -1.8891155374270083714936395268915260054134381371616,
      -1.6657615087415094698666537171307433322798696612353,
      -1.442825970215932787702577716776781467558992104909,
      -1.2202503912189530588204931976741636515776285057147,
      -0.9979774360981052439241030610879289945935713461451,
      -0.7759507615401457819750658338752050281515312263498,
      -0.55411482359161698823299767239979854264076384558092,
      -0.33241469234223180704589884489338884776779165908485,
      -0.11079587242243948288755989392835521073522875550516,
      0.11079587242243948288755989392835521073522875550516,
      0.33241469234223180704589884489338884776779165908485,
      0.55411482359161698823299767239979854264076384558092,
      0.7759507615401457819750658338752050281515312263498,
      0.9979774360981052439241030610879289945935713461451,
      1.2202503912189530588204931976741636515776285057147,
      1.442825970215932787702577716776781467558992104909,
      1.6657615087415094698666537171307433322798696612353,
      1.8891155374270083714936395268915260054134381371616,
      2.1129479963711879520297712999877086865700732258921,
      2.3373204639068785050126227798659529280851747489535,
      2.5622964023726080250560245984515873668232679322664,
      2.7879414239819893131903676217409219127677228740981,
      3.0143235803311555167151651485231965602581338238536,
      3.2415136796310129503587732945183130796639221482042,
      3.4695856364185891697681598371294103733559227855906,
      3.6986168593184919397969539485760535948752486554752,
      3.9286886834276709720095023242871466851524016002606,
      4.1598868551310305400680411225876429394973862403352,
      4.392302078682684016744775569093026011111816408444,
      4.6260306357871557730740379959854765524883917545046,
      4.861175091791210210046066849049651598903759210722,
      5.09784510508913624700009193939928820181483169172,
      5.3361583601383604972771152654631793693757767432758,
      5.576241649329924103303485110097093953337203822098,
      5.818232135203517047362269817047869590598875519347,
      6.0622788326143026386651846010776852194050157282098,
      6.308544361112135121638817415387415841889996789733,
      6.557207031921539315980143109274836324215341213686,
      6.808463352858796414478980904321988789367313784202,
      7.062531060248865437465522731340211136955853371301,
      7.3196528223045353163320619830886983154201857246218,
      7.580100807857488884285808714779850800595244674054,
      7.84418238446082116879207953051081085258829182278,
      8.1122473111627919172116920138170293561681703167016,
      8.3846969404162650750860155396074513179782321306247,
      8.6619961681345177143760754560127444328156251045127,
      8.944689217325474478798596807541288507747329552581,
      9.2334208902191615504779366283532133797467520910863,
      9.5289658233901148046970657443074887808291687384498,
      9.8322698077779690943551615313409315780947453926671,
      10.144509941292845469888588301440455941004734121264,
      10.46718542134281214178313316357805048536805919779,
      10.80226075368471459482166754925048490352246777013,
      11.152404385585125264899035250356738671218866476907,
      11.521415400787030241694215193615806787762300833732,
      11.915061943114165801984797918762777070787192719624,
      12.342964222859674295102740266870727507684215885999,
      12.82379974948780890633912881377721549748456726861,
      13.4064873381449101384980153586516071458897569812959;
  map_points_[100] = points_100;
}

void Gauss_Hermite_Quadrature::FillAdaptedWeights() {
  Eigen::VectorXd AdaptedWeights_8(8);
  AdaptedWeights_8 << 1.0719301442479797564640154828686192710583035011087,
      0.8667526065633812222177945178444721007823603317873,
      0.7928900483864012509056467065099944670699652191022,
      0.7645441286517291990713914850625153797906970121608,
      0.7645441286517291990713914850625153797906970121608,
      0.7928900483864012509056467065099944670699652191022,
      0.8667526065633812222177945178444721007823603317873,
      1.0719301442479797564640154828686192710583035011087;
  map_AdaptedWeights_[8] = AdaptedWeights_8;
  Eigen::VectorXd AdaptedWeights_10(10);
  AdaptedWeights_10 << 1.0254516913657372330206021439998001007206764041771,
      0.820666126404816614571910879903882294986432537887,
      0.7414419319435649700820477018891891603635366640119,
      0.70329632310490617009834172682079856333223356450024,
      0.68708185395127336268656718422692784453580030087846,
      0.6870818539512733626865671842269278445358003008785,
      0.7032963231049061700983417268207985633322335645002,
      0.7414419319435649700820477018891891603635366640119,
      0.8206661264048166145719108799038822949864325378872,
      1.0254516913657372330206021439998001007206764041771;
  map_AdaptedWeights_[10] = AdaptedWeights_10;
  Eigen::VectorXd AdaptedWeights_12(12);
  AdaptedWeights_12 << 0.989699047092298099365013260061309904979902995276,
      0.7866439394633224644915380743541227886372855230251,
      0.7052203661122197557556715481998492923710656431374,
      0.662662773266871319239255150461100359348980754644,
      0.63962123202025660066934991623180131877302719880201,
      0.62930787436949282103571883185136329069537833837549,
      0.62930787436949282103571883185136329069537833837549,
      0.639621232020256600669349916231801318773027198802,
      0.66266277326687131923925515046110035934898075464401,
      0.70522036611221975575567154819984929237106564313742,
      0.7866439394633224644915380743541227886372855230251,
      0.9896990470922980993650132600613099049799029952755;
  map_AdaptedWeights_[12] = AdaptedWeights_12;
  Eigen::VectorXd AdaptedWeights_14(14);
  AdaptedWeights_14 << 0.960878703025659256530957856273245078574670135086,
      0.7599870873975660800632761513147237493826116686251,
      0.677706759192397010397799872260068292400349536379,
      0.63290060647233309082923787100002824017391731693,
      0.6063797391260974872052603343591461156764643412857,
      0.59110666704316242483025610616840494300223021601381,
      0.58406169052199623900075832593066558843366126221565,
      0.5840616905219962390007583259306655884336612622156,
      0.59110666704316242483025610616840494300223021601381,
      0.6063797391260974872052603343591461156764643412857,
      0.6329006064723330908292378710000282401739173169296,
      0.677706759192397010397799872260068292400349536379,
      0.75998708739756608006327615131472374938261166862506,
      0.960878703025659256530957856273245078574670135086;
  map_AdaptedWeights_[14] = AdaptedWeights_14;
  Eigen::VectorXd AdaptedWeights_16(16);
  AdaptedWeights_16 << 0.936874492884069357470004849342561171325068702881,
      0.738245622277681359882790450735840033408093284309,
      0.6557556728761177064705989221774875270966151707271,
      0.6097369582559972856242997148163131018517144433067,
      0.58124727540086389202624422184292731510412746076873,
      0.5632178290881998377123686952648505613118715089659,
      0.55244195736745939041573957443504654808920309409138,
      0.54737520503784399928196163481039041583828307915463,
      0.54737520503784399928196163481039041583828307915463,
      0.55244195736745939041573957443504654808920309409138,
      0.5632178290881998377123686952648505613118715089659,
      0.5812472754008638920262442218429273151041274607687,
      0.6097369582559972856242997148163131018517144433067,
      0.65575567287611770647059892217748752709661517072711,
      0.738245622277681359882790450735840033408093284309,
      0.936874492884069357470004849342561171325068702881;
  map_AdaptedWeights_[16] = AdaptedWeights_16;
  Eigen::VectorXd AdaptedWeights_18(18);
  AdaptedWeights_18 << 0.9163935375519155947662880291953182438433621949995,
      0.719993383105314144400021542382132236413335255132,
      0.637630172006160187495403399833138046386032910798,
      0.5909530034631081328753352419791538626101162669642,
      0.561279045549804538746093740280135250066751747336,
      0.54157867866213244558778798431831136530920994802962,
      0.5285894429188008800743612444401935861230623382277,
      0.5206349466760646162215527041692833691475359172075,
      0.5168458364816212822612399422473770735127756668207,
      0.5168458364816212822612399422473770735127756668207,
      0.52063494667606461622155270416928336914753591720746,
      0.5285894429188008800743612444401935861230623382277,
      0.5415786786621324455877879843183113653092099480296,
      0.561279045549804538746093740280135250066751747336,
      0.590953003463108132875335241979153862610116266964,
      0.637630172006160187495403399833138046386032910798,
      0.7199933831053141444000215423821322364133352551319,
      0.916393537551915594766288029195318243843362194999;
  map_AdaptedWeights_[18] = AdaptedWeights_18;
  Eigen::VectorXd AdaptedWeights_20(20);
  AdaptedWeights_20 << 0.898591961453191416420545454828522781943430553196,
      0.7043329611769424087138204002833519583892017111602,
      0.622278696191412280649317396569296403505856898279,
      0.575262442852503182139156253731619647430862573735,
      0.544851742364520005199359051276235186443829263999,
      0.524080350948557612676557263766842812596750345434,
      0.50967902711745800667286665991982639104787118706115,
      0.4999208713362905172649779639324870322555667062887,
      0.49384338527205292781460899199861133161984929633202,
      0.49092150066674582427959429560835390391359129040998,
      0.49092150066674582427959429560835390391359129040998,
      0.493843385272052927814608991998611331619849296332,
      0.4999208713362905172649779639324870322555667062887,
      0.5096790271174580066728666599198263910478711870611,
      0.5240803509485576126765572637668428125967503454339,
      0.544851742364520005199359051276235186443829263999,
      0.575262442852503182139156253731619647430862573735,
      0.622278696191412280649317396569296403505856898279,
      0.70433296117694240871382040028335195838920171116,
      0.898591961453191416420545454828522781943430553196;
  map_AdaptedWeights_[20] = AdaptedWeights_20;
  Eigen::VectorXd AdaptedWeights_40(40);
  AdaptedWeights_40 << 0.79217343042479188987800095748798411535774567837,
      0.613953703878935383944246291689536142504787739962,
      0.536616531144795196536723170248508610918146786087,
      0.490665384575827574543390365654021705490497311997,
      0.459424375107941603710371577218345173808391179699,
      0.436537482189441642164328468470713683872015807784,
      0.4189698708431732031240293469237776265259205587382,
      0.405060349154516337882290585279197190300142034582,
      0.3938118403658963050929861777821223128111093983517,
      0.384584951523524201762130019349088370018133158048,
      0.376948948361650239259741281290406302051303489467,
      0.3706026146575434159283205942344419468957845295787,
      0.3653292765749101735525280685904706175318557190108,
      0.3609698396280510762801426398148467820351636833947,
      0.3574059229232464112539845210821416756728513979189,
      0.3545489531398290125116992047959251509182701267523,
      0.3523329389876451331367093201797921020267727439583,
      0.35070961650094071619709743385068413742301776785814,
      0.34964518840941309218045459186871590112941250662274,
      0.34911818842117296421961593485789636945260602763304,
      0.349118188421172964219615934857896369452606027633,
      0.3496451884094130921804545918687159011294125066227,
      0.35070961650094071619709743385068413742301776785814,
      0.3523329389876451331367093201797921020267727439583,
      0.3545489531398290125116992047959251509182701267523,
      0.3574059229232464112539845210821416756728513979189,
      0.3609698396280510762801426398148467820351636833947,
      0.3653292765749101735525280685904706175318557190108,
      0.3706026146575434159283205942344419468957845295787,
      0.376948948361650239259741281290406302051303489467,
      0.384584951523524201762130019349088370018133158048,
      0.393811840365896305092986177782122312811109398352,
      0.405060349154516337882290585279197190300142034582,
      0.4189698708431732031240293469237776265259205587382,
      0.436537482189441642164328468470713683872015807784,
      0.459424375107941603710371577218345173808391179699,
      0.490665384575827574543390365654021705490497311997,
      0.536616531144795196536723170248508610918146786087,
      0.61395370387893538394424629168953614250478773996,
      0.79217343042479188987800095748798411535774567837;
  map_AdaptedWeights_[40] = AdaptedWeights_40;

  Eigen::VectorXd AdaptedWeights_100(100);
  AdaptedWeights_100 << 0.6743535524209081439144025322357969381272017071,
      0.518506807270200187726050665111323503038427962204,
      0.4499931710544165907648101872521147551333758224,
      0.40868865844190154714613837503957915906257950342,
      0.38013743880057595596193666992410590336797709384,
      0.3588184090711120834491848927844103303232485607,
      0.34208926231424714546011050858620558080828493449,
      0.32849948464545747856020223747214567572843775586,
      0.31717511097185385937581657915597613681593413933,
      0.307552728501673729425021966433176174327683014141,
      0.299249958039079093578440327494018648052919217681,
      0.291996563960276082259823793494679455502968596256,
      0.2855952145313678849370074481368712583044532496687,
      0.279897872545084658580480609338457328739955191921,
      0.274790938326829146069468993027033265118124824608,
      0.27018554353399078770286477498189887309588469265,
      0.266011005285956696413087151450559093401633842281,
      0.262210289443758959517549614653266828478241448795,
      0.258736790904380865770764353737768989580456052256,
      0.255552000562019435279616540371000633519831808597,
      0.252623783391417573284153133498430447377859549676,
      0.249925086601289282222331416606355747401733716912,
      0.247432956126835293415851674773995121032599185583,
      0.245127777913567834895395123882781470007877207313,
      0.242992685579107730478061435462116976292893659945,
      0.241013092922387224180078423754952089502145990545,
      0.239176321299559035958881946763582668655766586888,
      0.237471299920461647510524395875446862597050976355,
      0.235888322794699254658347185155053993143790400688,
      0.234418850121758228317060808304373017810627782989,
      0.233055344869710310073633127854054318689174911742,
      0.2317911374537038421006636685636535230105612914491,
      0.230620313034512848757842867301380704437147086747,
      0.229537617164869894480798355881041685000969115206,
      0.2285383764262468035420204238669485174237681995155,
      0.2276184313984020656428194886871545920347032826,
      0.22677407984368572366352959998646567756517227542359,
      0.226002028407800085009415685138971573253587753407,
      0.2252993514677081961876097873053529240523027388728,
      0.2246634560172451970005387549736599871520685064234,
      0.2240920516877911097339302674236748167112933999977,
      0.2235831251671776091962776632918640772865666868697,
      0.2231349184139684965646673456144631502542687237661,
      0.2227459101733572351354113660822711481187881733362,
      0.22241480039054435089974751581529092250163484713076,
      0.2221404971917734901660652328308870403188519987264,
      0.2219221061654981101361923007519455534479680431397,
      0.2217589217290237858046220853815951121613060743657,
      0.2216504204115155471103158805118085904679336523634,
      0.22159625592418327022113796043197491110732147551622,
      0.22159625592418327022113796043197491110732147551622,
      0.22165042041151554711031588051180859046793365236339,
      0.2217589217290237858046220853815951121613060743657,
      0.22192210616549811013619230075194555344796804313971,
      0.22214049719177349016606523283088704031885199872643,
      0.2224148003905443508997475158152909225016348471308,
      0.2227459101733572351354113660822711481187881733362,
      0.22313491841396849656466734561446315025426872376614,
      0.22358312516717760919627766329186407728656668686975,
      0.2240920516877911097339302674236748167112933999977,
      0.2246634560172451970005387549736599871520685064234,
      0.2252993514677081961876097873053529240523027388728,
      0.2260020284078000850094156851389715732535877534075,
      0.226774079843685723663529599986465677565172275424,
      0.2276184313984020656428194886871545920347032826002,
      0.2285383764262468035420204238669485174237681995155,
      0.229537617164869894480798355881041685000969115206,
      0.2306203130345128487578428673013807044371470867471,
      0.2317911374537038421006636685636535230105612914491,
      0.233055344869710310073633127854054318689174911742,
      0.234418850121758228317060808304373017810627782989,
      0.235888322794699254658347185155053993143790400688,
      0.237471299920461647510524395875446862597050976355,
      0.2391763212995590359588819467635826686557665868877,
      0.241013092922387224180078423754952089502145990545,
      0.242992685579107730478061435462116976292893659945,
      0.245127777913567834895395123882781470007877207313,
      0.247432956126835293415851674773995121032599185583,
      0.249925086601289282222331416606355747401733716912,
      0.252623783391417573284153133498430447377859549676,
      0.2555520005620194352796165403710006335198318085972,
      0.258736790904380865770764353737768989580456052256,
      0.262210289443758959517549614653266828478241448795,
      0.266011005285956696413087151450559093401633842281,
      0.270185543533990787702864774981898873095884692651,
      0.274790938326829146069468993027033265118124824608,
      0.279897872545084658580480609338457328739955191921,
      0.2855952145313678849370074481368712583044532496687,
      0.291996563960276082259823793494679455502968596256,
      0.299249958039079093578440327494018648052919217681,
      0.307552728501673729425021966433176174327683014141,
      0.31717511097185385937581657915597613681593413933,
      0.32849948464545747856020223747214567572843775586,
      0.34208926231424714546011050858620558080828493449,
      0.358818409071112083449184892784410330323248560695,
      0.38013743880057595596193666992410590336797709384,
      0.408688658441901547146138375039579159062579503416,
      0.44999317105441659076481018725211475513337582239,
      0.518506807270200187726050665111323503038427962204,
      0.6743535524209081439144025322357969381272017071;
  map_AdaptedWeights_[100] = AdaptedWeights_100;
}
}  // namespace xtp
}  // namespace votca
