# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2014-2015 Canonical Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import testtools
import fixtures, os, os.path, subprocess, stat
from gi.repository import Gio


class TestRunner(testtools.TestCase):
    @classmethod
    def setUpClass(self):
        super(TestRunner, self).setUpClass()
        self.tempDirFixture = fixtures.TempHomeDir()
        self.tempDirFixture.setUp()
        self.original_env = os.environ
        home = os.environ['HOME']
        os.chmod(home, stat.S_IRUSR + stat.S_IWUSR + stat.S_IXUSR)
        os.environ['ACCOUNTS'] = home
        os.environ['SSO_STORAGE_PATH'] = home
        os.environ['SSO_EXTENSIONS_DIR'] = '/tmp/this/should/not/exist'
        os.environ['SSO_DAEMON_TIMEOUT'] = '5'
        os.environ['SSO_IDENTITY_TIMEOUT'] = '5'
        os.environ['SSO_AUTHSESSION_TIMEOUT'] = '5'
        runtime_dir = os.path.join(home, 'runtime-dir')
        os.makedirs(runtime_dir, exist_ok=True)
        os.environ['XDG_RUNTIME_DIR'] = runtime_dir

        bus_address = os.path.join(home, 'dbus')
        escaped_address = Gio.dbus_address_escape_value(bus_address)
        os.environ['DBUS_SESSION_BUS_ADDRESS'] = 'unix:path=' + escaped_address
        args = [ 'dbus-daemon', '--session', '--address=unix:path=' + escaped_address, '--print-address' ]
        self.dbus_daemon = subprocess.Popen(args, stdout=subprocess.PIPE, universal_newlines=True)
        # Wait for the daemon to be started
        print('Starting D-Bus: ' + self.dbus_daemon.stdout.readline())

    @classmethod
    def tearDownClass(self):
        self.dbus_daemon.terminate()
        self.tempDirFixture.cleanUp()
        super(TestRunner, self).tearDownClass()
