/*
 * include file for libCW.h
 * cw_set/get functions, min/max WPM, and default values
 */


#define RTS 0
#define PA  1

#define DEFAULT_WPM        20        /* default wpm */
#define DEFAULT_FARNS_OFF   7        /* default min farns wpm */
#define DEFAULT_RT          4.0      /* default rise time in msec */
#define DEFAULT_FT          4.0      /* default fall time in msec */
#define DEFAULT_WT          0.0      /* default weight time in msec */
#define DEFAULT_RATIO       0.0      /* default ratio */
#define DEFAULT_TONE      800        /* default audio tone */
#define DEFAULT_SHAPE       0        /* default shape is Hanning */

#define PLAYTIME 0

/* Shape Modes */
#define HANNING   0
#define NUTTALL   1
#define BLACKMAN  2
#define BLACK_NUT 3
#define BLACK_HAR 4
#define HAMMING   5
#define RC        6
#define PLAY      7

int   cw_init (int newmode, char *name, char *ser);

int   cw_get_keyMode (void);
int   cw_set_keyMode (int newmode, char *str);

char  *cw_get_serdev ();
void  cw_set_serdev (char *serdev);

int   cw_get_doReply (void);
int   cw_set_doReply (int mode);

int   cw_get_wpm (void);
int   cw_set_wpm (int new_wpm);

int   cw_get_fwpm (void);
int   cw_set_fwpm (int new_fwpm);

int   cw_get_farns_off (void);
int   cw_set_farns_off (int new_farns_off);

float cw_get_rise_time (void);
float cw_set_rise_time (float r);

float cw_get_fall_time (void);
float cw_set_fall_time (float f);

float cw_get_weight (void);
float cw_set_weight (float w);

float cw_get_ratio (void);
float cw_set_ratio (float ratio);

int   cw_get_shape (void);
int   cw_set_shape (int shape);

int   cw_get_tone (void);
int   cw_set_tone (int new_tone);

int   cw_send_char (char ch);
int   cw_send_str  (char *str);
int   cw_send_word (char *str);

void  cw_exit (void);

/************** end sendCW.h **************/
