# (Damien Leroux, Inra, 2009)
# Once done this will define :
#
# GMP_FOUND - system has libgmp
# GMP_INCLUDE_DIR - the GMP include directory
# GMP_LIBRARIES - what to link against to use GMP

FIND_PATH(GMP_INCLUDE_DIR gmp.h)
FIND_LIBRARY(GMP_LIBRARY gmp)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(gmp DEFAULT_MSG GMP_LIBRARY GMP_INCLUDE_DIR)

#INCLUDE(CheckLibraryExists)
#CHECK_LIBRARY_EXISTS(${GMP_LIBRARY} _gmpf_init "" HAVE_GMP)
  MESSAGE(STATUS "GMP LIB: ${GMP_LIBRARY}")
  MESSAGE(STATUS "GMP include: ${GMP_INCLUDE_DIR}")

IF (GMP_FOUND)
   IF (NOT GMP_FIND_QUIETLY)
      MESSAGE(STATUS "Found gmp: ${GMP_LIBRARY}")
   ENDIF (NOT GMP_FIND_QUIETLY)
ELSE (GMP_FOUND)
   IF (GMP_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find gmp lib")
   ENDIF (GMP_FIND_REQUIRED)
ENDIF (GMP_FOUND)

MARK_AS_ADVANCED(GMP_INCLUDE_DIR GMP_LIBRARIES GMP_FOUND)

