/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_GUI_APP_HPP
#define INDII_GUI_APP_HPP

#if defined(__WXMSW__) && defined(UNICODE)
#define INDII_IMPLEMENT_APP(app) \
  IMPLEMENT_APP_NO_MAIN(app) \
  \
  extern "C" int WINAPI wWinMain(HINSTANCE hInstance, \
      HINSTANCE hPrevInstance, wchar_t* WXUNUSED(lpCmdLine), \
      int nCmdShow) { \
   wxDISABLE_DEBUG_SUPPORT(); \
   return wxEntry(hInstance, hPrevInstance, NULL, nCmdShow); \
}
#else
#define INDII_IMPLEMENT_APP(app) IMPLEMENT_APP(app)
#endif

#include "Window.hpp"
#include "WindowObserver.hpp"
#include "../model/Model.hpp"
#include "../image/ImageResource.hpp"

#include "wx/app.h"
#include "wx/cmdline.h"

#include <set>

namespace indii {
/**
 * Application.
 *
 * @tparam WindowType Window type.
 * @tparam ObserverType Window observer type.
 * @tparam SplashType Splash type.
 */
class App : public wxApp, public WindowObserver {
public:
  /**
   * Constructor.
   */
  App();
  
  virtual void MacOpenFiles(const wxArrayString& fileNames);

  bool OnInit();

  void OnInitCmdLine(wxCmdLineParser& parser);

  bool OnCmdLineParsed(wxCmdLineParser& parser);

  int OnRun();

  int OnExit();

  /**
   * Open menu item event.
   */
  void OnButtonOpen(wxCommandEvent& evt);

  /**
   * Open recent menu event.
   */
  void OnOpenRecent(wxCommandEvent& evt);

  /**
   * About menu item event.
   */
  void OnButtonAbout(wxCommandEvent& evt);

  /**
   * Register menu item event.
   */
  void OnButtonRegister(wxCommandEvent& evt);

  /**
   * Help menu item event.
   */
  void OnButtonHelp(wxCommandEvent& evt);

  /**
   * Exit button event.
   */
  void OnButtonExit(wxCommandEvent& evt);

  /**
   * Notify that window is closing.
   *
   * @param window The window being closed.
   * @param exiting Is program exiting?
   */
  virtual void notifyClose(Window* window, const bool exiting = false);

protected:
  /**
   * Show splash screen.
   */
  virtual void splash() = 0;

  /**
   * Open window with file.
   */
  virtual Window* open(const wxString& file) = 0;

  /**
   * Open window without file.
   */
  virtual Window* open() = 0;

  /**
   * Main window.
   */
  Window* window;

  /**
   * Open recent menu.
   */
  OpenRecentMenu* mnRecent;

  /**
   * File name to open.
   */
  wxString file;
  
  /**
   * Have a file to open?
   */
  bool haveFile;
  
  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_DEFAULT = 1, // can't have menu item id of 0 on Mac
    ID_BUT_REGISTER,
    ID_OPEN_RECENT = 765 // must match OpenRecentMenu
  };

  DECLARE_EVENT_TABLE()
};
}

#endif
