/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_MODEL_OBSERVER_HPP
#define INDII_MODEL_OBSERVER_HPP

#include "Observable.hpp"

namespace indii {
/**
 * Abstract observer.
 */
class Observer {
public:
  /**
   * Constructor.
   */
  Observer();

  /**
   * Destructor. Object will automatically call unsubscribe() on any watched
   * Observable object if necessary.
   */
  virtual ~Observer();

  /**
   * Observe an object.
   */
  void watch(Observable* o);
   
  /**
   * Stop observing the object.
   */
  void ignore();
   
  /**
   * Notify of change.
   */
  virtual void notify();

  /**
   * Notify change of greyscale parameters.
   */
  virtual void notifyGreyscaleChange();

  /**
   * Notify of destruction.
   */
  void notifyDestroy();
  
private:
  /**
   * Observed object.
   */
  Observable* o;

  /**
   * Are we currently observing an object?
   */
  bool watching;
};
}

inline void indii::Observer::notify() {
  //
}

inline void indii::Observer::notifyGreyscaleChange() {
  //
}

inline void indii::Observer::notifyDestroy() {
  this->watching = false;
}

#endif
