---
myst:
  html_meta:
    keywords: LaTeX, fichier, XML, SGML
---

# Comment convertir SGML ou HTML en TeX ?

Le SGML est un système très important pour le stockage et l'échange de documents, 
mais il n'a pas de fonctions de formatage. La norme ISO qui l'accompagne, 
[DSSSL](http://www.jclark.com/dsssl), est conçue pour l'écriture de transformations 
et le formatage, mais elle n'a pas encore été largement mise en œuvre. 
Certains systèmes de création SGML (par exemple `Author/Editor` de SoftQuad) 
ont des capacités de formatage, et il existe des systèmes de composition SGML spécialisés 
haut de gamme (par exemple, `Genera` de Miles33). 
Cependant, la majorité des utilisateurs de SGML transforment leur source SGML 
en des formats disposant de système de composition, dès lors qu'existe un besoin
d'imprimer ces éléments. TeX est un bon candidat pour cela. 
Il y a trois approches pour écrire un traducteur :

1. Écrire un traducteur autonome de manière traditionnelle, 
  avec des outils comme `yacc` et `lex`. C'est, en pratique, difficile 
  à cause de la complexité du SGML.

2. Utiliser un langage spécialisé conçu pour les transformations SGML. 
  Les plus connus sont probablement `Omnimark` et `Balise`. Ils sont chers, mais puissants, 
  car ils intègrent des capacités d'interrogation et de transformation SGML 
  ainsi qu'une simple traduction de format.

3. Construire un traducteur à partir d'un analyseur SGML existant. 
  L'analyseur de loin le plus connu (et gratuit !) est `nsgmls` de James Clark. 
  Il produit un format de sortie beaucoup plus simple, appelé ESIS, 
  qui peut être analysé assez directement (on a aussi l'avantage d'une analyse SGML 
  par rapport à la DTD). Deux bonnes extensions du domaine public utilisent cette méthode :
   - [sgmlspm](http://www.cpan.org/modules/by-module/SGMLS/) de David Megginson, 
     écrit en Perl 5.
   - [STIL](ftp://ftp.tu-darmstadt.de/pub/text/sgml/stil) (*SGML Transformations in Lisp*),
     de Joachim Schrod et Christine Detig.

Ces deux logiciels permettent à l'utilisateur d'écrire des codes gérant chaque élément SGML, 
avec de nombreux accès aux attributs, aux entités et aux informations 
sur le contexte dans l'arborescence du document.

Si ces extensions ne répondent pas à vos besoins pour un travail de composition SGML 
de taille moyenne, vous devrez vous tourner vers les gros produits commerciaux. 

Le HTML étant simplement un exemple de SGML, nous n'avons pas besoin d'un système spécifique 
pour le HTML. Cependant, Nathan Torkington a développé <ctanpkg:html2latex> 
à partir de l'analyseur HTML du paquet Xmosaic du NCSA. 
Le programme prend un fichier HTML et génère un fichier LaTeX à partir de celui-ci. 
Le code de conversion est soumis aux restrictions du NCSA, 
mais [l'ensemble des sources](<ctanpkg:html2latex>) est disponible sur le CTAN.

Michel Goossens et Janne Saarela ont publié un [résumé](https://tug.org/TUGboat/tb16-2/tb47goo1.pdf) 
très utile du SGML et des outils du domaine public pour l'écrire et le manipuler dans le
[volume 16(2) de TUGboat](https://tug.org/tugboat/Contents/contents16-2.html).


:::{sources}
[Conversion from SGML or HTML to TeX](faquk:FAQ-SGML2TeX)
:::