---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie,
              style des entrées bibliographiques,
              style de bibliographie, bibtex
---

# Comment choisir un style de bibliographie BibTeX ?

Le style de la bibliographie est défini par la commande `\bibliographystyle`. 
Son argument indique le fichier de style (fichier BST) à utiliser.

Les fichiers de style bibliographique sont lus par BibTeX. 
Ils lui indiquent la mise en page à utiliser. Voici les caractéristiques 
des principaux styles en se basant sur les mêmes entrées bibliographiques.


## Les quatre styles de base de BibTeX

Les styles de base de BibTeX sont par défaut en anglais. Des styles 
pour d'autres langues sont évoqués à la question 
"[](/3_composition/annexes/bibliographie/style_bst/bibliographies_internationales)".


### Les styles `abbrv` et `abbrv-fr`

Le style [abbrv](ctanpkg:bibtex) (pour *abbreviated*) est similaire au style 
[plain](ctanpkg:bibtex) ci-dessous, mais les prénoms des auteurs 
ainsi que les noms des mois sont abrégés.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{abbrv-fr}
\bibliography{mabiblio}
\end{document}
```


### Les styles `alpha` et `alpha-fr`

Le style [alpha](ctanpkg:bibtex) (pour *alphabetic*) présente 
les clefs utilisées dans le document sous la forme mélangeant début du nom 
et année d'édition. Les entrées sont également triées dans l'ordre alphabétique
des auteurs.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{alpha-fr}
\bibliography{mabiblio}
\end{document}
```


### Les styles `plain` et `plain-fr`

Le style [plain](ctanpkg:bibtex) donne des clés numériques 
(par exemple "\[12\]"). Les entrées sont triées dans l'ordre alphabétique
des auteurs.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{plain-fr}
\bibliography{mabiblio}
\end{document}
```


### Les styles `unsrt` et `unsrt-fr`

Le style [unsrt](ctanpkg:bibtex) (pour *unsorted*) donne également 
des clés numériques. Les entrées ne sont ici pas triées, elles apparaissent 
dans l'ordre où elles sont citées dans le document.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{unsrt-fr}
\bibliography{mabiblio}
\end{document}
```

Ce style peut demander certaines manipulations pour éviter des anomalies, 
comme le montre la question 
"[](/3_composition/annexes/bibliographie/style_bst/probleme_avec_le_style_unsrt)"


## Les styles `apalike` et `apalike-fr`

Le style [apalike](ctanpkg:bibtex) propose des clefs constituées 
des noms complets des auteurs, ainsi que de l'année. Le tri est fait suivant
les noms des auteurs.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{apalike-fr}
\bibliography{mabiblio}
\end{document}
```

L'aspect de ce style peut être modifié avec l'extension <ctanpkg:apalike> : 
les étiquettes de référence sont alors entourées de parenthèses et les clés 
(très redondantes avec le contenu de chaque entrée) ne sont pas redonnées 
dans la bibliographie.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{complot,
    author    = "Machiavel, Nicolas",
    title     = "Le complot pour les nuls",
    publisher = "{\'E}ditions Dubois",
    year      = "1522"
  }
  @Article{vu,
    author  = "Londres, Albert and Rochefort, Henri",
    title   = "Machiavel n'avait rien vu",
    journal = "Le quotidien d'hier",
    year    = "1912"
  }
  @Book{titrer,
    author    = "Escher, Maurits Cornelis",
    title     = "Comment mal titrer un livre, y compris celui-ci",
    publisher = "{\'E}ditions du labyrinthe",
    year      = "1956",
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{apalike}

\begin{document}
Voici quelques références : \cite{vu}, \cite{complot} et \cite{titrer}.
\bibliographystyle{apalike-fr}
\bibliography{mabiblio}
\end{document}
```


## Autres styles

Si beaucoup de gens se contentent avec bonheur de l'un des styles vus 
jusqu'ici, aucun de ces styles ne propose de références sous la forme 
"auteur-date", populaire dans de nombreux domaines. En revanche, il existe 
un très grand nombre de styles distribués séparément, qui prennent en charge 
ce format.

Notez que le format "auteur-date" a été inventé parce que le format 
de références produit par le style [plain](ctanpkg:bibtex), pourtant simple et 
clair, serait une horreur à produire manuellement, en l'absence d'outil 
comme BibTeX. TeX, LaTeX et BibTeX éliminant les difficultés pendant la phase 
de préparation du manuscrit, vous avez de nouveau le choix 
parmi toute une panoplie de styles.

De nombreux sites d'aide existent sur le web :

- un exemple de document, montrant les formats disponibles, peut être trouvé 
  sur le
  [site web de Ken Turner](https://www.cs.stir.ac.uk/~kjt/software/latex/showbst.html) ;
- une excellente étude, qui répertorie et classe une grande variété de formats
  de citations, avec beaucoup d'exemples, intitulée 
  "[Choosing a BibTeX style](https://www.reed.edu/it/help/LaTeX/bibtexstyles.html)", 
  sur le site du Reed College.

Bien sûr, ces pages ne sont pas exhaustives... Le principal problème 
de l'utilisateur curieux sera de comprendre ce que font réellement 
les différents styles disponibles. Le meilleur moyen d'y parvenir 
(si les liens ci-dessus ne suffisent pas) est d'utiliser le fichier 
[xampl.bib](ctanpkg:bibtex), fourni avec la [documentation](texdoc:bibtex) 
de BibTeX : il est possible de se faire une idée assez précise de ce que fait 
chaque style en utilisant ce fichier standard. Par exemple, pour tester 
le style `mon-style.bst`, vous pouvez écrire et compiler ce simple document 
LaTeX :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\bibliographystyle{mon-style}
\nocite{*}
\bibliography{xampl}
\end{document}
```

Cela produira un échantillon représentatif des formats de citations offerts 
par le style (mais [xampl.bib](ctanpkg:bibtex) est un peu extrême 
dans certains de ses exemples et l'exécution de BibTeX vous montrera également
une sélection intéressante de ses messages d'erreur...).


:::{sources}
- [Choosing a bibliography style](faquk:FAQ-whatbst)
:::