[comment {-*- tcl -*- doctools manpage}]
[manpage_begin term::send n 0.1]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Terminal control}]
[titledesc {General output to terminals}]
[category  {Terminal control}]
[require Tcl 8.4]
[require term::send [opt 0.1]]
[description]

This package provides the most primitive commands for sending characters
to a terminal. They are in essence convenient wrappers around the
builtin command [cmd puts].

[list_begin definitions]
[call [cmd ::term::send::wrch] [arg chan] [arg str]]

Send the text [arg str] to the channel specified by the handle [arg chan].
In contrast to the builtin command [cmd puts] this command does not
terminate the string with a line terminator. It also forces an  flush of
Tcl internal and OS buffers to ensure that the characters are processed
immediately.

[call [cmd ::term::send::wr] [arg str]]

This convenience command is like [cmd ::term::send::wrch], except that the
destination channel is fixed to [emph stdout].

[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph term] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords terminal control {character output}]
[manpage_end]
