#ifndef INCLUDES_TARANTOOL_LUA_CRYPTO_H
#define INCLUDES_TARANTOOL_LUA_CRYPTO_H
/*
 * Copyright 2010-2015, Tarantool AUTHORS, please see AUTHORS file.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY <COPYRIGHT HOLDER> ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * <COPYRIGHT HOLDER> OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <openssl/evp.h>
#include <openssl/hmac.h>

#if defined(__cplusplus)
extern "C" {
#endif

int tnt_EVP_CIPHER_key_length(const EVP_CIPHER *cipher);
int tnt_EVP_CIPHER_iv_length(const EVP_CIPHER *cipher);
int tnt_openssl_init();
EVP_MD_CTX *tnt_EVP_MD_CTX_new(void);
void tnt_EVP_MD_CTX_free(EVP_MD_CTX *ctx);

HMAC_CTX *tnt_HMAC_CTX_new(void);
void tnt_HMAC_CTX_free(HMAC_CTX *ctx);

#if defined(__cplusplus)
}
#endif

#endif /* INCLUDES_TARANTOOL_LUA_CRYPTO_H */
