C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LRAID3
C                       *****************
C
C      -----------------------------------------------------
     * (NDIM,NPOINR,NELRAY,NODRAY,NRFRAY,COORAY)
C      -----------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS RAYONNEMENT           *
C                  STRUCTURE DE DONNEE ISSUE DE IDEAS MS               *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (3     )               !
C !  NPOINR   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NODRAY   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE RAYONNEMENT !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !  COORAY   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE RAYONNEMENT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    !    !                                              !
C ! /DIVCT/   !    !    !                                              !
C ! /NLOFES/  !    !    !                                              !
C ! /NLOFCT/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NPOINR,NDIM
      INTEGER NODRAY(NELRAY,NDIM),NRFRAY(NELRAY)
      DOUBLE PRECISION  COORAY(NPOINR,NDIM)
C
C.. Variables internes
      INTEGER N,I,J,NUMMAX
      INTEGER NUM,ID,N1,N2,N3,NBNO,NR
      CHARACTER*80 CH
C
C***********************************************************************
C
C
C     2- LECTURE DE LA TABLE DES NOEUDS
C     =================================
C
      CALL SECIDE(NFSGRA,2411)
C
      DO 220 N=1,NPOINR
        READ(NFSGRA,2200) N1,N2,N3,NR
        READ(NFSGRA,2210) (COORAY(N,J),J=1,NDIM)
  220 CONTINUE
C
C
C
C     3- TABLE DES ELEMENTS
C     =====================
C
      CALL SECIDE(NFSGRA,2412)
C
C
      IF(NDIM.EQ.3) THEN
        DO 320 N=1,NELRAY
          READ(NFSGRA,3200) NUM,ID,N1,N2,NRFRAY(N),NBNO
          READ(NFSGRA,3201) (NODRAY(N,I),I=1,NBNO)
  320   CONTINUE
      ELSE
        DO 321 N=1,NELRAY
          READ(NFSGRA,3200) NUM,ID,N1,N2,NRFRAY(N),NBNO
          READ(NFSGRA,3000) CH
          READ(NFSGRA,3201) (NODRAY(N,I),I=1,NBNO)
  321   CONTINUE
      ENDIF
C
      NUMMAX=0
      DO N=1,NELRAY
        DO I=1,NDIM
          NUMMAX=MAX(NUMMAX,NODRAY(N,I))
        ENDDO
      ENDDO
      IF (NUMMAX.GT.NPOINR) THEN
         WRITE(NFECRA,6000)
         STOP
      ENDIF
C
C
C     4- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLR.GT.0) THEN
        WRITE(NFECRA,4000)
        WRITE(NFECRA,4010) NDIM,NPOINR,NELRAY
      ENDIF
C
C
C     5- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLR.GE.2) THEN
C
      WRITE(NFECRA,5000) 
      WRITE(NFECRA,5010)
      DO 100 I=1,10
        WRITE(NFECRA,5011) I,(COORAY(I,J),J=1,NDIM)
  100 CONTINUE
C
      WRITE(NFECRA,5020)
      DO 110 I=1,10
        WRITE(NFECRA,5012)I,(NODRAY(I,J),J=1,NDIM)
 110  CONTINUE
C
      WRITE(NFECRA,5030)
      DO 120 I=1,10
        WRITE(NFECRA,5013)I,NRFRAY(I)
 120  CONTINUE
C
C
      ENDIF  
C
C--------
C FORMATS
C--------
C
 2200 FORMAT(4I10)
 2210 FORMAT(1P3D25.16)
 3000 FORMAT(A80)
 3200 FORMAT(6I10)
 3201 FORMAT(8I10)
C
 4000 FORMAT(//,' *** LRAID2 : MAILLAGE POUR LE RAYONNEMENT :')
 4010 FORMAT(8X,'- Dimension du maillage            : ',I6,/
     &       8X,'- Nombre total de noeuds           : ',I6,/
     &       8X,'- Nombre d''elements                : ',I6)
C
 5000 FORMAT(/,' *** LRAID2 : Verification du maillage solide',/)
 5010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 5020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 5030 FORMAT(/,14X,'References des 10 premiers elements :',/)
 5011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5)
 5012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I6)
 5013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
C
 6000 FORMAT(/,' %% ERREUR LRAID3 : LA NUMEROTATION DES NOEUDS DU',
     * ' MAILLAGE POUR LE RAYONNEMENT',/,
     *         '                    COMPORTE DES TROUS',/,
     *         '                    VEUILLEZ RENUMEROTER VOTRE',
     * ' MAILLAGE POUR AVOIR UNE NUMEROTATION CONTINUE')
C
      END
