/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROGETTCMD_H
#define _SC_PROPGETCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class PropGetParam;


/**
 * Command for getting the properties of a path or url.
 */
class PropGetCmd : public ScCmd
{
public:
  /**
   * Construct a PropGetCmd.
   *
   * \param param the parameters for the command. The command takes ownership
   * of the parameter object and deletes it if it itself destroyed.
   *
   * \param cb the callback that gets called when the command has finished.
   * 
   */
  PropGetCmd( PropGetParam* param, CmdResultCallback* cb );
  ~PropGetCmd();

  void run();

private:
  // in
  PropGetParam*      _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_PROPGETCMD_H
