/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMIT_H
#define _SC_COMMIT_H

// sc
#include "svn/CommitBaton.h"
class CommitDialog;


class Commit : public svn::CommitBaton
{
public:
  /**
   * implicit commit.
   */
  Commit();
  /**
   * explicit commit, show "list items"
   */
  Commit( CommitDialog* dlg );
  /**
   * explicit commit, skip "list items"
   */
  Commit( const sc::String& log );

  // svn::CommitBaton
  bool getLogMsg( sc::String& logMsg, sc::String& tmpFile, const svn::CommitItems& items );
  
private:
  enum Type {
    Implicit,
    ExplicitShow,
    ExplicitSkip
  };
  
  Type          _type;
  
  CommitDialog* _dlg;
  sc::String    _log;
  
};

#endif //  _SC_COMMIT_H

