/*
 * Decompiled with CFR 0.152.
 */
package adql.db.region;

import adql.db.region.STCS;
import adql.parser.grammar.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordSys {
    private static final String coordSysRegExp = Frame.regexp + "?\\s*" + RefPos.regexp + "?\\s*" + Flavor.regexp + "?";
    private static final String onlyCoordSysRegExp = "^\\s*" + coordSysRegExp + "\\s*$";
    private static final String defaultCoordSysRegExp = "^\\s*" + (Object)((Object)Frame.DEFAULT) + "?\\s*" + (Object)((Object)RefPos.DEFAULT) + "?\\s*" + (Object)((Object)Flavor.DEFAULT) + "?\\s*$";
    private static final String allowedCoordSysRegExp = "^\\s*" + CoordSys.buildAllowedRegExp(Frame.regexp) + "\\s+" + CoordSys.buildAllowedRegExp(RefPos.regexp) + "\\s+" + CoordSys.buildAllowedRegExp(Flavor.regexp) + "\\s*$";
    private static final Pattern allowedCoordSysPattern = Pattern.compile(allowedCoordSysRegExp);
    public static final String COORD_SYS_SYNTAX = "\"[" + Frame.regexp + "] [" + RefPos.regexp + "] [" + Flavor.regexp + "]\" ; an empty string is also allowed and will be interpreted as the coordinate system locally used";
    public final Frame frame;
    public final RefPos refpos;
    public final Flavor flavor;
    private final boolean isDefault;
    private final String stcs;
    private final String fullStcs;

    private static String buildAllowedRegExp(String rootRegExp) {
        return "(" + rootRegExp + "|\\*|(\\(\\s*" + rootRegExp + "\\s*(\\|\\s*" + rootRegExp + "\\s*)*\\)))";
    }

    public CoordSys() {
        this(null, null, null);
    }

    public CoordSys(Frame fr, RefPos rp, Flavor fl) throws IllegalArgumentException {
        this.frame = fr == null ? Frame.DEFAULT : fr;
        this.refpos = rp == null ? RefPos.DEFAULT : rp;
        Flavor flavor = this.flavor = fl == null ? Flavor.DEFAULT : fl;
        if (this.flavor != Flavor.SPHERICAL2 && (this.frame != Frame.UNKNOWNFRAME || this.refpos != RefPos.UNKNOWNREFPOS)) {
            throw new IllegalArgumentException("a coordinate system expressed with a cartesian flavor MUST have an UNKNOWNFRAME and UNKNOWNREFPOS!");
        }
        this.isDefault = this.frame.isDefault() && this.refpos.isDefault() && this.flavor.isDefault();
        this.stcs = ((!this.frame.isDefault() ? (Object)((Object)this.frame) + " " : "") + (!this.refpos.isDefault() ? (Object)((Object)this.refpos) + " " : "") + (!this.flavor.isDefault() ? this.flavor : "")).trim();
        this.fullStcs = (Object)((Object)this.frame) + " " + (Object)((Object)this.refpos) + " " + (Object)((Object)this.flavor);
    }

    public CoordSys(String coordsys) throws ParseException {
        CoordSys tmp = new STCS.STCSParser().parseCoordSys(coordsys);
        this.frame = tmp.frame;
        this.refpos = tmp.refpos;
        this.flavor = tmp.flavor;
        this.isDefault = tmp.isDefault;
        this.stcs = tmp.stcs;
        this.fullStcs = tmp.fullStcs;
    }

    private static String buildRegexp(Class<?> enumType) throws IllegalArgumentException {
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("An enum class was expected, but a " + enumType.getName() + " has been given!");
        }
        ?[] constants = enumType.getEnumConstants();
        if (constants == null || constants.length == 0) {
            return "\\s*";
        }
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < constants.length; ++i) {
            buf.append(constants[i]);
            if (i + 1 >= constants.length) continue;
            buf.append('|');
        }
        return buf.append(')').toString();
    }

    public static String buildCoordSysRegExp(String[] allowedCoordSys) throws ParseException {
        if (allowedCoordSys == null) {
            return onlyCoordSysRegExp;
        }
        if (allowedCoordSys.length == 0) {
            return defaultCoordSysRegExp;
        }
        StringBuffer finalRegExp = new StringBuffer("^\\s*(");
        int nbCoordSys = 0;
        for (int i = 0; i < allowedCoordSys.length; ++i) {
            if (allowedCoordSys[i] == null) continue;
            if (nbCoordSys > 0) {
                finalRegExp.append('|');
            }
            ++nbCoordSys;
            Matcher m = allowedCoordSysPattern.matcher(allowedCoordSys[i].toUpperCase());
            if (m.matches()) {
                finalRegExp.append('(');
                for (int g = 0; g < 3; ++g) {
                    if (m.group(2 + 6 * g) != null) {
                        finalRegExp.append('(').append(CoordSys.defaultChoice(g, m.group(2 + 6 * g))).append(m.group(2 + 6 * g)).append(')');
                    } else if (m.group(3 + 6 * g) != null) {
                        finalRegExp.append('(').append(CoordSys.defaultChoice(g, m.group(3 + 6 * g))).append(m.group(3 + 6 * g).replaceAll("\\s", "").substring(1));
                    } else {
                        switch (g) {
                            case 0: {
                                finalRegExp.append(Frame.regexp);
                                break;
                            }
                            case 1: {
                                finalRegExp.append(RefPos.regexp);
                                break;
                            }
                            case 2: {
                                finalRegExp.append(Flavor.regexp);
                            }
                        }
                        finalRegExp.append('?');
                    }
                    finalRegExp.append("\\s*");
                }
                finalRegExp.append(')');
                continue;
            }
            throw new ParseException("Wrong allowed coordinate system syntax for the " + (i + 1) + "-th item: \"" + allowedCoordSys[i] + "\"! Expected: \"frameRegExp refposRegExp flavorRegExp\" ; where each xxxRegExp = (xxx | '*' | '('xxx ('|' xxx)*')'), frame=\"" + Frame.regexp + "\", refpos=\"" + RefPos.regexp + "\" and flavor=\"" + Flavor.regexp + "\" ; an empty string is also allowed and will be interpreted as '*' (so all possible values).");
        }
        finalRegExp.append(")\\s*$");
        return nbCoordSys > 0 ? finalRegExp.toString() : defaultCoordSysRegExp;
    }

    private static String defaultChoice(int g, String value) {
        switch (g) {
            case 0: {
                return value.contains(Frame.DEFAULT.toString()) ? "" : (Object)((Object)Frame.DEFAULT) + "|";
            }
            case 1: {
                return value.contains(RefPos.DEFAULT.toString()) ? "" : (Object)((Object)RefPos.DEFAULT) + "|";
            }
            case 2: {
                return value.contains(Flavor.DEFAULT.toString()) ? "" : (Object)((Object)Flavor.DEFAULT) + "|";
            }
        }
        return "";
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public String toSTCS() {
        return this.stcs;
    }

    public String toFullSTCS() {
        return this.fullStcs;
    }

    public String toString() {
        return this.stcs;
    }

    public static enum Flavor {
        CARTESIAN2,
        CARTESIAN3,
        SPHERICAL2;

        public static final Flavor DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = SPHERICAL2;
            regexp = CoordSys.buildRegexp(Flavor.class);
        }
    }

    public static enum RefPos {
        BARYCENTER,
        GEOCENTER,
        HELIOCENTER,
        LSR,
        TOPOCENTER,
        RELOCATABLE,
        UNKNOWNREFPOS;

        public static final RefPos DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNREFPOS;
            regexp = CoordSys.buildRegexp(RefPos.class);
        }
    }

    public static enum Frame {
        ECLIPTIC,
        FK4,
        FK5,
        J2000,
        GALACTIC,
        ICRS,
        UNKNOWNFRAME;

        public static final Frame DEFAULT;
        public static final String regexp;

        public final boolean isDefault() {
            return this == DEFAULT;
        }

        static {
            DEFAULT = UNKNOWNFRAME;
            regexp = CoordSys.buildRegexp(Frame.class);
        }
    }
}

