-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Text_IO;
with Sparklalr_Common;
with Sparklalr_Error;
with Sparklalr_Symbol;

use type Sparklalr_Symbol.Symbol;

--# inherit Command_Line_Options,
--#         Fatal,
--#         SPARK.Ada.Command_Line,
--#         SPARK.Ada.Strings.Unbounded,
--#         SPARK.Ada.Text_IO,
--#         SPARK.Ada.Text_IO.Unbounded_String,
--#         Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_Error,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Symbol,
--#         SPARK_Ada_Integer_Text_IO,
--#         Symbols_Dump;

package Sparklalr_Input
--# own State;
is

   type Symbol_Set_Type is private;

   Symbol_Set_False_Const : constant Symbol_Set_Type;

   procedure Initialise (Signpost : out Symbol_Set_Type);
   --# global in     Command_Line_Options.State;
   --#        in out SPARK.Ada.Command_Line.State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Error;
   --#           out Sparklalr_Char_Class.Charmap;
   --#           out Sparklalr_Error.State;
   --#           out Sparklalr_Level.State;
   --#           out State;
   --# derives Signpost,
   --#         Sparklalr_Char_Class.Charmap,
   --#         Sparklalr_Level.State                from  &
   --#         SPARK.Ada.Command_Line.State,
   --#         SPARK.Ada.Text_IO.The_Standard_Error from *,
   --#                                                   Command_Line_Options.State &
   --#         Sparklalr_Error.State,
   --#         State                                from Command_Line_Options.State;

   procedure Finalize (F : in out SPARK.Ada.Text_IO.File_Type);
   --# global in     State;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --# derives F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         Sparklalr_Error.State                 from *,
   --#                                                    State;

   function Signpost_To_Symbol_Set_Type (Signpost : in Symbol_Set_Type) return Symbol_Set_Type;

   procedure Scan
     (F     : in out SPARK.Ada.Text_IO.File_Type;
      Col   : in out Sparklalr_Error.Err_Col_T;
      Symb  :    out Sparklalr_Symbol.Symbol;
      Token :    out Sparklalr_Common.Id_Name);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         State,
   --#         Symb,
   --#         Token                                 from Col,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State &
   --#         F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output from *,
   --#                                                    Col,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State;

   procedure Skipto
     (F       : in out SPARK.Ada.Text_IO.File_Type;
      Arg_Set : in     Symbol_Set_Type;
      Col     : in out Sparklalr_Error.Err_Col_T;
      Symb    : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out State;
   --# derives Col,
   --#         F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         Sparklalr_Error.State,
   --#         State,
   --#         Symb                                  from *,
   --#                                                    Arg_Set,
   --#                                                    Col,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State,
   --#                                                    Symb;

   procedure Copy_Action
     (F, Echo  : in out SPARK.Ada.Text_IO.File_Type;
      Signpost : in     Symbol_Set_Type;
      Col      : in out Sparklalr_Error.Err_Col_T;
      Symb     : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --# derives Col,
   --#         Echo,
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         Sparklalr_Error.State,
   --#         State,
   --#         Symb                                  from *,
   --#                                                    Col,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State,
   --#                                                    Symb &
   --#         F,
   --#         Sparklalr_Level.State                 from *,
   --#                                                    Col,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    Sparklalr_Memory.Prod_No,
   --#                                                    State,
   --#                                                    Symb;

   procedure Skip_Action
     (F        : in out SPARK.Ada.Text_IO.File_Type;
      Signpost : in     Symbol_Set_Type;
      Col      : in out Sparklalr_Error.Err_Col_T;
      Symb     : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out State;
   --# derives Col,
   --#         F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         Sparklalr_Error.State,
   --#         State,
   --#         Symb                                  from *,
   --#                                                    Col,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State,
   --#                                                    Symb;

   procedure Proc_Term
     (F          : in out SPARK.Ada.Text_IO.File_Type;
      Gram_Rules :    out Boolean;
      Col        : in out Sparklalr_Error.Err_Col_T;
      Signpost   : in     Symbol_Set_Type;
      Symb       :    out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out SPARK.Ada.Text_IO.The_Standard_Output;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --#        in out Symbols_Dump.State;
   --# derives Col,
   --#         F,
   --#         SPARK.Ada.Text_IO.The_Standard_Output,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Level.State,
   --#         State,
   --#         Symbols_Dump.State                    from *,
   --#                                                    Col,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State &
   --#         Gram_Rules                            from  &
   --#         Symb                                  from Col,
   --#                                                    Signpost,
   --#                                                    Sparklalr_Char_Class.Charmap,
   --#                                                    Sparklalr_Error.State,
   --#                                                    State,
   --#                                                    Symbols_Dump.State;

   -- Setter
   procedure Set_Symbol_Set (Symbol_Set : in out Symbol_Set_Type;
                             Symb       : in     Sparklalr_Symbol.Symbol;
                             Value      : in     Boolean);
   --# derives Symbol_Set from *,
   --#                         Symb,
   --#                         Value;

   -- Getter
   function Get_Symbol_Set (Symbol_Set : in Symbol_Set_Type;
                            Symb       : in Sparklalr_Symbol.Symbol) return Boolean;

private

   type Symbol_Set_Type is array (Sparklalr_Symbol.Symbol) of Boolean;

   Symbol_Set_False_Const : constant Symbol_Set_Type := Symbol_Set_Type'(others => False);

end Sparklalr_Input;
