# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/html.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html generation, processing

=end
module SiSU_HTML
  begin
    require 'pstore'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('pstore NOT FOUND (LoadError)')
  end
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'html_table'                         # html_table.rb
  require_relative 'html_format'                        # html_format.rb
    include SiSU_HTML_Format
  require_relative 'html_segments'                      # html_segments.rb
    include SiSU_HTML_Seg
  require_relative 'html_scroll'                        # html_scroll.rb
  require_relative 'html_promo'                         # html_promo.rb
    include SiSU_HTML_Promo
  require_relative 'html_tune'                          # html_tune.rb
    include SiSU_HTML_Tune
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      begin
        songsheet
      ensure
        SiSU_Env::CreateSite.new(@opt.cmd).cp_css
      end
    end
    def songsheet
      begin
        @md=@particulars.md
        @fnb=@md.fnb
        @env=@particulars.env
        primary_output_file=(@opt.act[:html_seg][:set]==:on) \
        ? (@md.file.output_path.html_seg.dir + '/' + @md.file.base_filename.html_segtoc)
        : (@md.file.output_path.html_scroll.dir + '/' + @md.file.base_filename.html_scroll)
        unless @opt.act[:quiet][:set]==:on
          tool=(@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? ("#{@env.program.web_browser} file://#{primary_output_file}")
          : ("[#{@opt.f_pth[:lng_is]}] #{@opt.fno}")
          (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'HTML',tool).green_hi_blue
          : SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'HTML',tool).green_title_hi
          if (@opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],@opt.fns,"file://#{primary_output_file}").flow
          end
        end
        data=nil
        tuned_file_array=SiSU_HTML::Source::HTML_Environment.new(@particulars).tuned_file_instructions
        data=tuned_file_array
        if @opt.act[:html_scroll][:set]==:on
          scr_endnotes=SiSU_HTML::Source::Endnotes.new(data,@md).scroll
        end
        toc=SiSU_HTML::Source::Toc.new(@md,data).songsheet
        links_guide=SiSU_HTML::Source::LinksGuide.new(data,@md).toc
        data=tuned_file_array
        scr_toc=SiSU_HTML::Source::ScrollHeadAndSegToc.new(@md,toc,links_guide).in_common #watch
        if @opt.act[:html_seg][:set]==:on
          SiSU_HTML::Source::Seg.new(@md,data).songsheet
        end
        data=tuned_file_array
        if @opt.act[:html_scroll][:set]==:on
          scr=SiSU_HTML::Source::Scroll.new(@md,data,scr_endnotes).songsheet
          scroll=SiSU_HTML::Source::ScrollOutput.new(scr_toc,scr[:body],scr[:metadata],scr[:owner_details],scr[:tails],@md).publish
          SiSU_HTML::Source::Output.new(scroll,@md).scroll
        end
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        unless (@opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on)
          texfiles=Dir["#{@env.processing_path.tune}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Clear.new(@opt.cmd,@opt.fns,@md).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@heading1=@@heading2=@@heading3=@@heading4=0
      end
    end
    private
    class HTML_Environment
      def initialize(particulars)
        @particulars=particulars
        @md,@env=particulars.md,particulars.env
        @vz=SiSU_Viz::Defaults.new
        @env,@css=particulars.env,SiSU_Style::CSS.new
      end
      def tuned_file_instructions
        @tell=SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set])
        ao_array=@particulars.ao_array # ao file drawn here
        tuned_file_array=SiSU_HTML_Tune::Tune.new(ao_array,@md).songsheet
        tuned_file_array
      end
    end
    class LinksGuide
      @links_guide_toc=[]
      def initialize(data,md)
        @data,@md=data,md
        @links_guide_=SiSU_Env::CreateSite.new(@md.opt.cmd).html_quick_ref?
      end
      def toc
        @links_guide_toc=[]
        if @links_guide_
          format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
          guide_type='horzontal' #values: horizontal or vertical
          @links_guide_toc << format_head_toc.links_guide_open(guide_type)
          if defined? @md.lnk \
          and @md.lnk
            @md.lnk.each do |l|
              if defined? l[:say]
                target=(l[:url] !~/^\.(\.)?\//) \
                ? 'external'
                : '_top'
                s_lnk_url,s_lnk_lnk=l[:url],l[:say]
                txt_obj={ lnk_url: s_lnk_url, lnk_txt: s_lnk_lnk, target: target }
                lev_dob_ocn=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
                @links_guide_toc << lev_dob_ocn.links_guide if s_lnk_lnk
              end
            end
          end
          format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
          @links_guide_toc << format_head_toc.links_guide_close #(guide_type)
          @links_guide_toc
        else ''
        end
      end
    end
    class Endnotes
      include SiSU_HTML_Format
      def initialize(data,md)
        @data,@md=data,md
      end
      def scroll
        @scr_endnotes=[]
        SiSU_HTML_Format::HeadScroll.new(@md)
        @data.each do |dob|
          pg=dob.dup
          unless pg.is ==:code
            if pg.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ /
              endnote_array=[]
              if pg.obj=~/#{Mx[:en_a_o]}[\d*+].+?#{Mx[:en_a_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_a_o]}[\d*+]+(.+?)#{Mx[:en_a_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d*]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d*]+(.+?)#{Mx[:en_b_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d+]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d+]+(.+?)#{Mx[:en_b_c]}/m)
              end
              endnote_array.flatten.each do |note|
                txt_obj={ txt: note }
                format_scroll=SiSU_HTML_Format::FormatScroll.new(@md,txt_obj)
                @scr_endnotes << format_scroll.endnote_body
              end
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc <LinksGuide
      @@toc={ seg: [], seg_mini: [], scr: [] }
      @@seg_url=''
      @@firstseg=nil
      def initialize(md=nil,data='')
        @data,@md=data,md
        @vz=SiSU_Viz::Defaults.new
        @ocn_html_identifier=SiSU_Env::ProcessingSettings.new(@md).ocn_html_identifier
        @tell=SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set]) if @md
      end
      def songsheet #extracts toc for scroll & seg
        if (@md.opt.act[:verbose][:set]==:on \
        || @md.opt.act[:verbose_plus][:set]==:on \
        || @md.opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'Toc').txt_grey
        end
        toc=nil
        @@firstseg=nil
        @@toc={ seg: [], seg_mini: [], scr: [] }
        @data.each do |dob|
          if dob.is==:heading \
          || dob.is==:heading_insert
            dob_toc=dob.dup
            toc=if dob_toc.is ==:heading \
            || dob.is==:heading_insert
              toc=case dob_toc.ln
              when 0 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_0
              when 1 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_1
              when 2 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_2
              when 3 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_3
              when 4 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_4
              when 5 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_5
              when 6 then SiSU_HTML::Source::Toc.new(@md,dob_toc).level_6
              else nil
              end
            end
            toc.each do |k,d|
              d.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
            end if toc
            if @@firstseg.nil? \
            and dob.ln==4 \
            and dob.name =~/\S+/
              @@firstseg=dob.name
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg] if toc[:seg]
                @@toc[:seg_mini] << toc[:seg_mini] if toc[:seg_mini]
                @@toc[:scr] << toc[:scr] if toc[:scr]
              rescue
                SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
                  __LINE__.to_s + ':' + __FILE__
                end
              end
            end
          end
        end
        @md.firstseg=@@firstseg
        @@toc
      end
      def minitoc
        minitoc=@@toc[:seg_mini].join("\n")
        '<div class="toc">' + minitoc + '</div>'
      end
    protected
      def rss #sort all wrong, disabled but kept
        @@toc[:seg] <<<<WOK
<center>
<table><tr><td>
<p><font color="#222222" #{@font.face} size="2">
(relatively static) RSS feeds for DOCUMENTS:<br />
<a href="../rssfeed/documents.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/documents.xml<br />
<a href="../rssfeed/tradelaw.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/tradelaw.xml<br />
<a href="../rssfeed/environmental.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/environmental.xml<br />
<center><a href="mailto:info@address.com" target="_top">info@address.com</a></center>
</font></p>
</td></tr></table>
WOK
      end
#not used -->
      def level_endnotes
        if @md.flag_endnotes
          format_head_scroll=SiSU_HTML_Format::HeadScroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_endnote
        end
      end
      def level_concordance
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
        @@toc[:seg_mini] << format_head_toc.mini_seg_concordance
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
        @@toc[:scr] << format_head_toc.metadata
        @@toc[:seg] << format_head_toc.seg_metadata
        @@toc[:seg_mini] << format_head_toc.mini_seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@d0c)
        @@toc[:scr] << format_head_toc.concordance
        @@toc[:seg] << format_head_toc.concordance
        @@toc[:seg_mini] << format_head_toc.mini_concordance
      end
# <-- not used
      def level_0
        dob=@data
        linkname,link=dob.obj.strip,dob.ocn
        if link \
        and link !~/#/ #% keep eye on link
          SiSU_HTML_Format::ParagraphNumber.new(@md,link)
        end
        title=linkname
        toc={}
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc[:seg]=format_toc.lev0
        toc[:seg_mini]=format_toc.mini_lev0
        title=if dob.ocn ==0 then linkname
        else
          @@toc[:scr] <<  '<br />'
          %{<b><a href="##{@ocn_html_identifier}#{dob.ocn}">#{linkname}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev0
        toc
      end
      def level_1
        dob=@data
        linkname,link=dob.obj.strip,dob.ocn
        if link \
        and link !~/#/ #% keep eye on link
          SiSU_HTML_Format::ParagraphNumber.new(@md,link)
        end
        title=if dob.obj !~/^Metadata$/ then linkname
        else
          link='metadata'
          %{<b><a href="#{link}#{@md.lang_code_insert}#{Sfx[:html]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc[:seg]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc[:seg_mini]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          @md.concord_make \
          ? format_toc.mini_concord_tail
          : format_toc.mini_tail
        else format_toc.mini_lev1
        end
        title=if dob.ocn ==0
          if dob.name =~/^meta/ \
          and dob.obj =~/Document Information/
            %{<a href="#docinfo">#{linkname}</a>}
          else linkname
          end
        else
          @@toc[:scr] <<  '<br />'
          %{<b><a href="##{@ocn_html_identifier}#{dob.ocn}">#{linkname}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc[:scr]=if dob.obj =~/^Metadata$/ then ''
        elsif txt_obj[:txt] =~/<a href="#">/
          format_toc.lev1.gsub(/<a href="#">|<\/a>/,'')
        else format_toc.lev1
        end
        toc
      end
      def level_2
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=if ocn \
        and ocn !~/#/
          SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        else nil
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev2
        toc[:seg_mini]=format_toc.mini_lev2
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=if txt_obj[:txt] =~/<a href="#">/
            format_toc.lev2.gsub(/<a href="#">|<\/a>/,'')
          else format_toc.lev2
          end
        end
        toc
      end
      def level_3
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=if ocn \
        and ocn !~/#/
          SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        else nil
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev3
        toc[:seg_mini]=format_toc.mini_lev3
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=if txt_obj[:txt] =~/<a href="#">/
            format_toc.lev3.gsub(/<a href="#">|<\/a>/,'')
          else format_toc.lev3
          end
        end
        toc
      end
      def level_4
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn) if ocn
        if dob.ln ==4
          fnh={
            fn: dob.name,
          }
          f=@md.file.base_filename.html_seg(fnh)
          seg_link=%{  <a href="#{f}" target="_top">
    #{dob.obj}
  </a> }
          @@seg_url=dob.name
        elsif dob.obj =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
          fn,hd=/^(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/.match(dob.obj)[1,2]
          fnh={
            fn: fn,
          }
          f=@md.file.base_filename.html_seg(fnh)
          seg_link=%{<a href="#{f}" target="_top">#{fn} #{hd}</a> }
        end
        p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn) if ocn
        @file=SiSU_Env::FileOp.new(@md) if @md
        txt_obj=if seg_link=~/sisu_manifest\.html/
          man_link=if @file.output_dir_structure.by_language_code? \
          or @file.output_dir_structure.by_filetype?
            seg_link.gsub(/sisu_manifest\.html/,"../../manifest/#{@file.base_filename.manifest}")
          else seg_link
          end
          { txt: man_link }
        else { txt: seg_link }
        end
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev4
        toc[:seg_mini]=format_toc.mini_lev4
        title=%{#{p_num.goto}#{linkname}</a>} if p_num
        txt_obj=if title=~/sisu_manifest.html/
          man_link=title.gsub(/sisu_manifest.html/,"../manifest/#{@file.base_filename.manifest}")
          { txt: man_link }
        else { txt: title }
        end
        format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev4
        toc
       #end
      end
      def level_5
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          fnh={
            fn: @@seg_url,
          }
          f=@md.file.base_filename.html_seg(fnh)
          p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{f}##{@ocn_html_identifier}#{ocn}">
    #{linkname}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev5
          toc[:seg_mini]=format_toc.mini_lev5
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev5
        end
        toc
      end
      def level_6
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          fnh={
            fn: @@seg_url,
          }
          f=@md.file.base_filename.html_seg(fnh)
          p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{f}##{@ocn_html_identifier}#{ocn}">
  #{linkname}
</a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev6
          toc[:seg_mini]=format_toc.mini_lev6
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_HTML_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev6
        end
        toc
      end
      def level_crosslink
        dob=@data
        dob=if dob !~/^4~!/
          dob.gsub(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1" target="_top">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          dob.gsub(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1" target="_top">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class ScrollHeadAndSegToc < Toc
      def initialize(md='',toc='',links_guide_toc='')
        @md,@toc,@links_guide_toc=md,toc,links_guide_toc
        @vz=SiSU_Viz::Defaults.new
        @make=SiSU_Env::ProcessingSettings.new(@md)
      end
      def in_common
        toc_shared=[]
        @segtoc=[]
        if (@md.opt.act[:verbose][:set]==:on \
        || @md.opt.act[:verbose_plus][:set]==:on \
        || @md.opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(@md.opt.act[:color_state][:set],'Scroll & Segtoc').txt_grey
        end
        format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
        dochead=format_head_toc.head
        dochead=dochead.gsub(/toc\.(html)/,'doc.\1') #kludge
        toc_shared << dochead
        @segtoc << format_head_toc.head
        if @make.build.html_top_band?
          toc_shared << format_head_toc.scroll_head_navigation_band
        end
        if defined? @md.rights.all
          rights=format_head_toc.rights.all
          rights=SiSU_HTML_Tune::CleanHTML.new(rights).clean
        end
        if @md.prefix_b
          prefix_b=format_head_toc.notes.prefix_b
          prefix_b=SiSU_HTML_Tune::CleanHTML.new(prefix_b).clean
        end
        if @make.build.html_top_band?
          @segtoc << format_head_toc.seg_head_navigation_band
        end
        toc_shared << format_head_toc.scroll_head_title_banner_open
        @segtoc << format_head_toc.seg_head_title_banner_open
        tmp_head=nil
        doc_title_endnote=@md.title.full.gsub(/(\*+)/,
          '<sup><a href="#endnotes">\1</a></sup>')
        tmp_head=doc_title_endnote + "\n"
        txt_obj={ txt: tmp_head }
        format_txt_obj=SiSU_HTML_Format::FormatTextObject.new(@md,txt_obj)
        toc_shared << format_txt_obj.center_bold
        @segtoc << format_txt_obj.center_bold
        if defined? @md.creator.author
          creator=SiSU_HTML_Tune::CleanHTML.new(@md.creator.author).clean_for_html
          creator_endnote=creator.gsub(/(\*+)/,
            %{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          tmp_head=creator_endnote + "\n"
          txt_obj={ txt: tmp_head }
          format_txt_obj=SiSU_HTML_Format::FormatTextObject.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        toc_shared << "#{@vz.table_close*1}\n"
        @segtoc << "#{@vz.table_close*1}\n"
        tmp_head=nil
        if @md.prefix_a
          tmp_head ||= %{<p />#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          @segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @links_guide_toc
        if defined? @md.rights.all #and ? @md.rights.all
          toc_shared << rights
        end
        if defined? @md.prefix_b
          toc_shared << prefix_b
        end
        if @make.build.toc? #Table of Contents added/appended here
          toc_shared << @toc[:scr]
        end
        @segtoc << @links_guide_toc
        @segtoc << @toc[:seg]
        if defined? @md.rights.all \
        and not @md.rights.all.empty?
          @segtoc << rights
        end
        @segtoc << prefix_b if @md.prefix_b
        #Segtoc tail added here
        @segtoc << "</p>\n" #bugfix sort later DEBUGNOW
        @segtoc << @seg_toc_band_bottom
        @segtoc << format_head_toc.seg_navigation_tail << format_head_toc.html_close
        @segtoc=@segtoc.flatten.compact #watch
        if @md.opt.act[:html_seg][:set]==:on
          SiSU_HTML::Source::Output.new(@segtoc,@md).segtoc
        end
        @segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_HTML_Table::TableHTML
    end
    class Scroll < SiSU_HTML_Scroll::Scroll
    end
    class ScrollOutput
      def initialize(scr_toc,scr_body,scr_metadata,scr_owner_details,scr_tails,md)
        @scr_toc,@scr_body,@scr_metadata,@scr_owner_details,@scr_tails,@md=scr_toc,scr_body,scr_metadata,scr_owner_details,scr_tails,md
      end
      def publish
        scroll=[]
        scroll << @scr_toc << '<div class="scroll">' << @scr_body << @scr_endnotes << @scr_owner_details << '</div>' << @scr_tails
        scroll=scroll.flatten.compact #watch
      end
    end
    class Seg < SiSU_HTML_Seg::Seg
    end
    class Output
      def initialize(data='',md='')
        @data,@md=data,md
        @file=SiSU_Env::FileOp.new(md)
        @o_str ||=SiSU_Env::ProcessingSettings.new(md).output_dir_structure
      end
      def scroll
        if @md.opt.act[:html_scroll][:set]==:on
          begin
            @filename_html_scroll=@file.write_file.html_scroll
            @data.each do |para|
              para=para.strip.
                gsub(/<:.+?>/,'').
                gsub(Xx[:html_relative2],@file.path_rel_links.html_scroll_2).
                gsub(Xx[:html_relative1],@file.path_rel_links.html_scroll_1).
               #gsub(/#{Xx[:html_relative]}/,@file.path_rel_links.html_scroll).
                gsub(/#{Rx[:mx_fa_clean]}/,'')
              unless para =~/\A\s*\Z/
                @filename_html_scroll.puts para,"\n"
              end
            end
          rescue
            SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
              __LINE__.to_s + ':' + __FILE__
            end
          ensure
            @filename_html_scroll.close
          end
        end
      end
      def segtoc
        if @md.opt.act[:html_seg][:set]==:on
          begin
            @filename_html_segtoc=@file.write_file.html_segtoc
            @data.each do |para|
              para=para.strip.
                gsub(/<!.+?!>/,'').
                gsub(Xx[:html_relative2],@file.path_rel_links.html_seg_2).
                gsub(Xx[:html_relative1],@file.path_rel_links.html_seg_1)
              unless para =~/\A\s*\Z/
                @filename_html_segtoc.puts para,"\n"
              end
            end
          rescue
            SiSU_Errors::Rescued.new($!,$@,@md.opt.cmd,@md.fns).location do
              __LINE__.to_s + ':' + __FILE__
            end
          ensure
            @filename_html_segtoc.close
            pwd_set=Dir.pwd
            idx_lnk=(@o_str.dump_or_redirect?) \
            ? @file.base_filename.manifest
            : @file.base_filename.html_segtoc
            mlnk=@file.base_filename.html_seg_index
            Dir.chdir(@file.output_path.html_seg.dir)
            FileUtils::rm_f(mlnk)
            FileUtils::ln_s(idx_lnk,mlnk)
            Dir.chdir(pwd_set)
          end
        end
      end
    end
  end
end
__END__
