#ifndef INCLUDED_TYPEDEFS_
#define INCLUDED_TYPEDEFS_

#include <vector>
#include <cstdint>
#include <string>
#include <unordered_set>

#include "../enums/enums.h"

//struct
struct LineInfo
{
    ParamsSrc   src;
    uint16_t    lineNr;
    std::string txt;
    std::string tail;
};
//=
//types
using StringSet     = std::unordered_set<std::string>;

using BoolVect      = std::vector<bool>;
using DoubleVect    = std::vector<double>;
using DoubleVect2   = std::vector<DoubleVect>;
using LineInfoVect  = std::vector<LineInfo>;
using SizeVect      = std::vector<size_t>;
using StringVect    = std::vector<std::string>;
using Uint16Vect    = std::vector<uint16_t>;

using RowCol        = std::pair<uint16_t, uint16_t>;

//=

#endif


