from sbws.lib.relaylist import Relay


def test_relay_properties(persistent_launch_tor):
    cont = persistent_launch_tor
    # AA45C13025C037F056E734169891878ED0880231 is auth1
    fp = 'AA45C13025C037F056E734169891878ED0880231'
    relay = Relay(fp, cont)
    assert relay.nickname == 'auth1'
    assert relay.fingerprint == 'AA45C13025C037F056E734169891878ED0880231'
    assert 'Authority' in relay.flags
    assert not relay.exit_policy or not relay.exit_policy.is_exiting_allowed()
    assert relay.average_bandwidth == 1073741824
    assert relay.consensus_bandwidth == 0
    assert relay.address == '127.10.0.1'
    assert relay.master_key_ed25519 == \
        'wLglSEw9/DHfpNrlrqjVRSnGLVWfnm0vYxkryH4aT6Q'


def test_relay_list_last_consensus_timestamp(rl):
    assert rl.last_consensus_timestamp == \
        rl._relays[0].last_consensus_timestamp
