# standalone socket-activate (sasa) #

This project provides a standalone C implementation of systemd-style
socket-activation for use on Unix-based systems that don't have systemd
installed.

It uses the simple [`sd_listen_fds` environment variable and file
descriptor
convention](https://manpages.debian.org/unstable/systemd/sd_listen_fds.3.en.html)
introduced by
[systemd](https://www.freedesktop.org/wiki/Software/systemd/), without
using any code or dependencies from systemd.

See the [socket-activate manpage](./socket-activate.md) for more information.


## Code and Issues ##

The source code is available at
https://git.devuan.org/leepen/standalone-socket-activate where bug reports can
be made and pull requests are welcome.

## Dependencies ##

 - make
 - C compiler [tested with gcc]
 - pandoc [for manpage only]
 - diff, python3 [for [tests](./tests) only]

## Similar work ##

[systemd](https://www.freedesktop.org/wiki/Software/systemd/) offers
`systemd-socket-activate`, but that code is only for testing and has a few
drawbacks that hopefully this project avoids:

 - The systemd project itself doesn't build on non-Linux systems.
 
 - `systemd-socket-activate` doesn't allow for multiple sockets of
   different types.

## Authors ##

This implementation of `socket-activate` is written by Mark Hindley
<mark@hindley.org.uk> based on an initial C implementation by Peter Pentchev
<roam@ringlet.net>. The [original Python 3
implementation](https://gitlab.com/dkg/socket-activate) was written by Daniel
Kahn Gillmor <dkg@fifthhorseman.net>.

It is licensed under the [GPL version 3 or
later](https://www.gnu.org/licenses/gpl.html)

## References ##

 * [systemd Socket Activation, part 1](http://0pointer.de/blog/projects/socket-activation.html)
 * [systemd Socket Activation, part 2](http://0pointer.de/blog/projects/socket-activation2.html)
 * [Debian bug report asking for non-systemd socket activation](https://bugs.debian.org/922082)
 * [systemd-socket-activate documentation](https://manpages.debian.org/unstable/systemd/systemd-socket-activate.1.en.html)
 * [Python 3 implementation](https://gitlab.com/dkg/socket-activate)
