/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Draw.h"
#include "Line_dlg.h"
#define LINESTYLEBOX
#include "LineStyleBox.h"



/*
 * ------------------------------------------------------------------
 * ドローイングエリア
 * "expose (再描画)" イベントハンドラ
 */
gint ls_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	gint w, h, i;
	GdkGC *line_style_gc;
	
	/* GC 作成 */
	line_style_gc = gdk_gc_new(widget->window);
	
	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;
	
	/* 背景 */
	PenSet(line_style_gc, 1, 0x0000);
	gdk_draw_rectangle (widget->window, line_style_gc, TRUE, 0, 0, w, h);
	
	/* 現在の線種を表示 */
	PenSet(line_style_gc, NowStyle, NowColor);
	if (NowStyle == 0 || NowStyle == 1){
		gdk_draw_line(widget->window, line_style_gc, 0, h/2, w, h/2);
	}
	if (NowStyle == 2){
		for (i = 5; i < 105; i = i + 10) {
			gdk_draw_line(widget->window, line_style_gc, i-5, h/2, i, h/2);
		}
	}
	if (NowStyle == 3){
		gdk_draw_line(widget->window, line_style_gc, 0, h/2, 15, h/2);
		gdk_draw_line(widget->window, line_style_gc, 20, h/2, 25, h/2);
		gdk_draw_line(widget->window, line_style_gc, 30, h/2, 70, h/2);
		gdk_draw_line(widget->window, line_style_gc, 75, h/2, 80, h/2);
		gdk_draw_line(widget->window, line_style_gc, 85, h/2, w, h/2);
	}
	if (NowStyle == 4){
		gdk_draw_line(widget->window, line_style_gc, 0, h/2, 37, h/2);
		gdk_draw_line(widget->window, line_style_gc, 42, h/2, 47, h/2);
		gdk_draw_line(widget->window, line_style_gc, 52, h/2, 57, h/2);
		gdk_draw_line(widget->window, line_style_gc, 62, h/2, w, h/2);
	}
	//gdk_draw_line(widget->window, line_style_gc, 0, h/2, w, h/2);
	
	/* GC 開放 */
	gdk_gc_destroy(line_style_gc);
	
	return FALSE;
}



/*
 * ------------------------------------------------------------------
 * ドローイングエリア
 * "button_press (クリック)" イベントハンドラ
 */
gint ls_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	int style;
	long color;
	GdkRectangle update_rect;
	GdkGC *line_style_gc;
	
	/* GC 作成 */
	line_style_gc = gdk_gc_new(widget->window);
	
	style = NowStyle;
	color = NowColor;
	
	/* 左ボタン */
	if (event->button == 1) {
		Line_set_dlg(&style, &color);
		
		NowStyle = style;
		NowColor = color;
		
		update_rect.x = 0;
		update_rect.y = 0;
		/* ドローイングアレアの大きさ取得 */
		update_rect.width = widget->allocation.width;
		update_rect.height = widget->allocation.height;
		
		/* 再描画 */
		gtk_widget_draw (widget, &update_rect);
	}
	
	/* GC 開放 */
	gdk_gc_destroy(line_style_gc);
	
	return TRUE;
}



/*
 * ------------------------------------------------------------------
 * ドローイングエリアの生成
 */
GtkWidget *create_line_style_box(void)
{
	GtkWidget *line_style_box;

  /** ドローイングエリア生成 **/
  line_style_box = gtk_drawing_area_new();
  /** ドローイングエリアのサイズ設定 **/
  gtk_widget_set_size_request(GTK_WIDGET(line_style_box), 100, 18);
  
	/* ボタンにツールチップを設定 */
	//gtk_tooltips_set_tip(line_style_box, GTK_WIDGET(line_style_box), "Line Style Setting", NULL);

  /** "expose_event"イベントハンドラ設定 **/
  g_signal_connect(G_OBJECT(line_style_box), "expose_event",
			 G_CALLBACK(ls_expose_event), NULL);
  /** "button_press_event"イベントハンドラ設定 **/
  g_signal_connect(G_OBJECT(line_style_box), "button_press_event",
			 G_CALLBACK(ls_button_press_event), NULL);
  /** イベントマスク設定 **/
  gtk_widget_set_events(line_style_box, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  return line_style_box;
}



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : LineStyleBox.c
 * ====================================================================
 */
