#!/bin/bash
# bbou@ac-toulouse.fr
# 2005-07-10 11:50:44   
# _signal.sh

### P A R A M S

MYEXCEPTNSCD=
if [ "$1" == "-nonscd" ];then
	export MYEXCEPTNSCD="True"
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

# samba

echo "--------------------------------------------------------------------------------"
echo "REFRESH SAMBA DAEMONS FROM CONFIG"
echo "--------------------------------------------------------------------------------"

daemons="`pidof winbindd` `pidof nmbd` `pidof smbd`"
if [ "${daemons}" == "  " ];then
	echo "no running process"
	exit 0
fi
echo "signal sent to processes ${daemons}"
kill -s HUP ${daemons}

# nscd

if [ -z "${MYEXCEPTNSCD}" ];then

echo "--------------------------------------------------------------------------------"
echo "REFRESH NSCD DAEMON FROM CONFIG"
echo "older versions of nscd do not support SIGHUP"
echo "--------------------------------------------------------------------------------"

daemons="`pidof nscd`"
echo "signal sent to processes ${daemons}"
kill -s HUP ${daemons}

fi
