///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2013) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/** 
 * \file LinAlg.h 
 * \brief This high-level header file includes other headers to import the most important linear algebra classes.
 */

#ifndef __OVITO_LINALG_H
#define __OVITO_LINALG_H

#include <base/Base.h>

#include "Vector3.h"
#include "Vector2.h"
#include "Vector4.h"
#include "Point3.h"
#include "Point2.h"
#include "Matrix3.h"
#include "Matrix4.h"
#include "AffineTransformation.h"
#include "Scaling.h"
#include "Rotation.h"
#include "Quaternion.h"
#include "Box2.h"
#include "Box3.h"
#include "Ray.h"
#include "Plane.h"
#include "Tensor.h"

#endif // __OVITO_LINALG_H
