#ifndef ossimBmvStager_HEADER
#define ossimBmvStager_HEADER
#include <vector>

#include <ossim/base/ossimConstants.h>
#include <ossim/base/ossimFilename.h>
#include <ossim/base/ossimIrect.h>
#include <ossim/imaging/ossimImageFileWriter.h>
#include "ossimBmvUtil.h"

class ossimImageChain;
class ossimLlxyProjection;
class ossimGpt;
class ossimImageData;

class ossimBmvStager : public ossimImageFileWriter
{
 public:
   ossimBmvStager(ossim_uint32 tileSize = 256,
                  ossim_uint32 tilesWide = 10,   // tiles wide at level 0
                  ossim_uint32 tileHigh  = 5);    // tiles high at level 0
   ~ossimBmvStager();
   virtual bool writeFile();
   void addFile(const ossimFilename& filename);
   void clearFileList();
   void setResmapler(const ossimString& str);
   
   virtual bool isOpen()const;
   virtual bool open();
   virtual void close();

   /**
    * void getImageTypeList(std::vector<ossimString>& imageTypeList)const
    *
    * Appends the writers image types to the "imageTypeList".
    * 
    * This is the actual image type name.  So for
    * example, ossimTiffWriter has several image types.  Some of these
    * include TIFF_TILED, TIFF_TILED_BAND_SEPARATE ... etc.
    * The ossimGdalWriter
    * may include GDAL_IMAGINE_HFA, GDAL_RGB_NITF, GDAL_JPEG20000, ... etc.
    *
    * @param imageTypeList stl::vector<ossimString> list to append to.
    *
    * @note All writers should append to the list, not, clear it and then add
    * their types.
    */
   virtual void getImageTypeList(std::vector<ossimString>& imageTypeList)const;

 protected:
   ossimBmvUtil                  theBmvUtil;
   std::vector<ossimFilename>    theFilenameList;
   std::vector<ossimImageChain*> theChainList;
   ossimImageChain*              theMosaicChain;
   ossimLlxyProjection*          theView;
   ossim_uint16*                 theBuf;
   ossim_uint16*                 theFileBuf;
   ossimString                   theResampler;
   
   void findFullResolution(ossim_uint32& level);

   ossimFilename buildFilename(ossim_uint32 level,
                               const ossimGpt& gpt)const;

   
   void writeTile(const ossim_uint16* backgroundBuffer,
                  const ossimRefPtr<ossimImageData>& imageData,
                  const ossimFilename& filename)const;
   void buildMosaic();
   void setViewToChains();

   void deleteChains();
};

#endif
