#
#VID 0ac89b39-f829-11db-b55c-000e0c6d38a9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58857);
 script_cve_id("CVE-2007-1320", "CVE-2007-1321", "CVE-2007-1322", "CVE-2007-1323", "CVE-2007-1366");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: qemu, qemu-devel";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   qemu
   qemu-devel

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.debian.org/debian-security-announce/debian-security-announce-2007/msg00040.html
http://www.vuxml.org/freebsd/0ac89b39-f829-11db-b55c-000e0c6d38a9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: qemu, qemu-devel";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"qemu");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.0_1")<0) {
    security_note(0, data:"Package qemu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"0.9.0s.20070101*")>=0 && revcomp(a:bver, b:"0.9.0s.20070405_3")<0) {
    security_note(0, data:"Package qemu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"qemu-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.0_1")<0) {
    security_note(0, data:"Package qemu-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"0.9.0s.20070101*")>=0 && revcomp(a:bver, b:"0.9.0s.20070405_3")<0) {
    security_note(0, data:"Package qemu-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
