# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12950 (gtk2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66571);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 12 FEDORA-2009-12950 (gtk2)");

 desc = "The remote host is missing an update to gtk2
announced via advisory FEDORA-2009-12950.

Update Information:

This update fixes a crasher issue in gtk2 involving out of process
windows.  Side effects of the bug are sporadic panel crashes, and
occasional crashes in gnome-screensaver when typing an invalid
password.

This update also addresses a crash in Inkscape when using the text tool.

ChangeLog:

* Tue Dec  8 2009 Matthias Clasen  - 2.18.5-1
- Update to 2.18.5
* Tue Dec  1 2009 Matthias Clasen  - 2.18.4-3
- Fix a mistranslated format string in no_NO (#500067)
* Tue Dec  1 2009 Matthias Clasen  - 2.18.4-2
- Make compose sequences for  consistent (#510741)
* Tue Dec  1 2009 Matthias Clasen  - 2.18.4-1
- Update to 2.18.4
- See http://download.gnome.org/sources/gtk+/2.18/gtk+-2.18.4.news

References:

[ 1 ] Bug #540308 - [abrt] crash detected in gnome-screensaver-2.28.0-6.fc12 (BadDrawable)
https://bugzilla.redhat.com/show_bug.cgi?id=540308
[ 2 ] Bug #538156 - [abrt] crash detected in gnome-panel-2.28.0-13.fc12 (/usr/libexec/notification-area-applet)
https://bugzilla.redhat.com/show_bug.cgi?id=538156
[ 3 ] Bug #544590 - Using text tool crashes inkscape
https://bugzilla.redhat.com/show_bug.cgi?id=544590

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gtk2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12950

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-12950 (gtk2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel-docs", rpm:"gtk2-devel-docs~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-immodule-xim", rpm:"gtk2-immodule-xim~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-immodules", rpm:"gtk2-immodules~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-debuginfo", rpm:"gtk2-debuginfo~2.18.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
