# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12218 (bind)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66327);
 script_cve_id("CVE-2009-4022", "CVE-2009-0696");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-12218 (bind)");

 desc = "The remote host is missing an update to bind
announced via advisory FEDORA-2009-12218.

Update Information:

Update to 9.6.1-P2 release which contains following fix:
* Additional section of response could be cached without successful
DNSSEC validation even if DNSSEC validation is enabled

ChangeLog:

* Wed Nov 25 2009 Adam Tkac  32:9.6.1-7.P2
- update to 9.6.1-P2 (CVE-2009-4022)

References:

[ 1 ] Bug #538744 - CVE-2009-4022 bind: cache poisoning using not validated DNSSEC responses
https://bugzilla.redhat.com/show_bug.cgi?id=538744

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bind' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12218

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-12218 (bind)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bind", rpm:"bind~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-sdb", rpm:"bind-sdb~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.6.1~7.P2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
