# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1825-1 (nagios2, nagios3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64358);
 script_cve_id("CVE-2009-2288");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1825-1 (nagios2, nagios3)";
 script_name(name);

 desc = "The remote host is missing an update to nagios2, nagios3
announced via advisory DSA 1825-1.

It was discovered that the statuswml.cgi script of nagios, a monitoring
and management system for hosts, services and networks, is prone to a
command injection vulnerability.  Input to the ping and traceroute parameters
of the script is not properly validated which allows an attacker to execute
arbitrary shell commands by passing a crafted value to these parameters.

For the oldstable distribution (etch), this problem has been fixed in
version 2.6-2+etch3 of nagios2.

For the stable distribution (lenny), this problem has been fixed in
version 3.0.6-4~lenny2 of nagios3.

For the testing distribution (squeeze), this problem has been fixed in
version 3.0.6-5 of nagios3.

For the unstable distribution (sid), this problem has been fixed in
version 3.0.6-5 of nagios3.

We recommend that you upgrade your nagios2/nagios3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201825-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1825-1 (nagios2, nagios3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nagios3-doc", ver:"3.0.6-4~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-common", ver:"3.0.6-4~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3", ver:"3.0.6-4~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-dbg", ver:"3.0.6-4~lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2-doc", ver:"2.6-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2-common", ver:"2.6-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2-dbg", ver:"2.6-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2", ver:"2.6-2+etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
