# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1386-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58669);
 script_cve_id("CVE-2007-3917");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1386-1 (wesnoth)";
 script_name(name);

 desc = "The remote host is missing an update to wesnoth
announced via advisory DSA 1386-1.

A problem has been discovered in the processing of chat messages.
Overly long messages are truncated by the server to a fixed length,
without paying attention to the multibyte characters.  This leads to
invalid UTF-8 on clients and causes an uncaught exception.  Note that
both wesnoth and the wesnoth server are affected.

For the old stable distribution (sarge) this problem has been fixed in
version 0.9.0-6 and in version 1.2.7-1~bpo31+1 of sarge-backports.

For the stable distribution (etch) this problem has been fixed in
version 1.2-2 and in version 1.2.7-1~bpo40+1 of etch-backports.

For the unstable distribution (sid) this problem has been fixed in
version 1.2.7-1.

Packages for the oldstable mips architecture will be added to the
archive later.

We recommend that you upgrade your wesnoth packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201386-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1386-1 (wesnoth)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wesnoth-data", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-ei", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-httt", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-music", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-sotbe", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-tdh", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-trow", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-editor", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-server", ver:"0.9.0-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-data", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-ei", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-httt", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-music", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-sotbe", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-tdh", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-trow", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-editor", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wesnoth-server", ver:"0.9.0-6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
