/*
 * Copyright (c) 2025, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.jpackage.internal;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jdk.jpackage.internal.model.MacDmgPackage;
import jdk.jpackage.internal.model.MacDmgPackageMixin;
import jdk.jpackage.internal.util.RootedPath;

final class MacDmgPackageBuilder {

    MacDmgPackageBuilder(MacPackageBuilder pkgBuilder) {
        this.pkgBuilder = Objects.requireNonNull(pkgBuilder);
    }

    MacDmgPackageBuilder dmgRootDirSources(Collection<RootedPath> v) {
        dmgRootDirSources = v;
        return this;
    }

    MacDmgPackageBuilder icon(Path v) {
        icon = v;
        return this;
    }

    private Collection<RootedPath> validatedDmgRootDirSources() {
        return Optional.ofNullable(dmgRootDirSources).orElseGet(List::of);
    }

    MacDmgPackage create() {
        final var pkg = pkgBuilder.create();

        return MacDmgPackage.create(pkg, new MacDmgPackageMixin.Stub(
                Optional.ofNullable(icon).or((pkg.app())::icon),
                validatedDmgRootDirSources()));
    }

    private Path icon;
    private Collection<RootedPath> dmgRootDirSources;
    private final MacPackageBuilder pkgBuilder;
}
