#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#################################################################################

if test "$3" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$3" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$3" = sfcb
then
	/etc/init.d/sfcb stop
fi

$6/registration/OpenDRIM_Identity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountOnSystem.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountAssignedIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_GroupAssignedIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountManagementServiceAffectsIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountManagementService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_HostedAccountManagementService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_RegisteredSimpleIdentityManagementProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountManagementServiceConformsToProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Group.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountManagementServiceCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountAssociatedCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_GroupIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_IdentityInGroup.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_AccountManagementCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Account.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_GroupOnSystem.sh $1 $2 $3 $4 $5 $6

if test "$3" = sfcb
then
	/etc/init.d/sfcb start
fi

