// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeBuild_Edge_HeaderFile
#define _ShapeBuild_Edge_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Vertex;
class TopoDS_Face;
class Geom_Surface;
class TopLoc_Location;
class Geom2d_Curve;
class gp_Trsf2d;
class Geom_Curve;


//! This class provides low-level operators for building an edge <br>
//!          3d curve, copying edge with replaced vertices etc. <br>
class ShapeBuild_Edge  {
public:

  DEFINE_STANDARD_ALLOC

  //! Copy edge and replace one or both its vertices to a given <br>
//!          one(s). Vertex V1 replaces FORWARD vertex, and V2 - REVERSED, <br>
//!          as they are found by TopoDS_Iterator. <br>
//!          If V1 or V2 is NULL, the original vertex is taken <br>
  Standard_EXPORT     TopoDS_Edge CopyReplaceVertices(const TopoDS_Edge& edge,const TopoDS_Vertex& V1,const TopoDS_Vertex& V2) const;
  //! Copies ranges for curve3d and all common pcurves from <br>
//!          edge <fromedge> into edge <toedge>. <br>
  Standard_EXPORT     void CopyRanges(const TopoDS_Edge& toedge,const TopoDS_Edge& fromedge,const Standard_Real alpha = 0,const Standard_Real beta = 1) const;
  //! Sets range on 3d curve only. <br>
  Standard_EXPORT     void SetRange3d(const TopoDS_Edge& edge,const Standard_Real first,const Standard_Real last) const;
  //! Makes a copy of pcurves from edge <fromedge> into edge <br>
//!          <toedge>. Pcurves which are already present in <toedge>, <br>
//!          are replaced by copies, other are copied. Ranges are also <br>
//!          copied. <br>
  Standard_EXPORT     void CopyPCurves(const TopoDS_Edge& toedge,const TopoDS_Edge& fromedge) const;
  //! Make a copy of <edge> by call to CopyReplaceVertices() <br>
//!          (i.e. construct new TEdge with the same pcurves and vertices). <br>
//!          If <sharepcurves> is False, pcurves are also replaced by <br>
//!          their copies with help of method CopyPCurves <br>
  Standard_EXPORT     TopoDS_Edge Copy(const TopoDS_Edge& edge,const Standard_Boolean sharepcurves = Standard_True) const;
  //! Removes the PCurve(s) which could be recorded in an Edge for <br>
//!           the given Face <br>
  Standard_EXPORT     void RemovePCurve(const TopoDS_Edge& edge,const TopoDS_Face& face) const;
  //! Removes the PCurve(s) which could be recorded in an Edge for <br>
//!           the given Surface <br>
  Standard_EXPORT     void RemovePCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surf) const;
  //! Removes the PCurve(s) which could be recorded in an Edge for <br>
//!           the given Surface, with given Location <br>
  Standard_EXPORT     void RemovePCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surf,const TopLoc_Location& loc) const;
  //! Replace the PCurve in an Edge for the given Face <br>
//!           In case if edge is seam, i.e. has 2 pcurves on that face, <br>
//!           only pcurve corresponding to the orientation of the edge is <br>
//!           replaced <br>
  Standard_EXPORT     void ReplacePCurve(const TopoDS_Edge& edge,const Handle(Geom2d_Curve)& pcurve,const TopoDS_Face& face) const;
  //! Reassign edge pcurve lying on face <old> to another face <sub>. <br>
//!          If edge has two pcurves on <old> face, only one of them will be <br>
//!          reassigned, and other will left alone. Similarly, if edge already <br>
//!          had a pcurve on face <sub>, it will have two pcurves on it. <br>
//!          Returns True if succeeded, False if no pcurve lying on <old> found. <br>
  Standard_EXPORT     Standard_Boolean ReassignPCurve(const TopoDS_Edge& edge,const TopoDS_Face& old,const TopoDS_Face& sub) const;
  //! Transforms the PCurve with given matrix and affinity U factor. <br>
  Standard_EXPORT     Handle_Geom2d_Curve TransformPCurve(const Handle(Geom2d_Curve)& pcurve,const gp_Trsf2d& trans,const Standard_Real uFact,Standard_Real& aFirst,Standard_Real& aLast) const;
  //! Removes the Curve3D recorded in an Edge <br>
  Standard_EXPORT     void RemoveCurve3d(const TopoDS_Edge& edge) const;
  //! Calls BRepTools::BuildCurve3D <br>
  Standard_EXPORT     Standard_Boolean BuildCurve3d(const TopoDS_Edge& edge) const;
  //! Makes edge with curve and location <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom_Curve)& curve,const TopLoc_Location& L) const;
  //! Makes edge with curve, location and range [p1, p2] <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom_Curve)& curve,const TopLoc_Location& L,const Standard_Real p1,const Standard_Real p2) const;
  //! Makes edge with pcurve and face <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom2d_Curve)& pcurve,const TopoDS_Face& face) const;
  //! Makes edge with pcurve, face and range [p1, p2] <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom2d_Curve)& pcurve,const TopoDS_Face& face,const Standard_Real p1,const Standard_Real p2) const;
  //! Makes edge with pcurve, surface and location <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom2d_Curve)& pcurve,const Handle(Geom_Surface)& S,const TopLoc_Location& L) const;
  //! Makes edge with pcurve, surface, location and range [p1, p2] <br>
  Standard_EXPORT     void MakeEdge(TopoDS_Edge& edge,const Handle(Geom2d_Curve)& pcurve,const Handle(Geom_Surface)& S,const TopLoc_Location& L,const Standard_Real p1,const Standard_Real p2) const;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
