/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_PATH_HPP_INCLUDED
#define yf_PATH_HPP_INCLUDED

#include <QDir>

#ifdef NLKT_USE_SYSTEM_PATH
	#define SHARE_PREFIX "/usr/share/nlkt"
#else
	#define SHARE_PREFIX "../share"
#endif

const QString homeDir = QDir::homePath();

const QString programName = "nlkt";
const QString pathToKeyboardImage = SHARE_PREFIX "/images/keyboard.png";
const QString pathToUserProfiles = homeDir + "/.nlkt/profiles/";
const QString pathToDefaultProfiles = SHARE_PREFIX "/default_profiles/";
const QString pathToUserFortuneCatalog = homeDir + "/.nlkt/typed_fortunes";
const QString pathToLayouts = SHARE_PREFIX "/layouts/";
const QString pathToTranslations = SHARE_PREFIX "/translations/";

#endif

