/* $Id: ValidErrItem.cpp 648266 2022-04-12 11:42:32Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'valerr.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/valerr/ValidErrItem.hpp>
#include <util/static_map.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


typedef SStaticPair<const char*, const char*> TErrStrs;
typedef SStaticPair<unsigned int, TErrStrs> TErrTypStrs;

static const TErrTypStrs sc_ErrStrs[] = {
    { eErr_ALL,
    { "ALL", "ALL" } },
    { eErr_UNKNOWN,
    { "UNKNOWN", "UNKNOWN" } },

    /* SEQ_INST */

    { eErr_SEQ_INST_ExtNotAllowed,
    { "ExtNotAllowed",
    "A Bioseq \"extension\" is used for special classes of Bioseq. This class of \
    Bioseq should not have one but it does. This is probably a software error." } },
    { eErr_SEQ_INST_ExtBadOrMissing,
    { "ExtBadOrMissing",
    "This class of Bioseq requires an \"extension\" but it is missing or of the \
    wrong type. This is probably a software error." } },
    { eErr_SEQ_INST_SeqDataNotFound,
    { "SeqDataNotFound",
    "No actual sequence data was found on this Bioseq. This is probably a \
    software problem." } },
    { eErr_SEQ_INST_SeqDataNotAllowed,
    { "SeqDataNotAllowed",
    "The wrong type of sequence data was found on this Bioseq. This is probably a \
    software problem." } },
    { eErr_SEQ_INST_ReprInvalid,
    { "ReprInvalid",
    "This Bioseq has an invalid representation class. This is probably a software \
    error." } },
    { eErr_SEQ_INST_CircularProtein,
    { "CircularProtein",
    "This protein Bioseq is represented as circular. Circular topology is \
    normally used only for certain DNA molecules, for example, plasmids." } },
    { eErr_SEQ_INST_BadProteinMoltype,
    { "BadProteinMoltype",
    "This protein Bioseq has strandedness indicated. Strandedness is normally a \
    property only of DNA sequences. Please unset the strandedness." } },
    { eErr_SEQ_INST_MolNotSet,
    { "MolNotSet",
    "It is not clear whether this sequence is nucleic acid or protein. Please set \
    the appropriate molecule type (Bioseq.mol)." } },
    { eErr_SEQ_INST_MolinfoOther,
    { "MolOther",
    "Most sequences are either nucleic acid or protein. However, the molecule \
    type (Bioseq.mol) is set to \"other\". It should probably be set to nucleic \
    acid or a protein." } },
    { eErr_SEQ_INST_FuzzyLen,
    { "FuzzyLen",
    "This sequence is marked as having an uncertain length, but the length is \
    known exactly." } },
    { eErr_SEQ_INST_InvalidLen,
    { "InvalidLen",
    "The length indicated for this sequence is invalid. This is probably a \
    software error." } },
    { eErr_SEQ_INST_InvalidAlphabet,
    { "InvalidAlphabet",
    "This Bioseq has an invalid alphabet (e.g. protein codes on a nucleic acid or \
    vice versa). This is probably a software error." } },
    { eErr_SEQ_INST_SeqDataLenWrong,
    { "SeqDataLenWrong",
    "The length of this Bioseq does not agree with the length of the actual data. \
    This is probably a software error." } },
    { eErr_SEQ_INST_SeqPortFail,
    { "SeqPortFail",
    "Something is very wrong with this entry. The validator cannot open a SeqPort \
    on the Bioseq. Further testing cannot be done." } },
    { eErr_SEQ_INST_InvalidResidue,
    { "InvalidResidue",
    "Invalid residue codes were found in this Bioseq." } },
    { eErr_SEQ_INST_StopInProtein,
    { "StopInProtein",
    "Stop codon symbols were found in this protein Bioseq." } },
    { eErr_SEQ_INST_PartialInconsistent,
    { "PartialInconsistent",
    "This segmented sequence is described as complete or incomplete in several \
    places, but these settings are inconsistent." } },
    { eErr_SEQ_INST_ShortSeq,
    { "ShortSeq",
    "This Bioseq is unusually short (less than 4 amino acids or less than 11 \
    nucleic acids). GenBank does not usually accept such short sequences." } },
    { eErr_SEQ_INST_NoIdOnBioseq,
    { "NoIdOnBioseq",
    "No SeqIds were found on this Bioseq. This is probably a software error." } },
    { eErr_SEQ_INST_BadDeltaSeq,
    { "BadDeltaSeq",
    "Delta sequences should only be HTGS-1 or HTGS-2." } },
    { eErr_SEQ_INST_LongHtgsSequence,
    { "LongHtgsSequence",
    "HTGS-1 or HTGS-2 sequences must be < 350 KB in length." } },
    { eErr_SEQ_INST_LongLiteralSequence,
    { "LongLiteralSequence",
    "Delta literals must be < 350 KB in length." } },
    { eErr_SEQ_INST_ConflictingIdsOnBioseq,
    { "ConflictingIdsOnBioseq",
    "Two SeqIds of the same class was found on this Bioseq. This is probably a software error." } },
    { eErr_SEQ_INST_MolNuclAcid,
    { "MolNuclAcid",
    "The specific type of this nucleic acid (DNA or RNA) is not set." } },
    { eErr_SEQ_INST_ConflictingBiomolTech,
    { "ConflictingBiomolTech",
    "HTGS/STS/GSS records should be genomic DNA. There is a conflict between the \
    technique and expected molecule type." } },
    { eErr_SEQ_INST_SeqIdNameHasSpace,
    { "SeqIdNameHasSpace",
    "The Seq-id.name field should be a single word without any whitespace. This should be \
    fixed by the database staff." } },
    { eErr_SEQ_INST_IdOnMultipleBioseqs,
    { "IdOnMultipleBioseqs",
    "There are multiple occurrences of the same Seq-id in this record. Sequence \
    identifiers must be unique within a record." } },
    { eErr_SEQ_INST_DuplicateSegmentReferences,
    { "DuplicateSegmentReferences",
    "The segmented sequence refers multiple times to the same Seq-id. This may be due \
    to a software error. Please consult with the database staff to fix this record." } },
    { eErr_SEQ_INST_TrailingX,
    { "TrailingX",
    "The protein sequence ends with one or more X (unknown) amino acids." } },
    { eErr_SEQ_INST_BadSeqIdFormat,
    { "BadSeqIdFormat",
    "A nucleotide sequence identifier should be 1 letter plus 5 digits or 2 letters \
    plus 6 digits, and a protein sequence identifer should be 3 letters plus 5 digits." } },
    { eErr_SEQ_INST_PartsOutOfOrder,
    { "PartsOutOfOrder",
    "The parts inside a segmented set should correspond to the seq_ext of the segmented \
    bioseq.  A difference will affect how the flatfile is displayed." } },
    { eErr_SEQ_INST_BadSecondaryAccn,
    { "BadSecondaryAccn",
    "A secondary accession usually indicates a record replaced or subsumed by the current \
    record.  In this case, the current accession and secondary are the same." } },
    { eErr_SEQ_INST_ZeroGiNumber,
    { "ZeroGiNumber",
    "GI numbers are assigned to sequences by NCBI's sequence tracking database.  0 is not \
    a legal value for a gi number." } },
    { eErr_SEQ_INST_RnaDnaConflict,
    { "RnaDnaConflict",
    "The MolInfo biomol field is inconsistent with the Bioseq molecule type field." } },
    { eErr_SEQ_INST_HistoryGiCollision,
    { "HistoryGiCollision",
    "The Bioseq history gi refers to this Bioseq, not to its predecessor or successor." } },
    { eErr_SEQ_INST_GiWithoutAccession,
    { "GiWithoutAccession",
    "The Bioseq has a gi identifier but no GenBank/EMBL/DDBJ accession identifier." } },
    { eErr_SEQ_INST_MultipleAccessions,
    { "MultipleAccessions",
    "The Bioseq has a gi identifier and more than one GenBank/EMBL/DDBJ accession identifier." } },
    { eErr_SEQ_INST_HistAssemblyMissing,
    { "HistAssemblyMissing",
    "The Bioseq has a TPA identifier but does not have a Seq-hist.assembly alignment.  This \
    should be annotated or calculated by the database, resulting in a PRIMARY block visible \
    in the flatfile." } },
    { eErr_SEQ_INST_TerminalNs,
    { "TerminalNs",
    "The Bioseq has one or more N bases at the end." } },
    { eErr_SEQ_INST_UnexpectedIdentifierChange,
    { "UnexpectedIdentifierChange",
    "The set of sequence identifiers on a Bioseq are not consistent with the previous version \
    of the record in the database." } },
    { eErr_SEQ_INST_InternalNsInSeqLit,
    { "InternalNsInSeqLit",
    "There are runs of many Ns inside the SeqLit component of a delta Bioseq." } },
    { eErr_SEQ_INST_SeqLitGapLength0,
    { "SeqLitGapLength0",
    "A SeqLit component of a delta Bioseq can specify a gap, but it should not be a gap \
    of 0 length." } },
    { eErr_SEQ_INST_TpaAssemblyProblem,
    { "TpaAssemblyProblem",
    "Third party annotation records should have a TpaAssembly user object and a \
    Seq-hist.assembly alignment for the PRIMARY block." } },
    { eErr_SEQ_INST_SeqLocLength,
    { "SeqLocLength",
    "A SeqLoc component of a delta Bioseq is suspiciously small." } },
    { eErr_SEQ_INST_MissingGaps,
    { "MissingGaps",
    "HTGS delta records should have gaps between each sequence segment." } },
    { eErr_SEQ_INST_CompleteTitleProblem,
    { "CompleteTitleProblem",
    "The sequence title has complete genome in it, but it is not marked as complete." } },
    { eErr_SEQ_INST_CompleteCircleProblem,
    { "CompleteCircleProblem",
    "This sequence has a circular topology, but it is not marked as complete." } },
    { eErr_SEQ_INST_BadHTGSeq,
    { "BadHTGSeq",
    "High throughput genomic sequences without gaps should have quality score graphs." } },
    { eErr_SEQ_INST_GapInProtein,
    { "GapInProtein",
    "Gap symbols found in this protein Bioseq." } },
    { eErr_SEQ_INST_BadProteinStart,
    { "BadProteinStart",
    "A gap symbols was found at the start of this protein Bioseq." } },
    { eErr_SEQ_INST_TerminalGap,
    { "TerminalGap",
    "The Bioseq has a gap at the end." } },
    { eErr_SEQ_INST_OverlappingDeltaRange,
    { "OverlappingDeltaRange",
    "The Bioseq has a gap at the end." } },
    { eErr_SEQ_INST_LeadingX,
    { "LeadingX",
    "The protein sequence starts with one or more X (unknown) amino acids." } },
    { eErr_SEQ_INST_InternalNsInSeqRaw,
    { "InternalNsInSeqRaw",
    "There are runs of greater than 100 Ns within sequence.  Please describe \
    what these Ns represent with your sequence submission." } },
    { eErr_SEQ_INST_InternalNsAdjacentToGap,
    { "InternalNsAdjacentToGap",
    "There are Ns directly adjacent to a SeqLit gap in a delta Bioseq." } },
    { eErr_SEQ_INST_CaseDifferenceInSeqID,
    { "CaseDifferenceInSeqID",
    "Multiple Bioseqs have the same Seq-id except for capitalization. Sequence \
    identifiers must be unique in a case-insensitive manner within a record." } },
    { eErr_SEQ_INST_DeltaComponentIsGi0,
    { "DeltaComponentIsGi0",
    "Delta component refers to gi 0. This indicates an error in database processing of this record." } },
    { eErr_SEQ_INST_FarFetchFailure,
    { "FarFetchFailure",
    "Fetching of a far feature location or component bioseq was needed, but no fetch \
    function is registered in the program." } },
    { eErr_SEQ_INST_InternalGapsInSeqRaw,
    { "InternalGapsInSeqRaw",
    "Raw sequences should not have gap characters." } },
    { eErr_SEQ_INST_SelfReferentialSequence,
    { "SelfReferentialSequence",
    "A delta sequence must refer to other components, not to itself." } },
    { eErr_SEQ_INST_WholeComponent,
    { "WholeComponent",
    "A delta sequence component should be described as a specific interval, not as \
    the whole of a sequence." } },
    { eErr_SEQ_INST_TSAHistAssemblyMissing,
    { "TSAHistAssemblyMissing",
    "The Bioseq has a TSA MolInfo tech but does not have a Seq-hist.assembly alignment." } },
    { eErr_SEQ_INST_ProteinsHaveGeneralID,
    { "ProteinsHaveGeneralID",
    "One or more protein Bioseqs have a general Seq-id." } },
    { eErr_SEQ_INST_HighNContent,
    { "HighNContent",
    "This sequence contains too many Ns." } },
    { eErr_SEQ_INST_SeqLitDataLength0,
    { "SeqLitDataLength0",
    "A SeqLit component of a delta Bioseq must not have 0 length." } },
    { eErr_SEQ_INST_HighNContentStretch,
    { "HighNContentStretch",
    "This sequence contains long stretches of Ns." } },
    { eErr_SEQ_INST_HighNContentPercent,
    { "HighNContentPercent",
    "This sequence contains a high percentage of Ns." } },
    { eErr_SEQ_INST_UnknownLengthGapNot100,
    { "UnknownLengthGapNot100",
    "Gap of unknown length should have standard length of 100." } },
    { eErr_SEQ_INST_SeqGapProblem,
    { "SeqGapProblem",
    "Inconsistent data in Seq-gap fields." } },
    { eErr_SEQ_INST_WGSMasterLacksStrucComm,
    { "WGSMasterLacksStrucComm",
    "WGS Master records require a Genome Assembly Data structured comment user object." } },
    { eErr_SEQ_INST_TSAMasterLacksStrucComm,
    { "TSAMasterLacksStrucComm",
    "TSA Master records require an Assembly Data structured comment user object." } },
    { eErr_SEQ_INST_AllNs,
    { "AllNs",
    "Sequence has only Ns." } },
    { eErr_SEQ_INST_FarLocationExcludesFeatures,
    { "FarLocationExcludesFeatures",
      "Scaffold points to sequence that has features outside the location." } },
    { eErr_SEQ_INST_ProteinShouldNotHaveGaps,
    { "ProteinShouldNotHaveGaps",
      "Protein sequences should not have gaps" } },
    { eErr_SEQ_INST_MitoMetazoanTooLong,
    { "MitoMetazoanTooLong",
      "Mitochondrial Metozoan sequences should be less than 20000 bp" } },
    { eErr_SEQ_INST_ESTshouldBemRNA,
    { "ESTshouldBemRNA",
      "EST sequence should be mRNA" } },
    { eErr_SEQ_INST_HTGS_STS_GSS_WGSshouldBeGenomic,
    { "HTGS_STS_GSS_WGSshouldBeGenomic",
      "HTGS/STS/GSS/WGS sequence should be genomic" } },
    { eErr_SEQ_INST_HTGS_STS_GSS_WGSshouldNotBeRNA,
    { "HTGS_STS_GSS_WGSshouldNotBeRNA",
      "HTGS/STS/GSS/WGS sequence should not be RNA" } },
    { eErr_SEQ_INST_mRNAshouldBeSingleStranded,
    { "mRNAshouldBeSingleStranded",
      "mRNA should be single stranded not double stranded" } },
    { eErr_SEQ_INST_TSAshouldBNotBeDNA,
    { "TSAshouldBNotBeDNA",
      "TSA sequence should not be DNA" } },
    { eErr_SEQ_INST_GenomeSeqGapProblem,
    { "GenomeSeqGapProblem",
      "Genome submission includes wrong gap type. Gaps for genomes should be Assembly Gaps with linkage evidence." } } ,
    { eErr_SEQ_INST_SeqGapBadLinkage,
    { "SeqGapBadLinkage",
      "Problem with linkage in gap" } } ,
    { eErr_SEQ_INST_TSAseqGapProblem,
    { "TSAseqGapProblem",
      "Gaps for TSA should be Assembly Gaps with linkage evidence." } } ,
    { eErr_SEQ_INST_WGSseqGapProblem,
    { "WGSseqGapProblem",
      "Gaps for WGS genomes should be Assembly Gaps with linkage evidence." } } ,
    { eErr_SEQ_INST_CompleteGenomeHasGaps,
    { "CompleteGenomeHasGaps",
      "Title contains 'complete genome' but sequence has gaps" } } ,
    { eErr_SEQ_INST_HighNcontent5Prime,
    { "HighNcontent5Prime",
      "Sequence with a large number or percentage of Ns at the 5' end might need to be trimmed" } } ,
    { eErr_SEQ_INST_HighNcontent3Prime,
    { "HighNcontent3Prime",
      "Sequence with a large number or percentage of Ns at the 3' end might need to be trimmed" } } ,
    { eErr_SEQ_INST_HighNpercent5Prime,
    { "HighNpercent5Prime",
      "Sequence with a large number or percentage of Ns at the 5' end might need to be trimmed" } } ,
    { eErr_SEQ_INST_HighNpercent3Prime,
    { "HighNpercent3Prime",
      "Sequence with a large number or percentage of Ns at the 3' end might need to be trimmed" } } ,
    { eErr_SEQ_INST_CircBactGenomeProblem,
    { "CircBactGenomeProblem",
      "Circular bacteria or archaea sequence should be annotated as chromosome or plasmid" } } ,
    { eErr_SEQ_INST_ContigsTooShort,
    {  "ContigsTooShort",
      "Maximum contig length is shorter than expected"} },
    { eErr_SEQ_INST_InstantiatedGapMismatch,
    { "InstantiatedGapMismatch",
      "Gap misc_feature does not match gap in delta Bioseq" } } ,

    /* SEQ_DESCR */

    { eErr_SEQ_DESCR_BioSourceMissing,
    { "BioSourceMissing",
    "The biological source of this sequence has not been described correctly.  A \
    Bioseq must have a BioSource descriptor that covers the entire molecule. \
    Additional BioSource features may also be added to recombinant molecules, \
    natural or otherwise, to designate the parts of the molecule. Please add the \
    source information." } },
    { eErr_SEQ_DESCR_InvalidForType,
    { "InvalidForType",
    "This descriptor cannot be used with this Bioseq. A descriptor placed at the \
    BioseqSet level applies to all of the Bioseqs in the set. Please make sure \
    the descriptor is consistent with every sequence to which it applies." } },
    { eErr_SEQ_DESCR_FileOpenCollision,
    { "FileOpenCollision",
    "FileOpen is unable to find a local file.  This is normal, and can be ignored." } },
    { eErr_SEQ_DESCR_Unknown,
    { "Unknown",
    "An unknown or \"other\" modifier was used." } },
    { eErr_SEQ_DESCR_NoPubFound,
    { "NoPubFound",
    "No publications were found in this entry which refer to this Bioseq. If a \
    publication descriptor is added to a BioseqSet, it will apply to all of the \
    Bioseqs in the set. A publication feature should be used if the publication \
    applies only to a subregion of a sequence." } },
    { eErr_SEQ_DESCR_NoOrgFound,
    { "NoOrgFound",
    "This entry does not specify the organism that was the source of the sequence. \
    Please name the organism." } },
    { eErr_SEQ_DESCR_MultipleBioSources,
    { "MultipleBioSources",
    "There are multiple BioSource or OrgRef descriptors in the same chain with \
    the same taxonomic name. Their information should be combined into a single \
    BioSource descriptor." } },
    { eErr_SEQ_DESCR_NoMolInfoFound,
    { "NoMolInfoFound",
    "This sequence does not have a Mol-info descriptor applying to it.  This indicates \
    genomic vs. message, sequencing technique, and whether the sequence is incomplete." } },
    { eErr_SEQ_DESCR_BadCountryCode,
    { "BadCountryCode",
    "The country code (up to the first colon) is not on the approved list of countries." } },
    { eErr_SEQ_DESCR_NoTaxonID,
    { "NoTaxonID",
    "The BioSource is missing a taxonID database identifier.  This will be inserted by \
    the automated taxonomy lookup called by Clean Up Record." } },
    { eErr_SEQ_DESCR_InconsistentBioSources,
    { "InconsistentBioSources",
    "This population study has BioSource descriptors with different taxonomic names. \
    All members of a population study should be from the same organism." } },
    { eErr_SEQ_DESCR_MissingLineage,
    { "MissingLineage",
    "A BioSource should have a taxonomic lineage, which can be obtained from the \
    taxonomy network server." } },
    { eErr_SEQ_DESCR_SerialInComment,
    { "SerialInComment",
    "Comments that refer to the conclusions of a specific reference should not be \
    cited by a serial number inside brackets (e.g., [3]), but should instead be \
    attached as a REMARK on the reference itself." } },
    { eErr_SEQ_DESCR_BioSourceNeedsFocus,
    { "BioSourceNeedsFocus",
    "Focus must be set on a BioSource descriptor in records where there is a \
    BioSource feature with a different organism name." } },
    { eErr_SEQ_DESCR_BadOrganelleLocation,
    { "BadOrganelleLocation",
    "Only Kinetoplastida have kinetoplasts. Only Chlorarchniophyta \
    and Cryptophyta have nucleomorphs. Bacterial or viral source should not have organelle location." } },
    { eErr_SEQ_DESCR_MultipleChromosomes,
    { "MultipleChromosomes",
    "There are multiple chromosome qualifiers on this Bioseq.  With the exception of \
    some pseudoautosomal genes, this is likely to be a biological annotation error." } },
    { eErr_SEQ_DESCR_BadSubSource,
    { "BadSubSource",
    "Unassigned SubSource subtype." } },
    { eErr_SEQ_DESCR_BadOrgMod,
    { "BadOrgMod",
    "Unassigned OrgMod subtype." } },
    { eErr_SEQ_DESCR_InconsistentProteinTitle,
    { "InconsistentProteinTitle",
    "An instantiated protein title descriptor should normally be the same as the \
    automatically generated title.  This may be a curated exception, or it may \
    be out of synch with the current annotation." } },
    { eErr_SEQ_DESCR_Inconsistent,
    { "Inconsistent",
    "There are two descriptors of the same type which are inconsistent with each \
    other. Please make them consistent." } },
    { eErr_SEQ_DESCR_ObsoleteSourceLocation,
    { "ObsoleteSourceLocation",
    "There is a source location that is no longer legal for use in GenBank records." } },
    { eErr_SEQ_DESCR_ObsoleteSourceQual,
    { "ObsoleteSourceQual",
    "There is a source qualifier that is no longer legal for use in GenBank records." } },
    { eErr_SEQ_DESCR_StructuredSourceNote,
    { "StructuredSourceNote",
    "The name of a structured source field is present as text in a note.  The data \
    should probably be put into the appropriate field instead." } },
    { eErr_SEQ_DESCR_UnnecessaryBioSourceFocus,
    { "UnnecessaryBioSourceFocus",
    "Focus should not be set on a BioSource descriptor in records where there is no \
    BioSource feature." } },
    { eErr_SEQ_DESCR_RefGeneTrackingWithoutStatus,
    { "RefGeneTrackingWithoutStatus",
    "The RefGeneTracking user object does not have the required Status field set." } },
    { eErr_SEQ_DESCR_UnwantedCompleteFlag,
    { "UnwantedCompleteFlag",
    "The Mol-info.completeness flag should not be set on a genomic sequence, unless \
    the title also says it is a complete sequence or complete genome, nor should it \
    be set on a plasmid, chromosome, or organelle." } },
    { eErr_SEQ_DESCR_CollidingPublications,
    { "CollidingPublications",
    "Multiple publication descriptors with the same PMID or MUID apply to a Bioseq. \
    The lower-level ones are redundant, and should be removed." } },
    { eErr_SEQ_DESCR_TransgenicProblem,
    { "TransgenicProblem",
    "A BioSource descriptor with /transgenic set must be accompanied by a BioSource \
    feature on the nucleotide record." } },
    { eErr_SEQ_DESCR_TaxonomyLookupProblem,
    { "TaxonomyLookupProblem",
    "A BioSource descriptor or feature has flags returned by taxonomy lookup that \
    are either inconsistent with the data or require a taxonomy consult." } },
    { eErr_SEQ_DESCR_MultipleTitles,
    { "MultipleTitles",
    "There are multiple title descriptors in the same Bioseq or BioseqSet chain." } },
    { eErr_SEQ_DESCR_RefGeneTrackingOnNonRefSeq,
    { "RefGeneTrackingOnNonRefSeq",
    "The RefGeneTracking user object should only be in RefSeq records." } },
    { eErr_SEQ_DESCR_BioSourceInconsistency,
    { "BioSourceInconsistency",
    "There is an internal inconsistency with specific fields in the BioSource." } },
    { eErr_SEQ_DESCR_FastaBracketTitle,
    { "FastaBracketTitle",
    "Bracketed [...=...] information remains in the title.  This should have been parsed \
    out during sequence record generation to obtain qualifier values." } },
    { eErr_SEQ_DESCR_MissingText,
    { "MissingText",
    "Comments, regions, and other text descriptors need a descriptive text string. \
    The string provided with this descriptor is empty. If no text is desired, then \
    the descriptor should be removed." } },
    { eErr_SEQ_DESCR_BadCollectionDate,
    { "BadCollectionDate",
    "The collection date is not in the required format." } },
    { eErr_SEQ_DESCR_BadPCRPrimerSequence,
    { "BadPCRPrimerSequence",
    "The PCR primer sequence has illegal characters or non-IUPAC nucleotides." } },
    { eErr_SEQ_DESCR_BadPunctuation,
    { "BadPunctuation",
    "The title ends with incorrect punctuation marks." } },
    { eErr_SEQ_DESCR_BadPCRPrimerName,
    { "BadPCRPrimerName",
    "The PCR primer name appears to be a sequence instead of an identifying label." } },
    { eErr_SEQ_DESCR_BioSourceOnProtein,
    { "BioSourceOnProtein",
    "A BioSource descriptor should not be placed on a protein that is in a nuc-prot set." } },
    { eErr_SEQ_DESCR_BioSourceDbTagConflict,
    { "BioSourceDbTagConflict",
    "Multiple db_xrefs with the same database should not appear on a single BioSource." } },
    { eErr_SEQ_DESCR_DuplicatePCRPrimerSequence,
    { "DuplicatePCRPrimerSequence",
    "The PCR primer sequence has duplicate subsequences." } },
    { eErr_SEQ_DESCR_MultipleNames,
    { "MultipleNames",
    "There are multiple name descriptors in the same Bioseq or BioseqSet chain." } },
    { eErr_SEQ_DESCR_MultipleComments,
    { "MultipleComments",
    "There are multiple identical comment descriptors in the same Bioseq or BioseqSet chain." } },
    { eErr_SEQ_DESCR_LatLonFormat,
    { "LatLonFormat",
    "The format of lat_lon should be dd.dd N|S ddd.dd E|W." } },
    { eErr_SEQ_DESCR_LatLonRange,
    { "LatLonRange",
    "Latitude or longitude is out of range." } },
    { eErr_SEQ_DESCR_LatLonValue,
    { "LatLonValue",
    "Latitude or longitude values appear to be in the wrong hemisphere or swapped." } },
    { eErr_SEQ_DESCR_LatLonCountry,
    { "LatLonCountry",
    "The lat_lon coordinate does not map to the indicated country." } },
    { eErr_SEQ_DESCR_LatLonState,
    { "LatLonState",
    "The lat_lon coordinate does not map to the indicated state or province." } },
    { eErr_SEQ_DESCR_BadSpecificHost,
    { "BadSpecificHost",
    "A BioSource descriptor or feature has a specific host value that may \
    require a taxonomy consult." } },
    { eErr_SEQ_DESCR_RefGeneTrackingIllegalStatus,
    { "RefGeneTrackingIllegalStatus",
    "The RefGeneTracking user object has an illegal Status value." } },
    { eErr_SEQ_DESCR_ReplacedCountryCode,
    { "ReplacedCountryCode",
    "The country code (up to the first colon) is no longer on the approved list of countries." } },
    { eErr_SEQ_DESCR_BadInstitutionCode,
    { "BadInstitutionCode",
    "The institution (or institution: collection) code is not on the approved list." } },
    { eErr_SEQ_DESCR_BadCollectionCode,
    { "BadCollectionCode",
    "The institution code is recognized, but the collection is not on the approved list." } },
    { eErr_SEQ_DESCR_IncorrectlyFormattedVoucherID,
    { "IncorrectlyFormattedVoucherID",
    "The voucher is missing a specific identifier." } },
    { eErr_SEQ_DESCR_UnstructuredVoucher,
    { "UnstructuredVoucher",
    "The voucher needs to be structured as \"<institution-code>:[<collection-code>:]<culture_id>\"." } },
    { eErr_SEQ_DESCR_ChromosomeLocation,
    { "ChromosomeLocation",
    "BioSource location is not usually chromosome." } },
    { eErr_SEQ_DESCR_MultipleSourceQualifiers,
    { "MultipleSourceQualifiers",
    "BioSource has unexpected multiple qualifiers of the same type." } },
    { eErr_SEQ_DESCR_UnbalancedParentheses,
    { "UnbalancedParentheses",
    "Qualifier should have matching ( and ) parentheses or [ and ] brackets." } },
    { eErr_SEQ_DESCR_IdenticalInstitutionCode,
    { "IdenticalInstitutionCode",
    "BioSource has unexpected multiple bio_material/culture_collection/specimen_voucher \
    from the same institution." } },
    { eErr_SEQ_DESCR_BadCountryCapitalization,
    { "BadCountryCapitalization",
    "The country code does not use the correct capitalization." } },
    { eErr_SEQ_DESCR_WrongVoucherType,
    { "WrongVoucherType",
    "The institution (or institution: collection) code normally uses a different \
    bio_material/culture_collection/specimen_voucher type." } },
    { eErr_SEQ_DESCR_TitleHasPMID,
    { "TitleHasPMID",
    "The title has (PMID #####) embedded in it." } },
    { eErr_SEQ_DESCR_BadKeyword,
    { "BadKeyword",
    "The keyword is not appropriate in this record." } },
    { eErr_SEQ_DESCR_NoOrganismInTitle,
    { "NoOrganismInTitle",
    "A RefSeq record should have the organism name at the beginning of a nucleotide title and bracketed at the end of a protein title." } },
    { eErr_SEQ_DESCR_MissingChromosome,
    { "MissingChromosome",
    "An NC or AC RefSeq record should have a chromosome annotated." } },
    { eErr_SEQ_DESCR_LatLonAdjacent,
    { "LatLonAdjacent",
    "The lat_lon coordinate may be in an adjacent country or in surrounding waters." } },
    { eErr_SEQ_DESCR_BadStrucCommInvalidFieldName,
    { "BadStrucCommInvalidFieldName",
    "Structured comment is missing required fields or field values do not conform to correct format." } },
    { eErr_SEQ_DESCR_BadStrucCommInvalidFieldValue,
    { "BadStrucCommInvalidFieldValue",
    "Structured comment is missing required fields or field values do not conform to correct format." } },
    { eErr_SEQ_DESCR_BadStrucCommMissingField,
    { "BadStrucCommMissingField",
    "Structured comment is missing required fields or field values do not conform to correct format." } },
    { eErr_SEQ_DESCR_BadStrucCommFieldOutOfOrder,
    { "BadStrucCommFieldOutOfOrder",
    "Structured comment is missing required fields or field values do not conform to correct format." } },
    { eErr_SEQ_DESCR_BadStrucCommMultipleFields,
    { "BadStrucCommMultipleFields",
    "Structured comment is missing required fields or field values do not conform to correct format." } },
    { eErr_SEQ_DESCR_BioSourceNeedsChromosome,
    { "BioSourceNeedsChromosome",
    "Chromosome should be set on a BioSource descriptor in non-viral complete genomes." } },
    { eErr_SEQ_DESCR_MolInfoConflictsWithBioSource,
    { "MolInfoConflictsWithBioSource",
    "Viral lineage information conflicts with MolInfo." } },
    { eErr_SEQ_DESCR_FakeStructuredComment,
    { "FakeStructuredComment",
    "Comment descriptor may have been formatted to look like structured comment." } },
    { eErr_SEQ_DESCR_StructuredCommentPrefixOrSuffixMissing,
    { "StructuredCommentPrefixOrSuffixMissing",
    "Structured comments should have a prefix or suffix." } },
    { eErr_SEQ_DESCR_LatLonWater,
    { "LatLonWater",
    "The lat_lon coordinate map in a body of water." } },
    { eErr_SEQ_DESCR_LatLonOffshore,
    { "LatLonOffshore",
    "The lat_lon coordinate is probably in a minor or unnamed body of water." } },
    { eErr_SEQ_DESCR_MissingPersonalCollectionName,
    { "MissingPersonalCollectionName",
    "The personal collection does not indicate the name of the collector." } },
    { eErr_SEQ_DESCR_LatLonPrecision,
    { "LatLonPrecision",
    "The precision of lat_lon should be dd.dd N|S ddd.dd E|W." } },
    { eErr_SEQ_DESCR_DBLinkProblem,
    { "DBLinkProblem",
    "Only one DBLink user object with approved databases should apply to each Bioseq." } },
    { eErr_SEQ_DESCR_FinishedStatusForWGS,
    { "FinishedStatusForWGS",
    "WGS projects should not have the Genome-Assembly-Data structured comment current \
    finishing status set to Finished." } },
    { eErr_SEQ_DESCR_BadTentativeName,
    { "BadTentativeName",
    "A structured comment descriptor or feature has a tentative name value that may \
    require a taxonomy consult." } },
    { eErr_SEQ_DESCR_OrganismNotFound,
    { "OrganismNotFound",
    "The indicated organism is not in the taxonomy database." } },
    { eErr_SEQ_DESCR_TaxonomyIsSpeciesProblem,
    { "TaxonomyIsSpeciesProblem",
    "Taxonomy lookup of the indicated organism reports an is_species_level problem." } },
    { eErr_SEQ_DESCR_TaxonomyConsultRequired,
    { "TaxonomyConsultRequired",
    "A taxonomy consult is required for the indicated organism." } },
    { eErr_SEQ_DESCR_TaxonomyNucleomorphProblem,
    { "TaxonomyNucleomorphProblem",
    "Taxonomy lookup indicates that the nucleomorph flag should be set for this organism." } },
    { eErr_SEQ_DESCR_InconsistentMolTypeBiomol,
    { "InconsistentMolTypeBiomol",
    "The Bioseq instance molecule field is inconsistent with the Mol-info biomol field." } },
    { eErr_SEQ_DESCR_BadInstitutionCountry,
    { "BadInstitutionCountry",
    "The institution (or institution: collection) code should not have a <country> modifier." } },
    { eErr_SEQ_DESCR_AmbiguousSpecificHost,
    { "AmbiguousSpecificHost",
    "A BioSource descriptor or feature has an ambiguous specific host value that may \
    require a taxonomy consult." } },
    { eErr_SEQ_DESCR_BadAltitude,
    { "BadAltitude",
    "The altitude must be reported as a number followed by a space and the letter m (for meters)." } },
    { eErr_SEQ_DESCR_RefGeneTrackingOnNucProtSet,
    { "RefGeneTrackingOnNucProtSet",
    "The RefGeneTracking user object should not be on a nuc-prot set." } },
    { eErr_SEQ_DESCR_InconsistentDates,
    { "InconsistentDates",
    "There are two date descriptors that are inconsistent with each \
    other. Please make them consistent." } },
    { eErr_SEQ_DESCR_MultipleTaxonIDs,
    { "MultipleTaxonIDs",
    "There are multiple BioSources with multiple taxonIDs in this RefSeq record." } },
    { eErr_SEQ_DESCR_ScaffoldLacksBioProject,
    { "ScaffoldLacksBioProject",
    "There is no BioProject database link for this scaffold record." } },
    { eErr_SEQ_DESCR_CompleteGenomeLacksBioProject,
    { "CompleteGenomeLacksBioProject",
    "There is no BioProject database link for this complete genome record." } },
    { eErr_SEQ_DESCR_TaxonomyPlastidsProblem,
    { "TaxonomyPlastidsProblem",
    "Taxonomy lookup indicates that the plastids flag should be set for this organism." } },
    { eErr_SEQ_DESCR_OrganismIsUndefinedSpecies,
    { "OrganismIsUndefinedSpecies",
    "Organism is an undefined species and does not have a specific identifier." } },
    { eErr_SEQ_DESCR_SuspectedContaminatedCellLine,
    { "SuspectedContaminatedCellLine",
    "Suspected contaminated cell line." } },
    { eErr_SEQ_DESCR_WrongOrganismFor16SrRNA,
    { "WrongOrganismFor16SrRNA",
    "16S ribosomal RNA is not present in eukaryotic ribosomes." } },
    { eErr_SEQ_DESCR_InconsistentWGSFlags,
    { "InconsistentWGSFlags",
    "WGS indicators are used inconsistently in this record." } },
    { eErr_SEQ_DESCR_TitleNotAppropriateForSet,
    { "TitleNotAppropriateForSet",
    "Only population study, phylogenetic study, ecological sample study, and mutation sets should have title descriptors." } },
    { eErr_SEQ_DESCR_StrainContainsTaxInfo,
    { "StrainContainsTaxInfo",
    "Strain contains taxonomic name information" } },
    { eErr_SEQ_DESCR_InconsistentBioSources_ConLocation,
    { "InconsistentBioSources_ConLocation",
    "The source location for a contig and scaffold should be the same" } },
    { eErr_SEQ_DESCR_InconsistentRefSeqMoltype,
    { "InconsistentRefSeqMoltype",
    "Genomic RefSeq accession should use genomic or cRNA moltype" } },
    { eErr_SEQ_DESCR_InconsistentMolInfo,
    { "InconsistentMolInfo",
    "MolInfo descriptors that apply to the same sequence should be consistent" } },
    { eErr_SEQ_DESCR_InconsistentMolInfoTechnique,
    { "InconsistentMolInfoTechnique",
    "MolInfo descriptors that apply to the same sequence should be consistent" } },
    { eErr_SEQ_DESCR_InconsistentTaxName,
    { "InconsistentTaxName",
    "Source descriptors that apply to the same sequence should have the same organism name" } },
    { eErr_SEQ_DESCR_InconsistentMolType,
    { "InconsistentMolType",
    "RNA biomol values should be accompanied by RNA molecule type values" } },
    { eErr_SEQ_DESCR_InconsistentGenBankblocks,
    { "InconsistentGenBankblocks",
    "Only one GenBankBlock descriptor should apply to a sequence" } },
    { eErr_SEQ_DESCR_InconsistentTaxNameSet,
    { "InconsistentTaxNameSet",
    "Organism names in a population set should be consistent" } },
    { eErr_SEQ_DESCR_InconsistentTPA,
    { "InconsistentTPA",
    "TPA:experimental and TPA:inferential should not both be in the same set of keywords" } },
    { eErr_SEQ_DESCR_BacteriaMissingSourceQualifier,
    { "BacteriaMissingSourceQualifier",
        "Bacteria should have strain or isolate or environmental sample" } },
    { eErr_SEQ_DESCR_BadBioSourceFrequencyValue,
    { "BadBioSourceFrequencyValue",
        "Frequency should be a number less than 1" }},
    { eErr_SEQ_DESCR_BadPlasmidChromosomeLinkageName,
    { "BadPlasmidChromosomeLinkageName",
        "Problematic plasmid/chromosome/linkage group name" }},
    { eErr_SEQ_DESCR_BadPlastidName,
    { "BadPlastidName",
        "Plastid name should only appear for plastid location" }},
    { eErr_SEQ_DESCR_EnvironSampleMissingQualifier,
    { "EnvironSampleMissingQualifier",
        "Environmental sample should also have isolation source or specific host annotated" }},
    { eErr_SEQ_DESCR_InconsistentVirusMoltype,
    { "InconsistentVirusMoltype",
        "Molecule type is unexpected for specified virus type" }},
    { eErr_SEQ_DESCR_InvalidMatingType,
    { "InvalidMatingType",
        "Unexpected use of /mating_type qualifier" }},
    { eErr_SEQ_DESCR_InvalidSexQualifier,
    { "InvalidSexQualifier",
        "Sex qualifier should only be used for some types of organisms" }},
    { eErr_SEQ_DESCR_InvalidTissueType,
    { "InvalidTissueType",
        "Tissue-type is inappropriate for bacteria" }},
    { eErr_SEQ_DESCR_MissingEnvironmentalSample,
    { "MissingEnvironmentalSample",
        "Environmental-sample qualifier is expected for this sequence" }},
    { eErr_SEQ_DESCR_MissingMetagenomicQualifier,
    { "MissingMetagenomicQualifier",
        "Metagenomic qualifier is expected for this sequence" }},
    { eErr_SEQ_DESCR_MissingPlasmidLocation,
    { "MissingPlasmidLocation",
        "Plasmid-name is specified, but location is not plasmid" }},
    { eErr_SEQ_DESCR_MissingPlasmidName,
    { "MissingPlasmidName",
        "Location is plasmid, but no plasmid-name is provided" }},
    { eErr_SEQ_DESCR_OrgModValueInvalid,
    { "OrgModValueInvalid",
        "Invalid qualifier value" }},
    { eErr_SEQ_DESCR_StrainWithEnvironSample,
    { "StrainWithEnvironSample",
        "Strain should not be present in an environmental sample" }},
    { eErr_SEQ_DESCR_UnculturedNeedsEnvSample,
    { "UnculturedNeedsEnvSample",
        "Uncultured should also have /environmental_sample"} },
    { eErr_SEQ_DESCR_BadTextInSourceQualifier,
    { "BadTextInSourceQualifier",
      "Qualifier value incorrectly formatted"} },
    { eErr_SEQ_DESCR_OrgModMissingValue,
    { "OrgModMissingValue",
      "Qualifier value is missing"} },
    { eErr_SEQ_DESCR_BadAssemblyName,
    { "BadAssemblyName" ,
      "Assembly Name should not start with 'NCBI' or 'GenBank' in structured comment" } },
    { eErr_SEQ_DESCR_BadKeywordForStrucComm,
    { "BadKeywordForStrucComm" ,
      "Structured Comment is non-compliant, keyword should be removed" } },
    { eErr_SEQ_DESCR_BadKeywordNoTechnique,
    { "BadKeywordNoTechnique" ,
      "Sequences with BARCODE keywords should have Molinfo.tech barcode" } },
    { eErr_SEQ_DESCR_BadKeywordUnverified,
    { "BadKeywordUnverified" ,
      "Sequence should not have both BARCODE and UNVERIFIED keywords" } },
    { eErr_SEQ_DESCR_BadStrucCommInvalidPrefix,
    { "BadStrucCommInvalidPrefix" ,
      "Unrecognized structured comment prefix" } },
    { eErr_SEQ_DESCR_BadStrucCommInvalidSuffix,
    { "BadStrucCommInvalidSuffix" ,
      "Unrecognized structured comment suffix" } },
    { eErr_SEQ_DESCR_BINDoesNotMatch,
    { "BINDoesNotMatch" ,
      "The organism name should end with sp. plus Barcode Index Number" } },
    { eErr_SEQ_DESCR_CollidingPubMedID,
    { "CollidingPubMedID" ,
      "Multiple different publications should not have the same identifier" } },
    { eErr_SEQ_DESCR_CommentMissingText,
    { "CommentMissingText" ,
      "Comment descriptors should not be blank" } },
    { eErr_SEQ_DESCR_DBLinkBadAssembly,
    { "DBLinkBadAssembly" ,
      "Assembly entries should not appear in DBLink user objects" } },
    { eErr_SEQ_DESCR_DBLinkBadBioProject,
    { "DBLinkBadBioProject" ,
      "Bad BioProject format" } },
    { eErr_SEQ_DESCR_DBLinkBadBioSample,
    { "DBLinkBadBioSample" ,
      "Bad BioSample format" } },
    { eErr_SEQ_DESCR_DBLinkBadCapitalization,
    { "DBLinkBadCapitalization" ,
      "Bad DBLink capitalization" } },
    { eErr_SEQ_DESCR_DBLinkBadFormat,
    { "DBLinkBadFormat" ,
      "Unrecognized entries appear in DBLink user objects" } },
    { eErr_SEQ_DESCR_DBLinkBadSRAaccession,
    { "DBLinkBadSRAaccession" ,
      "Bad Sequence Read Archive format" } },
    { eErr_SEQ_DESCR_DBLinkMissingUserObject,
    { "DBLinkMissingUserObject" ,
      "A DBLink user object descriptor should not be empty" } },
    { eErr_SEQ_DESCR_DBLinkOnSet,
    { "DBLinkOnSet" ,
      "A DBLink object should be placed on a nucleotide sequence, not a set" } },
    { eErr_SEQ_DESCR_InvalidForTypeGIBB,
    { "InvalidForTypeGIBB" ,
      "GIBB descriptors are obsolete" } },
    { eErr_SEQ_DESCR_InvalidMolInfo,
    { "InvalidMolInfo" ,
      "Nucleic acid should not have Molinfo-biomol = peptide" } },
    { eErr_SEQ_DESCR_MoltypeOther,
    { "MoltypeOther" ,
      "Molinfo-biomol should not be 'other'" } },
    { eErr_SEQ_DESCR_MoltypeOtherGenetic,
    { "MoltypeOtherGenetic" ,
      "Molinfo-biomol should not be 'other genetic'" } },
    { eErr_SEQ_DESCR_MoltypeUnknown,
    { "MoltypeUnknown" ,
      "Molinfo-biomol unknown should not be used" } },
    { eErr_SEQ_DESCR_MultipleDBLinkObjects,
    { "MultipleDBLinkObjects" ,
      "Sequence should not have multiple DBLink objects" } },
    { eErr_SEQ_DESCR_MultipleStrucComms,
    { "MultipleStrucComms" ,
      "Multiple structured comments with prefix " } },
    { eErr_SEQ_DESCR_NoKeywordHasTechnique,
    { "NoKeywordHasTechnique" ,
      "Molinfo.tech barcode without BARCODE keyword" } },
    { eErr_SEQ_DESCR_NoSourceDescriptor,
    { "NoSourceDescriptor" ,
      "No source information included on this record." } },
    { eErr_SEQ_DESCR_NucleotideTechniqueOnProtein,
    { "NucleotideTechniqueOnProtein" ,
      "Protein should not have nucleic acid sequence method" } },
    { eErr_SEQ_DESCR_ProteinTechniqueOnNucleotide,
    { "ProteinTechniqueOnNucleotide" ,
      "Nucleic acid should not have protein sequence method" } },
    { eErr_SEQ_DESCR_RegionMissingText,
    { "RegionMissingText" ,
      "Region descriptor needs text" } },
    { eErr_SEQ_DESCR_StrucCommMissingPrefixOrSuffix,
    { "StrucCommMissingPrefixOrSuffix",
      "Structured Comment lacks prefix and/or suffix" } },
    { eErr_SEQ_DESCR_StrucCommMissingUserObject,
    { "StrucCommMissingUserObject" ,
      "Structured Comment user object descriptor is empty" } },
    { eErr_SEQ_DESCR_SyntheticConstructNeedsArtificial,
    { "SyntheticConstructNeedsArtificial" ,
      "Synthetic construct should have artificial origin" } },
    { eErr_SEQ_DESCR_SyntheticConstructWrongMolType,
    { "SyntheticConstructWrongMolType" ,
      "Synthetic construct should have other-genetic" } },
    { eErr_SEQ_DESCR_TaxonomyAmbiguousName,
    { "TaxonomyAmbiguousName" ,
      "Taxonomy lookup failed with message 'ambiguous name'" } },
    { eErr_SEQ_DESCR_TaxonomyServiceProblem,
    { "TaxonomyServiceProblem" ,
      "Taxonomy service connection failure" } },
    { eErr_SEQ_DESCR_TitleMissingText,
    { "TitleMissingText" ,
      "Title descriptor needs text" } },
    { eErr_SEQ_DESCR_TPAassemblyWithoutTPAKeyword,
    { "TPAassemblyWithoutTPAKeyword" ,
      "Non-TPA record should not have TpaAssembly object" } },
    { eErr_SEQ_DESCR_UserObjectNoData,
    { "UserObjectNoData" ,
      "User object with no data" } },
    { eErr_SEQ_DESCR_UserObjectNoType,
    { "UserObjectNoType" ,
      "User object with no type" } },
    { eErr_SEQ_DESCR_WGSmasterLacksBioProject,
    { "WGSmasterLacksBioProject" ,
      "WGS master lacks BioProject" } },
    { eErr_SEQ_DESCR_WGSmasterLacksBioSample,
    { "WGSmasterLacksBioSample" ,
      "WGS master lacks BioSample" } },
    { eErr_SEQ_DESCR_WGSMasterLacksBothBioSampleBioProject,
    { "WGSMasterLacksBothBioSampleBioProject" ,
      "WGS master lacks both BioSample and BioProject" } },
    { eErr_SEQ_DESCR_WrongBiomolForTSA,
    { "WrongBiomolForTSA" ,
      "TSA records are expected to make use of a very limited set of MolInfo.biomol values: transcribed-RNA, mRNA, rRNA, ncRNA." } },
    { eErr_SEQ_DESCR_AmbiguousName,
    { "AmbiguousName",
      "More than one matching organism name" } },
    { eErr_SEQ_DESCR_ModifierTypeConflict,
    { "ModifierTypeConflict",
      "Resulting org-ref has more than one value for singleton modifier type" } },
    { eErr_SEQ_DESCR_AmbiguousModForward,
    { "AmbiguousModForward",
      "Multiple modifier forwarding reaches incompatible targets" } },
    { eErr_SEQ_DESCR_AmbiguousTypeMaterial,
    { "AmbiguousTypeMaterial",
      "Specified type material information belongs to unrelated taxa" } },
    { eErr_SEQ_DESCR_EmptyOrgInput,
    { "EmptyOrgInput",
      "Org-ref does not contain information to match" } },
    { eErr_SEQ_DESCR_HostIdenticalToOrganism,
    { "HostIdenticalToOrganism",
      "Specific host should not be identical to taxname" } } ,
    { eErr_SEQ_DESCR_MultipleStrains,
    { "MultipleStrains",
      "A Biosource should only have one strain value" } } ,
    { eErr_SEQ_DESCR_BadVariety,
    { "BadVariety",
      "Orgmod variety should only be in plants, fungi, or cyanobacteria" } } ,
    { eErr_SEQ_DESCR_BadTypeMaterial,
    { "BadTypeMaterial",
      "Bad value for type_material" } } ,
    { eErr_SEQ_DESCR_TaxonomyNoCommonAncestor,
    { "TaxonomyNoCommonAncestor",
      "No common ancestor for input taxids in join request" } },
    { eErr_SEQ_DESCR_TaxonomyNoValidTaxids,
    { "TaxonomyNoValidTaxids", 
      "All taxids in join request are invalid" } },
    { eErr_SEQ_DESCR_TaxonomyEmptyInput,
    { "TaxonomyEmptyInput",
      "No valid input to perform Taxonomy request" } } ,
    { eErr_SEQ_DESCR_ChromosomeWithoutLocation,
    {"ChromosomeWithoutLocation",
     "Location should be chromosome if chromosome name is present" } },
    { eErr_SEQ_DESCR_TaxonomyBlankSample,
    { "TaxonomyBlankSample", 
      "Blank sample taxonomy should not coexist with sequence records" } },
    { eErr_SEQ_DESCR_NonViralSegment,
    { "NonViralSegment", 
      "Non-viral taxonomy should not have segment qualifier" } },


    /* SEQ_GENERIC */

    { eErr_GENERIC_NonAsciiAsn,
    { "NonAsciiAsn",
    "There is a non-ASCII type character in this entry." } },
    { eErr_GENERIC_Spell,
    { "Spell",
    "There is a potentially misspelled word in this entry." } },
    { eErr_GENERIC_AuthorListHasEtAl,
    { "AuthorListHasEtAl",
    "The author list contains et al, which should be replaced with the \
    remaining author names." } },
    { eErr_GENERIC_MissingPubInfo,
    { "MissingPubInfo",
    "The publication is missing essential information, such as title or authors." } },
    { eErr_GENERIC_UnnecessaryPubEquiv,
    { "UnnecessaryPubEquiv",
    "A nested Pub-equiv is not normally expected in a publication.  This may prevent \
    proper display of all publication information." } },
    { eErr_GENERIC_BadPageNumbering,
    { "BadPageNumbering",
    "The publication page numbering is suspect." } },
    { eErr_GENERIC_MedlineEntryPub,
    { "MedlineEntryPub",
    "Publications should not be of type medline-entry.  This has abstract and MeSH \
    term information that does not appear in the GenBank flatfile.  Type cit-art \
    should be used instead." } },
    { eErr_GENERIC_BadDate,
    { "BadDate",
    "There are bad values for month, day, or year in a date." } },
    { eErr_GENERIC_StructuredCitGenCit,
    { "StructuredCitGenCit",
    "The publication has title or journal embedded in the unstructured citgen.cit \
    field." } },
    { eErr_GENERIC_CollidingSerialNumbers,
    { "CollidingSerialNumbers",
    "Multiple publications have the same serial number explicitly recorded in the \
    data." } },
    { eErr_GENERIC_EmbeddedScript,
    { "EmbeddedScript",
    "Script or other markup tags should not be used in sequence record fields." } },
    { eErr_GENERIC_PublicationInconsistency,
    { "PublicationInconsistency",
    "Some fields in the publication should not be present with other fields." } },
    { eErr_GENERIC_SgmlPresentInText,
    { "SgmlPresentInText",
    "SGML markup is embedded in text." } },
    { eErr_GENERIC_UnexpectedPubStatusComment,
    { "UnexpectedPubStatusComment",
    "An unexpected publication status exists for a print, online-only, or ahead-of-print article : Content-Of-Pubdesc.comment-String." } },
    { eErr_GENERIC_PastReleaseDate,
    { "PastReleaseDate",
    "The record has is marked as hold-until-published, but the release anyway date has already passed." } },
    { eErr_GENERIC_MissingISOJTA,
    { "MissingISOJTA",
    "The publication journal is missing an ISO journal title abbreviation." } },
    { eErr_GENERIC_MissingVolume,
    { "MissingVolume",
    "The publication volume is missing." } },
    { eErr_GENERIC_MissingVolumeEpub,
    { "MissingVolumeEpub",
    "The electronic publication volume is missing." } },
    { eErr_GENERIC_MissingPages,
    { "MissingPages",
    "The publication pages are missing." } },
    { eErr_GENERIC_MissingPagesEpub,
    { "MissingPagesEpub",
    "The electronic publication pages are missing." } },
    { eErr_GENERIC_BarcodeTooShort,
    { "BarcodeTooShort",
    "Barcode sequence is too short." } },
    { eErr_GENERIC_BarcodeMissingPrimers,
    { "BarcodeMissingPrimers",
    "Barcode sequence is missing primers." } },
    { eErr_GENERIC_BarcodeMissingCountry,
    { "BarcodeMissingCountry",
    "Barcode sequence is missing country." } },
    { eErr_GENERIC_BarcodeMissingVoucher,
    { "BarcodeMissingVoucher",
    "Barcode sequence is missing voucher." } },
    { eErr_GENERIC_BarcodeTooManyNs,
    { "BarcodeTooManyNs",
    "Barcode sequence contains too many Ns" } },
    { eErr_GENERIC_BarcodeBadCollectionDate,
    { "BarcodeBadCollectionDate",
"Barcode sequence has bad collection date" } } ,
    { eErr_GENERIC_BarcodeMissingOrderAssignment,
    { "BarcodeMissingOrderAssignment",
"Barcode sequence is missing order assignment." } },
    { eErr_GENERIC_BarcodeLowTrace,
    { "BarcodeLowTrace",
"Barcode sequence has low trace." } },
    { eErr_GENERIC_BarcodeFrameShift,
    { "BarcodeFrameShift",
"Barcode sequence has frame shift." } },
    { eErr_GENERIC_BarcodeStructuredVoucher,
    { "BarcodeStructuredVoucher",
"Barcode sequence has structured voucher problem." } },
    { eErr_GENERIC_BarcodeTestFails,
    { "BarcodeTestFails",
"Barcode test fails." } },
    { eErr_GENERIC_BarcodeTestPasses,
    { "BarcodeTestPasses",
"Barcode test passes." } },
    { eErr_GENERIC_InvalidAsn,
    { "InvalidAsn",
"Invalid ASN.1" } },
    { eErr_GENERIC_DeltaSeqError,
    { "DeltaSeqError",
"Service failure prevented complete validation" } },
    { eErr_GENERIC_DuplicateIDs,
    { "DuplicateIDs",
"Colliding sequence identifiers prevented loading into the object manager." } },
    { eErr_GENERIC_MissingPubRequirement,
    { "MissingPubRequirement",
"The publication is missing essential information, such as title or authors." } },

/* SEQ_PKG */

   { eErr_SEQ_PKG_NoCdRegionPtr,
   { "NoCdRegionPtr",
"A protein is found in this entry, but the coding region has not been \
described. Please add a CdRegion feature to the nucleotide Bioseq." } },
   { eErr_SEQ_PKG_NucProtProblem,
   { "NucProtProblem",
"Both DNA and protein sequences were expected, but one of the two seems to be \
missing. Perhaps this is the wrong package to use." } },
   { eErr_SEQ_PKG_SegSetProblem,
   { "SegSetProblem",
"A segmented sequence was expected, but it was not found. Perhaps this is the \
wrong package to use." } },
   { eErr_SEQ_PKG_EmptySet,
   { "EmptySet",
"No Bioseqs were found in this BioseqSet. Is that what was intended?" } },
   { eErr_SEQ_PKG_NucProtNotSegSet,
   { "NucProtNotSegSet",
"A nuc-prot set should not contain any other BioseqSet except segset." } },
   { eErr_SEQ_PKG_SegSetNotParts,
   { "SegSetNotParts",
"A segset should not contain any other BioseqSet except parts." } },
   { eErr_SEQ_PKG_SegSetMixedBioseqs,
   { "SegSetMixedBioseqs",
"A segset should not contain both nucleotide and protein Bioseqs." } },
   { eErr_SEQ_PKG_PartsSetMixedBioseqs,
   { "PartsSetMixedBioseqs",
"A parts set should not contain both nucleotide and protein Bioseqs." } },
   { eErr_SEQ_PKG_PartsSetHasSets,
   { "PartsSetHasSets",
"A parts set should not contain BioseqSets." } },
   { eErr_SEQ_PKG_FeaturePackagingProblem,
   { "FeaturePackagingProblem",
"A feature should be packaged on its bioseq, or on a set containing the Bioseq." } },
   { eErr_SEQ_PKG_GenomicProductPackagingProblem,
   { "GenomicProductPackagingProblem",
"The product of an mRNA feature in a genomic product set should point to a cDNA \
Bioseq packaged in the set, perhaps within a nuc-prot set.  RefSeq records may \
however be referenced remotely." } },
   { eErr_SEQ_PKG_InconsistentMolInfoBiomols,
   { "InconsistentMolInfoBiomols",
"Mol-info.biomol is inconsistent within a segset, parts set, or pop/phy/mut/eco set." } },
   { eErr_SEQ_PKG_ArchaicFeatureLocation,
   { "ArchaicFeatureLocation",
"A feature location should refer to the accession or gi number, not a local or general ID." } },
   { eErr_SEQ_PKG_ArchaicFeatureProduct,
   { "ArchaicFeatureProduct",
"A feature product should refer to the accession or gi number, not a local or general ID." } },
   { eErr_SEQ_PKG_GraphPackagingProblem,
   { "GraphPackagingProblem",
"A graph should be packaged on its bioseq, or on a set containing the Bioseq." } },
   { eErr_SEQ_PKG_InternalGenBankSet,
   { "InternalGenBankSet",
"An outer BioseqSet should not contain an internal BioseqSet of class genbank." } },
   { eErr_SEQ_PKG_ConSetProblem,
   { "ConSetProblem",
"BioseqSet class should not be conset." } },
   { eErr_SEQ_PKG_NoBioseqFound,
   { "NoBioseqFound",
"No Bioseqs were found in the entire record." } },
   { eErr_SEQ_PKG_INSDRefSeqPackaging,
   { "INSDRefSeqPackaging",
"INSD and RefSeq records should not be packaged together." } },
   { eErr_SEQ_PKG_GPSnonGPSPackaging,
   { "GPSnonGPSPackaging",
"Genomic product set records should not be packaged with other set types." } },
   { eErr_SEQ_PKG_RefSeqPopSet,
   { "RefSeqPopSet",
"RefSeq records should not be packaged in a popset." } },
   { eErr_SEQ_PKG_BioseqSetClassNotSet,
   { "BioseqSetClassNotSet",
"The BioseqSet class field is not set." } },
   { eErr_SEQ_PKG_OrphanedProtein,
   { "OrphanedProtein",
"The Bioseq is an INSD or RefSeq protein erroneously not in a nuc-prot set." } },
   { eErr_SEQ_PKG_MissingSetTitle,
   { "MissingSetTitle",
"No title was found on a pop/phy/mut/eco set." } },
   { eErr_SEQ_PKG_NucProtSetHasTitle,
   { "NucProtSetHasTitle",
"A title descriptor was found on a nuc-prot set." } },
   { eErr_SEQ_PKG_ComponentMissingTitle,
   { "ComponentMissingTitle",
"A title descriptor should be present on the components of a pop/phy/mut/eco set." } },
   { eErr_SEQ_PKG_SingleItemSet,
   { "SingleItemSet",
"Only a single Bioseq was found in this BioseqSet. Is that what was intended?" } },
   { eErr_SEQ_PKG_MisplacedMolInfo,
   { "MisplacedMolInfo",
"Mol-info should not be on a pop/phy/mut/eco/wgs/genbank/genprod set." } },
   { eErr_SEQ_PKG_ImproperlyNestedSets,
   { "ImproperlyNestedSets",
"A pop/phy/mut/eco/wgs set has an unexpected internal set other than nuc-prot, seg-set, or parts set." } },
   { eErr_SEQ_PKG_SeqSubmitWithWgsSet,
   { "SeqSubmitWithWgsSet",
"Seq-submit file is a wgs-set instead of a batch submission." } },
   { eErr_SEQ_PKG_InconsistentMoltypeSet,
   { "InconsistentMoltypeSet",
"Molecule types should be consistent within a pop/phy/mut/eco set" } },

/* SEQ_FEAT */

   { eErr_SEQ_FEAT_InvalidForType,
   { "InvalidForType",
"This feature type is illegal on this type of Bioseq." } },
   { eErr_SEQ_FEAT_PartialProblem,
   { "PartialProblem",
"There are several places in an entry where a sequence can be described as \
either partial or complete. In this entry, these settings are inconsistent. \
Make sure that the location and product Seq-locs, the Bioseqs, and the \
SeqFeat partial flag all agree in describing this SeqFeat as partial or \
complete." } },
   { eErr_SEQ_FEAT_InvalidType,
   { "InvalidType",
"A feature with an invalid type has been detected. This is most likely a \
software problem." } },
   { eErr_SEQ_FEAT_Range,
   { "Range",
"The coordinates describing the location of a feature do not fall within the \
sequence itself. A feature location or a product Seq-loc is out of range of \
the Bioseq it points to." } },
   { eErr_SEQ_FEAT_MixedStrand,
   { "MixedStrand",
"Mixed strands (plus and minus) have been found in the same location. While \
this is biologically possible, it is very unusual. Please check that this is \
really what you mean." } },
   { eErr_SEQ_FEAT_AnticodonMixedStrand,
   { "AnticodonMixedStrand",
     "Mixed strands in Anticodon location" } } ,
   { eErr_SEQ_FEAT_GenomeSetMixedStrand,
   { "GenomeSetMixedStrand",
     "Mixed strands in feature location on small genome set - set trans-splicing exception if needed" } } ,
   { eErr_SEQ_FEAT_SeqLocOrder,
   { "SeqLocOrder",
"This location has intervals that are out of order. While whis is biologically \
possible, it is very unusual. Please check that this is really what you mean." } },
   { eErr_SEQ_FEAT_CdTransFail,
   { "CdTransFail",
"A fundamental error occurred in software while attempting to translate this \
coding region. It is either a software problem or sever data corruption." } },
   { eErr_SEQ_FEAT_StartCodon,
   { "StartCodon",
"An illegal start codon was used. Some possible explanations are: (1) the \
wrong genetic code may have been selected; (2) the wrong reading frame may \
be in use; or (3) the coding region may be incomplete at the 5' end, in \
which case a partial location should be indicated." } },
   { eErr_SEQ_FEAT_InternalStop,
   { "InternalStop",
"Internal stop codons are found in the protein sequence. Some possible \
explanations are: (1) the wrong genetic code may have been selected; (2) the \
wrong reading frame may be in use; (3) the coding region may be incomplete \
at the 5' end, in which case a partial location should be indicated; or (4) \
the CdRegion feature location is incorrect." } },
   { eErr_SEQ_FEAT_NoProtein,
   { "NoProtein",
"Normally a protein sequence is supplied. This sequence can then be compared \
with the translation of the coding region. In this entry, no protein Bioseq \
was found, and the comparison could not be made." } },
   { eErr_SEQ_FEAT_MisMatchAA,
   { "MisMatchAA",
"The protein sequence that was supplied is not identical to the translation \
of the coding region. Mismatching amino acids are found between these two \
sequences." } },
   { eErr_SEQ_FEAT_TransLen,
   { "TransLen",
"The protein sequence that was supplied is not the same length as the \
translation of the coding region. Please determine why they are different." } },
   { eErr_SEQ_FEAT_NoStop,
   { "NoStop",
"A coding region that is complete should have a stop codon at the 3'end.  A \
stop codon was not found on this sequence, although one was expected." } },
   { eErr_SEQ_FEAT_TranslExcept,
   { "TranslExcept",
"An unparsed \transl_except qualifier was found. This indicates a parser \
problem." } },
   { eErr_SEQ_FEAT_MissingProteinName,
   { "MissingProteinName",
"The name and description of the protein is missing from this entry. Every \
protein Bioseq must have one full-length Prot-ref feature to provide this \
information." } },
   { eErr_SEQ_FEAT_NotSpliceConsensus,
   { "NotSpliceConsensus",
"Splice junctions typically have GT as the first two bases of the intron \
(splice donor) and AG as the last two bases of the intron (splice acceptor). \
This intron does not conform to that pattern." } },
   { eErr_SEQ_FEAT_OrfCdsHasProduct,
   { "OrfCdsHasProduct",
"A coding region flagged as orf has a protein product.  There should be no \
protein product bioseq on an orf." } },
   { eErr_SEQ_FEAT_GeneRefHasNoData,
   { "GeneRefHasNoData",
"A gene feature exists with no locus name or other fields filled in." } },
   { eErr_SEQ_FEAT_ExceptInconsistent,
   { "ExceptInconsistent",
"A coding region has an exception gbqual but the excpt flag is not set." } },
   { eErr_SEQ_FEAT_ProtRefHasNoData,
   { "ProtRefHasNoData",
"A protein feature exists with no name or other fields filled in." } },
   { eErr_SEQ_FEAT_GenCodeMismatch,
   { "GenCodeMismatch",
"The genetic code stored in the BioSource is different than that for this CDS." } },
   { eErr_SEQ_FEAT_RNAtype0,
   { "RNAtype0",
"RNA type 0 (unknown RNA) should be type 255 (other)." } },
   { eErr_SEQ_FEAT_UnknownImpFeatKey,
   { "UnknownImpFeatKey",
"An import feature has an unrecognized key." } },
   { eErr_SEQ_FEAT_UnknownImpFeatQual,
   { "UnknownImpFeatQual",
"An import feature has an unrecognized qualifier." } },
   { eErr_SEQ_FEAT_WrongQualOnImpFeat,
   { "WrongQualOnImpFeat",
"This qualifier is not legal for this feature." } },
   { eErr_SEQ_FEAT_MissingQualOnImpFeat,
   { "MissingQualOnImpFeat",
"An essential qualifier for this feature is missing." } },
   { eErr_SEQ_FEAT_PseudoCdsHasProduct,
   { "PseudoCdsHasProduct",
"A coding region flagged as pseudo has a protein product.  There should be no \
protein product bioseq on a pseudo CDS." } },
   { eErr_SEQ_FEAT_IllegalDbXref,
   { "IllegalDbXref",
"The database in a cross-reference is not on the list of officially \
recognized database abbreviations." } },
   { eErr_SEQ_FEAT_FarLocation,
   { "FarLocation",
"The location has a reference to a bioseq that is not packaged in this record." } },
   { eErr_SEQ_FEAT_DuplicateFeat,
   { "DuplicateFeat",
"The intervals on this feature are identical to another feature of the same type, \
but the label or comment are different." } },
   { eErr_SEQ_FEAT_UnnecessaryGeneXref,
   { "UnnecessaryGeneXref",
"This feature has a gene xref that is identical to the overlapping gene.  This is \
redundant, and probably should be removed." } },
   { eErr_SEQ_FEAT_TranslExceptPhase,
   { "TranslExceptPhase",
"A \transl_except qualifier was not on a codon boundary." } },
   { eErr_SEQ_FEAT_TrnaCodonWrong,
   { "TrnaCodonWrong",
"The tRNA codon recognized does not code for the indicated amino acid using the \
specified genetic code." } },
   { eErr_SEQ_FEAT_BothStrands,
   { "BothStrands",
"Feature location indicates that it is on both strands. This is not biologically \
possible for this kind of feature. Please indicate the correct strand (plus or \
minus) for this feature." } },
   { eErr_SEQ_FEAT_CDSgeneRange,
   { "CDSgeneRange",
"A CDS is overlapped by a gene feature, but is not completely contained by it. \
This may be an annotation error." } },
   { eErr_SEQ_FEAT_CDSmRNArange,
   { "CDSmRNArange",
"A CDS is overlapped by an mRNA feature, but the mRNA does not cover all \
intervals (i.e., exons) on the CDS. This may be an annotation error." } },
   { eErr_SEQ_FEAT_OverlappingPeptideFeat,
   { "OverlappingPeptideFeat",
"The intervals on this processed protein feature overlap another protein feature. \
This may be caused by errors in originally annotating these features on DNA coordinates, \
where start or stop positions do not occur in between codon boundaries.  These then \
appear as errors when the features are converted to protein coordinates by mapping \
through the CDS." } },
   { eErr_SEQ_FEAT_SerialInComment,
   { "SerialInComment",
"Comments that refer to the conclusions of a specific reference should not be \
cited by a serial number inside brackets (e.g., [3]), but should instead be \
attached as a REMARK on the reference itself." } },
   { eErr_SEQ_FEAT_MultipleCDSproducts,
   { "MultipleCDSproducts",
"More than one CDS feature points to the same protein product.  This can happen with \
viral long terminal repeats (LTRs), but GenBank policy is to have each equivalent \
CDS point to a separately accessioned protein Bioseq." } },
   { eErr_SEQ_FEAT_FocusOnBioSourceFeature,
   { "FocusOnBioSourceFeature",
"The /focus flag is only appropriate on BioSource descriptors, not BioSource features." } },
   { eErr_SEQ_FEAT_PeptideFeatOutOfFrame,
   { "PeptideFeatOutOfFrame",
"The start or stop positions of this processed peptide feature do not occur in between \
codon boundaries.  This may incorrectly overlap other peptides when the features are \
converted to protein coordinates by mapping through the CDS." } },
   { eErr_SEQ_FEAT_InvalidQualifierValue,
   { "InvalidQualifierValue",
"The value of this qualifier is constrained to a particular vocabulary of style.  This \
value does not conform to those constraints.  Please see the feature table documentation \
for more information." } },
   { eErr_SEQ_FEAT_mRNAgeneRange,
   { "mRNAgeneRange",
"An mRNA is overlapped by a gene feature, but is not completely contained by it. \
This may be an annotation error." } },
   { eErr_SEQ_FEAT_TranscriptLen,
   { "TranscriptLen",
"The mRNA sequence that was supplied is not the same length as the \
transcription of the mRNA feature. Please determine why they are different." } },
   { eErr_SEQ_FEAT_TranscriptMismatches,
   { "TranscriptMismatches",
"The mRNA sequence and the transcription of the mRNA feature are different. \
If the number is large, it may indicate incorrect intron/exon boundaries." } },
   { eErr_SEQ_FEAT_CDSproductPackagingProblem,
   { "CDSproductPackagingProblem",
"The nucleotide location and protein product of the CDS are not packaged together \
in the same nuc-prot set.  This may be an error in the software used to create \
the record." } },
   { eErr_SEQ_FEAT_DuplicateExonInterval,
   { "DuplicateExonInterval",
"The location has identical adjacent intervals, e.g., a duplicate exon reference." } },
   { eErr_SEQ_FEAT_DuplicateAnticodonInterval,
   { "DuplicateAnticodonInterval",
"The location has identical adjacent intervals, e.g., a duplicate exon reference." } },
   { eErr_SEQ_FEAT_PolyAsiteNotPoint,
   { "PolyAsiteNotPoint",
"A polyA_site should be at a single nucleotide position." } },
   { eErr_SEQ_FEAT_ImpFeatBadLoc,
   { "ImpFeatBadLoc",
"An import feature loc field does not equal the feature location.  This should be \
corrected, and then the loc field should be cleared." } },
   { eErr_SEQ_FEAT_LocOnSegmentedBioseq,
   { "LocOnSegmentedBioseq",
"Feature locations traditionally go on the individual parts of a segmented bioseq, not \
on the segmented sequence itself.  These features are invisible in asn2ff reports, and \
are now being flagged for correction." } },
   { eErr_SEQ_FEAT_UnnecessaryCitPubEquiv,
   { "UnnecessaryCitPubEquiv",
"A set of citations on a feature should not normally have a nested Pub-equiv construct. \
This may prevent proper matching to the correct publication." } },
   { eErr_SEQ_FEAT_ImpCDShasTranslation,
   { "ImpCDShasTranslation",
"A CDS that has known translation errors cannot have a /translation qualifier." } },
   { eErr_SEQ_FEAT_ImpCDSnotPseudo,
   { "ImpCDSnotPseudo",
"A CDS that has known translation errors must be marked as pseudo to suppress the \
translation." } },
   { eErr_SEQ_FEAT_MissingMRNAproduct,
   { "MissingMRNAproduct",
"The mRNA feature points to a cDNA product that is not packaged in the record. \
This is an error in the genomic product set." } },
   { eErr_SEQ_FEAT_AbuttingIntervals,
   { "AbuttingIntervals",
"The start of one interval is next to the stop of another.  A single interval \
may be desirable in this case." } },
   { eErr_SEQ_FEAT_MultiIntervalGene,
   { "MultiIntervalGene",
"A gene feature on a single Bioseq should have a single interval spanning everything \
considered to be under that gene." } },
   { eErr_SEQ_FEAT_FeatContentDup,
   { "FeatContentDup",
"The intervals on this feature are identical to another feature of the same type, \
and the label and comment are also identical. This is likely to be an error in \
annotating the record.  Note that GenBank format suppresses duplicate features, \
so use of Graphic view is recommended." } },
   { eErr_SEQ_FEAT_BadProductSeqId,
   { "BadProductSeqId",
"The feature product refers to a database ID that has a locus name but no accession. \
This is probably an error in parsing of a submission." } },
   { eErr_SEQ_FEAT_RnaProductMismatch,
   { "RnaProductMismatch",
"The RNA feature product type does not correspond to the RNA feature type.  These \
need to be consistent." } },
   { eErr_SEQ_FEAT_MissingCDSproduct,
   { "MissingCDSproduct",
"The CDS should have a product, but does not.  Pseudo or short CDSs (less than 6 \
amino acids), or those marked with a rearrangement required for product exception, \
are exempt from needing a product." } },
   { eErr_SEQ_FEAT_BadTrnaCodon,
   { "BadTrnaCodon",
"The tRNA codon recognized is an illegal value." } },
   { eErr_SEQ_FEAT_BadTrnaAA,
   { "BadTrnaAA",
"The tRNA encoded amino acid is an illegal value." } },
   { eErr_SEQ_FEAT_OnlyGeneXrefs,
   { "OnlyGeneXrefs",
"There are gene xrefs but no gene features.  Records should normally have single-interval \
gene features covering other biological features.  Gene xrefs are used only to override \
the inheritance by overlap." } },
   { eErr_SEQ_FEAT_UTRdoesNotAbutCDS,
   { "UTRdoesNotAbutCDS",
"The 5'UTR and 3'UTR features should exactly abut the CDS feature." } },
   { eErr_SEQ_FEAT_BadConflictFlag,
   { "BadConflictFlag",
"The coding region conflict flag is set, but the translated product is the \
same as the instantiated product Bioseq." } },
   { eErr_SEQ_FEAT_ConflictFlagSet,
   { "ConflictFlagSet",
"The coding region conflict flag is appropriately set, but this record should \
be brought to the attention of the source database for possible correction." } },
   { eErr_SEQ_FEAT_LocusTagProblem,
   { "LocusTagProblem",
"A gene locus_tag should be a single token, with no spaces." } },
   { eErr_SEQ_FEAT_CollidingLocusTags,
   { "CollidingLocusTags",
"Two gene features should not have the same locus_tag, which is supposed to be \
a unique identifer." } },
   { eErr_SEQ_FEAT_AltStartCodonException,
   { "AltStartCodonException",
"An alternative start codon was used. This is rare, and it is expected that \
confirmatory evidence will be cited." } },
   { eErr_SEQ_FEAT_PartialsInconsistent,
   { "PartialsInconsistent",
"There are several places in an entry where a sequence can be described as \
either partial or complete. In this entry, these settings are inconsistent. \
Make sure that the location and product Seq-locs, the Bioseqs, and the \
SeqFeat partial flag all agree in describing this SeqFeat as partial or \
complete." } },
   { eErr_SEQ_FEAT_GenesInconsistent,
   { "GenesInconsistent",
"The gene on the genomic sequence of a genomic product set should be the \
same as the gene on the cDNA product of the mRNA feature." } },
   { eErr_SEQ_FEAT_DuplicateTranslExcept,
   { "DuplicateTranslExcept",
"There are multiple /transl_except qualifiers at the same location on this \
CDS but with different amino acids indicated." } },
   { eErr_SEQ_FEAT_TranslExceptAndRnaEditing,
   { "TranslExceptAndRnaEditing",
"A CDS has both /exception=RNA editing and /transl_except qualifiers.  RNA \
editing indicates post-transcriptional changes prior to translation.  Use \
/transl_except for individual codon exceptions such as selenocysteine or \
other nonsense suppressors." } },
   { eErr_SEQ_FEAT_NoNameForProtein,
   { "NoNameForProtein",
"A protein feature has a description, but no product name." } },
   { eErr_SEQ_FEAT_TaxonDbxrefOnFeature,
   { "TaxonDbxrefOnFeature",
"A BioSource feature has a taxonID database identifier in the db_xref area \
common to all features. This db_xref should only exist within the separate \
BioSource xref list." } },
   { eErr_SEQ_FEAT_UnindexedFeature,
   { "UnindexedFeature",
"The location of a feature does not allow it to be mapped to a single Bioseq, \
or to the segmented parent if on one or more part Bioseqs. It will not show \
up in flatfile and other formats, and should be corrected or removed." } },
   { eErr_SEQ_FEAT_CDSmRNAmismatch,
   { "CDSmRNAmismatch",
"There should usually be a one-to-one correspondence between mRNA and CDS \
under a given gene." } },
   { eErr_SEQ_FEAT_UnnecessaryException,
   { "UnnecessaryException",
"The feature is marked with an exception qualifier, but the validator does \
not detect an error that needs to be suppressed." } },
   { eErr_SEQ_FEAT_LocusTagProductMismatch,
   { "LocusTagProductMismatch",
"In certain records a policy is that the locus_tag of the gene is expected to \
match the prefix of the general ID of the CDS or mRNA product Bioseq." } },
   { eErr_SEQ_FEAT_MrnaTransFail,
   { "MrnaTransFail",
"A fundamental error occurred in software while attempting to transcribe this \
messenger RNA. It is either a software problem or sever data corruption." } },
   { eErr_SEQ_FEAT_PseudoCdsViaGeneHasProduct,
   { "PseudoCdsViaGeneHasProduct",
"A coding region overlapped by a pseudo gene has a protein product.  There \
should be no protein product bioseq on a pseudo CDS." } },
   { eErr_SEQ_FEAT_MissingGeneXref,
   { "MissingGeneXref",
"This feature has multiple overlapping genes of the same length, but no \
xref to determine which one should be used for the /gene qualifier." } },
   { eErr_SEQ_FEAT_FeatureCitationProblem,
   { "FeatureCitationProblem",
"This feature has a citation to a publication that needs to be repaired." } },
   { eErr_SEQ_FEAT_NestedSeqLocMix,
   { "NestedSeqLocMix",
"A location should not have nested SEQLOC_MIX structures." } },
   { eErr_SEQ_FEAT_WrongQualOnFeature,
   { "WrongQualOnFeature",
"This qualifier is not legal for this feature." } },
   { eErr_SEQ_FEAT_MissingQualOnFeature,
   { "MissingQualOnFeature",
"An essential qualifier for this feature is missing." } },
   { eErr_SEQ_FEAT_CodonQualifierUsed,
   { "CodonQualifierUsed",
"The codon qualifier should be replaced by individual transl_except code breaks, \
after checking to make sure the proper genetic code is being used." } },
   { eErr_SEQ_FEAT_UnknownFeatureQual,
   { "UnknownFeatureQual",
"A feature has an unrecognized qualifier." } },
   { eErr_SEQ_FEAT_BadCharInAuthorName,
   { "BadCharInAuthorName",
"An author name has illegal characters." } },
   { eErr_SEQ_FEAT_PolyATail,
   { "PolyATail",
"The mRNA feature has polyA tail added to make the mRNA sequence." } },
   { eErr_SEQ_FEAT_ProteinNameEndsInBracket,
   { "ProteinNameEndsInBracket",
"The protein name ends with a right square bracket, and may have been \
copied from another GenPept record, where the organism name is \
appended to the definition line and placed inside brackets." } },
   { eErr_SEQ_FEAT_CDSwithMultipleMRNAs,
   { "CDSwithMultipleMRNAs",
"The CDS feature has more than one overlapping mRNA with the proper intervals and \
no other identification assigning it to a different coding region." } },
   { eErr_SEQ_FEAT_MultipleEquivBioSources,
   { "MultipleEquivBioSources",
"Multiple equivalent biosource features exist on the sequence. They should be \
fused into a single feature with multiple intervals." } },
   { eErr_SEQ_FEAT_MultipleEquivPublications,
   { "MultipleEquivPublications",
"Multiple equivalent publication features exist on the sequence. They should be \
fused into a single feature with multiple intervals." } },
   { eErr_SEQ_FEAT_BadFullLengthFeature,
   { "BadFullLengthFeature",
"A publication or biosource feature is on the full length the sequence. It should be \
converted to a publication or biosource descriptor." } },
   { eErr_SEQ_FEAT_RedundantFields,
   { "RedundantFields",
"A comment or other field contains information that is redundant with the primary \
field on a feature." } },
   { eErr_SEQ_FEAT_CDSwithNoMRNAOverlap,
   { "CDSwithNoMRNAOverlap",
"The CDS feature has no overlapping mRNA with the proper intervals." } },
   { eErr_SEQ_FEAT_CDSwithNoMRNA,
   {"CDSwithNoMRNA",
"The CDS feature has no matching mRNA. Matches are identified via xref \
 or overlap." } },
   { eErr_SEQ_FEAT_FeatureProductInconsistency,
   { "FeatureProductInconsistency",
"The CDS feature has more than one overlapping mRNA with the proper intervals and \
no other identification assigning it to a different coding region." } },
   { eErr_SEQ_FEAT_ImproperBondLocation,
   { "ImproperBondLocation",
"Only bond features should have locations of type bond. Most other features should \
use interval or point locations." } },
   { eErr_SEQ_FEAT_GeneXrefWithoutGene,
   { "GeneXrefWithoutGene",
"This feature has a gene xref, but there is no equivalent gene feature anywhere \
on the record." } },
   { eErr_SEQ_FEAT_SeqFeatXrefProblem,
   { "SeqFeatXrefProblem",
"This feature has a seqfeat xref, but it has nothing in the id or data field." } },
   { eErr_SEQ_FEAT_ProductFetchFailure,
   { "ProductFetchFailure",
"Unable to fetch the Bioseq product of this feature.  Remote fetching was requested, \
so this is likely due to a failure in a network sequence retrieval service." } },
   { eErr_SEQ_FEAT_SuspiciousGeneXref,
   { "SuspiciousGeneXref",
"This feature has a gene xref that is not expected for this organism." } },
   { eErr_SEQ_FEAT_MissingTrnaAA,
   { "MissingTrnaAA",
"The tRNA encoded amino acid is not set." } },
   { eErr_SEQ_FEAT_CollidingFeatureIDs,
   { "CollidingFeatureIDs",
"Multiple features have the same featureID.  Feature ID must be unique within \
a record." } },
   { eErr_SEQ_FEAT_ExceptionProblem,
   { "ExceptionProblem",
"There is a problem with /exception text." } },
   { eErr_SEQ_FEAT_PolyAsignalNotRange,
   { "PolyAsignalNotRange",
"A polyA_signal should be at nucleotide range position, not a single point." } },
   { eErr_SEQ_FEAT_OldLocusTagMismtach,
   { "OldLocusTagMismtach",
"The old_locus_tag qualifier on a feature does not match that on the overlapping gene." } },
   { eErr_SEQ_FEAT_DuplicateGeneOntologyTerm,
   { "DuplicateGeneOntologyTerm",
"A feature has multiple identical Gene Ontology (GO) term specifications." } },
   { eErr_SEQ_FEAT_InvalidInferenceValue,
   { "InvalidInferenceValue",
"The value of the inference qualifier is constrained by agreement of the international \
nucleotide sequence database collaboration.  This value does not conform to those \
constraints.  Please see the feature table documentation for more information." } },
   { eErr_SEQ_FEAT_HypotheticalProteinMismatch,
   { "HypotheticalProteinMismatch",
"There is a mismatch between the accession cited by the hypothetical protein claim \
and the actual accession of the record." } },
   { eErr_SEQ_FEAT_FeatureRefersToAccession,
   { "FeatureRefersToAccession",
"There is a mixture of features referring to sequence by gi numbers and by accession. \
This inconsistency is likely due to incomplete processing by software." } },
   { eErr_SEQ_FEAT_SelfReferentialProduct,
   { "SelfReferentialProduct",
"A feature product points to the same sequence that the feature location does. \
The product must point to a different sequence that is the biological product \
of the first, due to transcription, translation, or peptide processing." } },
   { eErr_SEQ_FEAT_ITSdoesNotAbutRRNA,
   { "ITSdoesNotAbutRRNA",
"The internal transcribed spacer misc_RNA features should exactly abut the flanking rRNA features." } },
   { eErr_SEQ_FEAT_FeatureSeqIDCaseDifference,
   { "FeatureSeqIDCaseDifference",
"Feature location and referenced Bioseq have the same Seq-id except for capitalization. \
Sequence identifiers must be unique in a case-insensitive manner within a record." } },
   { eErr_SEQ_FEAT_FeatureLocationIsGi0,
   { "FeatureLocationIsGi0",
"Feature location refers to gi 0. This indicates an error in database processing of this record." } },
   { eErr_SEQ_FEAT_GapFeatureProblem,
   { "GapFeatureProblem",
"Gap features must only cover gaps in the sequence, not actual bases." } },
   { eErr_SEQ_FEAT_PseudoCdsHasProtXref,
   { "PseudoCdsHasProtXref",
"A coding region flagged as pseudo has a protein cross reference.  There should be no \
protein product bioseq or protein cross reference on a pseudo CDS." } },
   { eErr_SEQ_FEAT_ErroneousException,
   { "ErroneousException",
"The feature is marked with a specific exception qualifier, but validation indicates \
that a different exception should be used." } },
   { eErr_SEQ_FEAT_SegmentedGeneProblem,
   { "SegmentedGeneProblem",
"A gene feature on the parts of a segmented Bioseq should map to a single interval on the \
segmented Bioseq's coordinate system." } },
   { eErr_SEQ_FEAT_WholeLocation,
   { "WholeLocation",
"Feature location is set to whole, the entirety of the parent sequence.  Please specify \
exact intervals for this feature location." } },
   { eErr_SEQ_FEAT_BadEcNumberFormat,
   { "BadEcNumberFormat",
"There is a problem with the format of the EC_number qualifier." } },
   { eErr_SEQ_FEAT_BadEcNumberValue,
   { "BadEcNumberValue",
"There is a problem with the value of the EC_number qualifier." } },
   { eErr_SEQ_FEAT_EcNumberProblem,
   { "EcNumberProblem",
"There is a problem with the format of the EC_number qualifier." } },
   { eErr_SEQ_FEAT_VectorContamination,
   { "VectorContamination",
"Contamination by cloning vector is annotated on this sequence. The underlying region \
should be removed from the sequence." } },
   { eErr_SEQ_FEAT_MinusStrandProtein,
   { "MinusStrandProtein",
"A feature on a protein indicates the minus strand, which does not exist." } },
   { eErr_SEQ_FEAT_BadProteinName,
   { "BadProteinName",
"A protein feature has a name that conflicts with other information on the feature." } },
   { eErr_SEQ_FEAT_GeneXrefWithoutLocus,
   { "GeneXrefWithoutLocus",
"A feature has a gene xref with a locus_tag and no locus, but the gene with that locus_tag has a locus." } },
   { eErr_SEQ_FEAT_UTRdoesNotExtendToEnd,
   { "UTRdoesNotExtendToEnd",
"The UTR does not have the expected range." } },
   { eErr_SEQ_FEAT_CDShasTooManyXs,
   { "CDShasTooManyXs",
"The CDS translation has greater than 50 percent ambiguous X residues." } },
   { eErr_SEQ_FEAT_SuspiciousFrame,
   { "SuspiciousFrame",
"The CDS has a frame greater than 1 that is not expected in this context." } },
   { eErr_SEQ_FEAT_TerminalXDiscrepancy,
   { "TerminalXDiscrepancy",
"The CDS translation and protein product sequence have a different number of terminal Xs." } },
   { eErr_SEQ_FEAT_UnnecessaryTranslExcept,
   { "UnnecessaryTranslExcept",
"The CDS translates to the same amino acid as indicated by the transl_except code break." } },
   { eErr_SEQ_FEAT_SuspiciousQualifierValue,
   { "SuspiciousQualifierValue",
"The value of this qualifier is constrained to a particular vocabulary of style.  This \
value appears not to conform to those constraints.  Please see the feature table documentation \
for more information." } },
   { eErr_SEQ_FEAT_NotSpliceConsensusDonor,
   { "NotSpliceConsensusDonor",
"Splice junctions typically have GT as the first two bases of the intron \
(splice donor) and AG as the last two bases of the intron (splice acceptor). \
This intron does not conform to that pattern." } },
   { eErr_SEQ_FEAT_NotSpliceConsensusAcceptor,
   { "NotSpliceConsensusAcceptor",
"Splice junctions typically have GT as the first two bases of the intron \
(splice donor) and AG as the last two bases of the intron (splice acceptor). \
This intron does not conform to that pattern." } },
   { eErr_SEQ_FEAT_RareSpliceConsensusDonor,
   { "RareSpliceConsensusDonor",
"Splice junctions typically have GT as the first two bases of the intron \
(splice donor) and AG as the last two bases of the intron (splice acceptor). \
This intron does not conform to that pattern." } },
   { eErr_SEQ_FEAT_SeqFeatXrefNotReciprocal,
   { "SeqFeatXrefNotReciprocal",
"Feature xrefs between CDS and mRNA are not reciprocal." } },
   { eErr_SEQ_FEAT_SeqFeatXrefFeatureMissing,
   { "SeqFeatXrefFeatureMissing",
"The feature referenced by a seqfeat xref cannot be found." } },
   { eErr_SEQ_FEAT_FeatureInsideGap,
   { "FeatureInsideGap",
"The feature is completely contained inside a sequence gap." } },
   { eErr_SEQ_FEAT_FeatureCrossesGap,
   { "FeatureCrossesGap",
"The feature extends from actual sequence into a sequence gap." } },
   { eErr_SEQ_FEAT_BadAuthorSuffix,
   { "BadAuthorSuffix",
"An author name has an unexpected suffix." } },
   { eErr_SEQ_FEAT_BadAnticodonAA,
   { "BadAnticodonAA",
"The tRNA encoded amino acid cannot be produced by any likely reverse complement \
and wobble expansion of the anticodon sequence." } },
   { eErr_SEQ_FEAT_BadAnticodonCodon,
   { "BadAnticodonCodon",
"The tRNA indicated codon recognized cannot be produced by any likely reverse complement \
and wobble expansion of the anticodon sequence." } },
   { eErr_SEQ_FEAT_AnticodonStrandConflict,
   { "AnticodonStrandConflict",
"The tRNA feature location and anticodon location are not on the same strand." } },
   { eErr_SEQ_FEAT_UndesiredGeneSynonym,
   { "UndesiredGeneSynonym",
"The gene synonym is uninformative." } },
   { eErr_SEQ_FEAT_UndesiredProteinName,
   { "UndesiredProteinName",
"The protein name is uninformative." } },
   { eErr_SEQ_FEAT_FeatureBeginsOrEndsInGap,
   { "FeatureBeginsOrEndsInGap",
"The feature starts or stops within a sequence gap." } },
   { eErr_SEQ_FEAT_GeneOntologyTermMissingGOID,
   { "GeneOntologyTermMissingGOID",
"A Gene Ontology (GO) term is missing the GO Identifier." } },
   { eErr_SEQ_FEAT_PseudoRnaHasProduct,
   { "PseudoRnaHasProduct",
"An RNA flagged as pseudo has a transcribed product.  There should be no \
transcribed product bioseq on a pseudo RNA." } },
   { eErr_SEQ_FEAT_PseudoRnaViaGeneHasProduct,
   { "PseudoRnaViaGeneHasProduct",
"An RNA overlapped by a pseudo gene has a transcribed product.  There \
should be no transcribed product bioseq on a pseudo RNA." } },
   { eErr_SEQ_FEAT_BadRRNAcomponentOrder,
   { "BadRRNAcomponentOrder",
"rRNA and ITS features are not in the expected order." } },
   { eErr_SEQ_FEAT_BadRRNAcomponentOverlap,
   { "BadRRNAcomponentOverlap",
"rRNA and ITS or tRNA elements should not overlap." } },
   { eErr_SEQ_FEAT_MissingGeneLocusTag,
   { "MissingGeneLocusTag",
"If one gene in a record has a locus-tag value, all genes in the record \
should have a locus-tag value." } },
   { eErr_SEQ_FEAT_MultipleProtRefs,
   { "MultipleProtRefs",
"The name and description of the protein is missing from this entry. Every \
protein Bioseq must have one full-length Prot-ref feature to provide this \
information." } },
   { eErr_SEQ_FEAT_BadInternalCharacter,
   { "BadInternalCharacter",
"Biological names or labels should not end with question mark, \
exclamation point, or tilde." } },
   { eErr_SEQ_FEAT_BadTrailingCharacter,
   { "BadTrailingCharacter",
"Biological names or labels should not contain underscore, period, \
comma, colon, or semicolon," } },
   { eErr_SEQ_FEAT_BadTrailingHyphen,
   { "BadTrailingHyphen",
"Biological names or labels should not end with a hyphen." } },
   { eErr_SEQ_FEAT_MultipleGeneOverlap,
   { "MultipleGeneOverlap",
"This genes completely contains two or more other genes." } },
   { eErr_SEQ_FEAT_BadCharInAuthorLastName,
   { "BadCharInAuthorLastName",
"An author name has illegal characters." } },
   { eErr_SEQ_FEAT_PseudoCDSmRNArange,
   { "PseudoCDSmRNArange",
"A pseudo CDS is overlapped by an mRNA feature, but the mRNA does not cover all \
intervals (i.e., exons) on the CDS. This may be an annotation error." } },
   { eErr_SEQ_FEAT_ExtendablePartialProblem,
   { "ExtendablePartialProblem",
"A partial end of this feature does not abut a gap and does not include the first \
or last nucleotide in the sequence, but it could be extended by one or two \
nucleotides to do so." } },
   { eErr_SEQ_FEAT_GeneXrefNeeded,
   { "GeneXrefNeeded",
"This feature has multiple overlapping genes of the same length and same name, \
but no xref to determine which one should be used for the /gene qualifier." } },
   { eErr_SEQ_FEAT_RubiscoProblem,
   { "RubiscoProblem",
"A protein name contains ribulose and bisphosphate but does not use \
the prefered formal naming convention." } },
   { eErr_SEQ_FEAT_ProteinNameHasPMID,
   { "ProteinNameHasPMID",
"The protein name has (PMID #####) embedded in it." } },
   { eErr_SEQ_FEAT_BadGeneOntologyFormat,
   { "BadGeneOntologyFormat",
"A feature has incorrectly labeled fields in a Gene Ontology (GO) term specification." } },
   { eErr_SEQ_FEAT_InconsistentGeneOntologyTermAndId,
   { "InconsistentGeneOntologyTermAndId",
"The same GO term should apply to Gene Ontology (GO) term specifications with the same GO ID." } },
   { eErr_SEQ_FEAT_DuplicateGeneConflictingLocusTag,
   { "DuplicateGeneConflictingLocusTag",
"Two gene features with the same name are annotated at the same location." } },
   { eErr_SEQ_FEAT_ShortIntron,
   { "ShortIntron",
"Introns should be longer than 10 nt." } },
   { eErr_SEQ_FEAT_GeneXrefStrandProblem,
   { "GeneXrefStrandProblem",
"This feature has a gene xref that points to a gene on the wrong strand." } },
   { eErr_SEQ_FEAT_CDSmRNAXrefLocationProblem,
   { "CDSmRNAXrefLocationProblem",
"The CDS is not contained within the cross-referenced mRNA" } },
   { eErr_SEQ_FEAT_LocusCollidesWithLocusTag,
   { "LocusCollidesWithLocusTag",
"A gene locus is identical with a gene locus_tag." } },
   { eErr_SEQ_FEAT_IdenticalGeneSymbolAndSynonym,
   { "IdenticalGeneSymbolAndSynonym",
"The gene synonym is the same as the locus of a different gene." } },
   { eErr_SEQ_FEAT_RptUnitRangeProblem,
   { "RptUnitRangeProblem",
"The value of the rpt_unit_range qualifier is not inside the parent feature location." } },
   { eErr_SEQ_FEAT_TooManyInferenceAccessions,
   { "TooManyInferenceAccessions",
"There are too many inference qualifier accessions to have their versions verified by network access." } },
   { eErr_SEQ_FEAT_SgmlPresentInText,
   { "SgmlPresentInText",
"SGML markup is embedded in text." } },
    { eErr_SEQ_FEAT_MissingLocation,
    { "MissingLocation",
"A feature must specify its location." } },
    { eErr_SEQ_FEAT_MultipleBioseqs,
    { "MultipleBioseqs",
"Feature location refers to multiple near non-part bioseqs." } },
    { eErr_SEQ_FEAT_DifferntIdTypesInSeqLoc,
    { "DifferntIdTypesInSeqLoc",
"All ids in a single seq-loc which refer to the same bioseq should be of the \
same id type" } },
   { eErr_SEQ_FEAT_IntervalBeginsOrEndsInGap,
   { "IntervalBeginsOrEndsInGap",
"An internal interval of the feature starts or stops within a sequence gap." } },
   { eErr_SEQ_FEAT_InconsistentRRNAstrands,
   { "InconsistentRRNAstrands",
"rRNA and ITS features are not on the same strand." } },
   { eErr_SEQ_FEAT_CDSonMinusStrandMRNA,
   { "CDSonMinusStrandMRNA",
"Coding regions should be on the plus strand of mRNA molecules." } },
   { eErr_SEQ_FEAT_tRNAmRNAmixup,
   { "tRNAmRNAmixup",
"An mRNA feature has annotation indicating that it is really a tRNA." } },
   { eErr_SEQ_FEAT_ProductLength,
   { "ProductLength",
"The protein sequence that was supplied is not the same length as the translation of the coding region." } },
   { eErr_SEQ_FEAT_InconsistentPseudogeneCounts,
   { "InconsistentPseudogeneCounts",
"There are pseudo features with and without pseudogene qualifiers." } },
   { eErr_SEQ_FEAT_DeletedEcNumber,
   { "DeletedEcNumber",
"The EC_number has been deleted." } },
   { eErr_SEQ_FEAT_ReplacedEcNumber,
   { "ReplacedEcNumber",
"The EC_number has been replaced." } },
   { eErr_SEQ_FEAT_SplitEcNumber,
   { "SplitEcNumber",
"The EC_number has been split." } },
   { eErr_SEQ_FEAT_PeptideFeatureLacksCDS,
   { "PeptideFeatureLacksCDS",
"The peptide feature cannot be assigned to a CDS parent, and thus cannot be mapped to the protein product." } },
   { eErr_SEQ_FEAT_EcNumberDataMissing,
   { "EcNumberDataMissing",
"An EC_number qualifier data file is missing or unreadable." } },
   { eErr_SEQ_FEAT_ShortExon,
   { "ShortExon",
 "Internal exon is too short." } } ,
   { eErr_SEQ_FEAT_ExtraProteinFeature,
   { "ExtraProteinFeature",
"Protein sequence has multiple protein features that are not signal peptides, mature peptides, transit peptides, or preproteins." } } ,
   { eErr_SEQ_FEAT_AssemblyGapAdjacentToNs,
   { "AssemblyGapAdjacentToNs",
"Assembly_gap features must cover the entire contiguous sequence gaps." } },
   { eErr_SEQ_FEAT_AssemblyGapCoversSequence,
   { "AssemblyGapCoversSequence",
"Assembly_gap features must not cover actual bases in the sequence." } },
   { eErr_SEQ_FEAT_FeatureBeginsOrEndsWithN,
   { "FeatureBeginsOrEndsWithN",
"The feature starts or stops with an N." } },
   { eErr_SEQ_FEAT_FeatureIsMostlyNs,
   { "FeatureIsMostlyNs",
"The feature contains more than 50% of Ns." } },
   { eErr_SEQ_FEAT_CDSonMinusStrandTranscribedRNA,
   { "CDSonMinusStrandTranscribedRNA",
"Coding regions should be on the plus strand of transcribed RNA molecules." } },
   { eErr_SEQ_FEAT_MultipleGenCodes,
   { "MultipleGenCodes",
"The genetic codes are the same for all CDS features on one Bioseq." } },
   { eErr_SEQ_FEAT_InvalidFuzz,
   { "InvalidFuzz",
"Incorrect use of Int-fuzz.lim" } },
   { eErr_SEQ_FEAT_BadCDScomment,
   { "BadCDScomment",
"Comment is inconsistent with content of feature." } },
   { eErr_SEQ_FEAT_IntronIsStopCodon,
   { "IntronIsStopCodon",
"3 base intron actually contains a stop codon." } },
   { eErr_SEQ_FEAT_InconsistentPseudogeneValue,
   { "InconsistentPseudogeneValue",
"Pseudogene qualifiers do not match between a CDS or mRNA and the parent gene." } },
   { eErr_SEQ_FEAT_MultiIntervalIntron,
   { "MultiIntervalIntron",
"Introns should only have a single interval." } },
   { eErr_SEQ_FEAT_SeqLocTypeProblem,
   { "SeqLocTypeProblem",
"A sequence location component is not the expected type." } },
   { eErr_SEQ_FEAT_RefSeqInText,
   { "RefSeqInText",
"The term RefSeq should not appear in a product name or a definition line." } },
   { eErr_SEQ_FEAT_ColdShockProteinProblem,
   { "ColdShockProteinProblem",
"A misc_feature containing cspA should not overlap a cold-shock protein CDS." } },
   { eErr_SEQ_FEAT_BadLocation,
   { "BadLocation",
"There is a problem with this feature location." } },
   { eErr_SEQ_FEAT_GenCodeInvalid,
   { "GenCodeInvalid",
"A coding region contains invalid genetic code." } },
   { eErr_SEQ_FEAT_TranslExceptIsPartial,
   { "TranslExceptIsPartial",
"A translation exception location should not be partial." } },
   { eErr_SEQ_FEAT_GeneIdMismatch,
   { "GeneIdMismatch",
"GeneID for parent and child features should match." } },
   { eErr_SEQ_FEAT_ProductShouldBeWhole,
   { "ProductShouldBeWhole",
     "Feature products should be entire sequences." } },
   { eErr_SEQ_FEAT_CDSmRNAMismatchProteinIDs,
   { "CDSmRNAMismatchProteinIDs",
    "A CDS-mRNA pair should hav matching protein_ids" } },
   { eErr_SEQ_FEAT_CDSmRNAMissingProteinIDs,
   { "CDSmRNAMissingProteinIDs",
    "A CDS-mRNA pair should have matching protein_ids" } },
   { eErr_SEQ_FEAT_CDSmRNAMismatchTranscriptIDs,
   { "CDSmRNAMismatchTranscriptIDs",
    "A CDS-mRNA pair should hav matching transcript_ids" } },
   { eErr_SEQ_FEAT_CDSmRNAmismatchCount,
   { "CDSmRNAmismatchCount",
    "A gene should contain the same number of mRNA features as coding region features" } },
   { eErr_SEQ_FEAT_CDSmRNAMismatchLocation,
   { "CDSmRNAMismatchLocation",
    "The coding region location should match the mRNA location" } },
   {  eErr_SEQ_FEAT_CDSmRNANotMatched,
   { "CDSmRNANotMatched",
    "Each mRNA feature should have a corresponding coding region feature" } },
   { eErr_SEQ_FEAT_PartialProblemHasStop,
   { "PartialProblemHasStop",
    "Feature has stop codon, but 3'end is labeled partial" } },
   { eErr_SEQ_FEAT_PartialProblemMismatch3Prime,
   { "PartialProblemMismatch3Prime",
    "Coding region should not be 3' partial if parent is 3' complete" } },
   { eErr_SEQ_FEAT_PartialProblemMismatch5Prime,
   { "PartialProblemMismatch5Prime",
    "Coding region should not be 5' partial if parent is 5' complete" } },
   { eErr_SEQ_FEAT_PartialProblemNotSpliceConsensus3Prime,
   { "PartialProblemNotSpliceConsensus3Prime",
    "3' partial is not at end of sequence, gap, or consensus splice site" } },
   { eErr_SEQ_FEAT_PartialProblemNotSpliceConsensus5Prime,
   { "PartialProblemNotSpliceConsensus5Prime",
    "5' partial is not at beginning of sequence, gap, or consensus splice site" } },
   { eErr_SEQ_FEAT_PartialProblemmRNASequence5Prime,
   { "PartialProblemmRNASequence5Prime",
    "Start does not include first/last residue of mRNA sequence" } },
   { eErr_SEQ_FEAT_PartialProblemmRNASequence3Prime,
   { "PartialProblemmRNASequence3Prime",
    "Stop does not include first/last residue of mRNA sequence" } },
   { eErr_SEQ_FEAT_PartialProblemOrganelle5Prime,
   { "PartialProblemOrganelle5Prime",
    "Start does not include first/last residue of organelle sequence (organelle does not use standard splice site convention)" } },
   { eErr_SEQ_FEAT_PartialProblemOrganelle3Prime,
   { "PartialProblemOrganelle3Prime",
    "Stop does not include first/last residue of organelle sequence (organelle does not use standard splice site convention)" } },
   { eErr_SEQ_FEAT_PartialProblem5Prime,
   { "PartialProblem5Prime",
    "Start does not include first/last residue of sequence" } },
   { eErr_SEQ_FEAT_PartialProblem3Prime,
   { "PartialProblem3Prime",
    "Stop does not include first/last residue of sequence" } },
   { eErr_SEQ_FEAT_PartialsInconsistentCDSProtein,
   { "PartialsInconsistentCDSProtein",
    "Coding region and protein feature partials conflict" } },
   { eErr_SEQ_FEAT_InvalidPseudoQualifier,
   { "InvalidPseudoQualifier",
     "Pseudogene qualifier has a controlled vocabulary" } },
   { eErr_SEQ_FEAT_InvalidRptUnitRange,
   { "InvalidRptUnitRange",
    "/rpt_unit_range should be a base range" } },
   { eErr_SEQ_FEAT_InvalidRptUnitSeqCharacters,
   { "InvalidRptUnitSeqCharacters",
    "/rpt_unit_seq has illegal characters" } },
   { eErr_SEQ_FEAT_InvalidRepeatUnitLength,
   { "InvalidRepeatUnitLength",
    "Length of rpt_unit_seq should be equal to or shorter than feature length" } },
   { eErr_SEQ_FEAT_MismatchedAllele,
   { "MismatchedAllele",
    "allele qualifiers on features and genes should match" } },
   { eErr_SEQ_FEAT_InvalidOperonMatchesGene,
   { "InvalidOperonMatchesGene",
    "Operon name should not match gene name" } },
   { eErr_SEQ_FEAT_InvalidPunctuation,
   { "InvalidPunctuation",
    "Other than /replace, a qualifier should contain more than just quotation marks" } },
   { eErr_SEQ_FEAT_InvalidAlleleDuplicates,
   { "InvalidAlleleDuplicates",
    "Do not add redundant allele qualifiers to features for which the gene has an allele" } },
   { eErr_SEQ_FEAT_InvalidCompareRefSeqAccession,
   { "InvalidCompareRefSeqAccession",
    "Do not use RefSeq accessions for qualifier compare" } },
   { eErr_SEQ_FEAT_RepeatSeqDoNotMatch,
   { "RepeatSeqDoNotMatch",
    "repeat_region /rpt_unit and underlying sequence should match" } },
   { eErr_SEQ_FEAT_RecombinationClassOtherNeedsNote,
   { "RecombinationClassOtherNeedsNote",
    "If recombination_class is 'other' a note should be present" } },
   { eErr_SEQ_FEAT_RegulatoryClassOtherNeedsNote,
   { "RegulatoryClassOtherNeedsNote",
    "If regulatory_class is 'other' a note should be present" } },
   { eErr_SEQ_FEAT_UnparsedtRNAAnticodon,
   { "UnparsedtRNAAnticodon",
    "Unparsed anticodon qualifier in tRNA" } },
   { eErr_SEQ_FEAT_UnparsedtRNAProduct,
   { "UnparsedtRNAProduct",
    "Unparsed product qualifier in tRNA" } },
   { eErr_SEQ_FEAT_rRNADoesNotHaveProduct,
   { "rRNADoesNotHaveProduct",
    "An rRNA feature should have a product name" } },
   { eErr_SEQ_FEAT_InvalidCompareMissingVersion,
   { "InvalidCompareMissingVersion",
    "/compare should have both an accession and a version" } },
   { eErr_SEQ_FEAT_InvalidCompareBadAccession,
   { "InvalidCompareBadAccession",
    "/compare should include a valid accession" } },
   { eErr_SEQ_FEAT_MobileElementInvalidQualifier,
   { "MobileElementInvalidQualifier",
    "/mobile_element has a controlled vocabulary" } },
   { eErr_SEQ_FEAT_InvalidReplace,
   { "InvalidReplace",
    "A /replace qualifier should only be composed of nucleotide or amino acid characters" } },
   { eErr_SEQ_FEAT_InvalidVariationReplace,
   { "InvalidVariationReplace",
    "A variation qualifier should should only be composed of acgt unambiguous nucleotide bases" } },
   { eErr_SEQ_FEAT_InvalidNumberQualifier,
   { "InvalidNumberQualifier",
    "Number qualifiers should not contain spaces" } },
   { eErr_SEQ_FEAT_InvalidProductOnGene,
   { "InvalidProductOnGene",
    "A product qualifier is not used on a gene feature" } },
   { eErr_SEQ_FEAT_InvalidMatchingReplace,
   { "InvalidMatchingReplace",
    "The value of a /replace qualifier should be different from the underlying sequence" } },
   { eErr_SEQ_FEAT_InvalidCodonStart,
   { "InvalidCodonStart",
    "A codon_start value should be 1, 2, or 3" } },
   { eErr_SEQ_FEAT_WrongQualOnCDS,
   { "WrongQualOnCDS",
    "A gene_synonym value should go on a gene, rather than a coding region feature" } },
   { eErr_SEQ_FEAT_EcNumberInCDSComment,
   { "EcNumberInCDSComment",
     "Enzyme Commission Numbers should not be placed in coding region comments; they should be placed in the protein feature EC field" } },
   { eErr_SEQ_FEAT_EcNumberInProteinName,
   { "EcNumberInProteinName",
     "Enzyme Commission Numbers should not be placed in protein names; they should be placed in the protein feature EC field" } },
   { eErr_SEQ_FEAT_EcNumberInProteinComment,
   { "EcNumberInProteinComment",
     "Enzyme Commission Numbers should not be placed in protein comments; they should be placed in the protein feature EC field" } },
   { eErr_SEQ_FEAT_EcNumberEmpty,
   { "EcNumberEmpty",
     "EC number field should not be blank" } },
   { eErr_SEQ_FEAT_GeneLocusCollidesWithLocusTag,
   { "GeneLocusCollidesWithLocusTag",
     "A locus value for one gene should not be reused for a locus-tag on another gene" } },
   { eErr_SEQ_FEAT_LocusTagGeneLocusMatch,
   { "LocusTagGeneLocusMatch",
     "A gene locus and a gene locus-tag should be different values" } },
   { eErr_SEQ_FEAT_LocusTagHasSpace,
   { "LocusTagHasSpace",
     "Gene locus tags should not have spaces" } },
   { eErr_SEQ_FEAT_OldLocusTagBadFormat,
   { "OldLocusTagBadFormat",
     "old-locus-tag values should not contain commas. Multiple old_locus_tags should be split into separate qualifiers." } },
   { eErr_SEQ_FEAT_OldLocusTagWithoutLocusTag,
   { "OldLocusTagWithoutLocusTag",
     "A feature should not have an old-locus-tag value if it does not have a locus-tag value" } },
   { eErr_SEQ_FEAT_BadRRNAcomponentOverlapRRNA,
   { "BadRRNAcomponentOverlapRRNA",
     "Internal transcribed spacers should not overlap adjacent rRNA components" } },
   { eErr_SEQ_FEAT_BadRRNAcomponentOverlapAndOrder,
   { "BadRRNAcomponentOverlapAndOrder",
     "rRNA components should appear in the correct order and not overlap" } },
   { eErr_SEQ_FEAT_BadRRNAcomponentOverlapTRNA,
   { "BadRRNAcomponentOverlapTRNA",
     "rRNA features should not overlap tRNA features" } },
   { eErr_SEQ_FEAT_NotSpliceConsensusAcceptorTerminalIntron,
   { "NotSpliceConsensusAcceptorTerminalIntron",
     "Introns should end with a splice consensus acceptor" } },
   { eErr_SEQ_FEAT_NotSpliceConsensusDonorTerminalIntron,
   { "NotSpliceConsensusDonorTerminalIntron",
     "Introns should begin with a splice consensus donor" } },
   { eErr_SEQ_FEAT_IdenticalMRNAtranscriptIDs,
   { "IdenticalMRNAtranscriptIDs" ,
     "Identical transcript IDs should not appear on multiple mRNAs" } },
   { eErr_SEQ_FEAT_InvalidFeatureForMRNA,
   { "InvalidFeatureForMRNA" ,
     "mRNA feature should not appear on an mRNA (cDNA) Bioseq." } },
   { eErr_SEQ_FEAT_InvalidFeatureForNucleotide,
   { "InvalidFeatureForNucleotide" ,
     "Invalid feature for a nucleotide Bioseq." } },
   { eErr_SEQ_FEAT_InvalidFeatureForProtein,
   { "InvalidFeatureForProtein" ,
     "Invalid feature for a protein Bioseq." } },
   { eErr_SEQ_FEAT_InvalidRNAFeature,
   { "InvalidRNAFeature" ,
     "RNA feature should be converted to the appropriate RNA feature subtype" } },
   { eErr_SEQ_FEAT_InvalidTRNAdata,
   { "InvalidTRNAdata" ,
     "tRNA data structure should not appear on a non-tRNA feature" } },
   { eErr_SEQ_FEAT_mRNAUnnecessaryException,
   { "mRNAUnnecessaryException" ,
     "mRNA should not have unqualified transcribed product replaced exception" } },
   { eErr_SEQ_FEAT_AssemblyGapFeatureProblem,
   { "AssemblyGapFeatureProblem",
     "An assembly_gap feature should only be on a contig record" } },
   { eErr_SEQ_FEAT_ExceptionMissingText,
   { "ExceptionMissingText",
     "Exception flag is set, but exception text is empty" } },
   { eErr_SEQ_FEAT_MiscFeatureNeedsNote,
   { "MiscFeatureNeedsNote",
     "A note or other qualifier is required for a misc_feature" } },
   { eErr_SEQ_FEAT_MissingExceptionFlag,
   { "MissingExceptionFlag",
     "Exception text is present, but exception flag is not set" } },
   { eErr_SEQ_FEAT_NoCDSbetweenUTRs,
   { "NoCDSbetweenUTRs",
     "Gene has both 5'UTR and 3'UTR but does not have a coding region" } },
   { eErr_SEQ_FEAT_RepeatRegionNeedsNote,
   { "RepeatRegionNeedsNote",
     "A repeat_region feature should have qualifiers or a note" } },
   { eErr_SEQ_FEAT_CDSrange,
   { "CDSrange",
     "A code-break location should fall inside the coding region feature location" } } ,
   { eErr_SEQ_FEAT_tRNArange,
   { "tRNArange",
     "An anticodon location should fall inside the tRNA feature location" } } ,
   { eErr_SEQ_FEAT_ExceptionRequiresLocusTag,
   { "ExceptionRequiresLocusTag",
     "Genes with an exception indicating that the gene was split must have a locus-tag value" } },
   { eErr_SEQ_FEAT_BadTranssplicedInterval,
   { "BadTranssplicedInterval",
     "a trans-spliced feature should have multiple intervals" } },
   { eErr_SEQ_FEAT_TRNAinsideTMRNA,
   { "TRNAinsideTMRNA",
     "tRNA should not be contained within tmRNA" } },
   { eErr_SEQ_FEAT_IncorrectQualifierCapitalization,
   { "IncorrectQualifierCapitalization",
     "The qualifier name is incorrectly capitalized" } },
   { eErr_SEQ_FEAT_CDSdoesNotMatchVDJC,
   { "CDSdoesNotMatchVDJC",
     "The CDS does not have a parent VDJ or C segment" } },
   { eErr_SEQ_FEAT_GeneOnNucPositionOfPeptide,
   { "GeneOnNucPositionOfPeptide",
     "Peptide under CDS matches small Gene" } },
   { eErr_SEQ_FEAT_ShortTRNAIntron,
   { "ShortTRNAIntron",
     "Bacterial tRNA intron less than 100 bp" } },

/* SEQ_ALIGN */

   { eErr_SEQ_ALIGN_SeqIdProblem,
   { "SeqIdProblem",
"The seqence referenced by an alignment SeqID is not packaged in the record." } },
   { eErr_SEQ_ALIGN_StrandRev,
   { "StrandRev",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_DensegLenStart,
   { "DensegLenStart",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_StartLessthanZero,
   { "StartLessthanZero",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_StartMorethanBiolen,
   { "StartMorethanBiolen",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_EndLessthanZero,
   { "EndLessthanZero",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_EndMorethanBiolen,
   { "EndMorethanBiolen",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_LenLessthanZero,
   { "LenLessthanZero",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_LenMorethanBiolen,
   { "LenMorethanBiolen",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_SumLenStart,
   { "SumLenStart",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_AlignDimSeqIdNotMatch,
   { "AlignDimSeqIdNotMatch",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_SegsDimSeqIdNotMatch,
   { "SegsDimSeqIdNotMatch",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_FastaLike,
   { "FastaLike",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_NullSegs,
   { "NullSegs",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_SegmentGap,
   { "SegmentGap",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_SegsDimOne,
   { "SegsDimOne",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_AlignDimOne,
   { "AlignDimOne",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_Segtype,
   { "Segtype",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_BlastAligns,
   { "BlastAligns",
"BLAST alignments are not desired in records submitted to the sequence database." } },
   { eErr_SEQ_ALIGN_PercentIdentity,
   { "PercentIdentity",
"An acceptable percent identity score is 75 percent or higher." } },
   { eErr_SEQ_ALIGN_ShortAln,
   { "ShortAln",
"Alignment is shorter than expected." } },
   { eErr_SEQ_ALIGN_UnexpectedAlignmentType ,
   { "UnexpectedAlignmentType",
"Only DenseSeg alignments are expected." } },

    { eErr_SEQ_ALIGN_SegsDimMismatch,
    { "SegsDimMismatch",
"Please contact the sequence database for further help with this error." } },
    { eErr_SEQ_ALIGN_SegsNumsegMismatch,
    { "SegsNumsegMismatch",
"Please contact the sequence database for further help with this error." } },
    { eErr_SEQ_ALIGN_SegsStartsMismatch,
    { "SegsStartsMismatch",
"Please contact the sequence database for further help with this error." } },
    { eErr_SEQ_ALIGN_SegsPresentMismatch,
    { "SegsPresentMismatch",
"Please contact the sequence database for further help with this error." } },
    { eErr_SEQ_ALIGN_SegsPresentStartsMismatch,
    { "SegsPresentStartsMismatch",
"Please contact the sequence database for further help with this error." } },
    { eErr_SEQ_ALIGN_SegsPresentStrandsMismatch,
    { "SegsPresentStrandsMismatch",
"Please contact the sequence database for further help with this error." } },
   { eErr_SEQ_ALIGN_NucProtMixture,
   { "NucProtMixture",
"The alignment refers to a mixture of nucleotides and proteins." } },


/* SEQ_GRAPH */

   { eErr_SEQ_GRAPH_GraphMin,
   { "GraphMin",
"The graph minimum value is outside of the 0-100 range." } },
   { eErr_SEQ_GRAPH_GraphMax,
   { "GraphMax",
"The graph maximum value is outside of the 0-100 range." } },
   { eErr_SEQ_GRAPH_GraphBelow,
   { "GraphBelow",
"Some quality scores are below the stated graph minimum value." } },
   { eErr_SEQ_GRAPH_GraphAbove,
   { "GraphAbove",
"Some quality scores are above the stated graph maximum value." } },
   { eErr_SEQ_GRAPH_GraphByteLen,
   { "GraphByteLen",
"The number of bytes in the quality graph does not correspond to the \
stated length of the graph." } },
   { eErr_SEQ_GRAPH_GraphOutOfOrder,
   { "GraphOutOfOrder",
"The quality graphs are not packaged in order - may be due to an old fa2htgs bug." } },
   { eErr_SEQ_GRAPH_GraphBioseqLen,
   { "GraphBioseqLen",
"The length of the quality graph does not correspond to the length of the Bioseq." } },
   { eErr_SEQ_GRAPH_GraphSeqLitLen,
   { "GraphSeqLitLen",
"The length of the quality graph does not correspond to the length of the \
delta Bioseq literal component." } },
   { eErr_SEQ_GRAPH_GraphSeqLocLen,
   { "GraphSeqLocLen",
"The length of the quality graph does not correspond to the length of the \
delta Bioseq location component." } },
   { eErr_SEQ_GRAPH_GraphStartPhase,
   { "GraphStartPhase",
"The quality graph does not start or stop on a sequence segment boundary." } },
   { eErr_SEQ_GRAPH_GraphStopPhase,
   { "GraphStopPhase",
"The quality graph does not start or stop on a sequence segment boundary." } },
   { eErr_SEQ_GRAPH_GraphDiffNumber,
   { "GraphDiffNumber",
"The number quality graph does not equal the number of sequence segments." } },
   { eErr_SEQ_GRAPH_GraphACGTScore,
   { "GraphACGTScore",
"Quality score values for known bases should be above 0." } },
   { eErr_SEQ_GRAPH_GraphNScore,
   { "GraphNScore",
"Quality score values for unknown bases should not be above 0." } },
   { eErr_SEQ_GRAPH_GraphGapScore,
   { "GraphGapScore",
"Gap positions should not have quality scores above 0." } },
   { eErr_SEQ_GRAPH_GraphOverlap,
   { "GraphOverlap",
"Quality graphs overlap - may be due to an old fa2htgs bug." } },
   { eErr_SEQ_GRAPH_GraphBioseqId,
   { "GraphBioseqId",
"Quality graph does not map to Bioseq in record." } },
   { eErr_SEQ_GRAPH_GraphACGTScoreMany,
   { "GraphACGTScoreMany",
"Quality score values for known bases should be above 0." } },
   { eErr_SEQ_GRAPH_GraphNScoreMany,
   { "GraphNScoreMany",
"Quality score values for unknown bases should not be above 0." } },
   { eErr_SEQ_GRAPH_GraphLocInvalid,
   { "GraphLocInvalid",
"Location for quality score values extends beyond end of sequence." } },


/* SEQ_ANNOT */

    { eErr_SEQ_ANNOT_AnnotIDs,
    { "AnnotIDs",
"Seq-annot.data.ids should only be used for communication between programs." } },
    { eErr_SEQ_ANNOT_AnnotLOCs,
    { "AnnotLOCs",
"Seq-annot.data.locs should only be used for communication between programs." } },

/* INTERNAL */

    { eErr_INTERNAL_Exception,
    { "Exception",
"Exception was caught while performing validation. Vaidation terminated." } }
};

typedef CStaticArrayMap<unsigned int, pair<string, string> > TErrTypeStrsMap;
DEFINE_STATIC_ARRAY_MAP_WITH_COPY(TErrTypeStrsMap, sc_ErrStrsMap, sc_ErrStrs);

#undef BEGIN
#undef END


CValidErrItem::CValidErrItem
(EDiagSev             sev,
 unsigned int         ec,
 const string&        msg,
 const string&        desc,
 const CSerialObject& obj,
 const string&        acc,
 const int            ver,
 const int            seq_offset)
  : m_Object(&obj)
{
    SetSev(sev);
    SetErrIndex(ec);
    SetMsg(msg);
    SetObjDesc(desc);
    SetAccession(acc);
    SetSeqOffset(seq_offset);
    if (ver > 0) {
        SetAccnver(acc + "." + NStr::IntToString(ver));
    } else {
        SetAccnver(acc);
    }
    SetVersion(ver);
    SetErrorName(ConvertErrCode(ec));
    SetErrorGroup(ConvertErrGroup(ec));
}

CValidErrItem::CValidErrItem
(EDiagSev             sev,
 unsigned int         ec,
 const string&        msg,
 const string&        desc,
 const CSerialObject& obj,
 const string&        acc,
 const int            ver,
 const string&        feature_id,
 const int            seq_offset)
  : m_Object(&obj)
{
    SetSev(sev);
    SetErrIndex(ec);
    SetMsg(msg);
    SetObjDesc(desc);
    SetAccession(acc);
    SetFeatureId(feature_id);
    SetSeqOffset(seq_offset);
    if (ver > 0) {
        SetAccnver(acc + "." + NStr::IntToString(ver));
    } else {
        SetAccnver(acc);
    }
    SetVersion(ver);
    SetErrorName(ConvertErrCode(ec));
    SetErrorGroup(ConvertErrGroup(ec));
}

CValidErrItem::CValidErrItem
(EDiagSev             sev,
 unsigned int         ec,
 const string&        msg,
 const string&        desc,
 const CSerialObject& obj,
 const CSeq_entry&    ctx,
 const string&        acc,
 const int            ver,
 const int            seq_offset)
  : m_Object(&obj),
    m_Ctx(&ctx)
{
    SetSev(sev);
    SetErrIndex(ec);
    SetMsg(msg);
    SetObjDesc(desc);
    SetAccession(acc);
    SetSeqOffset(seq_offset);
    if (ver > 0) {
        SetAccnver(acc + "." + NStr::IntToString(ver));
    } else {
        SetAccnver(acc);
    }
    SetVersion(ver);
    SetErrorName(ConvertErrCode(ec));
    SetErrorGroup(ConvertErrGroup(ec));
}


void CValidErrItem::SetFeatureObjDescFromFields()
{
    // Add feature part of label
    string desc = "FEATURE: ";
    if (IsSetObj_content()) {
        desc += GetObj_content();
    }

    // Add feature ID part of label (if present)
    if (IsSetFeatureId()) {
        desc += " <" + GetFeatureId() + "> ";
    }

    // Add feature location part of label
    if (IsSetLocation()) {
        desc += " [" + GetLocation() + "]";
    }

    // Append label for bioseq of feature location
    if (IsSetBioseq()) {
        desc += GetBioseq();
    }

    // Append label for product of feature
    if (IsSetProduct_loc()) {
        desc += " -> " + GetProduct_loc();
    }

    SetObjDesc(desc);
}


// destructor
CValidErrItem::~CValidErrItem(void)
{
}


const string CValidErrItem::GetErrCode(void) const
{
    return ConvertErrCode(GetErrIndex());
}


size_t CValidErrItem::GetErrCount(void)
{
    return sc_ErrStrsMap.size();
}


const string CValidErrItem::ConvertErrGroup(unsigned int err_int)
{
    static const char* kSeqInst  = "SEQ_INST";
    static const char* kSeqDescr = "SEQ_DESCR";
    static const char* kGeneric  = "GENERIC";
    static const char* kSeqPkg   = "SEQ_PKG";
    static const char* kSeqFeat  = "SEQ_FEAT";
    static const char* kSeqAlign = "SEQ_ALIGN";
    static const char* kSeqGraph = "SEQ_GRAPH";
    static const char* kSeqAnnot = "SEQ_ANNOT";
    static const char* kInternal = "INTERNAL";
    static const char* kUnknown   = "UNKNOWN";

    TErrIndex errIndex = static_cast<TErrIndex> (err_int);
    
#define IS_IN(x) (errIndex > ERR_CODE_BEGIN(x))  &&  (errIndex < ERR_CODE_END(x))

    if ((errIndex < eErr_MAX)  &&  (errIndex > 0)) {
        if ( IS_IN(SEQ_INST) ) {
            return kSeqInst;
        } else if ( IS_IN(SEQ_DESCR) ) {
            return kSeqDescr;
        } else if ( IS_IN(GENERIC) ) {
            return kGeneric;
        } else if ( IS_IN(SEQ_PKG) ) {
            return kSeqPkg;
        } else if ( IS_IN(SEQ_FEAT) ) {
            return kSeqFeat;
        } else if ( IS_IN(SEQ_ALIGN) ) {
            return kSeqAlign;
        } else if ( IS_IN(SEQ_GRAPH) ) {
            return kSeqGraph;
        } else if ( IS_IN(SEQ_ANNOT) ) {
            return kSeqAnnot;
        } else if ( IS_IN(INTERNAL) ) {
            return kInternal;
        }
    }

#undef IS_IN

    return kUnknown;
}

const string CValidErrItem::GetErrGroup(void) const
{
    return ConvertErrGroup(GetErrIndex());
}


const string CValidErrItem::GetVerbose(void) const
{
    TErrIndex err = GetErrIndex();
    if (err <= eErr_MAX) {
        TErrTypeStrsMap::const_iterator err_it = sc_ErrStrsMap.find(err);
        if (err_it != sc_ErrStrsMap.end()) {
            return err_it->second.second;
        }
    }
    return sc_ErrStrsMap.find(eErr_UNKNOWN)->second.second ;
}


const CSerialObject& CValidErrItem::GetObject(void) const
{
    return *m_Object;
}


bool CValidErrItem::IsSetObject(void) const 
{
    return m_Object.NotEmpty(); 
}


void CValidErrItem::SetObject(const CSerialObject& obj)
{
    m_Object.Reset(&obj);
}


const string CValidErrItem::ConvertSeverity(EDiagSev sev)
{
    static const char* str_sev[] = {
        "Info", "Warning", "Error", "Critical", "Fatal", "Trace"
    };

    return str_sev[sev];
}


const string CValidErrItem::ConvertErrCode(unsigned int err_int)
{
    TErrIndex err = static_cast<TErrIndex> (err_int);
    if (err <= eErr_MAX) {
        TErrTypeStrsMap::const_iterator err_it = sc_ErrStrsMap.find(err);
        if (err_it != sc_ErrStrsMap.end()) {
            return err_it->second.first;
        }
    }
    return sc_ErrStrsMap.find(eErr_UNKNOWN)->second.first;
}


unsigned int CValidErrItem::ConvertToErrCode(const string& str)
{
    TErrTypeStrsMap::const_iterator err_it = sc_ErrStrsMap.begin();

    while (err_it != sc_ErrStrsMap.end()) {
        if (NStr::Equal(err_it->second.first, str)) {
            return err_it->first;
        } else if (NStr::EndsWith(str, err_it->second.first)) {
            string group = ConvertErrGroup(err_it->first);
            if (NStr::Equal(group + "_" + err_it->second.first, str)) {
                return err_it->first;
            }
        }
        err_it++;
    }
    return eErr_MAX;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1875, CRC32: 4cb3d7e3 */
