/*  $Id: ecnum_replaced.inc 365227 2012-06-04 17:46:17Z kans $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_replaced.txt.
 *
 */

static const char* const kECNum_replaced[] = {
    "1.1.1.5	1.1.1.303	1.1.1.304",
    "1.1.1.68	1.5.1.20",
    "1.1.1.70	1.2.1.3",
    "1.1.1.89	1.1.1.86",
    "1.1.1.109	1.3.1.28",
    "1.1.1.139	1.1.1.21",
    "1.1.1.155	1.1.1.87",
    "1.1.1.171	1.5.1.20",
    "1.1.1.180	1.1.1.131",
    "1.1.1.182	1.1.1.198	1.1.1.227	1.1.1.228",
    "1.1.1.204	1.17.1.4",
    "1.1.1.242	1.3.1.69",
    "1.1.1.249	2.5.1.46",
    "1.1.1.253	1.5.1.33",
    "1.1.1.n1	1.1.1.305",
    "1.1.1.n2	1.1.1.300",
    "1.1.1.n10	1.1.1.301",
    "1.1.2.1	1.1.5.3",
    "1.1.3.1	1.1.3.15",
    "1.1.3.2	1.13.12.4",
    "1.1.3.22	1.17.3.2",
    "1.1.3.24	1.3.3.12",
    "1.1.3.25	1.1.99.18",
    "1.1.3.26	1.21.3.2",
    "1.1.3.32	1.14.21.1",
    "1.1.3.33	1.14.21.2",
    "1.1.3.34	1.14.21.3",
    "1.1.3.35	1.14.21.4",
    "1.1.3.36	1.14.21.5",
    "1.1.98.1	1.1.9.1",
    "1.1.99.5	1.1.5.3",
    "1.1.99.8	1.1.2.7	1.1.2.8",
    "1.1.99.15	1.5.1.20",
    "1.1.99.16	1.1.5.4",
    "1.1.99.17	1.1.5.2",
    "1.1.99.19	1.17.99.4",
    "1.1.99.23	1.1.2.6",
    "1.1.99.25	1.1.5.8",
    "1.1.99.34	1.1.98.2",
    "1.2.1.1	1.1.1.284	4.4.1.22",
    "1.2.1.14	1.1.1.205",
    "1.2.1.34	1.1.1.131",
    "1.2.1.35	1.1.1.203",
    "1.2.1.37	1.17.1.4",
    "1.2.1.45	1.1.1.312",
    "1.2.1.55	1.1.1.279",
    "1.2.1.56	1.1.1.280",
    "1.2.1.66	1.1.1.306",
    "1.2.1.n1	1.2.1.77",
    "1.2.3.2	1.17.3.2",
    "1.2.3.12	1.14.13.82",
    "1.2.4.3	1.2.4.4",
    "1.2.7.9	1.2.7.3",
    "1.2.99.1	1.17.99.4",
    "1.3.1.50	1.1.1.252",
    "1.3.1.n1	1.3.1.87",
    "1.3.2.1	1.3.8.1",
    "1.3.2.2	1.3.99.3",
    "1.3.3.1	1.3.98.1",
    "1.3.3.2	1.14.21.6",
    "1.3.99.2	1.3.8.1",
    "1.3.99.9	1.21.99.1",
    "1.3.99.11	1.3.5.2",
    "1.3.99.15	1.3.7.8",
    "1.3.99.20	1.3.7.9",
    "1.3.99.n2	4.1.99.19",
    "1.4.1.6	1.21.4.1",
    "1.4.3.6	1.4.3.21	1.4.3.22",
    "1.4.3.9	1.4.3.4",
    "1.4.3.17	1.3.3.10",
    "1.4.4.1	1.21.4.1",
    "1.4.98.1	1.4.9.1",
    "1.4.99.3	1.4.9.1",
    "1.4.99.4	1.4.9.2",
    "1.5.1.4	1.5.1.3",
    "1.5.1.13	1.17.1.5",
    "1.5.1.14	1.5.1.21",
    "1.5.1.29	1.5.1.38	1.5.1.39	1.5.1.41",
    "1.5.1.35	1.2.1.19",
    "1.5.3.8	1.3.3.8",
    "1.5.3.9	1.21.3.3",
    "1.5.3.11	1.5.3.13	1.5.3.14	1.5.3.15	1.5.3.16	1.5.3.17",
    "1.5.3.n1	1.5.3.16",
    "1.5.3.n2	1.5.3.16",
    "1.5.3.n3	1.5.3.13	1.5.3.16",
    "1.5.3.n4	1.5.3.13",
    "1.5.3.n5	1.5.3.16",
    "1.5.3.n6	1.5.3.14	1.5.3.15",
    "1.5.3.n7	1.5.3.14	1.5.3.15",
    "1.5.3.n8	1.5.3.14	1.5.3.15",
    "1.5.3.n9	1.5.3.14	1.5.3.15",
    "1.5.3.n10	1.5.3.13",
    "1.5.99.1	1.5.8.3",
    "1.5.99.2	1.5.8.4",
    "1.5.99.7	1.5.8.2",
    "1.5.99.10	1.5.8.1",
    "1.6.2.1	1.6.99.3",
    "1.6.4.1	1.8.1.6",
    "1.6.4.2	1.8.1.7",
    "1.6.4.3	1.8.1.4",
    "1.6.4.4	1.8.1.8",
    "1.6.4.5	1.8.1.9",
    "1.6.4.6	1.8.1.10",
    "1.6.4.7	1.8.1.11",
    "1.6.4.8	1.8.1.12",
    "1.6.4.9	1.8.1.13",
    "1.6.4.10	1.8.1.14",
    "1.6.6.1	1.7.1.1",
    "1.6.6.2	1.7.1.2",
    "1.6.6.3	1.7.1.3",
    "1.6.6.4	1.7.1.4",
    "1.6.6.5	1.7.2.1",
    "1.6.6.6	1.7.1.5",
    "1.6.6.7	1.7.1.6",
    "1.6.6.8	1.7.1.7",
    "1.6.6.10	1.7.1.9",
    "1.6.6.11	1.7.1.10",
    "1.6.6.12	1.7.1.11",
    "1.6.6.13	1.7.1.12",
    "1.6.7.1	1.18.1.2",
    "1.6.7.2	1.18.1.1",
    "1.6.8.1	1.5.1.38	1.5.1.39	1.5.1.41",
    "1.6.8.2	1.5.1.30",
    "1.6.99.2	1.6.5.2",
    "1.6.99.4	1.18.1.2",
    "1.6.99.6	1.6.5.10",
    "1.6.99.7	1.5.1.34",
    "1.6.99.8	1.16.1.3",
    "1.6.99.9	1.16.1.4",
    "1.6.99.10	1.5.1.34",
    "1.6.99.11	1.16.1.5",
    "1.6.99.12	1.16.1.6",
    "1.6.99.13	1.16.1.7",
    "1.7.99.3	1.7.2.1",
    "1.7.99.5	1.5.1.20",
    "1.7.99.6	1.7.2.4",
    "1.7.99.7	1.7.2.5",
    "1.8.4.5	1.8.4.13	1.8.4.14",
    "1.8.4.6	1.8.4.11",
    "1.8.6.1	2.5.1.18",
    "1.8.99.4	1.8.4.8",
    "1.9.3.2	1.7.2.1",
    "1.10.3.7	1.21.3.4",
    "1.10.3.8	1.21.3.5",
    "1.10.99.1	1.10.9.1",
    "1.11.1.4	1.13.11.11",
    "1.12.1.1	1.12.7.2",
    "1.12.7.1	1.12.7.2",
    "1.12.99.1	1.12.98.1",
    "1.12.99.3	1.12.5.1",
    "1.12.99.4	1.12.98.2",
    "1.12.99.5	1.13.11.47",
    "1.13.1.1	1.13.11.1",
    "1.13.1.2	1.13.11.2",
    "1.13.1.3	1.13.11.3",
    "1.13.1.4	1.13.11.4",
    "1.13.1.5	1.13.11.5",
    "1.13.1.6	1.13.11.6",
    "1.13.1.8	1.13.11.8",
    "1.13.1.9	1.13.11.9",
    "1.13.1.10	1.13.11.10",
    "1.13.1.11	1.13.99.1",
    "1.13.1.12	1.13.11.11",
    "1.13.1.13	1.13.11.12",
    "1.13.11.21	1.14.99.36",
    "1.13.11.32	1.13.12.16",
    "1.13.11.44	1.13.11.60	5.4.4.6",
    "1.13.12.11	1.14.13.8",
    "1.13.12.14	1.14.13.122",
    "1.13.99.2	1.14.12.10",
    "1.13.99.4	1.14.12.9",
    "1.13.99.5	1.13.11.47",
    "1.14.1.1	1.14.14.1",
    "1.14.1.2	1.14.13.9",
    "1.14.1.3	1.14.13.132	5.4.99.7",
    "1.14.1.4	1.14.99.2",
    "1.14.1.5	1.14.13.5",
    "1.14.1.6	1.14.15.4",
    "1.14.1.7	1.14.99.9",
    "1.14.1.8	1.14.99.10",
    "1.14.1.10	1.14.99.11",
    "1.14.2.1	1.14.17.1",
    "1.14.2.2	1.13.11.27",
    "1.14.3.1	1.14.16.1",
    "1.14.11.5	1.14.11.6",
    "1.14.12.2	1.14.13.35",
    "1.14.12.6	1.14.13.66",
    "1.14.12.n1	1.14.12.21",
    "1.14.13.3	1.14.14.9",
    "1.14.13.45	1.14.18.2",
    "1.14.13.n1	1.14.13.124",
    "1.14.13.n2	1.14.13.125",
    "1.14.13.n3	1.14.13.127",
    "1.14.13.n4	1.14.13.126",
    "1.14.14.2	1.14.14.1",
    "1.14.14.4	1.14.15.7",
    "1.14.14.6	1.14.13.111",
    "1.14.17.2	1.14.18.1",
    "1.14.19.n1	1.14.19.4",
    "1.14.19.n2	1.14.19.5",
    "1.14.19.n3	1.14.19.6",
    "1.14.99.5	1.14.19.1",
    "1.14.99.6	1.14.19.2",
    "1.14.99.7	1.14.13.132",
    "1.14.99.8	1.14.14.1",
    "1.14.99.13	1.14.13.23",
    "1.14.99.16	1.14.13.72",
    "1.14.99.17	1.14.16.5",
    "1.14.99.25	1.14.19.3",
    "1.14.99.30	1.3.5.6",
    "1.14.99.n1	1.14.99.41",
    "1.14.99.n3	1.14.99.42",
    "1.16.98.1	1.16.9.1",
    "1.17.1.6	1.17.99.5",
    "1.17.4.3	1.17.7.1",
    "1.18.2.1	1.18.6.1",
    "1.18.3.1	1.12.7.2",
    "1.18.96.1	1.15.1.2",
    "1.18.99.1	1.12.7.2",
    "1.20.98.1	1.20.9.1",
    "1.97.1.5	1.20.4.1",
    "1.97.1.6	1.20.99.1",
    "1.97.1.7	1.20.4.2",
    "1.98.1.1	1.12.7.2",
    "1.99.1.1	1.14.14.1",
    "1.99.1.2	1.14.16.1",
    "1.99.1.5	1.14.13.9",
    "1.99.1.7	1.14.15.4",
    "1.99.1.9	1.14.99.9",
    "1.99.1.11	1.14.99.10",
    "1.99.1.13	1.14.13.132	5.4.99.7",
    "1.99.1.14	1.13.11.27",
    "1.99.2.1	1.13.11.12",
    "1.99.2.2	1.13.11.1",
    "1.99.2.3	1.13.11.3",
    "1.99.2.4	1.13.11.4",
    "1.99.2.5	1.13.11.5",
    "1.99.2.6	1.13.99.1",
    "2.1.1.23	2.1.1.124	2.1.1.125	2.1.1.126",
    "2.1.1.24	2.1.1.77	2.1.1.80	2.1.1.100",
    "2.1.1.29	2.1.1.202	2.1.1.203	2.1.1.204",
    "2.1.1.31	2.1.1.221	2.1.1.228",
    "2.1.1.32	2.1.1.213	2.1.1.214	2.1.1.215	2.1.1.216",
    "2.1.1.36	2.1.1.217	2.1.1.218	2.1.1.219	2.1.1.220",
    "2.1.1.48	2.1.1.181	2.1.1.182	2.1.1.183	2.1.1.184",
    "2.1.1.51	2.1.1.187	2.1.1.188",
    "2.1.1.52	2.1.1.171	2.1.1.172	2.1.1.173	2.1.1.174",
    "2.1.1.58	2.1.1.57",
    "2.1.1.73	2.1.1.37",
    "2.1.1.81	2.1.1.49",
    "2.1.1.92	2.1.1.69",
    "2.1.1.93	2.1.1.70",
    "2.1.1.134	2.1.1.129",
    "2.1.1.135	1.16.1.8",
    "2.1.1.n2	2.1.1.211",
    "2.1.2.6	2.1.2.5",
    "2.1.2.12	2.1.1.74",
    "2.1.2.n1	2.1.2.13",
    "2.3.1.55	2.3.1.82",
    "2.3.1.n1	2.3.1.191",
    "2.4.1.3	2.4.1.25",
    "2.4.1.42	2.4.1.17",
    "2.4.1.51	2.4.1.101	2.4.1.143	2.4.1.144	2.4.1.145",
    "2.4.1.55	2.7.8.14",
    "2.4.1.59	2.4.1.17",
    "2.4.1.61	2.4.1.17",
    "2.4.1.72	2.4.2.24",
    "2.4.1.76	2.4.1.17",
    "2.4.1.77	2.4.1.17",
    "2.4.1.84	2.4.1.17",
    "2.4.1.89	2.4.1.69",
    "2.4.1.93	4.2.2.18",
    "2.4.1.98	2.4.1.90",
    "2.4.1.107	2.4.1.17",
    "2.4.1.108	2.4.1.17",
    "2.4.1.112	2.4.1.186",
    "2.4.1.124	2.4.1.87",
    "2.4.1.130	2.4.1.258	2.4.1.259	2.4.1.260	2.4.1.261",
    "2.4.1.151	2.4.1.87",
    "2.4.1.169	2.4.2.39",
    "2.4.1.200	4.2.2.17",
    "2.4.1.204	2.4.2.40",
    "2.4.1.233	2.4.1.115",
    "2.4.1.n1	2.4.1.245",
    "2.4.1.n3	2.4.1.250",
    "2.4.1.n4	2.4.1.131",
    "2.4.2.13	2.5.1.6",
    "2.4.2.n1	2.4.2.43",
    "2.5.1.8	2.5.1.75",
    "2.5.1.11	2.5.1.84	2.5.1.85",
    "2.5.1.12	2.5.1.18",
    "2.5.1.13	2.5.1.18",
    "2.5.1.14	2.5.1.18",
    "2.5.1.33	2.5.1.82	2.5.1.83",
    "2.5.1.37	4.4.1.20",
    "2.5.1.40	4.2.3.9",
    "2.5.1.64	2.2.1.9	4.2.99.20",
    "2.5.1.n1	2.2.1.9",
    "2.5.1.n2	2.5.1.81",
    "2.5.1.n3	2.5.1.73",
    "2.6.1.10	2.6.1.21",
    "2.6.1.25	2.6.1.24",
    "2.6.1.53	1.4.1.13",
    "2.6.1.61	2.6.1.40",
    "2.6.1.n1	2.6.1.87",
    "2.6.2.1	2.1.4.1",
    "2.7.1.37	2.7.11.1	2.7.11.8	2.7.11.9	2.7.11.10	2.7.11.11	2.7.11.12	2.7.11.13	2.7.11.21	2.7.11.22	2.7.11.24	2.7.11.25	2.7.11.30	2.7.12.1",
    "2.7.1.38	2.7.11.19",
    "2.7.1.70	2.7.11.1",
    "2.7.1.75	2.7.1.21",
    "2.7.1.96	2.7.1.86",
    "2.7.1.97	2.7.11.14",
    "2.7.1.99	2.7.11.2",
    "2.7.1.104	2.7.99.1",
    "2.7.1.109	2.7.11.31",
    "2.7.1.110	2.7.11.3",
    "2.7.1.111	2.7.11.27",
    "2.7.1.112	2.7.10.1	2.7.10.2",
    "2.7.1.115	2.7.11.4",
    "2.7.1.116	2.7.11.5",
    "2.7.1.117	2.7.11.18",
    "2.7.1.120	2.7.11.17",
    "2.7.1.123	2.7.11.17",
    "2.7.1.124	2.7.11.6",
    "2.7.1.125	2.7.11.14",
    "2.7.1.126	2.7.11.15",
    "2.7.1.128	2.7.11.27",
    "2.7.1.129	2.7.11.7",
    "2.7.1.131	2.7.11.29",
    "2.7.1.132	2.7.11.28",
    "2.7.1.133	2.7.1.134",
    "2.7.1.135	2.7.11.26",
    "2.7.1.139	2.7.1.134",
    "2.7.1.141	2.7.11.23",
    "2.7.1.152	2.7.4.21",
    "2.7.1.155	2.7.4.24",
    "2.7.1.n1	2.7.1.170",
    "2.7.1.n2	2.7.1.161",
    "2.7.1.n3	2.7.1.164",
    "2.7.1.n6	2.7.1.163",
    "2.7.2.5	6.3.4.16",
    "2.7.2.9	6.3.5.5",
    "2.7.3.11	2.7.13.1",
    "2.7.3.12	2.7.13.2",
    "2.7.4.5	2.7.4.14",
    "2.7.5.1	5.4.2.2",
    "2.7.5.2	5.4.2.3",
    "2.7.5.3	5.4.2.1",
    "2.7.5.4	5.4.2.4",
    "2.7.5.5	5.4.2.5",
    "2.7.5.6	5.4.2.7",
    "2.7.5.7	5.4.2.8",
    "2.7.7.16	3.1.27.5",
    "2.7.7.17	3.1.27.1",
    "2.7.7.21	2.7.7.72",
    "2.7.7.25	2.7.7.72",
    "2.7.7.26	3.1.27.3",
    "2.7.7.29	2.7.7.28",
    "2.7.7.n2	2.7.7.67",
    "2.7.7.n3	2.7.7.73",
    "2.7.7.n4	2.7.7.80",
    "2.7.7.n5	2.7.7.75",
    "2.7.8.16	2.7.8.2",
    "2.7.8.n1	2.7.8.30",
    "2.7.8.n2	2.7.8.33",
    "2.8.1.n1	2.8.1.11",
    "2.8.2.12	2.8.2.8",
    "2.9.1.n1	2.9.1.2",
    "3.1.1.12	3.1.1.1",
    "3.1.1.16	3.1.1.24	5.3.3.4",
    "3.1.1.18	3.1.1.17",
    "3.1.1.62	3.5.1.47",
    "3.1.1.69	3.5.1.89",
    "3.1.1.n1	3.5.1.103",
    "3.1.2.8	3.1.2.6",
    "3.1.2.24	3.13.1.3",
    "3.1.2.n1	3.1.2.28",
    "3.1.3.30	3.1.3.31",
    "3.1.3.65	3.1.3.64",
    "3.1.3.n1	3.1.3.86",
    "3.1.3.n2	3.1.3.84",
    "3.1.3.n3	3.1.3.78",
    "3.1.4.5	3.1.21.1",
    "3.1.4.6	3.1.22.1",
    "3.1.4.7	3.1.31.1",
    "3.1.4.8	3.1.27.3",
    "3.1.4.9	3.1.30.2",
    "3.1.4.10	4.6.1.13",
    "3.1.4.18	3.1.16.1",
    "3.1.4.19	3.1.13.3",
    "3.1.4.20	3.1.13.1",
    "3.1.4.21	3.1.30.1",
    "3.1.4.22	3.1.27.5",
    "3.1.4.23	3.1.27.1",
    "3.1.4.25	3.1.11.1",
    "3.1.4.27	3.1.11.2",
    "3.1.4.28	3.1.11.3",
    "3.1.4.30	3.1.21.2",
    "3.1.4.31	3.1.11.4",
    "3.1.4.36	3.1.4.43",
    "3.1.4.47	4.6.1.14",
    "3.1.4.n1	3.1.4.53",
    "3.1.22.3	3.1.21.7",
    "3.1.23.1	3.1.21.4",
    "3.1.23.2	3.1.21.4",
    "3.1.23.3	3.1.21.4",
    "3.1.23.4	3.1.21.4",
    "3.1.23.5	3.1.21.4",
    "3.1.23.6	3.1.21.4",
    "3.1.23.7	3.1.21.4",
    "3.1.23.8	3.1.21.4",
    "3.1.23.9	3.1.21.4",
    "3.1.23.10	3.1.21.4",
    "3.1.23.11	3.1.21.4",
    "3.1.23.12	3.1.21.4",
    "3.1.23.13	3.1.21.4",
    "3.1.23.14	3.1.21.4",
    "3.1.23.15	3.1.21.4",
    "3.1.23.16	3.1.21.4",
    "3.1.23.17	3.1.21.4",
    "3.1.23.18	3.1.21.4",
    "3.1.23.19	3.1.21.4",
    "3.1.23.20	3.1.21.4",
    "3.1.23.21	3.1.21.4",
    "3.1.23.22	3.1.21.4",
    "3.1.23.23	3.1.21.4",
    "3.1.23.24	3.1.21.4",
    "3.1.23.25	3.1.21.4",
    "3.1.23.26	3.1.21.4",
    "3.1.23.27	3.1.21.4",
    "3.1.23.28	3.1.21.4",
    "3.1.23.29	3.1.21.4",
    "3.1.23.30	3.1.21.4",
    "3.1.23.31	3.1.21.4",
    "3.1.23.32	3.1.21.4",
    "3.1.23.33	3.1.21.4",
    "3.1.23.34	3.1.21.4",
    "3.1.23.35	3.1.21.4",
    "3.1.23.36	3.1.21.4",
    "3.1.23.37	3.1.21.4",
    "3.1.23.38	3.1.21.4",
    "3.1.23.39	3.1.21.4",
    "3.1.23.40	3.1.21.4",
    "3.1.23.41	3.1.21.4",
    "3.1.23.42	3.1.21.4",
    "3.1.23.43	3.1.21.4",
    "3.1.23.44	3.1.21.4",
    "3.1.23.45	3.1.21.4",
    "3.1.23.46	3.1.21.4",
    "3.1.23.47	3.1.21.4",
    "3.1.23.48	3.1.21.4",
    "3.1.23.49	3.1.21.4",
    "3.1.23.50	3.1.21.4",
    "3.1.23.51	3.1.21.4",
    "3.1.23.52	3.1.21.4",
    "3.1.23.53	3.1.21.4",
    "3.1.23.54	3.1.21.4",
    "3.1.23.55	3.1.21.4",
    "3.1.23.56	3.1.21.4",
    "3.1.23.57	3.1.21.4",
    "3.1.23.58	3.1.21.4",
    "3.1.23.59	3.1.21.4",
    "3.1.24.1	3.1.21.3",
    "3.1.24.2	3.1.21.3",
    "3.1.24.3	3.1.21.5",
    "3.1.24.4	3.1.21.5",
    "3.1.25.2	4.2.99.18",
    "3.1.26.n1	3.1.26.12",
    "3.2.1.12	3.2.1.54",
    "3.2.1.13	3.2.1.54",
    "3.2.1.29	3.2.1.52",
    "3.2.1.30	3.2.1.52",
    "3.2.1.34	3.2.1.35",
    "3.2.1.69	3.2.1.41",
    "3.2.1.79	3.2.1.55",
    "3.2.1.110	3.2.1.97",
    "3.2.1.138	4.2.2.15",
    "3.2.1.148	4.4.1.21",
    "3.2.1.160	3.2.1.155",
    "3.2.2.18	3.5.1.52",
    "3.2.3.1	3.2.1.147",
    "3.3.1.3	4.4.1.21",
    "3.3.2.3	3.3.2.9	3.3.2.10",
    "3.4.1.1	3.4.11.1",
    "3.4.1.2	3.4.11.2",
    "3.4.1.3	3.4.11.4",
    "3.4.1.4	3.4.11.5",
    "3.4.2.1	3.4.17.1",
    "3.4.2.2	3.4.17.2",
    "3.4.2.3	3.4.17.4",
    "3.4.3.1	3.4.13.18	3.4.13.19",
    "3.4.3.2	3.4.13.18	3.4.13.19",
    "3.4.3.3	3.4.13.18	3.4.13.20",
    "3.4.3.4	3.4.13.5",
    "3.4.3.5	3.4.11.2",
    "3.4.3.6	3.4.13.18	3.4.13.19",
    "3.4.3.7	3.4.13.9",
    "3.4.4.1	3.4.23.1",
    "3.4.4.2	3.4.23.2",
    "3.4.4.3	3.4.23.4",
    "3.4.4.4	3.4.21.4",
    "3.4.4.5	3.4.21.1",
    "3.4.4.6	3.4.21.1",
    "3.4.4.7	3.4.21.36	3.4.21.37",
    "3.4.4.8	3.4.21.9",
    "3.4.4.9	3.4.14.1",
    "3.4.4.10	3.4.22.2",
    "3.4.4.11	3.4.22.6",
    "3.4.4.12	3.4.22.3",
    "3.4.4.13	3.4.21.5",
    "3.4.4.14	3.4.21.7",
    "3.4.4.15	3.4.23.15",
    "3.4.4.16	3.4.21.62	3.4.21.63	3.4.21.64	3.4.21.65	3.4.21.66	3.4.21.67",
    "3.4.4.17	3.4.21.103	3.4.23.20	3.4.23.21	3.4.23.22	3.4.23.23	3.4.23.24	3.4.23.25	3.4.23.26	3.4.23.28	3.4.23.29	3.4.23.30",
    "3.4.4.18	3.4.22.10",
    "3.4.4.19	3.4.24.3",
    "3.4.4.20	3.4.22.8",
    "3.4.4.21	3.4.21.34",
    "3.4.4.22	3.4.23.3",
    "3.4.4.23	3.4.23.5",
    "3.4.4.24	3.4.22.32	3.4.22.33",
    "3.4.11.8	3.4.19.3",
    "3.4.11.n1	3.4.11.24",
    "3.4.12.1	3.4.16.5	3.4.16.6",
    "3.4.12.2	3.4.17.1",
    "3.4.12.3	3.4.17.2",
    "3.4.12.4	3.4.16.2",
    "3.4.12.5	3.5.1.28",
    "3.4.12.6	3.4.17.8",
    "3.4.12.7	3.4.17.3",
    "3.4.12.8	3.4.17.4",
    "3.4.12.10	3.4.19.9",
    "3.4.12.11	3.4.17.6",
    "3.4.12.12	3.4.16.5	3.4.16.6",
    "3.4.13.1	3.4.13.18	3.4.13.19",
    "3.4.13.2	3.4.13.18	3.4.13.19",
    "3.4.13.3	3.4.13.18	3.4.13.20",
    "3.4.13.6	3.4.11.2",
    "3.4.13.8	3.4.13.18	3.4.13.19",
    "3.4.13.10	3.4.19.5",
    "3.4.13.11	3.4.13.18	3.4.13.19",
    "3.4.13.13	3.4.13.18	3.4.13.20",
    "3.4.13.15	3.4.13.18	3.4.13.19",
    "3.4.14.3	3.4.19.1",
    "3.4.14.8	3.4.14.9	3.4.14.10",
    "3.4.15.2	3.4.19.2",
    "3.4.15.3	3.4.15.5",
    "3.4.16.1	3.4.16.5	3.4.16.6",
    "3.4.16.3	3.4.16.5	3.4.16.6",
    "3.4.17.7	3.5.1.28",
    "3.4.17.9	3.4.17.4",
    "3.4.19.8	3.4.17.21",
    "3.4.19.10	3.5.1.28",
    "3.4.21.8	3.4.21.34	3.4.21.35",
    "3.4.21.11	3.4.21.36	3.4.21.37",
    "3.4.21.13	3.4.16.5	3.4.16.6",
    "3.4.21.14	3.4.21.62	3.4.21.63	3.4.21.64	3.4.21.65	3.4.21.67",
    "3.4.21.15	3.4.21.63",
    "3.4.21.28	3.4.21.74",
    "3.4.21.29	3.4.21.74",
    "3.4.21.30	3.4.21.74",
    "3.4.21.31	3.4.21.68	3.4.21.73",
    "3.4.21.44	3.4.21.43",
    "3.4.21.87	3.4.23.49",
    "3.4.22.4	3.4.22.32	3.4.22.33",
    "3.4.22.5	3.4.22.33",
    "3.4.22.9	3.4.21.48",
    "3.4.22.11	3.4.24.56",
    "3.4.22.12	3.4.19.9",
    "3.4.22.17	3.4.22.52	3.4.22.53",
    "3.4.22.18	3.4.21.26",
    "3.4.22.19	3.4.24.15",
    "3.4.22.21	3.4.25.1",
    "3.4.22.22	3.4.24.37",
    "3.4.22.23	3.4.21.61",
    "3.4.23.6	3.4.21.103	3.4.23.18	3.4.23.19	3.4.23.20	3.4.23.21	3.4.23.22	3.4.23.23	3.4.23.24	3.4.23.25	3.4.23.26	3.4.23.28	3.4.23.30",
    "3.4.23.7	3.4.23.20",
    "3.4.23.8	3.4.23.25",
    "3.4.23.9	3.4.23.21",
    "3.4.23.10	3.4.23.22",
    "3.4.23.27	3.4.21.103",
    "3.4.23.33	3.4.21.101",
    "3.4.23.37	3.4.21.100",
    "3.4.24.4	3.4.24.25	3.4.24.26	3.4.24.27	3.4.24.28	3.4.24.29	3.4.24.30	3.4.24.31	3.4.24.32	3.4.24.39	3.4.24.40",
    "3.4.24.5	3.4.22.52	3.4.22.53	3.4.25.1",
    "3.4.24.8	3.4.24.3",
    "3.4.99.1	3.4.23.28",
    "3.4.99.4	3.4.23.12",
    "3.4.99.5	3.4.24.3",
    "3.4.99.6	3.4.24.21",
    "3.4.99.10	3.4.24.56",
    "3.4.99.13	3.4.24.32",
    "3.4.99.19	3.4.23.15",
    "3.4.99.22	3.4.24.29",
    "3.4.99.25	3.4.23.21",
    "3.4.99.26	3.4.21.68	3.4.21.73",
    "3.4.99.28	3.4.21.60",
    "3.4.99.30	3.4.24.20",
    "3.4.99.31	3.4.24.15",
    "3.4.99.32	3.4.24.20",
    "3.4.99.35	3.4.23.36",
    "3.4.99.36	3.4.21.89",
    "3.4.99.38	3.4.23.17",
    "3.4.99.41	3.4.24.64",
    "3.4.99.43	3.4.23.42",
    "3.4.99.44	3.4.24.55",
    "3.4.99.45	3.4.24.56",
    "3.4.99.46	3.4.25.1",
    "3.5.1.34	3.4.13.5",
    "3.5.1.37	3.5.1.26",
    "3.5.1.45	6.3.4.6",
    "3.5.1.80	3.5.1.25",
    "3.5.1.n1	3.5.1.108",
    "3.5.1.n2	3.5.1.99",
    "3.5.2.8	3.5.2.6",
    "3.5.4.n1	3.5.4.31",
    "3.5.5.3	4.2.1.104",
    "3.6.1.4	3.6.1.3",
    "3.6.1.30	3.6.1.59	3.6.1.62",
    "3.6.1.32	3.6.4.1",
    "3.6.1.33	3.6.4.2",
    "3.6.1.34	3.6.3.14",
    "3.6.1.35	3.6.3.6",
    "3.6.1.36	3.6.3.10",
    "3.6.1.37	3.6.3.9",
    "3.6.1.38	3.6.3.8",
    "3.6.1.46	3.6.5.1",
    "3.6.1.47	3.6.5.2",
    "3.6.1.48	3.6.5.3",
    "3.6.1.49	3.6.5.4",
    "3.6.1.50	3.6.5.5",
    "3.6.1.51	3.6.5.6",
    "3.6.1.n5	3.6.1.54",
    "3.6.3.13	3.6.3.1",
    "3.6.3.45	3.6.3.44",
    "3.7.1.n1	3.7.1.14",
    "3.8.1.4	1.97.1.10",
    "3.8.2.1	3.1.8.2",
    "4.1.1.10	4.1.1.12",
    "4.1.1.26	4.1.1.28",
    "4.1.1.27	4.1.1.28",
    "4.1.2.1	4.1.3.16",
    "4.1.2.7	4.1.2.13",
    "4.1.2.15	2.5.1.54",
    "4.1.2.16	2.5.1.55",
    "4.1.2.31	4.1.3.16",
    "4.1.2.37	4.1.2.46	4.1.2.47",
    "4.1.2.39	4.1.2.46	4.1.2.47",
    "4.1.2.n1	4.1.2.44",
    "4.1.3.2	2.3.3.9",
    "4.1.3.5	2.3.3.10",
    "4.1.3.7	2.3.3.1",
    "4.1.3.8	2.3.3.8",
    "4.1.3.9	2.3.3.11",
    "4.1.3.10	2.3.3.7",
    "4.1.3.11	2.3.3.12",
    "4.1.3.12	2.3.3.13",
    "4.1.3.15	2.2.1.5",
    "4.1.3.18	2.2.1.6",
    "4.1.3.19	2.5.1.56",
    "4.1.3.20	2.5.1.57",
    "4.1.3.21	2.3.3.14",
    "4.1.3.23	2.3.3.2",
    "4.1.3.28	2.3.3.3",
    "4.1.3.29	2.3.3.4",
    "4.1.3.31	2.3.3.5",
    "4.1.3.33	2.3.3.6",
    "4.1.3.37	2.2.1.7",
    "4.1.99.4	3.5.99.7",
    "4.1.99.6	4.2.3.6",
    "4.1.99.7	4.2.3.9",
    "4.1.99.8	4.2.3.14",
    "4.1.99.9	4.2.3.15",
    "4.1.99.10	4.2.3.16",
    "4.2.1.13	4.3.1.17",
    "4.2.1.14	4.3.1.18",
    "4.2.1.15	4.4.1.1",
    "4.2.1.16	4.3.1.19",
    "4.2.1.21	4.2.1.22",
    "4.2.1.26	4.3.1.9",
    "4.2.1.29	4.99.1.6",
    "4.2.1.37	3.3.2.4",
    "4.2.1.38	4.3.1.20",
    "4.2.1.63	3.3.2.9	3.3.2.10",
    "4.2.1.64	3.3.2.9	3.3.2.10",
    "4.2.1.71	4.2.1.27",
    "4.2.1.72	4.1.1.78",
    "4.2.1.86	4.2.1.98",
    "4.2.1.102	4.2.1.100",
    "4.2.1.n1	4.2.1.126",
    "4.2.2.4	4.2.2.20	4.2.2.21",
    "4.2.3.n1	4.2.3.38",
    "4.2.3.n3	4.2.3.56",
    "4.2.3.n5	4.2.3.52",
    "4.2.3.n8	4.2.3.103",
    "4.2.3.n9	4.2.3.44",
    "4.2.3.n10	4.2.3.62",
    "4.2.3.n12	4.2.3.65",
    "4.2.3.n13	4.2.3.75",
    "4.2.99.1	4.2.2.1",
    "4.2.99.2	4.2.3.1",
    "4.2.99.3	4.2.2.2",
    "4.2.99.4	4.2.2.3",
    "4.2.99.6	4.2.2.5	4.2.2.20	4.2.2.21",
    "4.2.99.7	4.2.3.2",
    "4.2.99.8	2.5.1.47",
    "4.2.99.9	2.5.1.48",
    "4.2.99.10	2.5.1.49",
    "4.2.99.11	4.2.3.3",
    "4.2.99.13	2.5.1.50",
    "4.2.99.14	2.5.1.51",
    "4.2.99.15	2.5.1.52",
    "4.2.99.16	2.5.1.53",
    "4.2.99.17	2.5.1.51",
    "4.2.99.19	4.4.1.23",
    "4.2.99.n1	4.2.99.20",
    "4.3.1.5	4.3.1.23	4.3.1.24	4.3.1.25",
    "4.3.1.8	2.5.1.61",
    "4.3.1.21	4.3.1.9",
    "4.3.99.1	4.2.1.104",
    "4.4.1.7	2.5.1.18",
    "4.4.1.18	1.8.3.5",
    "4.6.1.3	4.2.3.4",
    "4.6.1.4	4.2.3.5",
    "4.6.1.5	4.2.3.7",
    "4.6.1.7	4.2.3.8",
    "4.6.1.8	4.2.3.10",
    "4.6.1.9	4.2.3.11",
    "4.6.1.10	4.2.3.12",
    "4.6.1.11	4.2.3.13",
    "5.1.3.n1	5.1.3.24",
    "5.2.1.7	3.1.1.64",
    "5.3.1.10	3.5.99.6",
    "5.3.1.19	2.6.1.16",
    "5.4.99.6	5.4.4.2",
    "5.4.99.10	5.4.99.11",
    "5.4.99.n1	5.4.99.39",
    "5.4.99.n2	5.4.99.41",
    "5.5.1.n2	5.5.1.19",
    "6.1.1.n1	6.3.1.13",
    "6.1.1.n2	6.1.1.27",
    "6.2.1.21	6.2.1.30",
    "6.2.1.29	6.2.1.7",
    "6.2.1.n1	6.2.1.37",
    "6.3.1.3	6.3.4.13",
    "6.3.2.15	6.3.2.10",
    "6.3.2.22	6.3.1.14",
    "6.3.2.n1	6.3.2.37",
    "6.3.5.8	2.6.1.85"
};
