/*
         
    h_correction.cpp implementation of correction of sights
    Copyright (C) 2011 Enas Giovanni <gio.enas@alice.it>
 
    This file is part of Nautic.

    Nautic is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Nautic is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Nautic.  If not, see <http://www.gnu.org/licenses/>.

 */

#include "h_correction.h"


static double eye_ht[] = {
	0.34, 0.43, 0.49, 0.58,
	0.67, 0.76, 0.85, 0.98,
	1.1, 1.22, 1.34, 1.49, 1.62,
	1.72, 1.92, 2.1, 2.26, 2.44, 2.62,
	2.8, 2.99, 3.2, 3.41, 3.63, 3.84, 4.05,
	4.30, 4.54, 4.79, 5.03, 5.3, 5.58, 5.82,
	6.13, 6.4, 6.71, 6.98, 7.28, 7.59, 7.92,
	8.26, 8.56, 8.9, 9.27, 9.6, 9.97, 10.33,
	10.7, 11.06, 11.46, 11.86, 12.22, 12.65,
	13.05, 13.45, 13.72, 14.33, 14.63,
	14.94, 15.54, 15.85, 16.46, 16.76, 17.37,
	17.68, 18.29, 18.9, 19.2, 19.81, 20.42, 20.73,
	21.34, 21.95, 22.56, 22.86, 23.47, 24.08, 24.69,
	25.3, 25.91, 26.52, 26.82, 27.43, 28.04, 28.65,
	29.26, 29.87, 30.78, 31.39, 32.0, 32.61, 33.22,
	33.83, 34.44, 35.36, 35.97, 36.58, 37.19, 38.1,
	38.71, 39.32, 40.23, 40.84, 41.45, 42.37, 42.89,
	43.89, 44.5, 45.42,
};

static double obs_ht[] = {
	4.38333, 4.43333, 4.483333, 4.53333, 4.6,
	4.65, 4.7, 4.76666, 4.81666, 4.88333, 4.93333,
	5.0, 5.06666, 5.133333, 5.2, 5.26666, 5.33333,
	5.4, 5.466666, 5.53333, 5.616666, 5.68333, 5.76666,
	5.85, 5.916666, 6.0, 6.083333, 6.18333, 6.26666,
	6.35, 6.45, 6.53333, 6.633333, 6.733333, 6.83333,
	6.933333, 7.133333, 7.15, 7.266666, 7.383333, 7.5,
	7.6166666, 7.733333, 7.866666, 8.0, 8.13333, 8.26666,
	8.416666, 8.566666, 8.716666, 8.8666666, 9.033333, 9.2,
	9.383333, 9.55, 9.733333, 9.933333, 10.13333, 10.33333,
	10.55, 10.76666, 11.0, 11.23333, 11.483333, 11.75,
	12.016666, 12.3, 12.583333, 12.9, 13.216666, 13.55, 13.9,
	14.26666, 14.66666, 15.066666, 15.5, 15.95, 16.43333, 16.93333,
	17.46666, 18.03333, 18.63333, 19.283333, 19.96666, 20.7, 21.46666,
	22.31666, 23.21666, 24.183333, 25.233333, 26.36666, 27.6, 28.93333,
	30.4, 32.0, 33.75, 35.66666, 37.8, 40.13333, 42.73333, 45.6, 48.783333,
	52.3, 56.183333, 60.46666, 65.133333, 70.183333, 75.56666, 81.216666,
	87.05, 90.0,

};

static double prlx[] = {
	54.0, 54.3, 54.6, 54.9, 55.2,
	55.5, 55.8, 56.1, 56.4, 56.7,
	57.0, 57.3, 57.6, 57.9, 58.2,
	58.5, 58.8, 59.1, 59.4, 59.7,
	60.0, 60.3, 60.6, 60.9, 61.2,
	61.5,
};

static double mean_alt[]= {
	9,14,19,24,29,34,39,44,49,54,59,64,69,74,79,84,89,
};

static double moon_alt[504];

static double moon_refrac[] = { 0.0, 0.0,
	66.9, 67.2, 67.4, 67.6, 67.8, 68.0, 68.2, 68.4, 68.6, 68.7, 68.9, 69.0,
	69.2, 69.4, 69.4, 69.5, 69.6, 69.8, 69.8, 70.0, 70.1, 70.2, 70.2, 70.3,
	70.4, 70.5, 70.5, 70.6, 70.7, 70.8,
	70.8, 70.9, 70.9, 70.9, 71.0, 71.1, 71.1, 71.1, 71.2, 71.3, 71.3, 71.3,
	71.3, 71.3, 71.4, 71.4, 71.4, 71.4, 71.4, 71.4, 71.5, 71.5, 71.5, 71.5,
	71.5, 71.5, 71.5, 71.5, 71.5, 71.5,
	71.5, 71.5, 71.5, 71.4, 71.4, 71.4, 71.4, 71.4, 71.4, 71.4, 71.4, 71.4,
	71.4, 71.4, 71.3, 71.3, 71.3, 71.3, 71.2, 71.2, 71.2, 71.2, 71.2, 71.1,
	71.1, 71.0, 71.0, 71.0, 71.0, 70.9,
	70.9, 70.9, 70.8, 70.8, 70.8, 70.8, 70.7, 70.7, 70.6, 70.6, 70.6, 70.5,
	70.4, 70.4, 70.4, 70.4, 70.3, 70.2, 70.2, 70.1, 70.1, 70.1, 70.0, 69.9,
	69.9, 69.8, 69.8, 69.8, 69.7, 69.6,
	69.6, 69.5, 69.4, 69.4, 69.4, 69.3, 69.2, 69.2, 69.1, 69.1, 69.0, 69.0,
	68.9, 68.8, 68.7, 68.7, 68.7, 68.6, 68.5, 68.5, 68.4, 68.3, 68.2, 68.1,
	68.1, 68.1, 68.0, 67.9, 67.8, 67.7,
	67.7, 67.6, 67.5, 67.5, 67.4, 67.3, 67.3, 67.2, 67.1, 67.0, 66.9, 66.8,
	66.8, 66.8, 66.7, 66.6, 66.5, 66.4, 66.3, 66.2, 66.1, 66.0, 65.9, 65.9,
	65.9, 65.8, 65.7, 65.6, 65.5, 65.4,
	65.3, 65.2, 65.1, 65.0, 64.9, 64.9, 64.8, 64.7, 64.6, 64.5, 64.4, 64.3,
	64.2, 64.1, 64.0, 63.9, 63.8, 63.8, 63.7, 63.6, 63.5, 63.4, 63.3, 63.2,
	63.1, 63.0, 62.9, 62.8, 62.7, 62.6,
	62.5, 62.5, 62.4, 62.2, 62.1, 62.0, 61.9, 61.8, 61.7, 61.6, 61.5, 61.4,
	61.3, 61.1, 61.0, 60.9, 60.8, 60.8, 60.7, 60.6, 60.5, 60.3, 60.2, 60.1,
	60.0, 59.9, 59.8, 59.7, 59.5, 59.4,
	59.3, 59.2, 59.1, 59.0, 58.9, 58.8, 58.7, 58.6, 58.5, 58.3, 58.2, 58.1,
	58.0, 57.9, 57.7, 57.6, 57.5, 57.4, 57.2, 57.1, 57.0, 56.9, 56.7, 56.7,
	56.6, 56.5, 56.3, 56.2, 56.1, 56.0,
	55.8, 55.7, 55.6, 55.5, 55.3, 55.2, 55.1, 54.9, 54.8, 54.7, 54.6, 54.4,
	54.3, 54.2, 54.1, 54.0, 53.9, 53.7, 53.6, 53.5, 53.3, 53.2, 53.1, 52.9,
	52.8, 52.7, 52.5, 52.4, 52.3, 52.1,
	52.0, 51.9, 51.7, 51.6, 51.4, 51.3, 51.2, 51.0, 51.0, 50.9, 50.7, 50.6,
	50.4, 50.3, 50.2, 50.0, 49.9, 49.7, 49.6, 49.5, 49.3, 49.2, 49.0, 48.9,
	48.8, 48.6, 48.5, 48.3, 48.2, 48.0,
	47.9, 47.8, 47.6, 47.5, 47.4, 47.3, 47.1, 47.0, 46.8, 46.7, 46.6, 46.4,
	46.3, 46.1, 46.0, 45.8, 45.7, 45.5, 45.4, 45.2, 45.1, 44.9, 44.8, 44.6,
	44.5, 44.3, 44.2, 44.0, 43.9, 43.7,
	43.6, 43.5, 43.4, 43.2, 43.1, 42.9, 42.8, 42.6, 42.5, 42.3, 42.2, 42.0,
	41.9, 41.7, 41.6, 41.4, 41.3, 41.1, 41.0, 40.8, 40.6, 40.5, 40.3, 40.2,
	40.0, 39.9, 39.7, 39.6, 39.4, 39.3,
	39.1, 38.9, 38.8, 38.7, 38.6, 38.4, 38.3, 38.1, 37.9, 37.8, 37.6, 37.5,
	37.3, 37.2, 37.0, 36.8, 36.7, 36.5, 36.4, 36.2, 36.0, 35.9, 35.7, 35.6,
	35.4, 35.3, 35.1, 34.9, 34.8, 34.6,
	34.5, 34.3, 34.1, 34.0, 33.9, 33.8, 33.6, 33.4, 33.3, 33.1, 32.9, 32.8,
	32.6, 32.5, 32.3, 32.1, 32.0, 31.8, 31.7, 31.5, 31.3, 31.2, 31.0, 30.8,
	30.7, 30.5, 30.4, 30.2, 30.0, 29.9,
	29.7, 29.5, 29.4, 29.2, 29.0, 28.9, 28.7, 28.6, 28.5, 28.3, 28.2, 28.0,
	27.8, 27.7, 27.5, 27.3, 27.2, 27.0, 26.8, 26.7, 26.5, 26.4, 26.2, 26.0,
	25.9, 25.7, 25.5, 25.4, 25.2, 25.0,
	24.9, 24.7, 24.5, 24.4, 24.2, 24.0, 23.9, 23.7, 23.5, 23.4, 23.2, 23.0,
	22.9, 22.8, 22.7, 22.5, 22.3, 22.2, 22.0, 21.8, 21.7, 21.5, 21.3, 21.2,
	21.0, 20.8, 20.7, 20.5, 20.3, 20.2
};

static double moon_prlx[][26]={
	{31.7, 31.9, 31.9, 32.0, 32.0, 32.2, 32.3, 32.6, 32.8, 33.0, 33.2, 33.4, 33.7, 33.8, 34.1, 34.3, 34.6},
	{32.1, 32.3, 32.3, 32.4, 32.4, 32.5, 32.7, 32.9, 33.1, 33.3, 33.4, 33.7, 33.9, 34.0, 34.2, 34.4, 34.7},
	{32.5, 32.7, 32.7, 32.7, 32.8, 32.9, 33.0, 33.2, 33.4, 33.5, 33.7, 33.9, 34.0, 34.2, 34.4, 34.6, 34.8},
	{32.9, 33.0, 33.1, 33.1, 33.1, 33.2, 33.3, 33.6, 33.7, 33.8, 34.0, 34.1, 34.2, 34.4, 34.5, 34.7, 34.9},
	{33.3, 33.4, 33.5, 33.4, 33.5, 33.6, 33.7, 33.9, 34.0, 34.1, 34.2, 34.4, 34.4, 34.6, 34.7, 34.9, 35.0},

	{33.7, 33.8, 33.9, 33.8, 33.9, 33.9, 34.1, 34.2, 34.3, 34.4, 34.5, 34.5, 34.6, 34.7, 34.9, 35.1, 35.2},
	{34.0, 34.1, 34.2, 34.1, 34.2, 34.2, 34.4, 34.4, 34.5, 34.6, 34.7, 34.7, 34.8, 34.8, 34.9, 35.1, 35.2},
	{34.4, 34.5, 34.5, 34.5, 34.5, 34.5, 34.7, 34.7, 34.8, 34.9, 34.9, 34.9, 35.0, 35.0, 35.1, 35.3, 35.4},
	{34.8, 34.9, 34.9, 34.8, 34.9, 34.9, 35.0, 35.1, 35.1, 35.1, 35.2, 35.1, 35.2, 35.2, 35.3, 35.4, 35.5},
	{35.2, 35.3, 35.3, 35.2, 35.2, 35.2, 35.4, 35.4, 35.4, 35.4, 35.4, 35.4, 35.4, 35.5, 35.5, 35.6, 35.6},

	{35.6, 35.7, 35.7, 35.6, 35.6, 35.6, 35.7, 35.7, 35.7, 35-7, 35.6, 35.6, 35.6, 35.7, 35.7, 35.7, 35.7},
	{35.9, 36.0, 36.0, 35.9, 35.9, 35.9, 36.0, 35.9, 35.9, 35.9, 35.8, 35.8, 35.7, 35.8, 35.8, 35.7, 35.7},
	{36.3, 36.4, 36.4, 36.3, 36.2, 36.2, 36.3, 36.2, 36.2, 36.2, 36.0, 36.0, 35.9, 36.0, 35.9, 35.9, 35.8},
	{36.7, 36.8, 36.8, 36.6, 36.6, 36.6, 36.6, 36.6, 36.5, 36.4, 36.3, 36.2, 36.1, 36.2, 36.1, 36.0, 35.9},
	{37.1, 37.2, 37.1, 37.0, 37.0, 36.9, 36.9, 36.9, 36.8, 36.7, 36.5, 36.5, 36.4, 36.4, 36.3, 36.2, 36.1},

	{37.5, 37.6, 37.5, 37.4, 37.3, 37.3, 37.3, 37.2, 37.1, 36.9, 36.8, 36.7, 36.6, 36.6, 36.4, 36.3, 36.2},
	{37.9, 38.0, 37.9, 37.8, 37.7, 37.6, 37.6, 37.5, 37.4, 37.2, 37.1, 36.9, 36.8, 36.7, 36.6, 36.4, 36.3},
	{38.2, 38.3, 38.2, 38.0, 38.0, 37.9, 37.9, 37.8, 37.6, 37.4, 37.3, 37.1, 37.0, 36.8, 36.7, 36.5, 36.3},
	{38.6, 38.6, 38.6, 38.4, 38.3, 38.2, 38.2, 38.1, 37.9, 37.7, 37.5, 37.3, 37.2, 37.0, 36.8, 36.6, 36.4},
	{39.0, 39.0, 39.0, 38.8, 38.7, 38.6, 38.5, 38.4, 38.2, 37.9, 37.8, 37.6, 37.4, 37.2, 37.0, 36.8, 36.5},

	{39.4, 39.4, 39.4, 39.2, 39.1, 38.9, 38.9, 38.7, 38.5, 38.2, 38.0, 37.9, 37.6, 37.4, 37.1, 36.9, 36.6},
	{39.8, 39.8, 39.7, 39.5, 39.4, 39.3, 39.2, 39.0, 38.8, 38.5, 38.3, 38.1, 37.8, 37.6, 37.3, 37.0, 36.7},
	{40.1, 40.1, 40.0, 39.8, 39.7, 39.6, 39.5, 39.3, 39.0, 38.7, 38.5, 38.3, 38.0, 37.7, 37.4, 37.1, 36.8},
	{40.5, 40.5, 40.4, 40.2, 40.1, 39.9, 39.8, 39.6, 39.3, 39.0, 38.7, 38.5, 38.2, 37.9, 37.5, 37.2, 36.9},
	{40.9, 40.9, 40.7, 40.6, 40.4, 40.2, 40.1, 39.9, 39.5, 39.3, 38.9, 38.7, 38.4, 38.1, 37.7, 37.3, 37.0},
	{41.3, 41.3, 41.1, 41.0, 40.8, 40.6, 40.5, 40.2, 39.8, 39.5, 39.2, 39.0, 38.6, 38.3, 37.9, 37.5, 37.1},
};

static double moon_prlx_ul[][26] = {
	{2.4, 2.4, 2.4, 2.5, 2.7, 2.9, 3.0, 3.1, 3.3, 3.5, 3.8, 4.0, 4.3, 4.5, 4.8, 5.0, 5.3},
	{2.6, 2.6, 2.6, 2.7, 2.9, 3.0, 3.2, 3.2, 3.4, 3.6, 3.8, 4.1, 4.3, 4.5, 4.7, 4.9, 5.2},
	{2.8, 2.8, 2.8, 2.9, 3.1, 3.2, 3.3, 3.3, 3.5, 3.7, 3.9, 4.1, 4.3, 4.5, 4.7, 4.9, 5.1},
	{3.0, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.8, 4.0, 4.1, 4.3, 4.5, 4.6, 4.8, 5.0},
	{3.2, 3.1, 3.2, 3.2, 3.4, 3.5, 3.6, 3.6, 3.7, 3.9, 4.0, 4.2, 4.3, 4.5, 4.7, 4.8, 4.9},

	{3.4, 3.3, 3.4, 3.4, 3.6, 3.6, 3.7, 3.7, 3.8, 4.0, 4.1, 4.2, 4.3, 4.5, 4.6, 4.7, 4.7},
	{3.7, 3.6, 3.7, 3.7, 3.8, 3.9, 3.8, 3.9, 4.0, 4.2, 4.3, 4.3, 4.4, 4.5, 4.6, 4.6, 4.7},
	{3.9, 3.8, 3.8, 3.9, 4.0, 4.0, 4.0, 4.0, 4.1, 4.3, 4.3, 4.4, 4.5, 4.5, 4.6, 4.6, 4.7},
	{4.1, 4.0, 4.0, 4.0, 4.2, 4.2, 4.1, 4.2, 4.2, 4.3, 4.4, 4.4, 4.5, 4.5, 4.6, 4.5, 4.6},
	{4.3, 4.2, 4.2, 4.2, 4.3, 4.3, 4.3, 4.3, 4.3, 4.4, 4.4, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5},

	{4.5, 4.4, 4.4, 4.4, 4.5, 4.5, 4.4, 4.4, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.4, 4.4},
	{4.8, 4.7, 4.7, 4.7, 4.8, 4.8, 4.6, 4.6, 4.7, 4.7, 4.7, 4.6, 4.6, 4.5, 4.5, 4.4, 4.4},
	{5.0, 4.9, 4.9, 4.9, 4.9, 4.9, 4.8, 4.7, 4.8, 4.8, 4.7, 4.7, 4.6, 4.5, 4.5, 4.4, 4.3},
	{5.2, 5.1, 5.1, 5.0, 5.1, 5.1, 4.9, 4.9, 4.9, 4.8, 4.8, 4.7, 4.6, 4.5, 4.4, 4.3, 4.2},
	{5.4, 5.3, 5.2, 5.2, 5.3, 5.2, 5.1, 5.0, 5.0, 4.9, 4.8, 4.8, 4.7, 4.5, 4.4, 4.3, 4.2},

	{5.6, 5.5, 5.4, 5.4, 5.4, 5.4, 5.2, 5.1, 5.1, 5.0, 4.9, 4.8, 4.7, 4.5, 4.3, 4.2, 4.1},
	{5.8, 5.7, 5.6, 5.6, 5.6, 5.5, 5.3, 5.2, 5.2, 5.1, 5.0, 4.8, 4.7, 4.5, 4.3, 4.2, 4.0},
	{6.1, 6.0, 5.9, 5.8, 5.9, 5.8, 5.6, 5.5, 5.4, 5.3, 5.1, 5.0, 4.7, 4.5, 4.3, 4.3, 4.0},
	{6.3, 6.1, 6.1, 6.1, 6.0, 5.9, 5.7, 5.7, 5.5, 5.4, 5.2, 5.0, 4.7, 4.5, 4.4, 4.2, 4.0},
	{6.5, 6.3, 6.3, 6.3, 6.2, 6.1, 5.8, 5.8, 5.6, 5.4, 5.3, 5.0, 4.7, 4.5, 4.4, 4.2, 3.9},

	{6.7, 6.5, 6.5, 6.5, 6.4, 6.2, 6.0, 5.9, 5.7, 5.5, 5.3, 5.0, 4.7, 4.6, 4.3, 4.1, 3.8},
	{6.9, 6.7, 6.6, 6.6, 6.5, 6.4, 6.1, 6.0, 5.8, 5.6, 5.4, 5.0, 4.8, 4.6, 4.3, 4.0, 3.7},
	{7.2, 7.0, 6.9, 6.9, 6.8, 6.6, 6.4, 6.3, 6.0, 5.8, 5.5, 5.2, 4.9, 4.7, 4.3, 4.0, 3.7},
	{7.4, 7.2, 7.1, 7.1, 7.0, 6.8, 6.5, 6.4, 6.1, 5.9, 5.6, 5.2, 4.9, 4.7, 4.3, 4.0, 3.7},
	{7.6, 7.4, 7.3, 7.3, 7.1, 6.9, 6.6, 6.5, 6.2, 6.0, 5.6, 5.2, 5.0, 4.7, 4.3, 3.9, 3.6},
	{7.8, 7.6, 7.5, 7.5, 7.3, 7.1, 7.0, 6.6, 6.3, 6.0, 5.7, 5.3, 5.0, 4.7, 4.3, 3.9, 3.5},
};

static double sun_lw_limb[] = {

	0.0, 40.3, 40.2, 40.1, 40.0, 39.8, 39.8, 39.8, 39.8, 39.9, 40.1, 40.2, 40.3,
};

static double sun_up_limb[] = {
	0.0, 7.7, 7.8, 7.8, 8.0, 8.2, 8.2, 8.2, 8.2, 8.1, 7.9, 7.8, 7.7,
};



HCorrection::HCorrection()
{
	moon_altitude = 4.8333334;
	for(int a = 0; a<514; a++){
		moon_alt[a] = moon_altitude;
		moon_altitude += 0.1666666;
	}
}

double HCorrection::CalcDip(double e)
{
	
	int a;
	double dip;
	dip = 19.1;
	if(e > 45.42)
		goto label;
	for(a = 0;a < sizeof(eye_ht);a++ )
	{
		dip = dip - 0.1;
			if(e <= eye_ht[a])
			{
				goto label;

			}
	}
label:
		return dip;
}

double HCorrection::CalcRefrac(double obs_h)
{

	int a;
	double refract;
	refract = 28.9;
	if(obs_h > 90.0)
		goto label;
	for(a = 0;a < sizeof(obs_ht);a++ )
	{
		refract = refract + 0.1;
			if(obs_h <= obs_ht[a])
			{
				goto label;

			}
	}
label:
		return refract;
}

double HCorrection::CalcSunRefrac(double obs_h)
{

	int a;
	double refract;
	refract = 5.0;
	if(obs_h > 90.0)
		goto label;
	for(a = 0;a < sizeof(obs_ht);a++ )
	{
		refract = refract + 0.1;
			if(obs_h <= obs_ht[a])
			{
				goto label;

			}
	}
label:
		return refract;
}

double HCorrection::moon_trd_coor(double px, double obs_h)
{
	
	double prlx_corr;
	int x,y;
	for(int a =0; a<sizeof(prlx); a++)
		if(px <= prlx[a])
		{
			x = a;
			goto label;
		}
		label:
	for(int b = 0; b < sizeof(mean_alt); b++)
		if(obs_h <= mean_alt[b])
		{
			y = b;
			goto label1;
		}
		label1:
		prlx_corr = moon_prlx[x][y];
		return prlx_corr;
}

double HCorrection::moon_trd_up_coor(double px, double obs_h)//upper limb
{

	double prlx_corr;
	int x,y;
	for(int a =0; a<sizeof(prlx); a++)
		if(px <= prlx[a])
		{
			x = a;
			goto label;
		}
		label:
	for(int b = 0; b < sizeof(mean_alt); b++)
		if(obs_h <= mean_alt[b])
		{
			y = b;
			goto label1;
		}
		label1:
		prlx_corr = moon_prlx_ul[x][y];
		return prlx_corr;
}

double HCorrection::calc_sun_llimb(int mon)
{
	double low_limb_corr;
	low_limb_corr = sun_lw_limb[mon];
	return low_limb_corr;

}

double HCorrection::calc_sun_uplimb(int mon)
{
	double up_limb_corr;
	up_limb_corr = sun_up_limb[mon];
	return up_limb_corr;

}

double HCorrection::moon_snd_coor(double obs_h)
{
	double moon_snd;
	for(int a = 0; a < 514; a++)
		if(obs_h <=moon_alt[a]){
			moon_snd = moon_refrac[a];
			goto label;
		}
		label:
		return moon_snd;
}

double HCorrection::sun_corr(double e, double obs_h,double mon, bool ch)
{
	double dip = CalcDip(e);
	double refrac = CalcSunRefrac(obs_h);
	double low_limb = calc_sun_llimb(mon);
	double up_limb = calc_sun_uplimb(mon);
	if(ch)
		low_limb = 0;
	else
		up_limb = 0;
	double correction = (dip + refrac + low_limb + up_limb - 60) / 60;
	double true_alt = obs_h + correction;
	return true_alt;

}

double HCorrection::moon_corr(double e,double px, double obs_h, bool ch)
{
	double dip = CalcDip(e);
	double snd_corr = moon_snd_coor(obs_h);
	double low_limb = moon_trd_coor(px,obs_h);
	double up_limb = moon_trd_up_coor(px,obs_h);
	if(ch)
		low_limb = 0;
	else
		up_limb = 0;
	double correction = (dip + snd_corr + low_limb + up_limb - 60) / 60;
	double true_alt = obs_h + correction;
	return true_alt;
}

double HCorrection::stars_corr(double e, double obs_h)
{
	double dip = CalcDip(e);
	double refrac = CalcRefrac(obs_h);
	double correction = (dip + refrac - 60) / 60;
	double true_alt = obs_h + correction;
	return true_alt;
}

double HCorrection::plan_corr(double e, double obs_h,double prlx)
{
	double dip = CalcDip(e);
	double refrac = CalcRefrac(obs_h);
	double correction = (dip + refrac + prlx - 60) / 60;
	double true_alt = obs_h + correction;
	return true_alt;
}

HCorrection::~HCorrection()
{
}

