/* 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Authors:        Andrew Hutchings, SkySQL (andrew at skysql dot com)
*/
#ifndef _common_h
#define _common_h

char *hostname=NULL;
char *username=NULL;
char *password=NULL;
char *socket_path=NULL;
char *db=NULL;
char *defaults_file=NULL;
#ifdef WITH_SSL
char *key=NULL;
char *cert=NULL;
char *ca=NULL;
char *capath=NULL;
char *cipher=NULL;
#endif

gboolean askPassword=FALSE;
guint port=0;
guint num_threads= 4;
guint verbose=2;
gboolean ssl= FALSE;
gboolean compress_protocol= FALSE;
gboolean program_version= FALSE;

GOptionEntry common_entries[] =
{
        { "host", 'h', 0, G_OPTION_ARG_STRING, &hostname, "The host to connect to", NULL },
        { "user", 'u', 0, G_OPTION_ARG_STRING, &username, "Username with the necessary privileges", NULL },
        { "password", 'p', 0, G_OPTION_ARG_STRING, &password, "User password", NULL },
        { "ask-password", 'a', 0, G_OPTION_ARG_NONE, &askPassword, "Prompt For User password", NULL },
        { "port", 'P', 0, G_OPTION_ARG_INT, &port, "TCP/IP port to connect to", NULL },
        { "socket", 'S', 0, G_OPTION_ARG_STRING, &socket_path, "UNIX domain socket file to use for connection", NULL },
        { "threads", 't', 0, G_OPTION_ARG_INT, &num_threads, "Number of threads to use, default 4", NULL },
        { "compress-protocol", 'C', 0, G_OPTION_ARG_NONE, &compress_protocol, "Use compression on the MySQL connection", NULL },
        { "version", 'V', 0, G_OPTION_ARG_NONE, &program_version, "Show the program version and exit", NULL },
        { "verbose", 'v', 0, G_OPTION_ARG_INT, &verbose, "Verbosity of output, 0 = silent, 1 = errors, 2 = warnings, 3 = info, default 2", NULL },
        { "defaults-file", 0, 0, G_OPTION_ARG_FILENAME, &defaults_file, "Use a specific defaults file",  NULL },
#ifdef WITH_SSL
		{ "ssl", 0, 0, G_OPTION_ARG_NONE, &ssl, "Connect using SSL", NULL},
        { "key", 0, 0, G_OPTION_ARG_STRING, &key, "The path name to the key file", NULL },
        { "cert", 0, 0, G_OPTION_ARG_STRING, &cert, "The path name to the certificate file", NULL },
        { "ca", 0, 0, G_OPTION_ARG_STRING, &ca, "The path name to the certificate authority file", NULL },
        { "capath", 0, 0, G_OPTION_ARG_STRING, &capath, "The path name to a directory that contains trusted SSL CA certificates in PEM format", NULL },
        { "cipher", 0, 0, G_OPTION_ARG_STRING, &cipher, "A list of permissible ciphers to use for SSL encryption", NULL },
#endif
        { NULL, 0, 0, G_OPTION_ARG_NONE,   NULL, NULL, NULL }
};

#endif
