

wget https://integral.physics.muni.cz/ftp/munipack/munipack-data-m67.tar.gz
tar zxf munipack-data-m67.tar.gz
cd munipack-data-m67/

# darks
munipack dark -o d7.fits d7_*.fits &
munipack dark -o d30.fits d30_*.fits &
wait

# flats
munipack flat -o fB.fits -dark d7.fits flat_*B.fits &
munipack flat -o fV.fits -dark d7.fits flat_*V.fits &
munipack flat -o fR.fits -dark d7.fits flat_*R.fits &
wait

# precorr
munipack phcorr -dark d30.fits -flat fB.fits m67_*B.fits &
munipack phcorr -dark d30.fits -flat fV.fits m67_*V.fits &
munipack phcorr -dark d30.fits -flat fR.fits m67_*R.fits &
wait

# find, aperture photometry
munipack find -th 10 -f 6 m67_*_proc.fits
munipack aphot m67_*_proc.fits

# astrometry
munipack cone -r 0.2 --magmax 14 --  132.8 11.8
munipack astrometry -c cone.fits m67_*_proc.fits

# collect
munipack kombine --rcen 132.8304 --dcen 11.7771 -o m67_B.fits m67_*B_proc.fits
munipack kombine --rcen 132.8304 --dcen 11.7771 -o m67_V.fits m67_*V_proc.fits
munipack kombine --rcen 132.8304 --dcen 11.7771 -o m67_R.fits m67_*R_proc.fits

# find, aperture photometry
munipack find -th 10 -f 6 m67_?.fits
munipack aphot m67_?.fits

# photometry calibration by UCAC4
munipack cone -r 0.2 --magmax 14 --Johnson-patch -o phcal_cone.fits -- 132.8 11.8
munipack phcal --photsys-ref Johnson -f B --area 0.3 --col-mag Bmag \
	 --col-magerr e_Bmag -c phcal_cone.fits m67_B.fits
munipack phcal --photsys-ref Johnson -f V --area 0.3 --col-mag Vmag \
	 --col-magerr e_Vmag -c phcal_cone.fits m67_V.fits
munipack phcal --photsys-ref Johnson -f R --area 0.3 --col-mag Rmag \
	 --col-magerr e_Rmag -c phcal_cone.fits m67_R.fits
