%{
#include "stdio.h"  // for fileno() prototype
#include "string.h" // for strdup() prototype
#include "mlr_dsl_parse.h"
#include "../containers/mlr_dsl_ast.h"
// http://flex.sourceforge.net/manual/Extra-Data.html
%}

%option reentrant
%option noyywrap
%option extra-type="struct _mlr_dsl_ast_node_t **"

%%
";" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_SEMICOLON;
}
"{" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_LEFT_BRACE;
}
"}" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_RIGHT_BRACE;
}

"=" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_SREC_ASSIGNMENT);
	return MD_TOKEN_ASSIGN;
}

"filter" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_FILTER);
	return MD_TOKEN_FILTER;
}
"gate" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_GATE);
	return MD_TOKEN_GATE;
}
"emit" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_EMIT);
	return MD_TOKEN_EMIT;
}
"dump" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_DUMP);
	return MD_TOKEN_DUMP;
}
"begin" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_BEGIN;
}
"end" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_END;
}

"?" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_QUESTION_MARK;
}

":" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_COLON;
}

"||" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LOGICAL_OR;
}
"^^" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LOGICAL_XOR;
}
"&&" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LOGICAL_AND;
}

"=~" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_MATCHES;
}
"!=~" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_DOES_NOT_MATCH;
}
"==" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_EQ;
}
"!=" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_NE;
}

">" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_GT;
}
">=" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_GE;
}
"<" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LT;
}
"<=" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LE;
}

"|" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_OR;
}

"^" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_XOR;
}

"&" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_AND;
}

"<<" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_LSH;
}
">>" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_RSH;
}

"+" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_PLUS;
}
"-" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_MINUS;
}
"\." {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_DOT;
}

"*" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_TIMES;
}
"/" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_DIVIDE;
}
"//" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_INT_DIVIDE;
}
"%" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_MOD;
}

"!" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_LOGICAL_NOT;
}

"~" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_BITWISE_NOT;
}

"**" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OPERATOR);
	return MD_TOKEN_POW;
}

\$[a-zA-Z_0-9]+ {
	// Note: the parser depends on the dollar sign being here. If this is changed,
	// that needs to be changed as well.
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_FIELD_NAME);
	return MD_TOKEN_FIELD_NAME;
}
\$\{([^\}]|\\.)*\} {
	// Note: the parser depends on the dollar sign being here. If this is changed,
	// that needs to be changed as well.
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_FIELD_NAME);
	return MD_TOKEN_BRACED_FIELD_NAME;
}

@[a-zA-Z_0-9]+ {
	// Note: the parser depends on the at-sign being here. If this is changed,
	// that needs to be changed as well.
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OOSVAR_NAME);
	return MD_TOKEN_OOSVAR_NAME;
}
@\{([^\}]|\\.)*\} {
	// Note: the parser depends on the percent-sign being here. If this is changed,
	// that needs to be changed as well.
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_OOSVAR_NAME);
	return MD_TOKEN_BRACED_OOSVAR_NAME;
}
"\[" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_LEFT_BRACKET;
}
"\]" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_RIGHT_BRACKET;
}

[0-9]+|[0-9]+\.[0-9]*|[0-9]*\.[0-9]+|[0-9]+[eE][0-9]+|[0-9]+[eE]-[0-9]+|[0-9]+\.[0-9]*[eE][0-9]+|[0-9]+\.[0-9]*[eE]-[0-9]+|[0-9]*\.[0-9]+[eE][0-9]+|[0-9]*\.[0-9]+[eE]-[0-9]+ {
	// Leading minus sign is handled via the unary-minus operator, not here.
	// 123
	// 123. 123.4
	// .234
	// 1e2
	// 1e-2
	// 1.2e3 1.e3
	// 1.2e-3 1.e-3
	// .2e3
	// .2e-3 1.e-3
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRNUM_LITERAL);
	return MD_TOKEN_NUMBER;
}
0x[0-9a-fA-F]+ {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRNUM_LITERAL);
	return MD_TOKEN_NUMBER;
}

\"([^\\\"]|\\.)*\" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRNUM_LITERAL);
	return MD_TOKEN_STRING;
}

\"([^\\\"]|\\.)*\"\i {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_REGEXI);
	return MD_TOKEN_REGEXI;
}

true {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_BOOLEAN_LITERAL);
	return MD_TOKEN_TRUE;
}
false {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_BOOLEAN_LITERAL);
	return MD_TOKEN_FALSE;
}

"NF" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"NR" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"FNR" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"FILENAME" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"FILENUM" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"PI" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"E" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_CONTEXT_VARIABLE);
	return MD_TOKEN_CONTEXT_VARIABLE;
}
"ENV" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_ENV);
	return MD_TOKEN_ENV;
}

[a-zA-Z_][a-zA-Z_0-9]+ {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_FUNCTION_NAME);
	return MD_TOKEN_FCN_NAME;
}

"(" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_LPAREN;
}
")" {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_RPAREN;
}

"," {
	*yyextra = mlr_dsl_ast_node_alloc(yytext, MD_AST_NODE_TYPE_STRIPPED_AWAY);
	return MD_TOKEN_COMMA;
}

[ \t\r\n] { }

. {
	return -1;
}
%%
