C **************************** LICENSE START ***********************************
C
C Copyright 2012 ECMWF and INPE. This software is distributed under the terms
C of the Apache License version 2.0. In applying this license, ECMWF does not
C waive the privileges and immunities granted to it by virtue of its status as
C an Intergovernmental Organization or submit itself to any jurisdiction.
C
C ***************************** LICENSE END ************************************

      FUNCTION SSHM(T,PMB,KLOLDM)
C
C     THIS FUNCTION RETURNS THE SATURATION SPECIFIC HUMIDITY GIVEN
C     T (K) AND P (MB)
C     THE FORMULA AND CONSTANTS USED ARE TAKEN FROM THE ECMWF FORECAST
C     MODEL DOCUMENTATION MANUAL VOL.I-8/79, PAGE 2.34
C
      LOGICAL KLOLDM

      T0=273.16
      RD=287.05
      RV=461.51
      EP = RD/RV
      PR = 100.*PMB
C
C     CALCULATE THE SATURATION WATER VAPOUR PRESSURE
C
      IF(T.GE.T0 .OR. KLOLDM ) THEN
         A = 17.269
         B = 35.86
      ELSE
         A = 21.875
         B =  7.66
      ENDIF
      SWVP = 610.78*EXP(A*(T-T0)/(T-B))
C
C     CALCULATE THE SATURATION SPECIFIC HUMIDITY
C
      IF( KLOLDM ) THEN
         SSHM = EP*SWVP/PR
      ELSE
         SSHM = EP*SWVP/( PR - (1.-EP)*SWVP )
      ENDIF

      RETURN
      END
