/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExportDialog_H
#define ExportDialog_H

#include <QComboBox>
#include <QFileDialog>
#include <QGridLayout>
#include <QLineEdit>
#include <QToolButton>
#include <QRadioButton>

#include "MvRequest.h"

using namespace std;

class ExportDialog : public QFileDialog
{
    Q_OBJECT

public:
    ExportDialog(int, int, const string&, bool, QWidget* parent = 0);
    ~ExportDialog();

    void edited(MvRequest&);
    const MvRequest& reqOut() const {return reqOut_;}

public slots:
    void accept();
    void slotEditFormat();
    void slotRangeFrameSelection(bool);

private:
    const char* getFormatVerb(string);
    bool getFrameSelection(MvRequest&);
    void buildFrameSelection(int, int, QGridLayout*,
                             const std::vector<bool>&, const QString&, bool);
    void errorMessage(const char*, const char* = 0);

    int current_;           // Current frame
    int total_;             // Total number of frames
    bool export_qt_{false}; // qt driver
    MvRequest reqFormats_;  // list of output formats requests
    QComboBox* comboBox_;   // List of output formats
    QToolButton* bEdit_;    // Edit button
    QLineEdit* leFs3_;      // Frame selection: line edit
    QRadioButton* cbFs1_;   // Frame selection: Current radio button
    QRadioButton* cbFs2_;   // Frame selection: All radio button
    QRadioButton* cbFs3_;   // Frame selection: Range radio button
    MvRequest reqOut_;
};

#endif
