/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef GAIA_H
#define GAIA_H

//*****************************************************************
//  Application Gaia
//
//  Access GRIB/BUFR/NETCDF data from the Navy's storage directories
//*****************************************************************

#include <Metview.h>

class Gaia : public MvService
{
public:
    Gaia(char* name) :
        MvService(name){};

    void serve(MvRequest&, MvRequest&);

    // Get some input arguments
    bool get_common_input_info(const MvRequest&);

    // Convert integer numbers to strings with '0's on the left
    void left_pad_string(const vector<int>&, int, vector<string>&);

    // Build the path
    bool build_path(MvRequest&);

    // Build filenames
    bool build_filenames(MvRequest&, vector<string>&);
    bool build_filenames_model(MvRequest&, vector<string>&);
    bool build_filenames_observation(MvRequest&, vector<string>&);
    bool build_filenames_ww3(MvRequest&, vector<string>&, vector<string>&);
    bool build_filenames_icon(vector<string>&, vector<string>&, string&,
                              vector<string>&);
    bool build_filenames_icon_single(const vector<string>&, vector<string>&);
    bool build_filenames_cosmo(string&, vector<string>&, vector<string>&,
                               vector<string>&);
    bool build_filenames_wrf(const string&, const string&,
                             const vector<string>&, const vector<string>&,
                             vector<string>&);
    bool build_filenames_adcirc(MvRequest&, vector<string>&);
    bool build_filenames_gfs(vector<string>&, vector<string>&,
                             vector<string>&);

    bool get_filenames(const string&, const string&, const string&,
                       vector<string>&);
    bool get_filenames(const string&, const string&, const string&,
                       const string&, const long, const long, vector<string>&);

    // Build output data file
    string bufr_obs(const vector<string>&);
    string grib_icon_model(const vector<string>&);
    string grib_icon_single_model(const vector<string>&);
    string grib_cosmo_wrf_gfs_model(const vector<string>&);

    // Add messages to a grib file
    bool add_messages(const string&, const string&);
    bool add_messages_tpl(const string&, const string&);

    // Split string according to a single caracter
    vector<string> split(const string&, char);

private:
    vector<string> dates_;
    vector<string> sparams_;
    vector<int> ilevels_;
    vector<int> times_;
    vector<int> isteps_;
    string spath_;
    string slevel_type_;
    float resX_, resY_;
};

#endif
