#include "pdf/pilot.h"
      SUBROUTINE GS96LO(X,Q,U,D,S,C,B,G)
#include "pdf/impdp.inc"
      PARAMETER(NP=78,NQ=11,NARG=2)
*****************************************************************
* Subroutine returns the parton distributions in the photon in  *
* leading order. u,d etc. gives the actual distributions and    *
* not x times the distributions; Q2 means Q^2. The distributions*
* are valid for 5.0e^-4< x < 1.0 and 5.3 GeV^2 < Q^2 < 1.0e^8.  *
* if higher Q^2 or lower x is required, these may be obtained   *
* from the authors on request.                                  * 
* Lionel Gordon April 1996 : Gordon@hep.anl.gov                 *
* John Storrow             :johns@a3.ph.man.ac.uk               *
*****************************************************************
      DIMENSION SIG(NP,NQ),QNS(NP,NQ),GL(NP,NQ),Y(NP)
      DIMENSION XT(NARG),NA(NARG),A(NP+NQ),QT(NQ)
      EXTERNAL GS2XCOR
      SAVE SIG,QNS,GL,Y,ICALL
      DATA QT /3.0D0,20.0D0,50.0D0,100.0D0,500.0D0,1.0D3,1.0D4,1.0D5,
     + 1.0D6,1.0D7,1.0D8/
******************************************************************
        DATA ((SIG(IX,IQ),IQ=1,11),IX=1,6)/
     +   .70233650E+01,  .16165820E+02,  .22649760E+02,  .35495220E+02,
     +   .65474820E+02,  .79231610E+02,  .12861310E+03,  .18177080E+03,
     +   .23718420E+03,  .29398330E+03,  .35164760E+03,
     +   .24311790E+01,  .56410560E+01,  .77057210E+01,  .11734420E+02,
     +   .20492340E+02,  .24322600E+02,  .37461360E+02,  .50877500E+02,
     +   .64331550E+02,  .77721700E+02,  .91007210E+02,
     +   .14971770E+01,  .33650050E+01,  .44991710E+01,  .66884180E+01,
     +   .11271360E+02,  .13227810E+02,  .19793990E+02,  .26335880E+02,
     +   .32785410E+02,  .39126610E+02,  .45362620E+02,
     +   .10921390E+01,  .23762350E+01,  .31245750E+01,  .45575990E+01,
     +   .74802520E+01,  .87078440E+01,  .12769890E+02,  .16754230E+02,
     +   .20641820E+02,  .24437220E+02,  .28151560E+02,
     +   .86489230E+00,  .18280090E+01,  .23716390E+01,  .34062140E+01,
     +   .54744220E+01,  .63325540E+01,  .91427930E+01,  .11868580E+02,
     +   .14509180E+02,  .17075190E+02,  .19578820E+02,
     +   .71901990E+00,  .14813820E+01,  .19005850E+01,  .26943770E+01,
     +   .42556170E+01,  .48970560E+01,  .69807250E+01,  .89845070E+01,
     +   .10915430E+02,  .12785660E+02,  .14606780E+02 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=7,12)/
     +   .61723300E+00,  .12432440E+01,  .15799330E+01,  .22148420E+01,
     +   .34465520E+01,  .39484520E+01,  .55681480E+01,  .71151260E+01,
     +   .85998060E+01,  .10034390E+02,  .11429420E+02,
     +   .54204300E+00,  .10699620E+01,  .13485000E+01,  .18719250E+01,
     +   .28753520E+01,  .32813470E+01,  .45843660E+01,  .58219380E+01,
     +   .70058830E+01,  .81478560E+01,  .92573340E+01,
     +   .48415250E+00,  .93844130E+00,  .11741140E+01,  .16156780E+01,
     +   .24533400E+01,  .27901670E+01,  .38661630E+01,  .48833590E+01,
     +   .58539990E+01,  .67889940E+01,  .76968530E+01,
     +   .43815400E+00,  .83533890E+00,  .10383010E+01,  .14176170E+01,
     +   .21304710E+01,  .24155340E+01,  .33225110E+01,  .41765600E+01,
     +   .49898510E+01,  .57725110E+01,  .65321960E+01,
     +   .29240730E+00,  .51945260E+00,  .62849450E+00,  .83051500E+00,
     +   .11956680E+01,  .13384320E+01,  .17859910E+01,  .22018350E+01,
     +   .25955570E+01,  .29738200E+01,  .33411740E+01,
     +   .22771950E+00,  .38647540E+00,  .45986050E+00,  .59540790E+00,
     +   .83445110E+00,  .92663030E+00,  .12135430E+01,  .14787420E+01,
     +   .17296330E+01,  .19709840E+01,  .22058840E+01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=13,18)/
     +   .18804090E+00,  .30803060E+00,  .36194060E+00,  .46150040E+00,
     +   .63379280E+00,  .69956000E+00,  .90347860E+00,  .10916570E+01,
     +   .12699170E+01,  .14418210E+01,  .16095890E+01,
     +   .16106230E+00,  .25639660E+00,  .29829840E+00,  .37582780E+00,
     +   .50798110E+00,  .55803760E+00,  .71298070E+00,  .85604630E+00,
     +   .99191000E+00,  .11233210E+01,  .12519440E+01,
     +   .14144340E+00,  .21987620E+00,  .25375560E+00,  .31665930E+00,
     +   .42255270E+00,  .46242310E+00,  .58580990E+00,  .69996700E+00,
     +   .80871960E+00,  .91424490E+00,  .10178260E+01,
     +   .12648450E+00,  .19269370E+00,  .22089650E+00,  .27351290E+00,
     +   .36116160E+00,  .39400900E+00,  .49574770E+00,  .59015340E+00,
     +   .68040390E+00,  .76825760E+00,  .85472490E+00,
     +   .11467010E+00,  .17166800E+00,  .19566950E+00,  .24073410E+00,
     +   .31512060E+00,  .34289780E+00,  .42907090E+00,  .50931720E+00,
     +   .58630930E+00,  .66148940E+00,  .73566840E+00,
     +   .10508230E+00,  .15432960E+00,  .17493660E+00,  .21482420E+00,
     +   .27930330E+00,  .30330860E+00,  .37792090E+00,  .44765370E+00,
     +   .51478960E+00,  .58053120E+00,  .64554070E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=19,24)/
     +   .97131789E-01,  .14084660E+00,  .15900900E+00,  .19428030E+00,
     +   .25102050E+00,  .27209930E+00,  .33777610E+00,  .39940580E+00,
     +   .45894800E+00,  .51741330E+00,  .57534640E+00,
     +   .90422034E-01,  .12963520E+00,  .14583600E+00,  .17742940E+00,
     +   .22803570E+00,  .24680480E+00,  .30544260E+00,  .36069220E+00,
     +   .41424930E+00,  .46697050E+00,  .51930820E+00,
     +   .84676370E-01,  .12016500E+00,  .13476290E+00,  .16336950E+00,
     +   .20901730E+00,  .22592660E+00,  .27890360E+00,  .32902210E+00,
     +   .37775960E+00,  .42584740E+00,  .47366380E+00,
     +   .79695620E-01,  .11205840E+00,  .12532620E+00,  .15146720E+00,
     +   .19303900E+00,  .20842480E+00,  .25676830E+00,  .30268500E+00,
     +   .34746950E+00,  .39175020E+00,  .43584570E+00,
     +   .75332552E-01,  .10503960E+00,  .11718890E+00,  .14126560E+00,
     +   .17943800E+00,  .19355690E+00,  .23804960E+00,  .28047120E+00,
     +   .32196180E+00,  .36306450E+00,  .40404830E+00,
     +   .71475916E-01,  .98902315E-01,  .11009980E+00,  .13242690E+00,
     +   .16772780E+00,  .18077960E+00,  .22202890E+00,  .26150320E+00,
     +   .30021130E+00,  .33862380E+00,  .37696920E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=25,30)/
     +   .68039946E-01,  .93488976E-01,  .10386800E+00,  .12469620E+00,
     +   .15754450E+00,  .16968690E+00,  .20817210E+00,  .24513120E+00,
     +   .28145950E+00,  .31756730E+00,  .35364870E+00,
     +   .64957649E-01,  .88677347E-01,  .98345891E-01,  .11787750E+00,
     +   .14860990E+00,  .15996950E+00,  .19607450E+00,  .23086390E+00,
     +   .26513530E+00,  .29924710E+00,  .33336460E+00,
     +   .62175583E-01,  .84369965E-01,  .93415700E-01,  .11181690E+00,
     +   .14070770E+00,  .15138750E+00,  .18542390E+00,  .21832420E+00,
     +   .25080060E+00,  .28316720E+00,  .31556580E+00,
     +   .59650775E-01,  .80420166E-01,  .88902399E-01,  .10637240E+00,
     +   .13365770E+00,  .14374470E+00,  .17597350E+00,  .20721680E+00,
     +   .23811440E+00,  .26894210E+00,  .29982100E+00,
     +   .51509041E-01,  .68176709E-01,  .75015508E-01,  .89448459E-01,
     +   .11187040E+00,  .12017020E+00,  .14694140E+00,  .17316310E+00,
     +   .19925500E+00,  .22538240E+00,  .25160820E+00,
     +   .45536134E-01,  .59398353E-01,  .65131053E-01,  .77530891E-01,
     +   .96705496E-01,  .10381690E+00,  .12693770E+00,  .14976790E+00,
     +   .17258700E+00,  .19549320E+00,  .21851570E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=31,36)/
     +   .40955305E-01,  .52766804E-01,  .57704475E-01,  .68659775E-01,
     +   .85510314E-01,  .91773830E-01,  .11227210E+00,  .13264130E+00,
     +   .15306790E+00,  .17360690E+00,  .19426700E+00,
     +   .37324660E-01,  .47601301E-01,  .51943392E-01,  .61794415E-01,
     +   .76885954E-01,  .82510278E-01,  .10101900E+00,  .11950580E+00,
     +   .13809150E+00,  .15680180E+00,  .17563260E+00,
     +   .34372974E-01,  .43435521E-01,  .47311056E-01,  .56301422E-01,
     +   .70009246E-01,  .75133115E-01,  .92074446E-01,  .10906660E+00,
     +   .12618310E+00,  .14342960E+00,  .16079300E+00,
     +   .31923808E-01,  .40012788E-01,  .43512553E-01,  .51803045E-01,
     +   .64385124E-01,  .69104590E-01,  .84772743E-01,  .10054340E+00,
     +   .11645470E+00,  .13249750E+00,  .14865270E+00,
     +   .29857013E-01,  .37139244E-01,  .40328316E-01,  .48041262E-01,
     +   .59685305E-01,  .64070739E-01,  .78682460E-01,  .93434341E-01,
     +   .10833710E+00,  .12337080E+00,  .13851210E+00,
     +   .28087676E-01,  .34687765E-01,  .37615880E-01,  .44843495E-01,
     +   .55690806E-01,  .59795659E-01,  .73516525E-01,  .87405436E-01,
     +   .10145160E+00,  .11562690E+00,  .12990470E+00 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=37,42)/
     +   .26553867E-01,  .32570735E-01,  .35275102E-01,  .42089522E-01,
     +   .52249193E-01,  .56115251E-01,  .69075659E-01,  .82225241E-01,
     +   .95535874E-01,  .10897300E+00,  .12250760E+00,
     +   .25209235E-01,  .30719869E-01,  .33231538E-01,  .39689910E-01,
     +   .49249481E-01,  .52910630E-01,  .65216698E-01,  .77728003E-01,
     +   .90402141E-01,  .10319940E+00,  .11608920E+00,
     +   .24018301E-01,  .29084699E-01,  .31427387E-01,  .37579320E-01,
     +   .46610452E-01,  .50094768E-01,  .61834782E-01,  .73792145E-01,
     +   .85912563E-01,  .98152287E-01,  .11047950E+00,
     +   .22953326E-01,  .27626833E-01,  .29821219E-01,  .35707723E-01,
     +   .44270609E-01,  .47601912E-01,  .58850951E-01,  .70326120E-01,
     +   .81963196E-01,  .93715243E-01,  .10554960E+00,
     +   .21992300E-01,  .26317418E-01,  .28381797E-01,  .34036707E-01,
     +   .42182721E-01,  .45381572E-01,  .56204535E-01,  .67259535E-01,
     +   .78474045E-01,  .89798547E-01,  .10120000E+00,
     +   .21117412E-01,  .25130259E-01,  .27079122E-01,  .32535497E-01,
     +   .40309582E-01,  .43394115E-01,  .53848099E-01,  .64537331E-01,
     +   .75382322E-01,  .86331800E-01,  .97352557E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=43,48)/
     +   .20314088E-01,  .24048898E-01,  .25896588E-01,  .31180535E-01,
     +   .38622063E-01,  .41608363E-01,  .51744010E-01,  .62115550E-01,
     +   .72637826E-01,  .83258361E-01,  .93944140E-01,
     +   .19570207E-01,  .23054440E-01,  .24812274E-01,  .29951232E-01,
     +   .37095614E-01,  .39998349E-01,  .49861446E-01,  .59958387E-01,
     +   .70199609E-01,  .80532081E-01,  .90923406E-01,
     +   .18875565E-01,  .22135690E-01,  .23814905E-01,  .28832132E-01,
     +   .35710733E-01,  .38543295E-01,  .48175458E-01,  .58036570E-01,
     +   .68034008E-01,  .78114823E-01,  .88247612E-01,
     +   .18221470E-01,  .21283235E-01,  .22894613E-01,  .27810007E-01,
     +   .34449894E-01,  .37224889E-01,  .46664707E-01,  .56325421E-01,
     +   .66112675E-01,  .75974435E-01,  .85880660E-01,
     +   .17600402E-01,  .20484766E-01,  .22037288E-01,  .26872966E-01,
     +   .33294700E-01,  .36024913E-01,  .45310233E-01,  .54803822E-01,
     +   .64411715E-01,  .74083857E-01,  .83792232E-01,
     +   .17005796E-01,  .19735906E-01,  .21239230E-01,  .26012382E-01,
     +   .32214422E-01,  .34919977E-01,  .44098802E-01,  .53459194E-01,
     +   .62916011E-01,  .72424434E-01,  .81959791E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=49,54)/
     +   .16431818E-01,  .19026265E-01,  .20488355E-01,  .25218941E-01,
     +   .31340595E-01,  .34012362E-01,  .43073423E-01,  .52304987E-01,
     +   .61622459E-01,  .70982762E-01,  .80362923E-01,
     +   .15873218E-01,  .18351970E-01,  .19781215E-01,  .24486300E-01,
     +   .30548692E-01,  .33194769E-01,  .42162675E-01,  .51287871E-01,
     +   .60487274E-01,  .69720104E-01,  .78965351E-01,
     +   .15325210E-01,  .17709229E-01,  .19113980E-01,  .23808308E-01,
     +   .29830996E-01,  .32458834E-01,  .41356008E-01,  .50395038E-01,
     +   .59495397E-01,  .68619095E-01,  .77747427E-01,
     +   .14783341E-01,  .17090147E-01,  .18477764E-01,  .23178712E-01,
     +   .29180394E-01,  .31796936E-01,  .40643897E-01,  .49614865E-01,
     +   .58633033E-01,  .67663796E-01,  .76691084E-01,
     +   .14243398E-01,  .16494034E-01,  .17872585E-01,  .22593448E-01,
     +   .28591167E-01,  .31202689E-01,  .40017735E-01,  .48936587E-01,
     +   .57887271E-01,  .66839188E-01,  .75779170E-01,
     +   .13701326E-01,  .15913295E-01,  .17289814E-01,  .22046775E-01,
     +   .28056910E-01,  .30669276E-01,  .39469026E-01,  .48349790E-01,
     +   .57245754E-01,  .66130891E-01,  .74995354E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=55,60)/
     +   .13153119E-01,  .15346353E-01,  .16728375E-01,  .21535255E-01,
     +   .27572803E-01,  .30191237E-01,  .38990181E-01,  .47844768E-01,
     +   .56696646E-01,  .65525070E-01,  .74323796E-01,
     +   .12594732E-01,  .14791337E-01,  .16186563E-01,  .21054942E-01,
     +   .27133595E-01,  .29762773E-01,  .38573418E-01,  .47411691E-01,
     +   .56228105E-01,  .65007895E-01,  .73748708E-01,
     +   .12021979E-01,  .14241454E-01,  .15657019E-01,  .20601317E-01,
     +   .26734108E-01,  .29378202E-01,  .38211159E-01,  .47040939E-01,
     +   .55828430E-01,  .64565547E-01,  .73254302E-01,
     +   .11430394E-01,  .13697128E-01,  .15140896E-01,  .20171570E-01,
     +   .26369859E-01,  .29032351E-01,  .37895892E-01,  .46722665E-01,
     +   .55485573E-01,  .64183913E-01,  .72824322E-01,
     +   .10815056E-01,  .13151020E-01,  .14630304E-01,  .19760678E-01,
     +   .26035184E-01,  .28719062E-01,  .37619423E-01,  .46446476E-01,
     +   .55186883E-01,  .63848116E-01,  .72441801E-01,
     +   .10170342E-01,  .12601701E-01,  .14124501E-01,  .19365635E-01,
     +   .25725456E-01,  .28432934E-01,  .37373677E-01,  .46201620E-01,
     +   .54919042E-01,  .63542381E-01,  .72088622E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=61,66)/
     +   .94895000E-02,  .12047191E-01,  .13622015E-01,  .18982301E-01,
     +   .25434965E-01,  .28167473E-01,  .37149407E-01,  .45976061E-01,
     +   .54667313E-01,  .63249402E-01,  .71744934E-01,
     +   .87638441E-02,  .11478874E-01,  .13114383E-01,  .18605402E-01,
     +   .25157452E-01,  .27915688E-01,  .36936633E-01,  .45756657E-01,
     +   .54415464E-01,  .62949926E-01,  .71388632E-01,
     +   .79806140E-02,  .10895309E-01,  .12601756E-01,  .18230738E-01,
     +   .24886614E-01,  .27670188E-01,  .36724158E-01,  .45528390E-01,
     +   .54144844E-01,  .62621906E-01,  .70994429E-01,
     +   .74511403E-02,  .10516069E-01,  .12272826E-01,  .17993828E-01,
     +   .24716759E-01,  .27515635E-01,  .36585581E-01,  .45373466E-01,
     +   .53956587E-01,  .62391039E-01,  .70715770E-01,
     +   .68464987E-02,  .10112029E-01,  .11928732E-01,  .17750293E-01,
     +   .24543701E-01,  .27357465E-01,  .36438715E-01,  .45203689E-01,
     +   .53746648E-01,  .62131848E-01,  .70402443E-01,
     +   .62988829E-02,  .97366562E-02,  .11607243E-01,  .17522307E-01,
     +   .24376523E-01,  .27201468E-01,  .36282752E-01,  .45014754E-01,
     +   .53508431E-01,  .61836019E-01,  .70044719E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=67,72)/
     +   .57118190E-02,  .93493359E-02,  .11279009E-01,  .17287323E-01,
     +   .24200602E-01,  .27034778E-01,  .36107492E-01,  .44796858E-01,
     +   .53231634E-01,  .61492369E-01,  .69630355E-01,
     +   .50750975E-02,  .89408755E-02,  .10935490E-01,  .17041067E-01,
     +   .24011744E-01,  .26852885E-01,  .35906781E-01,  .44541899E-01,
     +   .52906290E-01,  .61089125E-01,  .69145881E-01,
     +   .43719336E-02,  .85081635E-02,  .10575719E-01,  .16780412E-01,
     +   .23806021E-01,  .26651226E-01,  .35673607E-01,  .44240404E-01,
     +   .52520528E-01,  .60612228E-01,  .68575099E-01,
     +   .35696272E-02,  .80408603E-02,  .10193244E-01,  .16499719E-01,
     +   .23578117E-01,  .26423991E-01,  .35399497E-01,  .43880824E-01,
     +   .52059866E-01,  .60044378E-01,  .67898139E-01,
     +   .25796264E-02,  .75202058E-02,  .97787427E-02,  .16189592E-01,
     +   .23321355E-01,  .26164258E-01,  .35074543E-01,  .43449294E-01,
     +   .51506475E-01,  .59364054E-01,  .67090012E-01,
     +   .63840469E-03,  .66830339E-02,  .91540636E-02,  .15787654E-01,
     +   .23020176E-01,  .25863128E-01,  .34693021E-01,  .42934284E-01,
     +   .50842009E-01,  .58546569E-01,  .66120222E-01 /
        DATA ((SIG(IX,IQ),IQ=1,11),IX=73,78)/
     +   .54348679E-03,  .66718971E-02,  .91313645E-02,  .15770439E-01,
     +   .22891581E-01,  .25676530E-01,  .34300376E-01,  .42334419E-01,
     +   .50041795E-01,  .57553779E-01,  .64941801E-01,
     +   .44987255E-03,  .66495002E-02,  .90860846E-02,  .15707679E-01,
     +   .22679351E-01,  .25390834E-01,  .33761628E-01,  .41547108E-01,
     +   .49016580E-01,  .56300890E-01,  .63469745E-01,
     +   .35752088E-03,  .66093411E-02,  .90073841E-02,  .15578166E-01,
     +   .22348387E-01,  .24965560E-01,  .33020519E-01,  .40502422E-01,
     +   .47683932E-01,  .54693565E-01,  .61598159E-01,
     +   .26639336E-03,  .65389010E-02,  .88747321E-02,  .15344365E-01,
     +   .21837499E-01,  .24330446E-01,  .31980157E-01,  .39080344E-01,
     +   .45902595E-01,  .52570321E-01,  .59145831E-01,
     +   .17645306E-03,  .64132204E-02,  .86474940E-02,  .14928375E-01,
     +   .21021180E-01,  .23341957E-01,  .30444333E-01,  .37038930E-01,
     +   .43388367E-01,  .49606442E-01,  .55748388E-01,
     +   .87666333E-04,  .61405073E-02,  .81724292E-02,  .14103483E-01,
     +   .19544823E-01,  .21597438E-01,  .27870284E-01,  .33712901E-01,
     +   .39361767E-01,  .44912312E-01,  .50408222E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=1,6)/
     +   .22347780E-01,  .30416997E-01,  .34220558E-01,  .38654409E-01,
     +   .48890565E-01,  .52922335E-01,  .66621147E-01,  .80712840E-01,
     +   .95122613E-01,  .10979640E+00,  .12469360E+00,
     +   .14476375E-01,  .19870752E-01,  .22425551E-01,  .25597360E-01,
     +   .32909065E-01,  .35732053E-01,  .45331556E-01,  .55207506E-01,
     +   .65299712E-01,  .75566433E-01,  .85977353E-01,
     +   .11962311E-01,  .16505240E-01,  .18658876E-01,  .21417702E-01,
     +   .27743990E-01,  .30164229E-01,  .38388949E-01,  .46841018E-01,
     +   .55468224E-01,  .64235009E-01,  .73115870E-01,
     +   .10589727E-01,  .14661130E-01,  .16591460E-01,  .19117894E-01,
     +   .24881853E-01,  .27073927E-01,  .34517843E-01,  .42159259E-01,
     +   .49951315E-01,  .57862427E-01,  .65870196E-01,
     +   .96859979E-02,  .13441657E-01,  .15222020E-01,  .17591115E-01,
     +   .22971103E-01,  .25008233E-01,  .31921271E-01,  .39010916E-01,
     +   .46234246E-01,  .53562596E-01,  .60975742E-01,
     +   .90294778E-02,  .12552069E-01,  .14221529E-01,  .16473485E-01,
     +   .21565964E-01,  .23487607E-01,  .30004630E-01,  .36682442E-01,
     +   .43481242E-01,  .50374601E-01,  .57343986E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=7,12)/
     +   .85226241E-02,  .11862587E-01,  .13445049E-01,  .15604578E-01,
     +   .20469274E-01,  .22299757E-01,  .28504094E-01,  .34856651E-01,
     +   .41320160E-01,  .47870025E-01,  .54489061E-01,
     +   .81145316E-02,  .11305598E-01,  .12817057E-01,  .14900750E-01,
     +   .19577978E-01,  .21333689E-01,  .27281454E-01,  .33367082E-01,
     +   .39555471E-01,  .45823533E-01,  .52155215E-01,
     +   .77760560E-02,  .10842069E-01,  .12293876E-01,  .14313543E-01,
     +   .18832160E-01,  .20524794E-01,  .26256071E-01,  .32116495E-01,
     +   .38072787E-01,  .44103172E-01,  .50192557E-01,
     +   .74886265E-02,  .10447377E-01,  .11847992E-01,  .13812449E-01,
     +   .18194064E-01,  .19832352E-01,  .25377102E-01,  .31043489E-01,
     +   .36799841E-01,  .42625524E-01,  .48506290E-01,
     +   .64256275E-02,  .89773368E-02,  .10183567E-01,  .11935689E-01,
     +   .15789291E-01,  .17219389E-01,  .22049619E-01,  .26973020E-01,
     +   .31964321E-01,  .37007291E-01,  .42090867E-01,
     +   .58390745E-02,  .81581678E-02,  .92532923E-02,  .10881490E-01,
     +   .14427078E-01,  .15736699E-01,  .20153632E-01,  .24647752E-01,
     +   .29197568E-01,  .33789434E-01,  .38414113E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=13,18)/
     +   .54209060E-02,  .75701606E-02,  .85841808E-02,  .10120295E-01,
     +   .13437810E-01,  .14658688E-01,  .18771384E-01,  .22949880E-01,
     +   .27175499E-01,  .31436477E-01,  .35724893E-01,
     +   .51001306E-02,  .71166358E-02,  .80672922E-02,  .95302416E-02,
     +   .12667454E-01,  .13818449E-01,  .17691769E-01,  .21622244E-01,
     +   .25593415E-01,  .29594965E-01,  .33620004E-01,
     +   .48420541E-02,  .67501036E-02,  .76490170E-02,  .90512559E-02,
     +   .12039731E-01,  .13133255E-01,  .16809879E-01,  .20536831E-01,
     +   .24299441E-01,  .28088575E-01,  .31898152E-01,
     +   .46274024E-02,  .64440374E-02,  .72993753E-02,  .86496659E-02,
     +   .11511710E-01,  .12556502E-01,  .16066508E-01,  .19621277E-01,
     +   .23207651E-01,  .26817473E-01,  .30445315E-01,
     +   .44443929E-02,  .61822440E-02,  .70000733E-02,  .83048791E-02,
     +   .11057034E-01,  .12059559E-01,  .15425186E-01,  .18830957E-01,
     +   .22265013E-01,  .25720004E-01,  .29191058E-01,
     +   .42853877E-02,  .59574638E-02,  .67436076E-02,  .80045108E-02,
     +   .10659067E-01,  .11624165E-01,  .14862226E-01,  .18136676E-01,
     +   .21436702E-01,  .24755616E-01,  .28089002E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=19,24)/
     +   .41451608E-02,  .57549435E-02,  .65114158E-02,  .77362983E-02,
     +   .10303783E-01,  .11235525E-01,  .14359901E-01,  .17517360E-01,
     +   .20698044E-01,  .23895871E-01,  .27106808E-01,
     +   .40199752E-02,  .55736504E-02,  .63034128E-02,  .74954242E-02,
     +   .99840201E-02,  .10885593E-01,  .13907254E-01,  .16959157E-01,
     +   .20032283E-01,  .23121063E-01,  .26221819E-01,
     +   .39070938E-02,  .54097446E-02,  .61152326E-02,  .72769844E-02,
     +   .96934550E-02,  .10567492E-01,  .13495505E-01,  .16451305E-01,
     +   .19426599E-01,  .22416286E-01,  .25416970E-01,
     +   .38044569E-02,  .52603283E-02,  .59435759E-02,  .70772693E-02,
     +   .94272951E-02,  .10276008E-01,  .13117989E-01,  .15985610E-01,
     +   .18871248E-01,  .21770189E-01,  .24679305E-01,
     +   .37104669E-02,  .51231552E-02,  .57858899E-02,  .68934062E-02,
     +   .91818236E-02,  .10007096E-01,  .12769531E-01,  .15555740E-01,
     +   .18358679E-01,  .21173978E-01,  .23998743E-01,
     +   .36238658E-02,  .49964576E-02,  .56401626E-02,  .67231297E-02,
     +   .89541078E-02,  .97575644E-02,  .12446046E-01,  .15156664E-01,
     +   .17882895E-01,  .20620679E-01,  .23367316E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=25,30)/
     +   .35436423E-02,  .48788190E-02,  .55047837E-02,  .65646246E-02,
     +   .87417914E-02,  .95248455E-02,  .12144244E-01,  .14784350E-01,
     +   .17439092E-01,  .20104686E-01,  .22778606E-01,
     +   .34689903E-02,  .47690975E-02,  .53784545E-02,  .64164181E-02,
     +   .85429605E-02,  .93068564E-02,  .11861458E-01,  .14435508E-01,
     +   .17023347E-01,  .19621437E-01,  .22227386E-01,
     +   .33992324E-02,  .46663643E-02,  .52601271E-02,  .62773130E-02,
     +   .83560478E-02,  .91018872E-02,  .11595481E-01,  .14107424E-01,
     +   .16632421E-01,  .19167142E-01,  .21709338E-01,
     +   .33338103E-02,  .45709312E-02,  .51503726E-02,  .61466023E-02,
     +   .81798965E-02,  .89086248E-02,  .11344525E-01,  .13797851E-01,
     +   .16263613E-01,  .18738655E-01,  .21220839E-01,
     +   .31070877E-02,  .42338623E-02,  .47612539E-02,  .56870929E-02,
     +   .75597861E-02,  .82283197E-02,  .10461652E-01,  .12709657E-01,
     +   .14968293E-01,  .17234933E-01,  .19507756E-01,
     +   .29223014E-02,  .39567789E-02,  .44408757E-02,  .53065377E-02,
     +   .70437291E-02,  .76620006E-02,  .97269351E-02,  .11805083E-01,
     +   .13892934E-01,  .15988134E-01,  .18089021E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=31,36)/
     +   .27672520E-02,  .37230218E-02,  .41703400E-02,  .49827849E-02,
     +   .66026538E-02,  .71779541E-02,  .90995627E-02,  .11033838E-01,
     +   .12977473E-01,  .14928191E-01,  .16884387E-01,
     +   .26343348E-02,  .35203339E-02,  .39353445E-02,  .47014700E-02,
     +   .62181177E-02,  .67561464E-02,  .85539315E-02,  .10364416E-01,
     +   .12184278E-01,  .14011203E-01,  .15843540E-01,
     +   .25184827E-02,  .33429826E-02,  .37297010E-02,  .44538858E-02,
     +   .58783856E-02,  .63836933E-02,  .80732238E-02,  .97759375E-02,
     +   .11488298E-01,  .13207850E-01,  .14932853E-01,
     +   .24161392E-02,  .31847458E-02,  .35460098E-02,  .42331023E-02,
     +   .55746799E-02,  .60510873E-02,  .76453555E-02,  .92535503E-02,
     +   .10871798E-01,  .12497444E-01,  .14128623E-01,
     +   .23247080E-02,  .30426823E-02,  .33811228E-02,  .40347395E-02,
     +   .53010983E-02,  .57518403E-02,  .72618043E-02,  .87866252E-02,
     +   .10321981E-01,  .11864970E-01,  .13413583E-01,
     +   .22422282E-02,  .29143866E-02,  .32323541E-02,  .38553227E-02,
     +   .50530406E-02,  .54809167E-02,  .69160364E-02,  .83670495E-02,
     +   .98291114E-02,  .11299029E-01,  .12774654E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=37,42)/
     +   .21671746E-02,  .27969701E-02,  .30962587E-02,  .36919208E-02,
     +   .48268489E-02,  .52343542E-02,  .66029835E-02,  .79885563E-02,
     +   .93856575E-02,  .10790807E-01,  .12201700E-01,
     +   .20983317E-02,  .26895320E-02,  .29719966E-02,  .35426398E-02,
     +   .46198913E-02,  .50092353E-02,  .63187508E-02,  .76462403E-02,
     +   .89856889E-02,  .10333324E-01,  .11686685E-01,
     +   .20347110E-02,  .25900172E-02,  .28570674E-02,  .34055049E-02,
     +   .44297641E-02,  .48029721E-02,  .60600555E-02,  .73360526E-02,
     +   .86243451E-02,  .99208793E-02,  .11223059E-01,
     +   .19754882E-02,  .24977257E-02,  .27507916E-02,  .32792690E-02,
     +   .42547612E-02,  .46136663E-02,  .58243466E-02,  .70547578E-02,
     +   .82976893E-02,  .95488243E-02,  .10805460E-01,
     +   .19199703E-02,  .24119478E-02,  .26524004E-02,  .31627815E-02,
     +   .40933578E-02,  .44396473E-02,  .56094276E-02,  .67995982E-02,
     +   .80023827E-02,  .92132315E-02,  .10429357E-01,
     +   .18675593E-02,  .23314061E-02,  .25603592E-02,  .30549287E-02,
     +   .39442163E-02,  .42794705E-02,  .54134391E-02,  .65682498E-02,
     +   .77356072E-02,  .89107733E-02,  .10090907E-01 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=43,48)/
     +   .18177333E-02,  .22559424E-02,  .24746060E-02,  .29550160E-02,
     +   .38063226E-02,  .41320026E-02,  .52348385E-02,  .63587371E-02,
     +   .74949465E-02,  .86385896E-02,  .97867977E-02,
     +   .17700301E-02,  .21844842E-02,  .23938271E-02,  .28621464E-02,
     +   .36785998E-02,  .39961003E-02,  .50721983E-02,  .61692949E-02,
     +   .72782673E-02,  .83941603E-02,  .95141260E-02,
     +   .17240335E-02,  .21168005E-02,  .23178440E-02,  .27757883E-02,
     +   .35602150E-02,  .38708593E-02,  .49243383E-02,  .59984224E-02,
     +   .70837280E-02,  .81752967E-02,  .92703467E-02,
     +   .16793646E-02,  .20525989E-02,  .22463524E-02,  .26953907E-02,
     +   .34502086E-02,  .37552959E-02,  .47901147E-02,  .58447379E-02,
     +   .69096684E-02,  .79800356E-02,  .90531837E-02,
     +   .16356716E-02,  .19910987E-02,  .21784257E-02,  .26203613E-02,
     +   .33471312E-02,  .36480818E-02,  .46683489E-02,  .57069808E-02,
     +   .67546302E-02,  .78066657E-02,  .88606523E-02,
     +   .15926257E-02,  .19323232E-02,  .21141705E-02,  .25503533E-02,
     +   .32471677E-02,  .35467034E-02,  .45584687E-02,  .55849277E-02,
     +   .66182101E-02,  .76544383E-02,  .86916070E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=49,54)/
     +   .15499133E-02,  .18755398E-02,  .20527074E-02,  .24848238E-02,
     +   .31733939E-02,  .34694192E-02,  .44690468E-02,  .54824166E-02,
     +   .65016863E-02,  .75231162E-02,  .85448455E-02,
     +   .15072295E-02,  .18206546E-02,  .19939956E-02,  .24234734E-02,
     +   .31059671E-02,  .33993160E-02,  .43893415E-02,  .53919069E-02,
     +   .63992999E-02,  .74079740E-02,  .84162494E-02,
     +   .14642783E-02,  .17675108E-02,  .19378792E-02,  .23659528E-02,
     +   .30444127E-02,  .33358624E-02,  .43186182E-02,  .53124558E-02,
     +   .63098902E-02,  .73076356E-02,  .83042309E-02,
     +   .14207619E-02,  .17155047E-02,  .18836682E-02,  .23118563E-02,
     +   .29882609E-02,  .32785446E-02,  .42561842E-02,  .52431626E-02,
     +   .62323501E-02,  .72207870E-02,  .82072634E-02,
     +   .13763800E-02,  .16647108E-02,  .18315095E-02,  .22609546E-02,
     +   .29371365E-02,  .32269242E-02,  .42013871E-02,  .51831640E-02,
     +   .61656036E-02,  .71461424E-02,  .81238644E-02,
     +   .13308234E-02,  .16145061E-02,  .17806848E-02,  .22128231E-02,
     +   .28905622E-02,  .31804843E-02,  .41535427E-02,  .51315837E-02,
     +   .61085774E-02,  .70824325E-02,  .80525652E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=55,60)/
     +   .12837673E-02,  .15648245E-02,  .17311798E-02,  .21672363E-02,
     +   .28481861E-02,  .31388116E-02,  .41120243E-02,  .50875777E-02,
     +   .60602142E-02,  .70283907E-02,  .79919016E-02,
     +   .12348646E-02,  .15155509E-02,  .16828970E-02,  .21238977E-02,
     +   .28095911E-02,  .31014334E-02,  .40761591E-02,  .50502648E-02,
     +   .60194237E-02,  .69827237E-02,  .79403762E-02,
     +   .11837373E-02,  .14660839E-02,  .16351854E-02,  .20824377E-02,
     +   .27743466E-02,  .30678713E-02,  .40452708E-02,  .50187502E-02,
     +   .59850952E-02,  .69441064E-02,  .78964606E-02,
     +   .11299629E-02,  .14164957E-02,  .15881890E-02,  .20426349E-02,
     +   .27420740E-02,  .30376737E-02,  .40186653E-02,  .49921009E-02,
     +   .59560612E-02,  .69111488E-02,  .78585465E-02,
     +   .10730581E-02,  .13661027E-02,  .15411772E-02,  .20040437E-02,
     +   .27122635E-02,  .30102821E-02,  .39955704E-02,  .49693054E-02,
     +   .59310701E-02,  .68823644E-02,  .78249183E-02,
     +   .10124517E-02,  .13147718E-02,  .14940858E-02,  .19663968E-02,
     +   .26844949E-02,  .29851950E-02,  .39752019E-02,  .49492950E-02,
     +   .59087812E-02,  .68561523E-02,  .77937292E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=61,66)/
     +   .94743934E-03,  .12623048E-02,  .14467723E-02,  .19293092E-02,
     +   .26582282E-02,  .29617944E-02,  .39566495E-02,  .49308604E-02,
     +   .58876914E-02,  .68307277E-02,  .77629220E-02,
     +   .87709510E-03,  .12078434E-02,  .13984037E-02,  .18922722E-02,
     +   .26328613E-02,  .29393982E-02,  .39389115E-02,  .49126549E-02,
     +   .58661192E-02,  .68040863E-02,  .77301855E-02,
     +   .80003432E-03,  .11512021E-02,  .13489637E-02,  .18548695E-02,
     +   .26077745E-02,  .29172751E-02,  .39208494E-02,  .48931264E-02,
     +   .58421153E-02,  .67739063E-02,  .76928437E-02,
     +   .74728276E-03,  .11139882E-02,  .13169042E-02,  .18309152E-02,
     +   .25918433E-02,  .29031567E-02,  .39087888E-02,  .48794411E-02,
     +   .58248718E-02,  .67520482E-02,  .76657822E-02,
     +   .68607146E-03,  .10738550E-02,  .12829850E-02,  .18060285E-02,
     +   .25754357E-02,  .28885351E-02,  .38957414E-02,  .48640515E-02,
     +   .58051650E-02,  .67269858E-02,  .76348069E-02,
     +   .63109450E-03,  .10367482E-02,  .12514084E-02,  .17826892E-02,
     +   .25595864E-02,  .28740799E-02,  .38816468E-02,  .48465123E-02,
     +   .57822992E-02,  .66978340E-02,  .75988779E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=67,72)/
     +   .57163765E-03,  .99813228E-03,  .12188881E-02,  .17584077E-02,
     +   .25426985E-02,  .28583936E-02,  .38654087E-02,  .48257681E-02,
     +   .57551647E-02,  .66633858E-02,  .75566689E-02,
     +   .50657062E-03,  .95704297E-03,  .11845379E-02,  .17327410E-02,
     +   .25243440E-02,  .28410126E-02,  .38463804E-02,  .48009655E-02,
     +   .57226974E-02,  .66223801E-02,  .75067324E-02,
     +   .43403276E-03,  .91310695E-03,  .11482193E-02,  .17053575E-02,
     +   .25041185E-02,  .28214669E-02,  .38238284E-02,  .47710915E-02,
     +   .56836274E-02,  .65733013E-02,  .74473219E-02,
     +   .35039449E-03,  .86517580E-03,  .11092160E-02,  .16756579E-02,
     +   .24814762E-02,  .27991587E-02,  .37968634E-02,  .47349199E-02,
     +   .56363973E-02,  .65142848E-02,  .73762853E-02,
     +   .24582000E-03,  .81114075E-03,  .10664663E-02,  .16426319E-02,
     +   .24557333E-02,  .27733813E-02,  .37644526E-02,  .46909759E-02,
     +   .55790963E-02,  .64430088E-02,  .72909221E-02,
     +   .35476281E-04,  .72180846E-03,  .10002272E-02,  .15994064E-02,
     +   .24252383E-02,  .27432269E-02,  .37260412E-02,  .46380637E-02,
     +   .55097681E-02,  .63568163E-02,  .71879309E-02 /
        DATA ((QNS(IX,IQ),IQ=1,11),IX=73,78)/
     +   .30202087E-04,  .72409806E-03,  .10007038E-02,  .15989871E-02,
     +   .24141988E-02,  .27261258E-02,  .36867927E-02,  .45761415E-02,
     +   .54257843E-02,  .62515843E-02,  .70622102E-02,
     +   .25000061E-04,  .72496943E-03,  .99849456E-03,  .15936608E-02,
     +   .23942941E-02,  .26984934E-02,  .36318651E-02,  .44939639E-02,
     +   .53173834E-02,  .61180494E-02,  .69044800E-02,
     +   .19868037E-04,  .72366704E-03,  .99236052E-03,  .15812239E-02,
     +   .23618541E-02,  .26560733E-02,  .35552515E-02,  .43839971E-02,
     +   .51756361E-02,  .59459638E-02,  .67032245E-02,
     +   .14803957E-04,  .71882695E-03,  .98005263E-03,  .15577927E-02,
     +   .23104828E-02,  .25914747E-02,  .34465918E-02,  .42332974E-02,
     +   .49852394E-02,  .57177851E-02,  .64387219E-02,
     +   .98058217E-05,  .70762285E-03,  .95700304E-03,  .15153018E-02,
     +   .22270584E-02,  .24895843E-02,  .32848851E-02,  .40157419E-02,
     +   .47153663E-02,  .53982073E-02,  .60712975E-02,
     +   .48717807E-05,  .68005547E-03,  .90639328E-03,  .14304101E-02,
     +   .20745308E-02,  .23080043E-02,  .30119694E-02,  .36594281E-02,
     +   .42814114E-02,  .48904535E-02,  .54922933E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=1,6)/ 
     +   .39315710E+02,  .20245180E+03,  .29706970E+03,  .38998940E+03,
     +   .60235050E+03,  .69640340E+03,  .10156940E+04,  .13391290E+04,
     +   .16625500E+04,  .19842600E+04,  .23036300E+04,
     +   .13015950E+02,  .49272890E+02,  .67578800E+02,  .84305940E+02,
     +   .11989870E+03,  .13482840E+03,  .18292200E+03,  .22887100E+03,
     +   .27305840E+03,  .31586090E+03,  .35758670E+03,
     +   .77627230E+01,  .25476180E+02,  .33880740E+02,  .41311560E+02,
     +   .56675360E+02,  .62984860E+02,  .82935480E+02,  .10164970E+03,
     +   .11947380E+03,  .13666090E+03,  .15338970E+03,
     +   .55138630E+01,  .16482330E+02,  .21481590E+02,  .25806310E+02,
     +   .34593800E+02,  .38157860E+02,  .49312930E+02,  .59683670E+02,
     +   .69527700E+02,  .79015690E+02,  .88260600E+02,
     +   .42658210E+01,  .11894110E+02,  .15268630E+02,  .18139960E+02,
     +   .23903340E+02,  .26221040E+02,  .33428250E+02,  .40096080E+02,
     +   .46419510E+02,  .52520490E+02,  .58476340E+02,
     +   .34724210E+01,  .91583450E+01,  .11614240E+02,  .13676010E+02,
     +   .17776240E+02,  .19414830E+02,  .24487940E+02,  .29168890E+02,
     +   .33609710E+02,  .37901580E+02,  .42100420E+02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=7,12)/ 
     +   .29236900E+01,  .73619860E+01,  .92410990E+01,  .10800740E+02,
     +   .13879670E+02,  .15104270E+02,  .18884070E+02,  .22367230E+02,
     +   .25675400E+02,  .28879140E+02,  .32020490E+02,
     +   .25216790E+01,  .61023070E+01,  .75924430E+01,  .88169690E+01,
     +   .11219890E+02,  .12172050E+02,  .15104770E+02,  .17806420E+02,
     +   .20376430E+02,  .22870820E+02,  .25322180E+02,
     +   .22145510E+01,  .51757430E+01,  .63895740E+01,  .73782130E+01,
     +   .93086000E+01,  .10071270E+02,  .12417000E+02,  .14578650E+02,
     +   .16638900E+02,  .18643140E+02,  .20617200E+02,
     +   .19723110E+01,  .44689910E+01,  .54786420E+01,  .62943900E+01,
     +   .78805140E+01,  .85057080E+01,  .10426880E+02,  .12198810E+02,
     +   .13891190E+02,  .15541450E+02,  .17170380E+02,
     +   .12192910E+01,  .24316200E+01,  .28947910E+01,  .32561530E+01,
     +   .39488150E+01,  .42202090E+01,  .50550090E+01,  .58326740E+01,
     +   .65854590E+01,  .73288830E+01,  .80706300E+01,
     +   .89568560E+00,  .16476350E+01,  .19244260E+01,  .21352100E+01,
     +   .25370800E+01,  .26946220E+01,  .31820390E+01,  .36420290E+01,
     +   .40930590E+01,  .45432050E+01,  .49959960E+01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=13,18)/ 
     +   .70236720E+00,  .12133440E+01,  .13958970E+01,  .15320790E+01,
     +   .17914540E+01,  .18935330E+01,  .22120250E+01,  .25170300E+01,
     +   .28198830E+01,  .31250270E+01,  .34340990E+01,
     +   .57403860E+00,  .94195960E+00,  .10701270E+01,  .11639690E+01,
     +   .13431070E+01,  .14140590E+01,  .16377030E+01,  .18552240E+01,
     +   .20738340E+01,  .22959820E+01,  .25223120E+01,
     +   .48276260E+00,  .75846460E+00,  .85241990E+00,  .91998680E+00,
     +   .10496390E+01,  .11014220E+01,  .12665440E+01,  .14297320E+01,
     +   .15956310E+01,  .17655070E+01,  .19394290E+01,
     +   .41459380E+00,  .62730140E+00,  .69839230E+00,  .74857360E+00,
     +   .84566840E+00,  .88484390E+00,  .10113570E+01,  .11384390E+01,
     +   .12690460E+01,  .14037090E+01,  .15421800E+01,
     +   .36179650E+00,  .52962120E+00,  .58475120E+00,  .62281720E+00,
     +   .69741960E+00,  .72788010E+00,  .82761280E+00,  .92945410E+00,
     +   .10352090E+01,  .11449400E+01,  .12582510E+01,
     +   .31973670E+00,  .45602200E+00,  .50002460E+00,  .52755250E+00,
     +   .58588310E+00,  .61006640E+00,  .69047460E+00,  .77397260E+00,
     +   .86153110E+00,  .95289100E+00,  .10475210E+01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=19,24)/ 
     +   .28546990E+00,  .39609320E+00,  .43120210E+00,  .45286930E+00,
     +   .49941110E+00,  .51900170E+00,  .58512720E+00,  .65489610E+00,
     +   .72871570E+00,  .80612360E+00,  .88651230E+00,
     +   .25703600E+00,  .34778440E+00,  .37611500E+00,  .39334930E+00,
     +   .43098980E+00,  .44710000E+00,  .50233750E+00,  .56153960E+00,
     +   .62470790E+00,  .69125440E+00,  .76057760E+00,
     +   .23307990E+00,  .30815390E+00,  .33121990E+00,  .34503790E+00,
     +   .37582200E+00,  .38924040E+00,  .43599920E+00,  .48689240E+00,
     +   .54162370E+00,  .59951500E+00,  .65993800E+00,
     +   .21263500E+00,  .27515820E+00,  .29407020E+00,  .30521350E+00,
     +   .33062720E+00,  .34192670E+00,  .38196380E+00,  .42620350E+00,
     +   .47413120E+00,  .52501650E+00,  .57824470E+00,
     +   .19499370E+00,  .24733700E+00,  .26292730E+00,  .27194790E+00,
     +   .29309460E+00,  .30270110E+00,  .33732640E+00,  .37615440E+00,
     +   .41850880E+00,  .46361800E+00,  .51082990E+00,
     +   .17962590E+00,  .22362120E+00,  .23652510E+00,  .24384140E+00,
     +   .26155530E+00,  .26979150E+00,  .30000080E+00,  .33436720E+00,
     +   .37209560E+00,  .41239260E+00,  .45459160E+00 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=25,30)/ 
     +   .16612660E+00,  .20321190E+00,  .21392240E+00,  .21985520E+00,
     +   .23477780E+00,  .24189180E+00,  .26845490E+00,  .29909880E+00,
     +   .33294350E+00,  .36919390E+00,  .40722360E+00,
     +   .15418160E+00,  .18550240E+00,  .19440770E+00,  .19920540E+00,
     +   .21183550E+00,  .21802150E+00,  .24154210E+00,  .26904760E+00,
     +   .29959740E+00,  .33241030E+00,  .36693600E+00,
     +   .14354290E+00,  .17002830E+00,  .17743740E+00,  .18129060E+00,
     +   .19202030E+00,  .19743110E+00,  .21838900E+00,  .24322370E+00,
     +   .27095230E+00,  .30081140E+00,  .33232360E+00,
     +   .13401250E+00,  .15663680E+00,  .16284470E+00,  .16565330E+00,
     +   .17478120E+00,  .17953840E+00,  .19831970E+00,  .22086330E+00,
     +   .24615430E+00,  .27343450E+00,  .30220600E+00,
     +   .10417360E+00,  .11535630E+00,  .11815790E+00,  .11911660E+00,
     +   .12408260E+00,  .12707970E+00,  .13982000E+00,  .15582030E+00,
     +   .17404900E+00,  .19379540E+00,  .21450010E+00,
     +   .83280005E-01,  .88074952E-01,  .89076415E-01,  .89106910E-01,
     +   .91864996E-01,  .93877465E-01,  .10307430E+00,  .11506430E+00,
     +   .12887400E+00,  .14388710E+00,  .15967520E+00 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=31,36)/ 
     +   .67934953E-01,  .69085434E-01,  .69108382E-01,  .68593055E-01,
     +   .70118375E-01,  .71543127E-01,  .78508377E-01,  .87859437E-01,
     +   .98705448E-01,  .11052400E+00,  .12302120E+00,
     +   .56260787E-01,  .55174585E-01,  .54643415E-01,  .53940937E-01,
     +   .54771874E-01,  .55829812E-01,  .61310552E-01,  .68827577E-01,
     +   .77579148E-01,  .87120317E-01,  .97241007E-01,
     +   .47136471E-01,  .44782624E-01,  .43963388E-01,  .43144271E-01,
     +   .43570966E-01,  .44388734E-01,  .48833929E-01,  .55020325E-01,
     +   .62230367E-01,  .70076510E-01,  .78366145E-01,
     +   .39851971E-01,  .36729421E-01,  .35761900E-01,  .34960799E-01,
     +   .35165071E-01,  .35822459E-01,  .39520901E-01,  .44708878E-01,
     +   .50748222E-01,  .57299107E-01,  .64171284E-01,
     +   .33936139E-01,  .30413296E-01,  .29391401E-01,  .28638413E-01,
     +   .28721986E-01,  .29267857E-01,  .32407962E-01,  .36824454E-01,
     +   .41951463E-01,  .47493108E-01,  .53274922E-01,
     +   .29064327E-01,  .25394445E-01,  .24376754E-01,  .23667054E-01,
     +   .23691460E-01,  .24157966E-01,  .26869521E-01,  .30675927E-01,
     +   .35078317E-01,  .39836071E-01,  .44877306E-01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=37,42)/ 
     +   .25005670E-01,  .21313759E-01,  .20330390E-01,  .19698773E-01,
     +   .19704042E-01,  .20112814E-01,  .22487143E-01,  .25800835E-01,
     +   .29612962E-01,  .33709742E-01,  .37998725E-01,
     +   .21591624E-01,  .17993903E-01,  .17066699E-01,  .16497068E-01,
     +   .16503645E-01,  .16868832E-01,  .18971251E-01,  .21880019E-01,
     +   .25205512E-01,  .28755449E-01,  .32410495E-01,
     +   .18696362E-01,  .15236171E-01,  .14373514E-01,  .13882327E-01,
     +   .13905123E-01,  .14237027E-01,  .16116453E-01,  .18687543E-01,
     +   .21608196E-01,  .24718836E-01,  .27949309E-01,
     +   .16224073E-01,  .12943409E-01,  .12151208E-01,  .11731592E-01,
     +   .11776471E-01,  .12081807E-01,  .13774335E-01,  .16059784E-01,
     +   .18637422E-01,  .21368474E-01,  .24185961E-01,
     +   .14100579E-01,  .11029239E-01,  .10308568E-01,  .99482210E-02,
     +   .10017652E-01,  .10301282E-01,  .11834858E-01,  .13876001E-01,
     +   .16161347E-01,  .18575162E-01,  .21078646E-01,
     +   .12267570E-01,  .94079394E-02,  .87572867E-02,  .84591992E-02,
     +   .85540330E-02,  .88194236E-02,  .10215702E-01,  .12045618E-01,
     +   .14078925E-01,  .16218534E-01,  .18442789E-01 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=43,48)/ 
     +   .10678612E-01,  .80411639E-02,  .74585718E-02,  .72102095E-02,
     +   .73285024E-02,  .75779841E-02,  .88539496E-02,  .10499517E-01,
     +   .12312989E-01,  .14205817E-01,  .16131215E-01,
     +   .92962785E-02,  .68717860E-02,  .63530938E-02,  .61557251E-02,
     +   .62960787E-02,  .65315128E-02,  .77010165E-02,  .91844928E-02,
     +   .10807140E-01,  .12500655E-01,  .14262684E-01,
     +   .80900881E-02,  .58743884E-02,  .54162336E-02,  .52629183E-02,
     +   .54223728E-02,  .56449408E-02,  .67190123E-02,  .80587724E-02,
     +   .95121395E-02,  .11018037E-01,  .12558649E-01,
     +   .70349826E-02,  .50230976E-02,  .46202401E-02,  .45038406E-02,
     +   .46794270E-02,  .48900503E-02,  .58778906E-02,  .70894663E-02,
     +   .83929282E-02,  .97336173E-02,  .11080893E-01,
     +   .61101746E-02,  .42890897E-02,  .39374796E-02,  .38562235E-02,
     +   .40452047E-02,  .42445557E-02,  .51537910E-02,  .62503573E-02,
     +   .74207983E-02,  .86196940E-02,  .98239370E-02,
     +   .52982839E-02,  .36604956E-02,  .33559944E-02,  .33026745E-02,
     +   .35019240E-02,  .36904460E-02,  .45274529E-02,  .55202697E-02,
     +   .65719620E-02,  .76472559E-02,  .87406971E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=49,54)/ 
     +   .45846859E-02,  .31162135E-02,  .28544515E-02,  .28278052E-02,
     +   .30347600E-02,  .32128408E-02,  .39831395E-02,  .48819482E-02,
     +   .58267280E-02,  .67886505E-02,  .77651339E-02,
     +   .39569810E-02,  .26473093E-02,  .24247454E-02,  .24201476E-02,
     +   .26318897E-02,  .27997717E-02,  .35080994E-02,  .43213819E-02,
     +   .51694019E-02,  .60254131E-02,  .68709645E-02,
     +   .34046043E-02,  .22438292E-02,  .20557572E-02,  .20694688E-02,
     +   .22834097E-02,  .24413213E-02,  .30918797E-02,  .38271116E-02,
     +   .45877709E-02,  .53499108E-02,  .60871537E-02,
     +   .29184977E-02,  .18943140E-02,  .17375646E-02,  .17673951E-02,
     +   .19812547E-02,  .21293866E-02,  .27258748E-02,  .33896712E-02,
     +   .40718531E-02,  .47570397E-02,  .54436428E-02,
     +   .24908588E-02,  .15938922E-02,  .14650387E-02,  .15071268E-02,
     +   .17186721E-02,  .18571820E-02,  .24029033E-02,  .30011062E-02,
     +   .36116906E-02,  .42246808E-02,  .48497366E-02,
     +   .21149423E-02,  .13337741E-02,  .12296776E-02,  .12825140E-02,
     +   .14899448E-02,  .16190086E-02,  .21169737E-02,  .26547844E-02,
     +   .31992192E-02,  .37372273E-02,  .42481385E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=55,60)/ 
     +   .17848848E-02,  .11100007E-02,  .10279622E-02,  .10888171E-02,
     +   .12903691E-02,  .14101348E-02,  .18630619E-02,  .23452309E-02,
     +   .28302725E-02,  .33104452E-02,  .37802462E-02,
     +   .14955774E-02,  .91816997E-03,  .85495703E-03,  .92171424E-03,
     +   .11158739E-02,  .12265068E-02,  .16369194E-02,  .20677091E-02,
     +   .24983147E-02,  .29245843E-02,  .33496965E-02,
     +   .12425565E-02,  .75325108E-03,  .70664968E-03,  .77761279E-03,
     +   .96307229E-03,  .10647400E-02,  .14349712E-02,  .18182454E-02,
     +   .21985855E-02,  .25711039E-02,  .29267429E-02,
     +   .10219081E-02,  .61274960E-03,  .58026408E-03,  .65349269E-03,
     +   .82906091E-03,  .92193682E-03,  .12541724E-02,  .15935067E-02,
     +   .19281739E-02,  .22555219E-02,  .25712277E-02,
     +   .83019893E-03,  .49286627E-03,  .47243104E-03,  .54662937E-03,
     +   .71134872E-03,  .79562637E-03,  .10919393E-02,  .13906204E-02,
     +   .16835885E-02,  .19713063E-02,  .22600864E-02,
     +   .66441589E-03,  .39152073E-03,  .38124149E-03,  .45483175E-03,
     +   .60783821E-03,  .68371580E-03,  .94607181E-03,  .12071352E-02,
     +   .14617282E-02,  .17114556E-02,  .19640063E-02 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=61,66)/ 
     +   .52191544E-03,  .30650964E-03,  .30425549E-03,  .37610304E-03,
     +   .51669736E-03,  .58439397E-03,  .81469049E-03,  .10409664E-02,
     +   .12601558E-02,  .14725731E-02,  .16762451E-02,
     +   .40038952E-03,  .23561563E-03,  .23987702E-03,  .30875663E-03,
     +   .43637617E-03,  .49612531E-03,  .69619791E-03,  .89036964E-03,
     +   .10774892E-02,  .12590361E-02,  .14368123E-02,
     +   .29784342E-03,  .17733237E-03,  .18638084E-03,  .25133189E-03,
     +   .36553078E-03,  .41758516E-03,  .58923062E-03,  .75382303E-03,
     +   .91158360E-03,  .10640966E-02,  .12122908E-02,
     +   .24263514E-03,  .14657351E-03,  .15790347E-03,  .21989158E-03,
     +   .32554189E-03,  .37292621E-03,  .52770838E-03,  .67504530E-03,
     +   .81580994E-03,  .95157587E-03,  .10827127E-02,
     +   .19389040E-03,  .11982659E-03,  .13287440E-03,  .19154098E-03,
     +   .28854961E-03,  .33137732E-03,  .46998850E-03,  .60099066E-03,
     +   .72579295E-03,  .84621052E-03,  .96362067E-03,
     +   .15126605E-03,  .96748132E-04,  .11102766E-03,  .16600316E-03,
     +   .25431774E-03,  .29271128E-03,  .41584924E-03,  .53141493E-03,
     +   .64115948E-03,  .74654218E-03,  .84706687E-03 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=67,72)/ 
     +   .11422795E-03,  .76975164E-04,  .91862144E-04,  .14302804E-03,
     +   .22263659E-03,  .25672730E-03,  .36509661E-03,  .46611740E-03,
     +   .56187488E-03,  .65453263E-03,  .74745726E-03,
     +   .82548140E-04,  .60335195E-04,  .75479809E-04,  .12240191E-03,
     +   .19332457E-03,  .22325170E-03,  .31756415E-03,  .40491007E-03,
     +   .48751378E-03,  .56748604E-03,  .64830645E-03,
     +   .56067460E-04,  .46576439E-04,  .61551989E-04,  .10392733E-03,
     +   .16621596E-03,  .19212785E-03,  .27310662E-03,  .34764089E-03,
     +   .41793621E-03,  .48556499E-03,  .55175397E-03,
     +   .34734632E-04,  .35494017E-04,  .49847993E-04,  .87416200E-04,
     +   .14115951E-03,  .16321550E-03,  .23160117E-03,  .29418812E-03,
     +   .35311008E-03,  .40979666E-03,  .46541318E-03,
     +   .18723960E-04,  .26813012E-04,  .39640283E-04,  .72688417E-04,
     +   .11801605E-03,  .13638902E-03,  .19294648E-03,  .24444712E-03,
     +   .29276972E-03,  .33828942E-03,  .37740954E-03,
     +   .93565259E-05,  .20590080E-04,  .31268002E-04,  .59558730E-04,
     +   .96649608E-04,  .11153039E-03,  .15706076E-03,  .19835927E-03,
     +   .23715146E-03,  .27442537E-03,  .31072315E-03 /
        DATA ((GL(IX,IQ),IQ=1,11),IX=73,78)/ 
     +   .58125347E-05,  .15763651E-04,  .24259758E-04,  .47547979E-04,
     +   .76808079E-04,  .88442721E-04,  .12384965E-03,  .15586225E-03,
     +   .18594966E-03,  .21513535E-03,  .24504971E-03,
     +   .33188869E-05,  .11465197E-04,  .17867565E-04,  .36357698E-04,
     +   .58392205E-04,  .67069799E-04,  .93331379E-04,  .11700520E-03,
     +   .13930532E-03,  .16144506E-03,  .18695639E-03,
     +   .16769123E-05,  .75460362E-05,  .11905428E-04,  .26007532E-04,
     +   .41472722E-04,  .47497775E-04,  .65626220E-04,  .81923725E-04,
     +   .97279568E-04,  .11249990E-03,  .12980429E-03,
     +   .69826064E-06,  .41568615E-05,  .66606681E-05,  .16558290E-04,
     +   .26177566E-04,  .29877849E-04,  .40942730E-04,  .50868424E-04,
     +   .60249815E-04,  .69740156E-04,  .81512750E-04,
     +   .20423862E-06,  .11978445E-05,  .19153056E-05,  .81375920E-05,
     +   .12744816E-04,  .14486184E-04,  .19656443E-04,  .24288327E-04,
     +   .28693794E-04,  .33321077E-04,  .39870585E-04,
     +   .25206663E-07,  .43935846E-08,  .36314065E-08,  .11058760E-05,
     +   .16963572E-05,  .19157351E-05,  .25642855E-05,  .31440914E-05,
     +   .36332465E-05,  .35040996E-05, -.10333942E-06 /
******************************************************************
        q2=q*q
*if x is out of range
       IF((X.LT.5.0D-4).OR.(X.GT.1.0D0)) GOTO 90
*******************************************************************
       IF (ICALL.NE.1) THEN
* get the x coordinates
       CALL GS2XCOR(Y,NP)
C       OPEN(UNIT=50,FILE='FOR020.DAT',status='old')
C       DO 20 IQ=1,NQ
C        DO 10 IX=1,NP
C         READ(50,*)SIG(IX,IQ),QNS(IX,IQ),GL(IX,IQ)
C   10   CONTINUE  
C   20  CONTINUE  
        ICALL=1
        END IF
*
      DO 30 IX=1,NP
        A(IX)=Y(IX)
   30 CONTINUE
      DO 40 IQ=1,NQ
        A(NP+IQ)=QT(IQ)
   40 CONTINUE
*
      NA(1)=NP
      NA(2)=NQ  
       XT(1)=X
       XT(2)=Q2
      XSIG=DBFINT(2,XT,NA,A,SIG)
      XQNS=DBFINT(2,XT,NA,A,QNS)
        G =DBFINT(2,XT,NA,A,GL)
*
      IF (Q2.LT.50.0D0) THEN 
C Use three flavour evolution. 
       U=(XSIG+9D0*XQNS)/6.0D0
       D=(XSIG-4.5D0*XQNS)/6.0D0
       S=D
       C=0.0D0
       B=0.0D0
*      
      ELSE IF((Q2.GT.50.0D0).AND.(Q2.LT.250.0D0)) THEN
C Use four flavour evolution 
      U=(XSIG+6.0D0*XQNS)/8.0D0
      D=(XSIG-6.0D0*XQNS)/8.0D0
      S=D
      C=U
      B=0.0D0
      ELSE
C Use five flavour evolution
      U=(XSIG+7.5D0*XQNS)/10.0D0
      D=(XSIG-5.0D0*XQNS)/10.0D0
      S=D
      C=U
      B=D
      ENDIF
      U=X*U
      US=U
      D=X*D
      DS=D
      S=X*S
      C=X*C
      B=X*B
      G=X*G
 90   RETURN
      END
