# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ISCSIVolumeSource(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'target_portal': 'str',
            'iqn': 'str',
            'lun': 'int',
            'fs_type': 'str',
            'read_only': 'bool'
        }

        self.attribute_map = {
            'target_portal': 'targetPortal',
            'iqn': 'iqn',
            'lun': 'lun',
            'fs_type': 'fsType',
            'read_only': 'readOnly'
        }

        self._target_portal = None
        self._iqn = None
        self._lun = None
        self._fs_type = None
        self._read_only = None

    @property
    def target_portal(self):
        """
        Gets the target_portal of this V1ISCSIVolumeSource.
        iSCSI target portal

        :return: The target_portal of this V1ISCSIVolumeSource.
        :rtype: str
        """
        return self._target_portal

    @target_portal.setter
    def target_portal(self, target_portal):
        """
        Sets the target_portal of this V1ISCSIVolumeSource.
        iSCSI target portal

        :param target_portal: The target_portal of this V1ISCSIVolumeSource.
        :type: str
        """
        self._target_portal = target_portal

    @property
    def iqn(self):
        """
        Gets the iqn of this V1ISCSIVolumeSource.
        iSCSI Qualified Name

        :return: The iqn of this V1ISCSIVolumeSource.
        :rtype: str
        """
        return self._iqn

    @iqn.setter
    def iqn(self, iqn):
        """
        Sets the iqn of this V1ISCSIVolumeSource.
        iSCSI Qualified Name

        :param iqn: The iqn of this V1ISCSIVolumeSource.
        :type: str
        """
        self._iqn = iqn

    @property
    def lun(self):
        """
        Gets the lun of this V1ISCSIVolumeSource.
        iscsi target lun number

        :return: The lun of this V1ISCSIVolumeSource.
        :rtype: int
        """
        return self._lun

    @lun.setter
    def lun(self, lun):
        """
        Sets the lun of this V1ISCSIVolumeSource.
        iscsi target lun number

        :param lun: The lun of this V1ISCSIVolumeSource.
        :type: int
        """
        self._lun = lun

    @property
    def fs_type(self):
        """
        Gets the fs_type of this V1ISCSIVolumeSource.
        file system type to mount, such as ext4, xfs, ntfs

        :return: The fs_type of this V1ISCSIVolumeSource.
        :rtype: str
        """
        return self._fs_type

    @fs_type.setter
    def fs_type(self, fs_type):
        """
        Sets the fs_type of this V1ISCSIVolumeSource.
        file system type to mount, such as ext4, xfs, ntfs

        :param fs_type: The fs_type of this V1ISCSIVolumeSource.
        :type: str
        """
        self._fs_type = fs_type

    @property
    def read_only(self):
        """
        Gets the read_only of this V1ISCSIVolumeSource.
        read-only if true, read-write otherwise (false or unspecified)

        :return: The read_only of this V1ISCSIVolumeSource.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this V1ISCSIVolumeSource.
        read-only if true, read-write otherwise (false or unspecified)

        :param read_only: The read_only of this V1ISCSIVolumeSource.
        :type: bool
        """
        self._read_only = read_only

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
