/* attackDefenceAroundKing.h
 */
#ifndef _ATTACK_DEFENCE_AROUND_KING_MC_H
#define _ATTACK_DEFENCE_AROUND_KING_MC_H

#include "osl/effect_util/neighboring25Direct.h"
#include "osl/state/numEffectState.h"
#include "osl/direction.h"

namespace osl
{
  namespace move_classifier
  {
    /**
     * 玉の周辺 5x5 の領域に利きをつける手
     * - P は move の player と一般には一致しないので注意
     * - TODO 5x5 の領域での駒の移動も含めた方が良いか？
     * -- Open Moves?
     * -- 駒取り
     * -- (予め)合い駒の位置に置いておく
     */
    template <Player P>
    struct AttackDefenceAroundKing
    {
      static bool
      isMember(const NumEffectState& state, Move move)
      {
	const PtypeO ptypeO = move.ptypeO();
	Square from = move.to();
	Square king = state.template kingSquare <P> ();
	
	return Neighboring25Direct::hasEffect(state, ptypeO, from, king);
      }
    };
  } // namespace move_classifier
  
} // namespace osl

#endif /* _ATTACK_DEFENCE_AROUND_KING_MC_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
