; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define ptr @mul4(ptr %p, i64 %x) {
; CHECK-LABEL: define ptr @mul4(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_IDX:%.*]] = shl i64 [[X]], 4
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[GEP_IDX]]
; CHECK-NEXT:    ret ptr [[GEP]]
;
entry:
  %mul = mul i64 %x, 4
  %gep = getelementptr inbounds i32, ptr %p, i64 %mul
  ret ptr %gep
}

define ptr @mul4_nuw(ptr %p, i64 %x) {
; CHECK-LABEL: define ptr @mul4_nuw(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_IDX:%.*]] = shl i64 [[X]], 4
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr nuw i8, ptr [[P]], i64 [[GEP_IDX]]
; CHECK-NEXT:    ret ptr [[GEP]]
;
entry:
  %mul = mul i64 %x, 4
  %gep = getelementptr nuw i32, ptr %p, i64 %mul
  ret ptr %gep
}

define ptr @mul5(ptr %p, i64 %x) {
; CHECK-LABEL: define ptr @mul5(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_IDX:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[GEP_IDX]]
; CHECK-NEXT:    ret ptr [[GEP]]
;
entry:
  %mul = mul i64 %x, 5
  %gep = getelementptr inbounds i32, ptr %p, i64 %mul
  ret ptr %gep
}

define ptr @noinbounds(ptr %p, i64 %x) {
; CHECK-LABEL: define ptr @noinbounds(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_IDX:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[P]], i64 [[GEP_IDX]]
; CHECK-NEXT:    ret ptr [[GEP]]
;
entry:
  %mul = mul i64 %x, 5
  %gep = getelementptr i32, ptr %p, i64 %mul
  ret ptr %gep
}

define ptr @usemul(ptr %p, i64 %x) {
; CHECK-LABEL: define ptr @usemul(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[X]], 5
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 [[MUL]]
; CHECK-NEXT:    call void @use(i64 [[MUL]])
; CHECK-NEXT:    ret ptr [[GEP]]
;
entry:
  %mul = mul i64 %x, 5
  %gep = getelementptr inbounds i32, ptr %p, i64 %mul
  call void @use(i64 %mul)
  ret ptr %gep
}

define void @multiple(ptr %p, i64 %x) {
; CHECK-LABEL: define void @multiple(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL21:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[MUL21]]
; CHECK-NEXT:    [[MUL20:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[MUL20]]
; CHECK-NEXT:    call void @use2(ptr [[GEP3]], ptr [[GEP2]])
; CHECK-NEXT:    ret void
;
entry:
  %mul5 = mul i64 %x, 5
  %gep1 = getelementptr inbounds i32, ptr %p, i64 %mul5
  %mul20 = mul i64 %x, 20
  %gep2 = getelementptr inbounds i8, ptr %p, i64 %mul20
  call void @use2(ptr %gep1, ptr %gep2)
  ret void
}

define void @multiplestore(ptr %p, i64 %x) {
; CHECK-LABEL: define void @multiplestore(
; CHECK-SAME: ptr [[P:%.*]], i64 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL20:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[MUL20]]
; CHECK-NEXT:    [[MUL21:%.*]] = mul i64 [[X]], 20
; CHECK-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i8, ptr [[P]], i64 [[MUL21]]
; CHECK-NEXT:    store i32 0, ptr [[GEP2]], align 4
; CHECK-NEXT:    store i32 1, ptr [[GEP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %mul5 = mul i64 %x, 5
  %gep1 = getelementptr inbounds i32, ptr %p, i64 %mul5
  %mul20 = mul i64 %x, 20
  %gep2 = getelementptr inbounds i8, ptr %p, i64 %mul20
  store i32 0, ptr %gep1
  store i32 1, ptr %gep2
  ret void
}

declare void @use(i64)
declare void @use2(ptr, ptr)
