; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=CHECK,AVX,AVX-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -O3 | FileCheck %s --check-prefixes=CHECK,AVX,AVX-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=CHECK,AVX512F,AVX512F-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f -O3 | FileCheck %s --check-prefixes=CHECK,AVX512F,AVX512F-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512VL,AVX512VL-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512VL,AVX512VL-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512dq -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512dq -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQ
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512dq,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512dq,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQVL


declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(<4 x double>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(<4 x double>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(<4 x float>, metadata)
declare <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(<4 x float>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(<4 x double>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(<4 x double>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f64(<4 x double>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f64(<4 x double>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f64(<4 x double>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f64(<4 x double>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f32(<4 x float>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f32(<4 x float>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f64(<4 x double>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f64(<4 x double>, metadata)
declare <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f32(<8 x float>, metadata)
declare <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f32(<8 x float>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f32(<8 x float>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f32(<8 x float>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f32(<8 x float>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f32(<8 x float>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f32(<8 x float>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f32(<8 x float>, metadata)

define <4 x i64> @strict_vector_fptosi_v4f64_to_v4i64(<4 x double> %a) #0 {
; AVX-32-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    .cfi_def_cfa_offset 8
; AVX-32-NEXT:    .cfi_offset %ebp, -8
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX-32-NEXT:    andl $-8, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vmovhps %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vmovhps %xmm0, (%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl (%esp)
; AVX-32-NEXT:    fisttpll (%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm2
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm1
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm2
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm0
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512F-32-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    .cfi_offset %ebp, -8
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512F-32-NEXT:    andl $-8, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vmovhps %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vmovhps %xmm0, (%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl (%esp)
; AVX512F-32-NEXT:    fisttpll (%esp)
; AVX512F-32-NEXT:    wait
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512F-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm1
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm0
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-64-NEXT:    retq
;
; AVX512VL-32-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $32, %esp
; AVX512VL-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm0, (%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-32-NEXT:    movl %ebp, %esp
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %ymm0, %ymm0
; AVX512DQ-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v4f64_to_v4i64:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2qq %ymm0, %ymm0
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i64> %ret
}

define <4 x i64> @strict_vector_fptoui_v4f64_to_v4i64(<4 x double> %a) #0 {
; AVX-32-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    .cfi_def_cfa_offset 8
; AVX-32-NEXT:    .cfi_offset %ebp, -8
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX-32-NEXT:    andl $-8, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX-32-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX-32-NEXT:    vmovapd %xmm1, %xmm3
; AVX-32-NEXT:    jae .LBB1_2
; AVX-32-NEXT:  # %bb.1:
; AVX-32-NEXT:    vxorpd %xmm3, %xmm3, %xmm3
; AVX-32-NEXT:  .LBB1_2:
; AVX-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %al
; AVX-32-NEXT:    movzbl %al, %eax
; AVX-32-NEXT:    shll $31, %eax
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX-32-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX-32-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX-32-NEXT:    vcomisd %xmm1, %xmm3
; AVX-32-NEXT:    vmovapd %xmm1, %xmm4
; AVX-32-NEXT:    jae .LBB1_4
; AVX-32-NEXT:  # %bb.3:
; AVX-32-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX-32-NEXT:  .LBB1_4:
; AVX-32-NEXT:    vsubsd %xmm4, %xmm3, %xmm3
; AVX-32-NEXT:    vmovsd %xmm3, (%esp)
; AVX-32-NEXT:    fldl (%esp)
; AVX-32-NEXT:    fisttpll (%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %cl
; AVX-32-NEXT:    movzbl %cl, %ecx
; AVX-32-NEXT:    shll $31, %ecx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX-32-NEXT:    vmovapd %xmm1, %xmm3
; AVX-32-NEXT:    jae .LBB1_6
; AVX-32-NEXT:  # %bb.5:
; AVX-32-NEXT:    vxorpd %xmm3, %xmm3, %xmm3
; AVX-32-NEXT:  .LBB1_6:
; AVX-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %dl
; AVX-32-NEXT:    movzbl %dl, %edx
; AVX-32-NEXT:    shll $31, %edx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX-32-NEXT:    vcomisd %xmm1, %xmm0
; AVX-32-NEXT:    jae .LBB1_8
; AVX-32-NEXT:  # %bb.7:
; AVX-32-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX-32-NEXT:  .LBB1_8:
; AVX-32-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-32-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $3, %ecx, %xmm0, %xmm0
; AVX-32-NEXT:    setae %cl
; AVX-32-NEXT:    movzbl %cl, %ecx
; AVX-32-NEXT:    shll $31, %ecx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, %ecx, %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm1
; AVX-32-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX-64-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-64-NEXT:    vcomisd %xmm1, %xmm3
; AVX-64-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; AVX-64-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX-64-NEXT:    jb .LBB1_2
; AVX-64-NEXT:  # %bb.1:
; AVX-64-NEXT:    vmovapd %xmm1, %xmm4
; AVX-64-NEXT:  .LBB1_2:
; AVX-64-NEXT:    vsubsd %xmm4, %xmm3, %xmm4
; AVX-64-NEXT:    vcvttsd2si %xmm4, %rcx
; AVX-64-NEXT:    setae %al
; AVX-64-NEXT:    movzbl %al, %eax
; AVX-64-NEXT:    shlq $63, %rax
; AVX-64-NEXT:    xorq %rcx, %rax
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm3[1,0]
; AVX-64-NEXT:    vcomisd %xmm1, %xmm4
; AVX-64-NEXT:    vxorpd %xmm5, %xmm5, %xmm5
; AVX-64-NEXT:    jb .LBB1_4
; AVX-64-NEXT:  # %bb.3:
; AVX-64-NEXT:    vmovapd %xmm1, %xmm5
; AVX-64-NEXT:  .LBB1_4:
; AVX-64-NEXT:    vmovq %rax, %xmm3
; AVX-64-NEXT:    vsubsd %xmm5, %xmm4, %xmm4
; AVX-64-NEXT:    vcvttsd2si %xmm4, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm4
; AVX-64-NEXT:    vcomisd %xmm1, %xmm0
; AVX-64-NEXT:    vxorpd %xmm5, %xmm5, %xmm5
; AVX-64-NEXT:    jb .LBB1_6
; AVX-64-NEXT:  # %bb.5:
; AVX-64-NEXT:    vmovapd %xmm1, %xmm5
; AVX-64-NEXT:  .LBB1_6:
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX-64-NEXT:    vsubsd %xmm5, %xmm0, %xmm4
; AVX-64-NEXT:    vcvttsd2si %xmm4, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm4
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX-64-NEXT:    vcomisd %xmm1, %xmm0
; AVX-64-NEXT:    jb .LBB1_8
; AVX-64-NEXT:  # %bb.7:
; AVX-64-NEXT:    vmovapd %xmm1, %xmm2
; AVX-64-NEXT:  .LBB1_8:
; AVX-64-NEXT:    vsubsd %xmm2, %xmm0, %xmm0
; AVX-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm0
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm4[0],xmm0[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512F-32-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    .cfi_offset %ebp, -8
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512F-32-NEXT:    pushl %ebx
; AVX512F-32-NEXT:    andl $-8, %esp
; AVX512F-32-NEXT:    subl $40, %esp
; AVX512F-32-NEXT:    .cfi_offset %ebx, -12
; AVX512F-32-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-32-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512F-32-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX512F-32-NEXT:    xorl %eax, %eax
; AVX512F-32-NEXT:    vcomisd %xmm3, %xmm2
; AVX512F-32-NEXT:    setae %al
; AVX512F-32-NEXT:    kmovw %eax, %k1
; AVX512F-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm4 {%k1} {z}
; AVX512F-32-NEXT:    vsubsd %xmm4, %xmm2, %xmm2
; AVX512F-32-NEXT:    vmovsd %xmm2, (%esp)
; AVX512F-32-NEXT:    xorl %edx, %edx
; AVX512F-32-NEXT:    vcomisd %xmm3, %xmm1
; AVX512F-32-NEXT:    setae %dl
; AVX512F-32-NEXT:    kmovw %edx, %k1
; AVX512F-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm2 {%k1} {z}
; AVX512F-32-NEXT:    vsubsd %xmm2, %xmm1, %xmm1
; AVX512F-32-NEXT:    vmovsd %xmm1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-32-NEXT:    xorl %ecx, %ecx
; AVX512F-32-NEXT:    vcomisd %xmm3, %xmm1
; AVX512F-32-NEXT:    setae %cl
; AVX512F-32-NEXT:    kmovw %ecx, %k1
; AVX512F-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm2 {%k1} {z}
; AVX512F-32-NEXT:    vsubsd %xmm2, %xmm1, %xmm1
; AVX512F-32-NEXT:    vmovsd %xmm1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    xorl %ebx, %ebx
; AVX512F-32-NEXT:    vcomisd %xmm3, %xmm0
; AVX512F-32-NEXT:    setae %bl
; AVX512F-32-NEXT:    kmovw %ebx, %k1
; AVX512F-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm1 {%k1} {z}
; AVX512F-32-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX512F-32-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl (%esp)
; AVX512F-32-NEXT:    fisttpll (%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    wait
; AVX512F-32-NEXT:    shll $31, %eax
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    shll $31, %edx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX512F-32-NEXT:    shll $31, %ecx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    shll $31, %ebx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, %ebx, %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $3, %ecx, %xmm1, %xmm1
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-32-NEXT:    leal -4(%ebp), %esp
; AVX512F-32-NEXT:    popl %ebx
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512F-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm1
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm0
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-64-NEXT:    retq
;
; AVX512VL-32-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    pushl %ebx
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $40, %esp
; AVX512VL-32-NEXT:    .cfi_offset %ebx, -12
; AVX512VL-32-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-32-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512VL-32-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm3, %xmm2
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm4, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovsd %xmm2, (%esp)
; AVX512VL-32-NEXT:    xorl %edx, %edx
; AVX512VL-32-NEXT:    vcomisd %xmm3, %xmm1
; AVX512VL-32-NEXT:    setae %dl
; AVX512VL-32-NEXT:    kmovw %edx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm2 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm2, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovsd %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-32-NEXT:    xorl %ecx, %ecx
; AVX512VL-32-NEXT:    vcomisd %xmm3, %xmm1
; AVX512VL-32-NEXT:    setae %cl
; AVX512VL-32-NEXT:    kmovw %ecx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm2 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm2, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovsd %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %ebx, %ebx
; AVX512VL-32-NEXT:    vcomisd %xmm3, %xmm0
; AVX512VL-32-NEXT:    setae %bl
; AVX512VL-32-NEXT:    kmovw %ebx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm3, %xmm3, %xmm1 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    shll $31, %eax
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    shll $31, %ebx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %ebx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, %ecx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-32-NEXT:    leal -4(%ebp), %esp
; AVX512VL-32-NEXT:    popl %ebx
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %ymm0, %ymm0
; AVX512DQ-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v4f64_to_v4i64:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2uqq %ymm0, %ymm0
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i64> %ret
}

define <4 x i64> @strict_vector_fptosi_v4f32_to_v4i64(<4 x float> %a) #0 {
; AVX-32-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    .cfi_def_cfa_offset 8
; AVX-32-NEXT:    .cfi_offset %ebp, -8
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX-32-NEXT:    andl $-8, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vextractps $1, %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vextractps $2, %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    vextractps $3, %xmm0, (%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds (%esp)
; AVX-32-NEXT:    fisttpll (%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX-64-NEXT:    vcvttss2si %xmm1, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm1
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX-64-NEXT:    vcvttss2si %xmm2, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm2
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm2
; AVX-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX-64-NEXT:    vmovq %rax, %xmm0
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512F-32-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    .cfi_offset %ebp, -8
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512F-32-NEXT:    andl $-8, %esp
; AVX512F-32-NEXT:    subl $32, %esp
; AVX512F-32-NEXT:    vmovd %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vextractps $1, %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vextractps $2, %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vextractps $3, %xmm0, (%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds (%esp)
; AVX512F-32-NEXT:    fisttpll (%esp)
; AVX512F-32-NEXT:    wait
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-32-NEXT:    movl %ebp, %esp
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512F-64-NEXT:    vcvttss2si %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm1
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512F-64-NEXT:    vcvttss2si %xmm2, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm0
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-64-NEXT:    retq
;
; AVX512VL-32-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $32, %esp
; AVX512VL-32-NEXT:    vmovd %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $1, %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $2, %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $3, %xmm0, (%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-32-NEXT:    movl %ebp, %esp
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %xmm0, %xmm0
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v4f32_to_v4i64:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2qq %xmm0, %ymm0
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i64> @llvm.experimental.constrained.fptosi.v4i64.v4f32(<4 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i64> %ret
}

define <4 x i64> @strict_vector_fptoui_v4f32_to_v4i64(<4 x float> %a) #0 {
; AVX-32-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    pushl %ebp
; AVX-32-NEXT:    .cfi_def_cfa_offset 8
; AVX-32-NEXT:    .cfi_offset %ebp, -8
; AVX-32-NEXT:    movl %esp, %ebp
; AVX-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX-32-NEXT:    andl $-8, %esp
; AVX-32-NEXT:    subl $32, %esp
; AVX-32-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX-32-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX-32-NEXT:    vmovaps %xmm1, %xmm3
; AVX-32-NEXT:    jae .LBB3_2
; AVX-32-NEXT:  # %bb.1:
; AVX-32-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; AVX-32-NEXT:  .LBB3_2:
; AVX-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %al
; AVX-32-NEXT:    movzbl %al, %eax
; AVX-32-NEXT:    shll $31, %eax
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX-32-NEXT:    vpermilps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX-32-NEXT:    vmovaps %xmm1, %xmm3
; AVX-32-NEXT:    jae .LBB3_4
; AVX-32-NEXT:  # %bb.3:
; AVX-32-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; AVX-32-NEXT:  .LBB3_4:
; AVX-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX-32-NEXT:    vmovss %xmm2, (%esp)
; AVX-32-NEXT:    flds (%esp)
; AVX-32-NEXT:    fisttpll (%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %cl
; AVX-32-NEXT:    movzbl %cl, %ecx
; AVX-32-NEXT:    shll $31, %ecx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX-32-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX-32-NEXT:    vmovaps %xmm1, %xmm3
; AVX-32-NEXT:    jae .LBB3_6
; AVX-32-NEXT:  # %bb.5:
; AVX-32-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; AVX-32-NEXT:  .LBB3_6:
; AVX-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    setae %dl
; AVX-32-NEXT:    movzbl %dl, %edx
; AVX-32-NEXT:    shll $31, %edx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX-32-NEXT:    vcomiss %xmm1, %xmm0
; AVX-32-NEXT:    jae .LBB3_8
; AVX-32-NEXT:  # %bb.7:
; AVX-32-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX-32-NEXT:  .LBB3_8:
; AVX-32-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-32-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX-32-NEXT:    wait
; AVX-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX-32-NEXT:    vpinsrd $3, %ecx, %xmm0, %xmm0
; AVX-32-NEXT:    setae %cl
; AVX-32-NEXT:    movzbl %cl, %ecx
; AVX-32-NEXT:    shll $31, %ecx
; AVX-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-32-NEXT:    vpinsrd $1, %ecx, %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX-32-NEXT:    vpinsrd $3, %eax, %xmm1, %xmm1
; AVX-32-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-32-NEXT:    movl %ebp, %esp
; AVX-32-NEXT:    popl %ebp
; AVX-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vpermilps {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX-64-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX-64-NEXT:    vcomiss %xmm1, %xmm3
; AVX-64-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX-64-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX-64-NEXT:    jb .LBB3_2
; AVX-64-NEXT:  # %bb.1:
; AVX-64-NEXT:    vmovaps %xmm1, %xmm4
; AVX-64-NEXT:  .LBB3_2:
; AVX-64-NEXT:    vsubss %xmm4, %xmm3, %xmm3
; AVX-64-NEXT:    vcvttss2si %xmm3, %rcx
; AVX-64-NEXT:    setae %al
; AVX-64-NEXT:    movzbl %al, %eax
; AVX-64-NEXT:    shlq $63, %rax
; AVX-64-NEXT:    xorq %rcx, %rax
; AVX-64-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm0[1,0]
; AVX-64-NEXT:    vcomiss %xmm1, %xmm4
; AVX-64-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX-64-NEXT:    jb .LBB3_4
; AVX-64-NEXT:  # %bb.3:
; AVX-64-NEXT:    vmovaps %xmm1, %xmm5
; AVX-64-NEXT:  .LBB3_4:
; AVX-64-NEXT:    vmovq %rax, %xmm3
; AVX-64-NEXT:    vsubss %xmm5, %xmm4, %xmm4
; AVX-64-NEXT:    vcvttss2si %xmm4, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm4
; AVX-64-NEXT:    vcomiss %xmm1, %xmm0
; AVX-64-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX-64-NEXT:    jb .LBB3_6
; AVX-64-NEXT:  # %bb.5:
; AVX-64-NEXT:    vmovaps %xmm1, %xmm5
; AVX-64-NEXT:  .LBB3_6:
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX-64-NEXT:    vsubss %xmm5, %xmm0, %xmm4
; AVX-64-NEXT:    vcvttss2si %xmm4, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm4
; AVX-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-64-NEXT:    vcomiss %xmm1, %xmm0
; AVX-64-NEXT:    jb .LBB3_8
; AVX-64-NEXT:  # %bb.7:
; AVX-64-NEXT:    vmovaps %xmm1, %xmm2
; AVX-64-NEXT:  .LBB3_8:
; AVX-64-NEXT:    vsubss %xmm2, %xmm0, %xmm0
; AVX-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX-64-NEXT:    setae %cl
; AVX-64-NEXT:    movzbl %cl, %ecx
; AVX-64-NEXT:    shlq $63, %rcx
; AVX-64-NEXT:    xorq %rax, %rcx
; AVX-64-NEXT:    vmovq %rcx, %xmm0
; AVX-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm4[0],xmm0[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX-64-NEXT:    retq
;
; AVX512F-32-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512F-32:       # %bb.0:
; AVX512F-32-NEXT:    pushl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512F-32-NEXT:    .cfi_offset %ebp, -8
; AVX512F-32-NEXT:    movl %esp, %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512F-32-NEXT:    pushl %ebx
; AVX512F-32-NEXT:    andl $-8, %esp
; AVX512F-32-NEXT:    subl $40, %esp
; AVX512F-32-NEXT:    .cfi_offset %ebx, -12
; AVX512F-32-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512F-32-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    xorl %eax, %eax
; AVX512F-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512F-32-NEXT:    setae %al
; AVX512F-32-NEXT:    kmovw %eax, %k1
; AVX512F-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512F-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512F-32-NEXT:    vmovss %xmm1, (%esp)
; AVX512F-32-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-32-NEXT:    xorl %edx, %edx
; AVX512F-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512F-32-NEXT:    setae %dl
; AVX512F-32-NEXT:    kmovw %edx, %k1
; AVX512F-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512F-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512F-32-NEXT:    vmovss %xmm1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-32-NEXT:    xorl %ecx, %ecx
; AVX512F-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512F-32-NEXT:    setae %cl
; AVX512F-32-NEXT:    kmovw %ecx, %k1
; AVX512F-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512F-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512F-32-NEXT:    vmovss %xmm1, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    xorl %ebx, %ebx
; AVX512F-32-NEXT:    vcomiss %xmm2, %xmm0
; AVX512F-32-NEXT:    setae %bl
; AVX512F-32-NEXT:    kmovw %ebx, %k1
; AVX512F-32-NEXT:    vmovss %xmm2, %xmm2, %xmm1 {%k1} {z}
; AVX512F-32-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512F-32-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds (%esp)
; AVX512F-32-NEXT:    fisttpll (%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512F-32-NEXT:    wait
; AVX512F-32-NEXT:    shll $31, %eax
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512F-32-NEXT:    shll $31, %edx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512F-32-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX512F-32-NEXT:    shll $31, %ecx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512F-32-NEXT:    shll $31, %ebx
; AVX512F-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512F-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512F-32-NEXT:    vpinsrd $1, %ebx, %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512F-32-NEXT:    vpinsrd $3, %ecx, %xmm1, %xmm1
; AVX512F-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-32-NEXT:    leal -4(%ebp), %esp
; AVX512F-32-NEXT:    popl %ebx
; AVX512F-32-NEXT:    popl %ebp
; AVX512F-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512F-32-NEXT:    retl
;
; AVX512F-64-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512F-64:       # %bb.0:
; AVX512F-64-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512F-64-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm1
; AVX512F-64-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512F-64-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512F-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm2
; AVX512F-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512F-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512F-64-NEXT:    vmovq %rax, %xmm0
; AVX512F-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512F-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512F-64-NEXT:    retq
;
; AVX512VL-32-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    pushl %ebx
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $40, %esp
; AVX512VL-32-NEXT:    .cfi_offset %ebx, -12
; AVX512VL-32-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512VL-32-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovss %xmm1, (%esp)
; AVX512VL-32-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-32-NEXT:    xorl %edx, %edx
; AVX512VL-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512VL-32-NEXT:    setae %dl
; AVX512VL-32-NEXT:    kmovw %edx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovss %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-32-NEXT:    xorl %ecx, %ecx
; AVX512VL-32-NEXT:    vcomiss %xmm2, %xmm1
; AVX512VL-32-NEXT:    setae %cl
; AVX512VL-32-NEXT:    kmovw %ecx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm2, %xmm2, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovss %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %ebx, %ebx
; AVX512VL-32-NEXT:    vcomiss %xmm2, %xmm0
; AVX512VL-32-NEXT:    setae %bl
; AVX512VL-32-NEXT:    kmovw %ebx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm2, %xmm2, %xmm1 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    shll $31, %eax
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %edx, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, %eax, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    shll $31, %ebx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %ebx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, %ecx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-32-NEXT:    leal -4(%ebp), %esp
; AVX512VL-32-NEXT:    popl %ebx
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %xmm0, %xmm0
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v4f32_to_v4i64:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2uqq %xmm0, %ymm0
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i64> @llvm.experimental.constrained.fptoui.v4i64.v4f32(<4 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i64> %ret
}

define <4 x i32> @strict_vector_fptosi_v4f64_to_v4i32(<4 x double> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f64_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dq %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i32> @strict_vector_fptoui_v4f64_to_v4i32(<4 x double> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v4f64_to_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd {{.*#+}} ymm1 = [2.147483648E+9,2.147483648E+9,2.147483648E+9,2.147483648E+9]
; AVX-NEXT:    vcmpltpd %ymm1, %ymm0, %ymm2
; AVX-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[0,2],xmm3[0,2]
; AVX-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vmovaps {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; AVX-NEXT:    vblendvps %xmm3, %xmm4, %xmm5, %xmm3
; AVX-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vblendvpd %ymm2, %ymm4, %ymm1, %ymm1
; AVX-NEXT:    vsubpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vxorpd %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v4f64_to_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps %ymm0, %ymm0
; AVX512F-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v4f64_to_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v4f64_to_v4i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %ymm0, %ymm0
; AVX512DQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v4f64_to_v4i32:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2udq %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i16> @strict_vector_fptosi_v4f64_to_v4i16(<4 x double> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f64_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dq %ymm0, %xmm0
; CHECK-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i16> @strict_vector_fptoui_v4f64_to_v4i16(<4 x double> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f64_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dq %ymm0, %xmm0
; CHECK-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i8> @strict_vector_fptosi_v4f64_to_v4i8(<4 x double> %a) #0 {
; AVX-LABEL: strict_vector_fptosi_v4f64_to_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptosi_v4f64_to_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512F-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptosi_v4f64_to_v4i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v4f64_to_v4i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQ-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v4f64_to_v4i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQVL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i8> @strict_vector_fptoui_v4f64_to_v4i8(<4 x double> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v4f64_to_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v4f64_to_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512F-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v4f64_to_v4i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512VL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v4f64_to_v4i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQ-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v4f64_to_v4i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQVL-NEXT:    vpmovdb %xmm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i1> @strict_vector_fptosi_v4f64_to_v4i1(<4 x double> %a) #0 {
; AVX-LABEL: strict_vector_fptosi_v4f64_to_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptosi_v4f64_to_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptosi_v4f64_to_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v4f64_to_v4i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v4f64_to_v4i1:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQVL-NEXT:    vpmovd2m %xmm0, %k0
; AVX512DQVL-NEXT:    vpmovm2d %k0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <4 x i1> @strict_vector_fptoui_v4f64_to_v4i1(<4 x double> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v4f64_to_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v4f64_to_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v4f64_to_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v4f64_to_v4i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQ-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v4f64_to_v4i1:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; AVX512DQVL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512DQVL-NEXT:    vpmovd2m %xmm0, %k0
; AVX512DQVL-NEXT:    vpmovm2d %k0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f64(<4 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <8 x i32> @strict_vector_fptosi_v8f32_to_v8i32(<8 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f32_to_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i32> %ret
}

define <8 x i32> @strict_vector_fptoui_v8f32_to_v8i32(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v8f32_to_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps {{.*#+}} ymm1 = [2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9,2.14748365E+9]
; AVX-NEXT:    vcmpltps %ymm1, %ymm0, %ymm2
; AVX-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vmovaps {{.*#+}} ymm4 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; AVX-NEXT:    vblendvps %ymm2, %ymm3, %ymm4, %ymm4
; AVX-NEXT:    vblendvps %ymm2, %ymm3, %ymm1, %ymm1
; AVX-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vxorps %ymm4, %ymm0, %ymm0
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v8f32_to_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovaps %ymm0, %ymm0
; AVX512F-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v8f32_to_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f32_to_v8i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps %ymm0, %ymm0
; AVX512DQ-NEXT:    vcvttps2udq %zmm0, %zmm0
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v8f32_to_v8i32:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2udq %ymm0, %ymm0
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i32> %ret
}

define <8 x i16> @strict_vector_fptosi_v8f32_to_v8i16(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptosi_v8f32_to_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptosi_v8f32_to_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptosi_v8f32_to_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f32_to_v8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v8f32_to_v8i16:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i16> @strict_vector_fptoui_v8f32_to_v8i16(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v8f32_to_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v8f32_to_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v8f32_to_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f32_to_v8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v8f32_to_v8i16:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i8> @strict_vector_fptosi_v8f32_to_v8i8(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptosi_v8f32_to_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptosi_v8f32_to_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptosi_v8f32_to_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f32_to_v8i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v8f32_to_v8i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i8> @strict_vector_fptoui_v8f32_to_v8i8(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v8f32_to_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v8f32_to_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v8f32_to_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f32_to_v8i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v8f32_to_v8i8:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i1> @strict_vector_fptosi_v8f32_to_v8i1(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptosi_v8f32_to_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptosi_v8f32_to_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptosi_v8f32_to_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f32_to_v8i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptosi_v8f32_to_v8i1:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovd2m %ymm0, %k0
; AVX512DQVL-NEXT:    vpmovm2d %k0, %ymm0
; AVX512DQVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

define <8 x i1> @strict_vector_fptoui_v8f32_to_v8i1(<8 x float> %a) #0 {
; AVX-LABEL: strict_vector_fptoui_v8f32_to_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: strict_vector_fptoui_v8f32_to_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512F-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    ret{{[l|q]}}
;
; AVX512VL-LABEL: strict_vector_fptoui_v8f32_to_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f32_to_v8i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQ-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
;
; AVX512DQVL-LABEL: strict_vector_fptoui_v8f32_to_v8i1:
; AVX512DQVL:       # %bb.0:
; AVX512DQVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512DQVL-NEXT:    vpmovd2m %ymm0, %k0
; AVX512DQVL-NEXT:    vpmovm2d %k0, %ymm0
; AVX512DQVL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512DQVL-NEXT:    vzeroupper
; AVX512DQVL-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

attributes #0 = { strictfp }
